/* =========================================================
	File manipulation command set for Forth on the Atari 520
	Missing: copy diskcopy format
	converted for mForth by Rainer Saric
	========================================================= */

mforth 

#ifndef gemdos
	bload bin\gemdos.bin >voc gemdos
#endif

gemdos also

#ifndef alias
	: alias	( -- <new_name> <name> )	create ' , does> perform ;
#endif

vocabulary command
command also definitions

decimal

struct /* DiskTransferAddress	*/
{
   21 field d_reserved
    1 field d_attrib
    2 field d_time
    2 field d_date
    4 field d_lenght
   14 field d_fname
} DTA

   DTA dma-buffer
create linebuf   128 allot
create string2   256 allot

variable first-file

: filename   ( -- cstr )  	dma-buffer d_fname ;
: .filesize  ( -- )   		dma-buffer d_lenght @ 8 .r space ;
: .filename  ( -- )
   filename strlen >r type  13 r> - spaces .filesize ; 

: get-filename	( -- str )
	name nullstr? if s" *.*" else 1+ endif 
	string2 strcpy string2 ;

: save-string  ( str1 -- str2 )  string2 strcpy string2 ;

/* rename file on disk */
: rename  ( -- )	/* old-name new-name */ 
   name 1+ nullstr? not 
	if		save-string
   		name 1+ nullstr? not
			if 	f_rename 0< abort" rename failed" 
			endif
	endif ;

/* Select a drive */

: set-drive  ( n -- )   d_setdrv 0< abort" set-drive failed" ;
: drive:  ( drive# -- )	create w,  does>  w@ set-drive ;

 0 drive: a:  1 drive: b:  2 drive: c:  3 drive: d:
 4 drive: e:  5 drive: f:  6 drive: g:  7 drive: h:
 8 drive: i:  9 drive: j: 10 drive: k: 11 drive: l:
15 drive: p:	hide set-drive a:

: pwd  ( -- )
   linebuf 0 ( default drive ) d_getpath drop
   linebuf strlen 0=  if drop ." \" else type endif ;

variable dir-attributes  
     $10 dir-attributes ! /* Normal files and directories */

: file-pattern  ( str -- )
   dma-buffer f_setdta drop
   dir-attributes @ f_sfirst 0<
   if  -1  else  1  endif  first-file ! ;

: another-file?  ( -- another? )
   first-file @
   if    first-file @ 0>  
			first-file off
   else  f_snext 0=
   endif ;

variable cf
: (files  ( match-str -- )
   cf off file-pattern 
   begin	another-file?
   while cf @ 3 = if cr cf off endif
			cf inc .filename
   repeat cr ;

: ls  ( -- )			get-filename (files ;
: cd  ( path -- )		name nullstr? not if 1+ d_setpath 0< abort" Can't change directory" endif ;
: md  ( path -- ) 	name nullstr? not if 1+ d_create  0< abort" Can't make directory" endif ;
: rd  ( path -- )		name nullstr? not if 1+ d_delete  0< abort" Can't remove directory" endif ;
: del ( path -- )		name nullstr? not if 1+ f_delete  0< abort" Can't remove file" endif ;

hide d_reserved DTA
hide dma-buffer rename
hide dir-attributes ls

alias dir ls
cr
cr .( Command set loaded; Vocabulary: commands)
cr .( available commands: ) 
cr words cr

mforth command also

