/*
 * Quelltext zum ATOS-Artikel "Dynamische Datenstrukturen"
 * ATOS 3/96, 5/96, 1/97
 *
 * Quelltext zur verketteten Liste am Beispiel einer 
 * CD-Verwaltung.
 *
 * Autor: Hauke Wessels
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "liste.h"										/* Struct-Definitionen u. Prototypen */

void main(void)
{
	Eintrag *wurzel;									/* Anfang meiner Liste */
	Eintrag	test;										/* Testeintrag, der eingefgt wird */
	
	wurzel = NULL;
	test.cd_nr = 1;
	strcpy(test.titel, "Ain't my Bitch");
	strcpy(test.gruppe, "Metallica");
	einfuegen(&wurzel, &test);							/* ersten Eintrag einfgen */
	test.cd_nr = 2;
	strcpy(test.titel, "Blueprint");
	strcpy(test.gruppe, "Rainbirds");
	einfuegen(&wurzel, &test);							/* zweiten Eintrag einfgen */

	show(wurzel);										/* Alle Elemente anzeigen */
	loesche(&wurzel, 1);								/* erstes Element lschen */
	loesche(&wurzel, 2);								/* zweites Element lschen */

	exit(EXIT_SUCCESS);									/* return(0); */
}



int einfuegen(Eintrag **anfang, Eintrag *neuesElement)	/* fgt ein Element in die verkettete Liste ein */
{
    Eintrag *neu;										/* zeigt auf den neuen Speicherblock */
    Eintrag *vorgaenger;								/* Zeiger auf den Vorgnger */
    Eintrag *fokus;										/* Zeiger auf das betrachtete Element */
    int ergebnis;										/* das Ergebnis des Stringvergleichs */

    neu = malloc(sizeof(Eintrag));						/* Speicher holen */

    if (!neu)											/* Fehlschlag? (malloc liefert NULL zurck) */
        return(FALSE);									/* Dann konnte es nicht eingefgt werden */

    memcpy(neu, neuesElement, sizeof(Eintrag));			/* Eintrag bernehmen */

	if (*anfang == NULL)								/* das allererste Element ind der Liste? */
	{
		*anfang = neu;									/* neues Element an Anfang setzen */
		neu->next = NULL;								/* Es hat keinen Nachfolger */
		return(TRUE);									/* und zurck */
	}

    if (strcmp((*anfang)->titel, neu->titel) < 0)		/* ist der neue Titel der kleinste? */
    {
        neu->next = *anfang;							/* dann neues Element vor den Anfang setzen */
        *anfang = neu;									/* neuen Anfang setzen */
        return(TRUE);
    }
    else 
    {
        vorgaenger = *anfang;     						/* Hilfszeiger auf Anfang setzen */
        do {											/* solange der neue Titel grer ist, als der aktuelle... */
            fokus = vorgaenger->next;

            if (fokus != NULL)
            {
                ergebnis = strcmp(fokus->titel, neu->titel);
                vorgaenger = fokus;
            }
        } while (fokus != NULL && ergebnis >= 0);
    } /* else */

        /* nun steht fokus auf dem nchst greren Element und vorgaenger auf dem Element,
           direkt davor. Unser Element mu also genau dazwischen. */

    vorgaenger->next = neu;  							/* dem Vorgaenger unser neues Element als nchstes geben */
    neu->next = fokus;       							/* und den Rest hinter das neue Element hngen */
    return(TRUE);
}

	/* Diese Funktion ist vielleicht etwas verwirrend fr
	   Leute, die sich mit C nicht auskennen (Zeiger auf Zeiger 
	   sind immer lustig), aber dafr ist sie kurz */
int loesche(Eintrag **anfang, int nr)					/* lscht die CD mit der Nr nr */
{
	Eintrag **vorgaenger, *akt;
	
	vorgaenger = anfang;								/* Zeiger auf Zeiger auf erstes Element setzen */
	akt = *anfang;										/* mit dem ersten Element fangen wir an */
	
	while (akt != NULL)									/* bis zum Schlu */
	{
		if (akt->cd_nr == nr)							/* diese Cd lschen? */
		{
			*vorgaenger = akt->next;					/* Zeiger hinter dieses Element setzen */
			free(akt);									/* Element frei geben */
			return(TRUE);								/* und beenden */
		}
		else
		{
			vorgaenger = &akt->next;					/* Zeiger auf nchstes Element als Vorgnger sichern */
			akt = akt->next;							/* und aktuellen Zeiger einen weiter setzen */
		}
	}
	return(FALSE);										/* Fehler zurck geben */	
}

int show(Eintrag *anfang)								/* Gibt die CD-Liste auf den Bildschirm aus */
{
	Eintrag *akt;
	
	akt = anfang;										/* mit dem ersten fangen wir an */
	
	while (akt != NULL)									/* solange wir nicht am Ende sind */
	{
		printf("%3d %-40s %-40s\n", akt->cd_nr, akt->titel, akt->gruppe);	/* Alles ausgeben */
		akt = akt->next;								/* und das nxte Element nehmen */
	}
	return(TRUE);										/* und zurck */		
}



