#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <tos.h>
#include <xgem.h>
#include <vdi.h>

#include <image.h>
#include <vaproto.h>

#define ICF_GETPOS   0x0001		/* anstelle #include <icfs.h> */
#define ICF_FREEPOS  0x0002

#include "solitare.h"

#include "solitr.h"
#include "solitr.rsh"

OBJECT *menue,*infobox;
OBJECT *icon;
int handle;

MFDB picture;
MFDB screen={0l};

#define BORDER		NAME|CLOSER|MOVER|(SMALLER*aes_iconify)		
								/* fenster elemente */
								/* aes_iconify 0 falls kein Iconify mglich,
											   1 sonst */
int wi_handle=-1,wind_x,wind_y;
int wind_width	=	640;	/* gre des fensters */
int wind_height	=	366;

int card_height	=	92;		/* gre der spielkarten */
int	card_width	=	64;
int card_dist	=	16;		/* abstand bei berlappung/zwischen karten */

int draw_flag;

MOVE moves[MAX_MOVES];	/* fr undo */
int move;			/* zeiger auf nchste pos in moves */

CARD cards[NUM_CARDS],c2[NUM_CARDS];
int  cards_left;

KEY keys[]={
	K_CTRL,	0x17,	MT_DESK,  M_PRGINFO,
	K_CTRL,	0x31,	MT_DATEI, M_NEU,
	0,		0x3F,	MT_DATEI, M_NEU,
	K_CTRL,	0x10,	MT_DATEI, M_QUIT,
	0,		0x61,	MT_EDIT,  M_UNDO,
	K_CTRL,	0x2D,	MT_EDIT,  M_DRAW,
	K_CTRL,	0x02,	MT_EDIT,  M_MISCHEN,
	K_CTRL,	0x03,	MT_EDIT,  M_MISCHEN2,
	0,		0x40,	MT_EDIT,  M_MISCHEN,
	0,		0x41,	MT_EDIT,  M_MISCHEN2,
	K_CTRL, 0x25,   MT_OPTS,  M_CLASSIC,
	K_CTRL, 0x19,   MT_OPTS,  M_PING,
	K_CTRL, 0x23,   MT_OPTS,  M_HELP
};

int ap_id,av_id=-1;				/* fr avva-kommunikation */
int av_state;

int aes_iconify=0;
int iconified_handle=-1;		/* fr iconify */
int iconified_pos;
int cdecl (*iconify_server)(int opt,...);

void gong(void)
{
	if ( obj_checked(menue,M_PING) )
		Cconout(7);
}

void init_cards(void)
{
int i,j;

	for ( i=0; i<4; i++ ) {
		for ( j=0; j<13; j++ ) {
			cards[i*13+j].color=i;
			cards[i*13+j].number=j;
		}
	}
	for ( i=0; i<104; i++ ) {
	  int n1,n2;
	  CARD card;
		n1=(int)((unsigned int)Random()%52);
		n2=(int)((unsigned int)Random()%52);
		card=cards[n1];
		cards[n1]=cards[n2];
		cards[n2]=card;
	}

	cards_left=52;

	for ( i=0; i<4; i++ ) {
		cards[i+4*13].color=i;
		cards[i+4*13].number=EMPTY;
		cards[i+4*13].stack=100;
	}
}

void mische_cards(void)
{
int i,j;
int n1,n2;
CARD card;

	for ( i=0; i<cards_left; i++ ) {
		n1=(int)((unsigned int)Random()%cards_left);
		n2=(int)((unsigned int)Random()%cards_left);
		card=cards[n1];
		cards[n1]=cards[n2];
		cards[n2]=card;
	}
	for ( i=j=0; i<52; i++ ) {
		cards[i].stack=j;
		if ( i%3==2 )
			j++;
	}
	move=0;					/* entleere undo-puffer */
}

void set_draw_flag(int flag)
{
	if ( flag!=draw_flag ) {
		draw_flag=flag;
		if ( draw_flag )
			graf_mouse(POINT_HAND,0);
		else
			graf_mouse(ARROW,0);
	}
}

#define min(a,b)	(a)<(b)?(a):(b)
#define max(a,b)	(a)>(b)?(a):(b)

int check_recs(int x,int y,int w,int h,int *x1,int *y1,int *w1,int *h1)
{
int hx1,hy1,hx2,hy2;

	hx2=min(x+w,*x1+*w1);
	hy2=min(y+h,*y1+*h1);
	hx1=max(x,*x1);
	hy1=max(y,*y1);
	*x1=hx1; *y1=hy1;
	*w1=hx2-hx1; *h1=hy2-hy1;
	return( (hx2>hx1)&&(hy2>hy1) );
}

void copy_card(int flag,int clip_x,int clip_y,int clip_w,int clip_h,int card,int color,int x,int y)
{
int xy[8];

	xy[4]=x+wind_x;
	xy[5]=y+wind_y;
	if ( !flag )
		xy[6]=card_dist-1;
	else
		xy[6]=card_width-1;
	xy[7]=card_height-1;

	if ( check_recs(clip_x,clip_y,clip_w,clip_h,xy+4,xy+5,xy+6,xy+7) ) {
		xy[0]=card*card_width+xy[4]-x-wind_x;
		xy[1]=color*card_height+xy[5]-y-wind_y;
		if ( card==EMPTY || color==4 ) {
			xy[0]=14*card_width+xy[4]-x-wind_x;
			xy[1]=card_height+xy[5]-y-wind_y;
		}
		xy[2]=xy[0]+xy[6];
		xy[3]=xy[1]+xy[7];
		xy[6]+=xy[4];
		xy[7]+=xy[5];
		vro_cpyfm(handle,3,xy,&picture,&screen);
	}
}

void _redraw_icon(int window_handle,int *clip,OBJECT *icon_tree,int icon_nr)
{
int x,y,w,h;

	wind_get(window_handle,WF_WORKXYWH,&x,&y,&w,&h);
	icon_tree->ob_x=x;
	icon_tree->ob_y=y;
	icon_tree[icon_nr].ob_x=(w-icon_tree[icon_nr].ob_width)/2;
	icon_tree[icon_nr].ob_y=(h-icon_tree[icon_nr].ob_height)/2;

	wind_get(window_handle,WF_FIRSTXYWH,&x,&y,&w,&h);
	while ( w!=0 ) {
		if ( check_recs(clip[0],clip[1],clip[2],clip[3],&x,&y,&w,&h) )
			objc_draw(icon_tree,0,MAX_DEPTH,x,y,w,h);
		wind_get(window_handle,WF_NEXTXYWH,&x,&y,&w,&h);
	}
}

void show_cards(int flag,int *clip)
{
int i,xy[8];
int x,y;
int wx,wy,ww,wh;
int iconified,w,h;

	if ( wi_handle==-1 ) 
		return;

	wind_update(BEG_UPDATE);

	if ( aes_iconify )
		my_wind_get(wi_handle,WF_ICONIFY,&iconified,&w,&h,&i);
	else
		iconified=0;

	if ( iconified ) {
		_redraw_icon(wi_handle,clip,icon,ICONNR);
	}
	else {
		v_hide_c(handle);

		wind_get(wi_handle,WF_FIRSTXYWH,&wx,&wy,&ww,&wh);
		while ( ww!=0 ) {

			if ( clip ) {
				if ( !check_recs(clip[0],clip[1],clip[2],clip[3],&wx,&wy,&ww,&wh) ) {
					wind_get(wi_handle,WF_NEXTXYWH,&wx,&wy,&ww,&wh);
					continue;
				}
			}

			ww--;
			wh--;
	
			if ( !flag ) {
				xy[0]=wx;	xy[1]=wy;	xy[2]=wx+ww;	xy[3]=wy+wh;
				v_bar(handle,xy);
			}
	
			screen.fd_addr=0l;

			y=0;
			x=4;

			for ( i=0; i<56; i++ ) {

				if ( cards[i].color==4 )
					continue;

				cards[i].x=x;
				cards[i].y=y;
	
				if ( cards[i].stack==cards[i+1].stack && cards[i+1].color!=4 )
					copy_card(0,wx,wy,ww,wh,cards[i].number,cards[i].color,x,y);
				else
					copy_card(1,wx,wy,ww,wh,cards[i].number,cards[i].color,x,y);
	
				if ( cards[i].stack==cards[i+1].stack && cards[i+1].color!=4 ) {
					cards[i].top=0;
					x+=card_dist;
				}
				else {
				  int ii,xx,stack;
					cards[i].top=1;
					xy[0]=x+card_width+wind_x;
					xy[1]=y+wind_y;
					xy[2]=card_dist;
					xy[3]=card_height;
					if ( check_recs(wx,wy,ww,wh,xy,xy+1,xy+2,xy+3) ) {
						xy[2]+=xy[0];
						xy[3]+=xy[1];
						v_bar(handle,xy);
					}
					x+=card_width+card_dist;
					xx=x;
					ii=i+1;
					while ( cards[ii].color==4 )
						ii++;
					for ( stack=cards[ii].stack; ii<56 && cards[ii].stack==stack && cards[ii].color!=4; ii++ )
						xx+=card_dist;
					if ( xx>wind_width-card_width ) {	/* neue zeile */
						xy[0]=x+wind_x;
						xy[1]=y+wind_y;
						xy[2]=wind_width-x;
						xy[3]=card_height;
						if ( check_recs(wx,wy,ww,wh,xy,xy+1,xy+2,xy+3) ) {
							xy[2]+=xy[0];
							xy[3]+=xy[1];
							v_bar(handle,xy);
						}
						x=4; 
						y+=card_height;
					}
				}
			}
			xy[0]=x+wind_x;
			xy[1]=y+wind_y;
			xy[2]=wind_width-x;
			xy[3]=card_height;
			if ( check_recs(wx,wy,ww,wh,xy,xy+1,xy+2,xy+3) ) {
				xy[2]+=xy[0];
				xy[3]+=xy[1];
				v_bar(handle,xy);
			}
			if ( y+card_height<wind_height ) {
				xy[0]=wind_x;
				xy[1]=y+card_height+wind_y;
				xy[2]=wind_width;
				xy[3]=wind_height;
				if ( check_recs(wx,wy,ww,wh,xy,xy+1,xy+2,xy+3) ) {
					xy[2]+=xy[0];
					xy[3]+=xy[1];
					v_bar(handle,xy);
				}
			}
	
			wind_get(wi_handle,WF_NEXTXYWH,&wx,&wy,&ww,&wh);
		}

		v_show_c(handle,0);
	}

	wind_update(END_UPDATE);
}

void inc_move(void)
{
	move++;
	if ( move==MAX_MOVES ) {
		move--;
		memcpy(moves,moves+1,sizeof(moves[0])*(MAX_MOVES-1));
	}
}

void move_card(int new_pos,int card,int stack)
{
int i;
	if ( new_pos<card ) {
		for ( i=0; i<new_pos; i++ ) {
			c2[i]=cards[i];
		}
		c2[i]=cards[card];
		if ( stack==-1 )
			c2[i].stack=c2[i-1].stack;
		else
			c2[i].stack=stack;

		for ( ; i<card; i++ ) {
			c2[i+1]=cards[i];
		}
		for ( i++; i<56; i++ ) {
			c2[i]=cards[i];
		}
	}
	else {
		for ( i=0; i<card; i++ ) {
			c2[i]=cards[i];
		}
		for ( i++; i<new_pos; i++ ) {
			c2[i-1]=cards[i];
		}
		c2[i-1]=cards[card];
		if ( stack==-1 )
			c2[i-1].stack=c2[i-2].stack;
		else
			c2[i-1].stack=stack;
		for ( ; i<56; i++ ) {
			c2[i]=cards[i];
		}
	}
}

int get_card(int x,int y,int flag)
{
int i;

	for ( i=0; i<52; i++ ) {
		if ( cards[i].top==1 &&
				cards[i].x<x && cards[i].x+card_width>x &&
				cards[i].y<y && cards[i].y+card_height>y ) {
			return i;
		}
		else if ( flag && cards[i].x<x && cards[i].x+card_dist>x &&
				cards[i].y<y && cards[i].y+card_height>y ) {
			return i;
		}
	}
	return -1;
}

int get_newpos(int card,int all)
{
int i;

	for ( i=52; i<56; i++ ) 		/* karte passt auf ablagestapel */
		if ( cards[i].color==cards[card].color && ((cards[i].number==cards[card].number-1) || (cards[i].number==EMPTY && cards[card].number==0)) )
			return i;
	for ( i=0; i<52; i++ )
		if ( (all || cards[i].top==1) && cards[i].color==cards[card].color &&
				cards[i].number==cards[card].number+1 )
			return i;
	return -1;
}

void get_rec(int card,GRECT *rect)
{
	rect->g_x=cards[card].x+wind_x;
	rect->g_y=cards[card].y+wind_y+1;
	rect->g_w=card_width-1;
	rect->g_h=card_height-3;
}

int do_move(int x,int y)
{
int j;
int card,new_pos;
GRECT old,new;

	x-=wind_x;
	y-=wind_y;

	new_pos=-1;

	card=get_card(x,y,draw_flag);
	if ( card==-1 ) {
		gong();
		return 0;
	}

	moves[move].old_pos=card;
	moves[move].old_stack=cards[card].stack;
	if ( !cards[card].top )
		moves[move].flag=1;
	else
		moves[move].flag=0;

	get_rec(moves[move].old_pos,&old);

	new_pos=get_newpos(card,0);

	if ( new_pos==-1 ) {
		gong();
		return 0;
	}
	else if ( new_pos>=52 ) {		/* karte passt auf ablagestapel */
		get_rec(new_pos,&new);
		for ( j=0; j<card; j++ ) 
			c2[j]=cards[j];
		for ( j++; j<52; j++ )
			c2[j-1]=cards[j];
		c2[51].color=4;
		for ( j=52; j<56; j++ )
			c2[j]=cards[j];
		moves[move].new_pos=new_pos;
		c2[new_pos].number=cards[card].number;
		cards_left--;
	}
	else {							/* karte hat nicht auf ablagestapel gepasst */
		get_rec(new_pos,&new);
		new_pos++;
		moves[move].new_pos=new_pos;
		if ( card<new_pos ) {
			moves[move].new_pos--;
		}
		else {
			moves[move].old_pos++;
		}
		move_card(new_pos,card,-1);
	}

	if ( moves[move].flag ) {		/* karte war herausgezogen */
		obj_disable(menue,M_DRAW);
	}
	set_draw_flag(0);

	graf_movebox(old.g_w,old.g_h,old.g_x,old.g_y,new.g_x,new.g_y);

	inc_move();
	memcpy(cards,c2,sizeof(cards));
	show_cards(1,0l);
	return 1;
}

void draw_card_rec(int i)
{
int xy[4];

	if ( wi_handle==-1 ) 
		return;

	xy[0]=cards[i].x+wind_x;
	xy[1]=cards[i].y+wind_y+1;
	if ( cards[i].top )
		xy[2]=xy[0]+card_width-1;
	else
		xy[2]=xy[0]+card_dist;
	xy[3]=xy[1]+card_height-3;
	v_bar(handle,xy);
}

void show_move(int x,int y)
{
int i,card;
int dummy;
int top_window;

	wind_get(0,WF_TOP,&top_window);
	if ( top_window!=wi_handle )
		return;

	x-=wind_x;
	y-=wind_y;

	card=get_card(x,y,1);

	vswr_mode(handle,MD_XOR);
	wind_update(BEG_UPDATE);
	v_hide_c(handle);

	if ( card==-1 ) {			/* alle mglichen moves anzeigen */
		for ( i=0; i<52; i++ )
			if ( cards[i].top==1 && get_newpos(i,0)>=0 )
				draw_card_rec(i);

		evnt_button(2,2,0,&dummy,&dummy,&dummy,&dummy);

		for ( i=0; i<52; i++ )
			if ( cards[i].top==1 && get_newpos(i,0)>=0 )
				draw_card_rec(i);
	}
	else {						/* zeige karte an die karte passt */
		i=get_newpos(card,1);
		if ( i>=0 ) {
			draw_card_rec(i);
			evnt_button(2,2,0,&dummy,&dummy,&dummy,&dummy);
			draw_card_rec(i);
		}
	}
	v_show_c(handle,1);
	vswr_mode(handle,MD_REPLACE);
	wind_update(END_UPDATE);
}

int do_undo(void)
{
GRECT old,new;

	move--;
	if ( moves[move].flag && !obj_checked(menue,M_CLASSIC) )
		menu_ienable(menue,M_DRAW,1);

	get_rec(moves[move].new_pos,&old);
	get_rec(moves[move].old_pos,&new);

	if ( moves[move].new_pos>=52 ) {
	  int i;
		for ( i=0; i<moves[move].old_pos; i++ ) 
			c2[i]=cards[i];
		c2[i]=cards[moves[move].new_pos];
		c2[i].stack=moves[move].old_stack;
		for ( i++; i<52; i++ )
			c2[i]=cards[i-1];
		for ( i=52; i<56; i++ )
			c2[i]=cards[i];
		c2[moves[move].new_pos].number--;
		cards_left++;
	}
	else {
		move_card(moves[move].old_pos,moves[move].new_pos,moves[move].old_stack);
	}
	graf_movebox(old.g_w,old.g_h,old.g_x,old.g_y,new.g_x,new.g_y);
	memcpy(cards,c2,sizeof(cards));
	show_cards(1,0l);
	return 1;
}

/*------------------------------------------------------------------------------

	sende fr av_protokol

------------------------------------------------------------------------------*/
char *get_send_puffer(void)
{
static char *send_puffer=0l;

	if ( !send_puffer ) {
		send_puffer=Mxalloc(128,0x0022);
		if ( send_puffer==(char*)-32 )
			send_puffer=Malloc(128);
	}
	return send_puffer;
}

void av_send(int msg_typ,int d1,int d2,char *str)
{
int msg[8];
char *puf;

	if ( av_id<0 || (msg_typ==AV_SENDKEY && !(av_state&1)) ||
		 ((msg_typ==AV_ACCWINDOPEN || msg_typ==AV_ACCWINDCLOSED) && !(av_state&64)) ||
		 (msg_typ==AV_EXIT && !(av_state&1024))
		)	return;

	if ( str ) {
		puf=get_send_puffer();
		if ( !puf )
			return;
		strcpy(puf,str);
	}

	msg[0]=msg_typ;
	msg[1]=ap_id;
	msg[2]=0;
	if ( str ) {
		*(char**)&msg[3]=puf;
	}
	else {
		msg[3]=d1;
		msg[4]=d2;
	}
	msg[5]=msg[6]=msg[7]=0;
	if ( msg_typ==AV_PROTOKOLL )
		*(char**)&msg[6]="SOLITARE";
	appl_write(av_id,16,msg);
}

void av_init(void)
{
char *av,_av[32];

		/* av/va kommunikationspartner einstellen */
	av=getenv("AVSERVER");
	if ( av!=0l ) {
		strncpy(_av,av,16);
		_av[16]=0;
		strcat(_av,"        ");
		_av[8]=0;
		av_id=appl_find(_av);
	}
	av_send(AV_PROTOKOLL,2,0,0l);
}

void av_getproto(void)
{
int evnt;
EVENT event;

	do {
		memset(&event,0,sizeof(event));
		event.ev_mflags=MU_MESAG|MU_TIMER;
		event.ev_mtlocount=10;
		/*event.ev_mthicount=0;*/
		evnt=EvntMulti(&event);
		if ( evnt&MU_MESAG && event.ev_mmgpbuf[0]==VA_PROTOSTATUS )
			av_state=event.ev_mmgpbuf[3];
	} while ( evnt&MU_MESAG );
}

/*------------------------------------------------------------------------------

	iconify...

------------------------------------------------------------------------------*/

void redraw_icon(int *msg)
{
	wind_update(BEG_UPDATE);
	_redraw_icon(msg[3],msg+4,icon,ICONNR);
	wind_update(END_UPDATE);
}

int init_iconify(void)
{
int x,y,w,h;

	if ( iconified_handle!=-1 )
		return -1;

	if ( !iconify_server )	/* ohne server geht nichts */
		return -1;

	if ( !iconify_server )	/* ohne server geht nichts */
		return -1;

	iconified_pos=(*iconify_server)(ICF_GETPOS,&x,&y,&w,&h);
	if ( iconified_pos<=0 )
		return -1;			/* war wohl nix */

	wind_close(wi_handle);
	wind_delete(wi_handle);
	av_send(AV_ACCWINDCLOSED,wi_handle,0,0l);
	wi_handle=-1;

	iconified_handle=wind_create(NAME|MOVER,x,y,w,h);
	if ( iconified_handle<0 )
		return -2;			/* BIG TROUBLE */

	wind_set(iconified_handle,WF_NAME," Solitare ");
	wind_open(iconified_handle,x,y,w,h);

	return 0;
}

int exit_iconify(void)
{
int x,y,w,h,dummy;

	if ( !iconify_server )	/* ohne server geht nichts */
		return -1;

	if ( iconified_handle<0 )
		return -1;			/* das war wohl fehlalarm */

	wind_close(iconified_handle);
	wind_delete(iconified_handle);
	(*iconify_server)(ICF_FREEPOS,iconified_pos);
	iconified_handle=-1;

	wind_calc(WC_BORDER,BORDER,wind_x,wind_y,wind_width,wind_height,&x,&y,&w,&h);
	wi_handle=wind_create(BORDER,x,y,w,h);
	if ( wi_handle<0 )
		return -2;			/* tja... */

	wind_set(wi_handle,WF_NAME," Solitare ");
	wind_open(wi_handle,x,y,w,h);
	av_send(AV_ACCWINDOPEN,wi_handle,0,0l);

	evnt_button(1,3,0,&dummy,&dummy,&dummy,&dummy);

	return 0;
}

/*------------------------------------------------------------------------------

	init/exit

------------------------------------------------------------------------------*/
void open_window(void)
{
int x,y,w,h;

	wind_get(0,WF_WORKXYWH,&x,&y,&w,&h);
	wind_calc(WC_WORK,BORDER,x,y,w,h,&x,&y,&w,&h);
	w=wind_width;
	h=wind_height;
	wind_x=x;
	wind_y=y;
	wind_calc(WC_BORDER,BORDER,x,y,w,h,&x,&y,&w,&h);

	wi_handle=wind_create(BORDER,x,y,w,h);
	wind_set(wi_handle,WF_NAME," Solitare ");
	wind_open(wi_handle,x,y,w,h);

	av_send(AV_ACCWINDOPEN,wi_handle,0,0l);
}

typedef struct
{
	long id;
	long value;
} COOKJAR;

static long _get_cookjar(void)
{
	return *(long*)0x05a0l;
}

long get_cookie(long cookie)
{
COOKJAR	*cookiejar;
int	i = 0;

	cookiejar=(COOKJAR*)Supexec(_get_cookjar);

	if ( cookiejar ) {
		while ( cookiejar[i].id ) {
			if ( cookiejar[i].id==cookie )
				return cookiejar[i].value;
			i++;
		}
	}
	return 0l;
}

OBJECT *scale_tree(int index)
{
OBJECT *tree;

	tree=rs_trindex[index];
	do {
		rsrc_obfix(tree,0);
	} while ( !(tree++->ob_flags&LASTOB) );
	return rs_trindex[index];
}

void do_exit(void)
{
	if ( picture.fd_addr )
		free(picture.fd_addr);

	if ( wi_handle>=0 ) {
		wind_close(wi_handle);
		wind_delete(wi_handle);
		av_send(AV_ACCWINDCLOSED,wi_handle,0,0l);
	}
	else if ( iconified_handle>=0 ) {
		wind_close(iconified_handle);	
		wind_delete(iconified_handle);	
		(*iconify_server)(ICF_FREEPOS,iconified_pos);
	}
	menu_bar(menue,0);

	av_send(AV_EXIT,0,0,0l);

	v_clsvwk(handle);
	appl_exit();
	exit(0);
}

void load_cards(int planes)
{
int f,f_id;
DTA dta;
char name[128];
IMG_HEADER head;
char xname[128];
int w=0,h=0,p=0;

		/* lade karten */
	*xname=0;
	Fsetdta(&dta);
	f=Fsfirst("YUKONDAT\\CARDS*.IMG",0);
	while ( !f ) {
		strcpy(name,"YUKONDAT\\");
		strcat(name,dta.d_fname);
		f_id=Fopen(name,0);
		if ( f_id>=0 ) {
			Fread(f_id,sizeof(head),&head);
			Fclose(f_id);
			if ( head.plane_num<=planes && 
					(head.plane_num>p || head.pix_num>w || head.scan_num>h) ) {
				strcpy(xname,name);
				w=head.pix_num;
				h=head.scan_num;
				p=head.plane_num;
			}
		}
		f=Fsnext();
	}
	if ( !*xname || load_img(xname,&picture)!=IMG_OK ) {
		do_exit();
	}
}

int init(void)
{
int i,p_handle,dummy;
int work_in[11],work_out[57];
int planes;

		/* bearbeite objektbume */
	menue=scale_tree(MENUE);
	infobox=scale_tree(INFOBOX);
	icon=scale_tree(ICONIFIED);

	obj_spec(infobox,I_COMPDATE)=__DATE__;

		/* init aes */
	ap_id=appl_init();

	if ( _GemParBlk.global[0]>=0x400 || !appl_find("?AGI") ) {
	  int o1,o2,o3,o4;
		appl_getinfo(11,&o1,&o2,&o3,&o4);
		if ( (o1&0x0180)==0x0180 )
			aes_iconify=1;
	}
	if ( !aes_iconify )
		iconify_server=(void*)get_cookie('ICFS');

	av_init();

	p_handle=graf_handle(&dummy,&dummy,&dummy,&dummy);

		/* init vdi */
	handle=p_handle;
	for ( i=0; i<10; i++ )
		work_in[i]=0;
	work_in[10]=2;
	v_opnvwk(work_in,&handle,work_out);

	vq_extnd(handle,1,work_out);
	planes=work_out[4];

		/* lade karten */
	load_cards(planes);

	card_width=picture.fd_w/15;
	card_dist=16;	
	if ( card_width>64 )
		card_dist=card_width/4;
	card_height=picture.fd_h/4;
	wind_width=card_width*8+128;
	wind_height=card_height*4;

	i=transform_img(&picture,planes,handle);
	if ( i!=TRFM_OK ) {
		if ( i==TRFM_MEMORY )
			form_error(8);
		else if ( i==TRFM_ERROR )
			form_alert(1,"[1][ Falsches Image! ][ Ok ]");
		free(picture.fd_addr);	
		do_exit();
	}

	vsf_color(handle,1);
	vsf_interior(handle,1);

	graf_mouse(ARROW,0l);

	av_getproto();

	menu_bar(menue,1);

	open_window();

	return 1;
}

/*------------------------------------------------------------------------------

	hauptprogramm

------------------------------------------------------------------------------*/
int main(void)
{
int evnt,message[8];
int mx,my,mb,ks,key,dummy;
int i,exit_flag;
int maus_im_fenster=1;

	if ( init() ) {

		init_cards();

		mische_cards();
		if ( !obj_checked(menue,M_CLASSIC) )
			menu_ienable(menue,M_DRAW,1);
		else
			menu_ienable(menue,M_DRAW,0);
		menu_ienable(menue,M_MISCHEN,1);
		menu_ienable(menue,M_MISCHEN2,0);

		exit_flag=0;
		do {
			if ( move!=0 )
				menu_ienable(menue,M_UNDO,1);
			else
				menu_ienable(menue,M_UNDO,0);

			evnt=evnt_multi(MU_MESAG|MU_KEYBD|MU_BUTTON|MU_M1,2+3+256,3,0,
					maus_im_fenster,wind_x,wind_y,wind_width,wind_height, 0,0,0,0,0, 
					message,
					0,0, 
					&mx,&my,&mb,&ks,&key,&dummy);

			if ( evnt&MU_M1 ) {
				maus_im_fenster=!maus_im_fenster;
				if ( draw_flag ) {
					if ( maus_im_fenster )
						graf_mouse(POINT_HAND,0);
					else
						graf_mouse(ARROW,0);
				}
			}
			if ( evnt&MU_BUTTON ) {
				if ( iconified_handle>=0 ) {
					if ( exit_iconify()==-2 )
						exit_flag=1;
				}
				else {
					if ( mb==1 ) {
						do_move(mx,my);
					}
					else if ( obj_checked(menue,M_HELP) ) {
						show_move(mx,my);
					}
				}
			}
			if ( evnt&MU_KEYBD ) {
			  int xkey=key;
				key>>=8;
				key&=255;
				message[0]=MN_SELECTED;
				for ( i=0; i<sizeof(keys)/sizeof(keys[0]); i++ ) {
					if ( keys[i].state==ks && keys[i].key==key ) {
						if ( !obj_disabled(menue,keys[i].entry) ) {
							message[3]=keys[i].titel;
							message[4]=keys[i].entry;
							evnt|=MU_MESAG;
						}
						break;
					}
				}
				if ( i==sizeof(keys)/sizeof(keys[0]) ) {
					av_send(AV_SENDKEY,ks,xkey,0l);
				}
			}
			if ( evnt&MU_MESAG && message[0]==MN_SELECTED ) {
				menu_tnormal(menue,message[3],1);
				if ( message[4]==M_QUIT ) {
					exit_flag=1;
				}
				else if ( message[4]==M_MISCHEN || message[4]==M_MISCHEN2 ) {
					mische_cards();
					show_cards(0,0l);
					set_draw_flag(0);
					if ( message[4]==M_MISCHEN ) {
						menu_ienable(menue,M_MISCHEN,0);
						menu_ienable(menue,M_MISCHEN2,1);
					}
					else {
						menu_ienable(menue,M_MISCHEN2,0);
					}
				}
				else if ( message[4]==M_UNDO ) {
					do_undo();
				}
				else if ( message[4]==M_DRAW ) {
					set_draw_flag(1);
				}
				else if ( message[4]==M_CLASSIC ) {
					if ( !obj_checked(menue,M_CLASSIC) )
						menu_icheck(menue,M_CLASSIC,1);
					else
						menu_icheck(menue,M_CLASSIC,0);
				}
				else if ( message[4]==M_PING ) {
					if ( !obj_checked(menue,M_PING) )
						menu_icheck(menue,M_PING,1);
					else
						menu_icheck(menue,M_PING,0);
				}
				else if ( message[4]==M_HELP ) {
					if ( !obj_checked(menue,M_HELP) )
						menu_icheck(menue,M_HELP,1);
					else
						menu_icheck(menue,M_HELP,0);
				}
				else if ( message[4]==M_NEU ) {
					init_cards();
					mische_cards();
					show_cards(0,0l);
					menu_ienable(menue,M_MISCHEN,1);
					menu_ienable(menue,M_MISCHEN2,0);
					set_draw_flag(0);
					if ( !obj_checked(menue,M_CLASSIC) )
						menu_ienable(menue,M_DRAW,1);
					else
						menu_ienable(menue,M_DRAW,0);
				}
				else if ( message[4]==M_PRGINFO ) {
				  int x,y,w,h,r;
				  	wind_update(BEG_UPDATE);
					form_center(infobox,&x,&y,&w,&h);
					form_dial(FMD_START,x,y,w,h,x,y,w,h);
					objc_draw(infobox,0,10,x,y,w,h);
					r=form_do(infobox,0)&0x7FFF;
					obj_unselect(infobox,r);
					form_dial(FMD_FINISH,x,y,w,h,x,y,w,h);
				  	wind_update(END_UPDATE);
				}
			}
			if ( evnt&MU_MESAG ) {
				if ( message[0]==WM_TOPPED ) {
					wind_set(message[3],WF_TOP);
				}
				else if ( message[0]==WM_REDRAW ) {
					if ( message[3]==wi_handle )
						show_cards(0,message+4);
					else if ( message[3]==iconified_handle )
						redraw_icon(message);
				}
				else if ( message[0]==WM_ICONIFY || message[0]==WM_ALLICONIFY ) {
					my_wind_set(message[3],WF_ICONIFY,message[4],message[5],message[6],message[7]);
				}
				else if ( message[0]==WM_UNICONIFY ) {
					my_wind_set(message[3],WF_UNICONIFY,message[4],message[5],message[6],message[7]);
				}
				else if ( message[0]==WM_CLOSED ) {
					if ( ks&(K_ALT|K_LSHIFT|K_RSHIFT|K_CTRL) && iconify_server ) {
						if ( init_iconify()==-2 )
							exit_flag=1;	/* notausstieg... */
					}
					else {
						exit_flag=1;
					}
				}
				else if ( message[0]==WM_MOVED ) {
					wind_set(message[3],WF_CURRXYWH,message[4],message[5],message[6],message[7]);
					if ( message[3]==wi_handle ) {
					 int iconified=0,w,h,i;
						if ( aes_iconify )
							my_wind_get(wi_handle,WF_ICONIFY,&iconified,&w,&h,&i);
						if ( !iconified )
							wind_get(message[3],WF_WORKXYWH,&wind_x,&wind_y,&dummy,&dummy);
					}
				}
			}
		} while ( !exit_flag );

		do_exit();
	}
	return 0;
}
