
; Coil spring maker program
; by Tom Hudson
; for 3D-Control language
; Version 1.0
;
; Number of turns = Number of times spring makes a rotation
; Number of segments per turn determines fineness of coil
; Spring diameter is diameter of entire coil
; Spring thickness is size of coil "wire"
; Height increase per turn should be > thickness
; Color is 1-15
;
; Try turns=2, segments=10, diameter=2000, thickness=200, increase=1000

alert "Coil spring maker program|      by Tom Hudson"

status totv,usedv,totf,usedf,objs
availv=totv-usedv:availf=totf-usedf

@GETTURN
input "Number of turns",turns:turns=int(turns)
if turns<1 then bell:goto GETTURN

@GETSEG
input "Number of segments per turn",segments:segments=int(segments)
if segments<3 then bell:goto GETSEG

@GETDIA
input "Spring diameter",diameter:diameter=int(diameter):radius=diameter/2
if diameter<100 | diameter>8000 then bell:goto GETDIA

@GETTHICK
input "Spring thickness",thickness:thickness=int(thickness)
if thickness<10 | thickness>=radius then bell:goto GETTHICK

@GETINC
input "Height increase per turn",increase:increase=int(increase)
if increase<=thickness then bell:goto GETINC

@GETCOLOR
input "Color of spring (1-15)",color:color=int(color)
if color<1 | color>15 then bell:goto GETCOLOR

needv=4*(turns*segments+1):needf=8*turns*segments+4
if needv<=availv & needf<=availf then goto GOFORIT
bell:alert "Spring too complex!":goto GETTURN

; Start spiral for spring core

@GOFORIT
thickness=thickness/2
springz=-4400+thickness
turnstep=360/segments:heightinc=increase/segments
inner=diameter-thickness:outer=diameter+thickness
vertix=0

for loop=1 to turns
for angle=0 to 359 step turnstep:gosub ADDVERTS:next angle
next loop

angle=0:gosub ADDVERTS

; Now link together vertices into triangular faces!

faceix=0:vertix=0

for loop=1 to turns
for angle=0 to 359 step turnstep
addface faceix,vertix,vertix+4,vertix+5,1,1,0,color
addface faceix+1,vertix,vertix+5,vertix+1,0,1,1,color
addface faceix+2,vertix+1,vertix+5,vertix+6,1,1,0,color
addface faceix+3,vertix+1,vertix+6,vertix+2,0,1,1,color
addface faceix+4,vertix+2,vertix+6,vertix+7,1,1,0,color
addface faceix+5,vertix+2,vertix+7,vertix+3,0,1,1,color
addface faceix+6,vertix+3,vertix+7,vertix+4,1,1,0,color
addface faceix+7,vertix+3,vertix+4,vertix,0,1,1,color
vertix=vertix+4:faceix=faceix+8
next angle
next loop

; Cap ends of spring!

addface faceix,0,1,2,1,1,0,color
addface faceix+1,0,2,3,0,1,1,color
addface faceix+2,vertix,vertix+3,vertix+2,1,1,0,color
addface faceix+3,vertix,vertix+2,vertix+1,0,1,1,color

; Send object over to CAD-3D!

faces=faceix+4:verts=vertix+4
upload COIL,verts,faces:clrgrp:select COIL:home:bell:end

; Subroutine to generate vertices in spiral

@ADDVERTS
inx=inner*cos(angle):iny=inner*sin(angle)
outx=outer*cos(angle):outy=outer*sin(angle)
addvertex vertix,outx,outy,springz+thickness
addvertex vertix+1,inx,iny,springz+thickness
addvertex vertix+2,inx,iny,springz-thickness
addvertex vertix+3,outx,outy,springz-thickness
vertix=vertix+4:springz=springz+heightinc
return

 