{$S20,T-}

PROGRAM life;
  { Grafikprogramm fuer hohe Aufloesung }

CONST n_max = 41; fx = 8; fy = 22; flng = 370; zv = 9;
      x_text = 50; y_text = 3; gy = 15;

TYPE in_type  = ARRAY[0..19] OF integer;
     out_type = ARRAY[0..99] OF integer;

VAR xch,ych,x,y,gen,og,
    handle,gr_1,gr_2,gr_3,gr_4 : integer;
    l_intin                    : in_type;
    l_out                      : out_type;
    feld1,feld2                : ARRAY[-1..n_max] OF
                                    ARRAY[-1..n_max] OF boolean;
    text                       : ARRAY[0..3] OF string[21];
    quit                       : boolean;


PROCEDURE clear_home;
{ Loescht den gesamten Bildschirm und setzt den Cursor in die Ecke (0, 0). }
  BEGIN write (chr (27), 'E')
  END;

PROCEDURE gotoxy (x, y: integer);
{ Positioniert den Cursor in Spalte 0 <= x <= 79 und Zeile 0 <= y <= 24. }
  BEGIN write (chr (27), 'Y', chr (y + 32), chr (x + 32))
  END;

PROCEDURE inverse_on;
{ Schaltet inverse Schrift ein (Farbe von Schrift und Hintergrund getauscht). }
  BEGIN write (chr (27), 'p')
  END;

PROCEDURE inverse_off;
{ Schaltet inverse Schrift aus. }
  BEGIN write (chr (27), 'q')
  END;

 PROCEDURE graf_mouse(i : integer);
  C;

 PROCEDURE v_show_c(handle : integer);
  C;

 PROCEDURE v_hide_c(handle : integer);
  C;

 PROCEDURE vq_mouse(handle : integer; VAR status,mx,my : integer);
  C;

 PROCEDURE v_opnvwk(VAR wi: in_type; VAR handle: integer; VAR wo: out_type);
  C;

 PROCEDURE v_clsvwk(handle: integer);
  C;

 PROCEDURE appl_init;
  C;

 PROCEDURE appl_exit;
  C;

 PROCEDURE evnt_timer(low,high : integer);
  C;

 FUNCTION graf_handle(VAR gl_wchar, gl_hchar,
                          gl_wbox, gl_hbox: integer):integer;
  C;


 PROCEDURE maus_inp;
 { Koordinateneingabe mit der Maus }
 VAR pst: integer;
 BEGIN
    pst := 0;
    WHILE pst=0 DO vq_mouse(handle,pst,x,y)
 END; { maus_inp }

 PROCEDURE wr_str(x_cur,y_cur : integer; str : string; inv : boolean);
 { Gibt den String str an der Cursorposition (x_cur,y_cur) aus. Inverse
   Schrift, falls inv=true. }
 BEGIN
    gotoxy(x_cur,y_cur);
    IF inv THEN inverse_on;
    v_hide_c(handle); write(str); v_show_c(handle);
    inverse_off
 END; { wr_str }

 PROCEDURE wr_text(text_nr : integer; inv : boolean);
 { Beschriftung einer Zeile im Feld "Optionen". }
 BEGIN
    wr_str(x_text,y_text+2*text_nr,text[text_nr],inv)
 END; { wr_text }

 PROCEDURE rechteck(x1,y1,x2,y2 : integer);
 { Zeichnet ein Rechteck mit (x1,y1) als rechtem oberen und (x2,y2) als
   linkem unteren Eckpunkt. }
 BEGIN
    line(x1,y1,x2,y1,1,1,1,1,$ffff,1);
    line(x2,y1,x2,y2,1,1,1,1,$ffff,1);
    line(x2,y2,x1,y2,1,1,1,1,$ffff,1);
    line(x1,y2,x1,y1,1,1,1,1,$ffff,1)
 END; { rechteck }

 PROCEDURE text_rechteck(x_cur,y_cur : integer; str : string);
 { Gibt den String str an der Cusorposition (x_cur,y_cur) aus, umrandet von
   einem Rechteck }
 BEGIN
    rechteck(x_cur*8-1,y_cur*16-1,(x_cur+length(str))*8,(y_cur+1)*16);
    gotoxy(x_cur,y_cur);
    write(str)
 END; { text_rechteck }

 FUNCTION test_xy(x,y,xr,yr,x_lng,y_lng : integer) : boolean;
 { Prueft, ob sich der Punkt (x,y) in einem Rechteck mit linkem oberen
   Eckpunkt (xr,yr) und den Massen x_lng,y_lng befindet. }
 BEGIN
    test_xy := (xr<=x) and (x<xr+x_lng) and (yr<=y) and (y<yr+y_lng)
 END; { test_xy }

 FUNCTION text_feld(x,y,text_nr : integer) : boolean;
 { Prueft, ob sich der Punkt (x,y) in der Textzeile "text_nr" des Feldes
   "Optionen" befindet: }
 BEGIN
    text_feld := test_xy(x,y,x_text*8,(y_text+2*text_nr)*16,168,16)
 END; { text_feld }

 PROCEDURE beschriftung;
 VAR k : integer;
 BEGIN
    wr_str(25,0,' Evolution *** Game of Life ',true);

    { Aufbau & Beschriftung des Feldes "Optionen". }

    rechteck(x_text*8-4,y_text*16-4,(x_text+21)*8+3,(y_text+7)*16+3);
    rechteck(x_text*8-6,y_text*16-6,(x_text+21)*8+5,(y_text+7)*16+5);
    wr_text(0,false);
    FOR k:=1 TO 3 DO text_rechteck(x_text,y_text+2*k,text[k]);

    text_rechteck(x_text,gy,' Generation Nr.:     ')
 END; { beschriftung }

 PROCEDURE wr_gen_nr;
 { Schreibt die Nummer der aktuellen Generation auf den Bildschirm. }
 BEGIN gotoxy(x_text+16,gy); write(gen:4)
 END; { wr_gen_nr }

 PROCEDURE feld;
 { Zeichnet ein Bild des Lebensraumes. }
 VAR v,k,x_max,y_max : integer;
 BEGIN
    rechteck(fx-2,fy-2,fx+flng+1,fy+flng+1);
    x_max := fx+flng-1; y_max := fy+flng-1;
    FOR k:= 0 TO n_max DO BEGIN
       v := fy+k*zv;
       line(fx,v,x_max,v,1,1,1,1,$ffff,1);         { Horizontal }
       v := fx+k*zv;
       line(v,fy,v,y_max,1,1,1,1,$ffff,1);         { Vertikal   }
    END;
 END; { feld }

 PROCEDURE generation;
 { Berechnet die naechste Generation. }
 VAR fi,fj,nb : integer;

  PROCEDURE nachbarn;
 { Ermittelt die Anzahl der besetzeten Nachbarfelder des Feldes feld1[fi,fj]. }
  VAR k,l : integer;
  BEGIN
     nb := 0;
     FOR k:=fi-1 TO fi+1 DO
        FOR l:=fj-1 TO fj+1 DO
           IF feld1[k,l] THEN nb := nb+1;
     IF feld1[fi,fj] THEN nb := nb-1
  END; { nachbarn }

 BEGIN  { generation }
    wr_text(1,true); graf_mouse(2);
    FOR fi:=0 TO og DO
       FOR fj:=0 TO og DO BEGIN
          nachbarn;
          IF feld1[fi,fj] THEN BEGIN
             IF (nb<2) or (nb>3) THEN feld2[fi,fj] := false
          END
          ELSE
             IF nb=3 THEN feld2[fi,fj] := true;
       END;
    feld1:=feld2;
    gen := gen+1;
    wr_gen_nr;

   { Zeichnen }

    FOR fi:=0 TO og DO
      FOR fj:=0 TO og DO
         IF feld1[fi,fj] THEN
            put_char('*',fx+1+zv*fi,fy+1+zv*fj,1)
         ELSE
            put_char(' ',fx+1+zv*fi,fy+1+zv*fj,1);
    wr_text(1,false); graf_mouse(0);
 END; { generation }

 PROCEDURE neue_eingabe;
 { Alte Zellkultur loeschen & Eingabe einer neuen mit der Maus. }
 VAR fi,fj : integer;
     start : boolean;

  PROCEDURE eingabe;

    PROCEDURE zelle_setzen;
    VAR flag : boolean;
    BEGIN
       fi := (x-fx-1) div zv; fj := (y-fy-1) div zv;
       xch := fx+1+zv*fi; ych := fy+1+zv*fj;
       flag := not feld1[fi,fj];
       feld1[fi,fj] := flag;
       v_hide_c(handle);
       IF flag THEN put_char('*',xch,ych,1)
       ELSE put_char(' ',xch,ych,1);
       v_show_c(handle);
    END; { zelle_setzen }

  BEGIN { eingabe }
    start := false;

      { Eingabe der neuen Zellkultur }

    REPEAT
      maus_inp;
      IF test_xy(x,y,fx,fy,flng-1,flng-1) THEN zelle_setzen
      ELSE BEGIN
         start := text_feld(x,y,1);
         IF (not start) and text_feld(x,y,3) THEN quit := true
      END;
      evnt_timer(500,0);          { 1/2 sec Verzoegerung }
    UNTIL start or quit;
  END; { eingabe }

 BEGIN { neue_eingabe }
    wr_text(2,true); graf_mouse(2);

       { Lebensraum initialisieren }

    FOR fi:=0 TO og DO
       FOR fj:=0 TO og DO BEGIN
          feld1[fi,fj] := false;
          put_char(' ',fx+1+zv*fi,fy+1+zv*fj,1)
       END;
    feld2 := feld1;

    gen := 0; wr_gen_nr;
    graf_mouse(0);
    eingabe;
    graf_mouse(2); wr_text(2,false);
    IF start THEN BEGIN
       feld2 := feld1;
       generation
    END
 END; { neue_eingabe }

 PROCEDURE auswahl;
 { Steuerung des Programmablaufs ueber das Feld "Optionen". }
 VAR ok : boolean;
     k  : integer;
 BEGIN
    k := 1; ok := false;
    REPEAT
       IF text_feld(x,y,k) THEN ok := true
       ELSE k := k+1
    UNTIL ok or (k>3);
    CASE k OF
       1 : generation;
       2 : neue_eingabe;
       3 : quit := true
    END
 END; { auswahl }

 PROCEDURE einstieg;
 VAR x0,y0,fi,fj,pst : integer;
 BEGIN
    clear_home;
    wr_str(18,4,' Evolution ( Game of Life ) nach J. H. Conway ',true);
    wr_str(10,6,'Mathematisches Modell fuer die Entwicklung von Zellkulturen',
           false);
    appl_init;
    handle:=graf_handle(gr_1,gr_2,gr_3,gr_4);
    graf_mouse(0);
    v_show_c(handle);

    { Bildschirm oeffnen }

   FOR fi:=0 TO 9 DO l_intin[fi]:=1;
   l_intin[10]:=2;
   v_opnvwk(l_intin, handle, l_out);

    { Globale Variablen initialisieren }

   gen := 0; quit := false; og := n_max-1;
   text[0] := '     Optionen :      ';   { Text fuer das Feld "Optionen" }
   text[1] := ' Naechste Generation ';
   text[2] := ' Neue Eingabe        ';
   text[3] := ' Quit                ';

       { "Lebensraum" initialisieren }

    FOR fi:=-1 TO n_max DO
       FOR fj:=-1 TO n_max DO feld1[fi,fj] := false;
    feld2 := feld1;

    { Auf Mausbewegung warten }

   wr_str(20,11,'Bitte Maus bewegen.',false);
   vq_mouse(handle,pst,x0,y0);
   REPEAT vq_mouse(handle,pst,x,y) UNTIL (x<>x0) or (y<>y0);

   v_hide_c(handle);
   clear_home; feld; beschriftung;
   v_show_c(handle);
END; { einstieg }

PROCEDURE ausstieg;
BEGIN
   wr_text(3,true);
   v_clsvwk(handle); appl_exit
END; { ausstieg }


 { ************************************************************************* }
                      {  ***  Hauptprogramm  ***  }

BEGIN { life }
   einstieg;
   REPEAT
      maus_inp;
      auswahl;
   UNTIL quit;
   ausstieg
END.
