; WACHFLIP by Darrel Anderson.  Can be used as a watch program or to 
; record using SMALLGAL.3D2  
; Can only be used to record with FEMSMALL.3D2 if
; you have at least 2 MEGABITES of RAM.
; 80 Object CAD-3D 2.02 required for all operations.

input "Watch(0) or Record(1)",recordit
if recordit=0 then input "Watch every ?nth frame",skip
if skip<0 then skip=1
if recordit=0 then alert "Place SMALLGAL.3D2 in Drive"
if recordit=0 then load3d "A:\SMALLGAL.3D2"
if recordit then alert "place FEMSMALL.3D2 in Drive"
if recordit then load3d "B:\FEMSMALL.3D2" 

bx=-4
group a:clrgrp:select Ltoes:grpcent fx,fy,fz:floor=fz

gosub DEFSPLINES
gosub TREESETUP

zoom 70:perspec 710:view w:backgnd yes,no
cam2 -5000,400,-800,0,0,0,0
if recordit then skip=1:rstart "A:\BACKFLIP",m:view s:goto RUNIT
watchon
;____________________________MAIN_LOOP___________________________
@RUNIT

; START AN 80 COUNT LOOP ...
for frame=0 to 80 step skip

; SOURCE .3d2 FILE MUST BE LOADED BEFORE EACH FRAME...

if recordit=0 then load3d "A:\SMALLGAL.3D2"
if recordit then load3d "B:\FEMSMALL.3D2"

pos=10*frame:neg=-10*frame

; POSITION JOINTS USING PREDEFINED SPLINES...

position Rhumerus,s1x(frame),s1y(frame),0
position Lhumerus,s1x(frame),(s1y(frame))*-1,0
position Rulna,0,0,0
position Rradius,0,0,0
position Lulna,pos0,0,0
position Lradius,0,0,0

position pelvis,(s2x(frame)) * -.5,0,0
position Lfemur,s2x(frame),0,0
position Rfemur,s2x(frame),0,0
position Ltibia,s3x(frame),0,0
position Lfibula,s3x(frame),0,0
position Rtibia,s3x(frame),0,0
position Rfibula,s3x(frame),0,0
position Lankle,0,0,0
position Ltoes,(s2x(frame)) * .2,0,0
position Rankle,0,0,0
position Rtoes,(s2x(frame)) * .2,0,0

position thorax,(s2x(frame)) * -.5,0,0
position cervneck,(s2x(frame)) * -.2,0,0
position skull,(s2x(frame)) * -.2,0,0

treeset saclumbr

;__________________POST-TREESET_OBJECT_MANIPULATION___________________
; AFTER THE TREESET FUNCTION HAS BEEN EXECUTED, THE OBJECT GROUP
; CAN BE MANIPULATED AS A WHOLE.
; THE FIRST OPERATION KEEPS THE FEET ON ONE LEVEL (THE "FLOOR").

group a:clrgrp:select Ltoes:grpcent cx,cy,cz:tofloor=floor-cz
group d
if frame<35 then xlate 0,0,tofloor

; THIS NEXT SECTION HANDLES THE FLIP OF THE FIGURE...

flip=s4x(frame)

; THE NEXT LINE CONVERTS ROTATION > 180 DEGREES TO NEGATIVE EQUIVALENT
if s4x(frame)>180 then flip=s4x(frame)-360
setarb fx,fy,fz:if frame>34 then setarb 0,200,0
rotate flip,0,0
if frame>34 then xlate 0,(pos-280)*5,s5z(frame-34)
bell

; GET CAMERA LOOK-AT POINT...
if frame<60 then framev=frame
if frame<50 then gosub CAMTRAC

cam2 -5000+(frame*60),400-(framev*100),-800+(framev*100),flx,fly,flz,0

; ..READY FOR SUPERVIEW.
group d:select box
bell:superview
if recordit then record
next frame
; THE PREVIOUS LINE SENDS US BACK TO THE TOP OF THE MAIN LOOP.

if recordit=0 then for pause=1 to 50:next pause:end
if recordit then rstop:end

_____________________CAMERA_TRACKING_SUB_ROUTINES_________________
@CAMTRAC
group a:clrgrp:select Rscapula:grpcent lx,ly,lz:group d
flx=lx:fly=ly:flz=lz:return

; _______________SUB-ROUTINE TO CREATE TREE STRUCTURE________________
@TREESETUP

; ADD ALL OBJECTS TO TREE (ORDER IS NOT SIGNIFICANT)

treeclr
treeadd thorax,Rhumerus,Lhumerus,Rulna,Lulna,Rradius,Lradius,Rhand,Lhand
treeadd skull,mandible,cervneck,Lscapula,Rscapula,Rclavicl,Lclavicl
treeadd pelvis,Lfemur,Lknee,Lfibula,Ltibia,Lankle,Ltoes
treeadd saclumbr,Rfemur,Rknee,Rfibula,Rtibia,Rankle,Rtoes

; NOW BUILD TREE USING SACLUMBR (LOWER SPINE) AS ROOT.
; START BY WORKING OUT TOWARDS LEFT TOES...
relate pelvis,saclumbr,*lowback
relate Lfemur,pelvis,*lhip
relate Ltibia,Lfemur,*lknee
relate Lfibula,Lfemur,*lknee
relate Lknee,Lfibula,*lknee
relate Lankle,Lfibula,*lankle
relate Ltoes,Lankle,*ltoes

; ...AND NOW TOWARDS RIGHT TOES...
relate Rfemur,pelvis,*rhip
relate Rtibia,Rfemur,*rknee
relate Rfibula,Rfemur,*rknee
relate Rknee,Rfibula,*rknee
relate Rankle,Rfibula,*rankle
relate Rtoes,Rankle,*rtoes

; ...UP TO SKULL AND OUT TO HANDS.
relate thorax,saclumbr,*midback
relate Lclavicl,thorax,*lscapul
relate Rclavicl,thorax,*rscapul
relate Rscapula,thorax,*rscapul
relate Lscapula,thorax,*lscapul
relate Rhumerus,thorax,*rsholdr
relate Lhumerus,thorax,*lsholdr
relate Rulna,Rhumerus,*relbow
relate Lulna,Lhumerus,*lelbow
relate Rradius,Rhumerus,*relbow
relate Lradius,Lhumerus,*lelbow
relate Rhand,Rulna,*rwrist
relate Lhand,Lulna,*lwrist
relate cervneck,thorax,*lowneck
relate skull,cervneck,*upneck
relate mandible,skull,*jaw

return

;________________SPLINE_DEFINITION_SUB-ROUTINES__________________
@DEFSPLINES

; SHOULDER
defpt 1,0,0,0
defpt 1,-160,0,0
defpt 1,240,0,0
defpt 1,-10,40,0
defpt 1,0,90,0
defspline 1,81,B

; FEMUR
defpt 2,0,0,0
defpt 2,180,0,0
defpt 2,120,0,0
defpt 2,-40,0,0
defpt 2,90,0,0
defpt 2,150,0,0
defpt 2,0,0,0
defspline 2,81,B

; TIBIA/FIBULA
defpt 3,0,0,0
defpt 3,-160,0,0
defpt 3,-140,0,0
defpt 3,0,0,0
defpt 3,0,0,0
defpt 3,-20,0,0
defpt 3,0,0,0
defspline 3,81,B

; WHOLE FIGURE
defpt 4,0,0,0
defpt 4,-10,0,0
defpt 4,20,0,400
defpt 4,50,0,1000
defpt 4,360,0,0
defspline 4,81,B

; JUMP
defpt 5,0,0,0
defpt 5,0,0,1000
defpt 5,0,0,0
defspline 5,47,B

return

