***************************************************************************
*  ER68_COM.Q ist die Quelltextdatei zu ER68_COM.AUT                      *
*  Beide Dateien gehren zum EASY RIDER Reassembler                       *
*  Quelltext fr ER68_ASS                         Autor: Andreas Borchard *
*  letzte nderung: 13.12.1989                                            *
***************************************************************************
*  ER68_COM.AUT enthlt die Bytefolgen, die "automatisch"  im Modus       *
*  REASSEMBLIEREN von einem definierten KOMMENTAR begleitet werden        *
*  ER68_COM.AUT mu in folgendem Format vorliegen:                        *
*                                                                       
*  1. DESKRIPTORFELD
*  DC.W         DISTANZ VOM 1. ZUM 2. DESKRIPTORFELD (MAX. 32767 B.) 
*  DC.B         1. BYTE DER ZU KOMMENTIERENDEN BYTEFOLGE
*  DC.B         ANZAHL DER NOCHFOLGENDEN BYTES DER BYTEFOLGE (MAX. 255 B.)
*  DC.B         2.BYTE,3.BYTE,4.BYTE ...
*  DC.B         'AUSZUGEBENDER KOMMENTAR',0
*  EVEN
*  2. DESKRIPTORFELD 
*  USW.
*  
*  Dem letzten Deskriptorfeld mu ein abschlieendes 'DC.W 0' folgen.
*  Steuercodes im Kommentarfeld auer <TAB> (=9) und <Control G> (=7)
*  werden ignoriert!
*  Eine Bytefolge wird Byte fr Byte mit den Opcodes im reassemblierten 
*  Programm verglichen, und zwar grundstzlich beginnend beim Opcodeanfang!
*  Datenbytes werden nicht verglichen, wohl aber Befehlsemulatoren (LINEA,
*  LINEF), falls diese zu Code gewandelt wurden.
*  In einer Bytefolge kann $AA als Platzhalter fr ein beliebiges Byte ver-
*  wendet werden. Wenn mit $AA selbst verglichen werden soll mu ein zweites
*  $AA nachgestellt werden.
*  Wenn der Platzhalter gleich an 1. Stelle eingesetzt werden soll, mu
*  das 2. Byte ebenfalls der Platzhalter sein.
*  BEISPIELE:
*
*  1)
*  DC.B  $AA                    ;1. BYTE
*  DC.B  4                      ;ANZAHL DER WEITEREN B.
*  DC.B  $AA,$3C,$00,$4A        ;WEITERE BYTES
*
*  sucht nach $??3C004A 
*  und kommentiert alle Befehle, die dem Muster '*.W #$4A,*' entsprechen.
*
*  2)
*  DC.B  $AA                    ;1. BYTE
*  DC.B  2                      ;ANZAHL DER WEITEREN B.
*  DC.B  $AA,$AA                ;WEITERE BYTES
*
*  sucht nach $AA 
*  und kommentiert (findet) vermutlich nichts.
*
*  3)
*  DC.B  $3F                    ;1. BYTE
*  DC.B  3                      ;ANZAHL DER WEITEREN B.
*  DC.B  $3C,$00,$AA            ;WEITERE BYTES
*
*  sucht nach $3F3C00?? 
*  und kommentiert alle Befehle mit folgendem Muster: 'MOVE.W #$??,-(A7)'.
*
*  4)
*  DC.B  $3F                    ;1. BYTE
*  DC.B  4                      ;ANZAHL DER WEITEREN B.
*  DC.B  $3C,$00,$AA,$AA        ;WEITERE BYTES
*
*  sucht nach $3F3C00AA 
*  und kommentiert 'MOVE.W #$AA,-(A7)'.
*
*  5)
*  DC.B  $AA                    ;1. BYTE
*  DC.B  0                      ;ANZAHL DER WEITEREN B.
*
*  sucht nach $?? 
*  und kommentiert jeden Befehl.
***************************************************************************

 MODUL \EASYRIDE\ER68_COM.AUT      * Unter diesem Namen soll der Code 
                                   * gespeichert werden

 ORG   0                           * um einen Programmheader zu verhindern 
**************************************************************************
* GEMDOS-ROUTINEN
 LOCAL
 DC.W  .AUT2-*
 DC.B  $42
 DC.B  (.AUT1-*)-1
 DC.B  $67,$4E,$41
.AUT1:
 DC.B  '	;PTERM0',0                
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,1,$4E,$41
.AUT1:
 DC.B  '	;CCONIN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,2,$4E,$41
.AUT1:
 DC.B  '	;CCONOUT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,3,$4E,$41
.AUT1:
 DC.B  '	;CAUXIN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,4,$4E,$41
.AUT1:
 DC.B  '	;CAUXOUT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,5,$4E,$41
.AUT1:
 DC.B  '	;CPRNOUT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,6,$4E,$41
.AUT1:
 DC.B  '	;CRAWIO',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,7,$4E,$41
.AUT1:
 DC.B  '	;CRAWCIN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,8,$4E,$41
.AUT1:
 DC.B  '	;CNECIN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,9,$4E,$41
.AUT1:
 DC.B  '	;CCONWS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$A,$4E,$41
.AUT1:
 DC.B  '	;CCONRS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$B,$4E,$41
.AUT1:
 DC.B  '	;CCONIS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$E,$4E,$41
.AUT1:
 DC.B  '	;DSETDRV',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$10,$4E,$41
.AUT1:
 DC.B  '	;CCONOS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$11,$4E,$41
.AUT1:
 DC.B  '	;CPRNOS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$12,$4E,$41
.AUT1:
 DC.B  '	;CAUXIS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$13,$4E,$41
.AUT1:
 DC.B  '	;CAUXOS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$19,$4E,$41
.AUT1:
 DC.B  '	;DGETDRV',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$1A,$4E,$41
.AUT1:
 DC.B  '	;DSETDTA',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$20,$4E,$41
.AUT1:
 DC.B  '	;SUPER',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$2A,$4E,$41
.AUT1:
 DC.B  '	;TGETDATE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$2B,$4E,$41
.AUT1:
 DC.B  '	;TSETDATE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$2C,$4E,$41
.AUT1:
 DC.B  '	;TGETTIME',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$2D,$4E,$41
.AUT1:
 DC.B  '	;TSETTIME',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$2F,$4E,$41
.AUT1:
 DC.B  '	;FGETDTA',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$30,$4E,$41
.AUT1:
 DC.B  '	;SVERSION',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$31,$4E,$41
.AUT1:
 DC.B  '	;PTERMRES',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$36,$4E,$41
.AUT1:
 DC.B  '	;DFREE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$39,$4E,$41
.AUT1:
 DC.B  '	;DCREATE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3A,$4E,$41
.AUT1:
 DC.B  '	;DDELETE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3B,$4E,$41
.AUT1:
 DC.B  '	;DSETPATH',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3C,$4E,$41
.AUT1:
 DC.B  '	;FCREATE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3D,$4E,$41
.AUT1:
 DC.B  '	;FOPEN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3E,$4E,$41
.AUT1:
 DC.B  '	;FCLOSE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3F,$4E,$41
.AUT1:
 DC.B  '	;FREAD',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$40,$4E,$41
.AUT1:
 DC.B  '	;FWRITE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$41,$4E,$41
.AUT1:
 DC.B  '	;FDELETE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$42,$4E,$41
.AUT1:
 DC.B  '	;FSEEK',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$43,$4E,$41
.AUT1:
 DC.B  '	;FATTRIB',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$45,$4E,$41
.AUT1:
 DC.B  '	;FDUP',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$46,$4E,$41
.AUT1:
 DC.B  '	;FFORCE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$47,$4E,$41
.AUT1:
 DC.B  '	;DGETPATH',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$48,$4E,$41
.AUT1:
 DC.B  '	;MALLOC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$49,$4E,$41
.AUT1:
 DC.B  '	;MFREE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$4A,$4E,$41
.AUT1:
 DC.B  '	;MSHRINK',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$4B,$4E,$41
.AUT1:
 DC.B  '	;PEXEC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$4C,$4E,$41
.AUT1:
 DC.B  '	;PTERM',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$4E,$4E,$41
.AUT1:
 DC.B  '	;FSFIRST',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$4F,$4E,$41
.AUT1:
 DC.B  '	;FSNEXT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$56,$4E,$41
.AUT1:
 DC.B  '	;FRENAME',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$57,$4E,$41
.AUT1:
 DC.B  '	;FDATIME',0
 EVEN
.AUT2:
* BIOS-ROUTINEN
 LOCAL
 DC.W  .AUT2-*
 DC.B  $42
 DC.B  (.AUT1-*)-1
 DC.B  $67,$4E,$4D
.AUT1:
 DC.B  '	;GETMBP',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,1,$4E,$4D
.AUT1:
 DC.B  '	;BCONSTAT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,2,$4E,$4D
.AUT1:
 DC.B  '	;BCONIN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,3,$4E,$4D
.AUT1:
 DC.B  '	;BCONOUT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,4,$4E,$4D
.AUT1:
 DC.B  '	;RWABS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,5,$4E,$4D
.AUT1:
 DC.B  '	;SETEXC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,6,$4E,$4D
.AUT1:
 DC.B  '	;TICKCAL',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,7,$4E,$4D
.AUT1:
 DC.B  '	;GETBPB',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,8,$4E,$4D
.AUT1:
 DC.B  '	;BCOSTAT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,9,$4E,$4D
.AUT1:
 DC.B  '	;MEDIACH',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,10,$4E,$4D
.AUT1:
 DC.B  '	;DRVMAP',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,11,$4E,$4D
.AUT1:
 DC.B  '	;KBSHIFT',0
 EVEN
.AUT2:
* XBIOS-ROUTINEN
 LOCAL
 DC.W  .AUT2-*
 DC.B  $42
 DC.B  (.AUT1-*)-1
 DC.B  $67,$4E,$4E
.AUT1:
 DC.B  '	;INITMOUSE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,2,$4E,$4E
.AUT1:
 DC.B  '	;PHYSBASE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,3,$4E,$4E
.AUT1:
 DC.B  '	;LOGBASE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,4,$4E,$4E
.AUT1:
 DC.B  '	;GETREZ',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,5,$4E,$4E
.AUT1:
 DC.B  '	;SETSCREEN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,6,$4E,$4E
.AUT1:
 DC.B  '	;SETPALLETE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,7,$4E,$4E
.AUT1:
 DC.B  '	;SETCOLOR',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,8,$4E,$4E
.AUT1:
 DC.B  '	;FLOPRD',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,9,$4E,$4E
.AUT1:
 DC.B  '	;FLOPWR',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,10,$4E,$4E
.AUT1:
 DC.B  '	;FLOPFMT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,12,$4E,$4E
.AUT1:
 DC.B  '	;MIDIWS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,13,$4E,$4E
.AUT1:
 DC.B  '	;MFPINT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,14,$4E,$4E
.AUT1:
 DC.B  '	;IOREC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,15,$4E,$4E
.AUT1:
 DC.B  '	;RSCONF',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,16,$4E,$4E
.AUT1:
 DC.B  '	;KEYBTL',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,17,$4E,$4E
.AUT1:
 DC.B  '	;RANDOM',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,18,$4E,$4E
.AUT1:
 DC.B  '	;PROTOBT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,19,$4E,$4E
.AUT1:
 DC.B  '	;FLOPVER',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,20,$4E,$4E
.AUT1:
 DC.B  '	;SCRDMP',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,21,$4E,$4E
.AUT1:
 DC.B  '	;CURSCONF',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,22,$4E,$4E
.AUT1:
 DC.B  '	;SETTIME',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,23,$4E,$4E
.AUT1:
 DC.B  '	;GETTIME',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,24,$4E,$4E
.AUT1:
 DC.B  '	;BIOSKEYS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,25,$4E,$4E
.AUT1:
 DC.B  '	;IKBDWS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,26,$4E,$4E
.AUT1:
 DC.B  '	;JDISINT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,27,$4E,$4E
.AUT1:
 DC.B  '	;JENABINT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,28,$4E,$4E
.AUT1:
 DC.B  '	;GIACCESS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,29,$4E,$4E
.AUT1:
 DC.B  '	;OFFGIBIT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,30,$4E,$4E
.AUT1:
 DC.B  '	;ONGIBIT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,31,$4E,$4E
.AUT1:
 DC.B  '	;XBTIMER',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,32,$4E,$4E
.AUT1:
 DC.B  '	;DOSOUND',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,33,$4E,$4E
.AUT1:
 DC.B  '	;SETPRT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,34,$4E,$4E
.AUT1:
 DC.B  '	;KBDVBASE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,35,$4E,$4E
.AUT1:
 DC.B  '	;KBRATE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,36,$4E,$4E
.AUT1:
 DC.B  '	;PRTBLK',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,37,$4E,$4E
.AUT1:
 DC.B  '	;VSYNC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,38,$4E,$4E
.AUT1:
 DC.B  '	;SUPEXEC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,39,$4E,$4E
.AUT1:
 DC.B  '	;PUNTAES',0
 EVEN
.AUT2:
*AES UND VDI
 LOCAL
 DC.W  .AUT2-*
 DC.B  $30
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$C8,$4E,$42
.AUT1:
 DC.B  '	;AES-AUFRUF',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $70
 DC.B  (.AUT1-*)-1
 DC.B  $73,$4E,$42
.AUT1:
 DC.B  '	;VDI-AUFRUF',0
 EVEN
.AUT2:
 IFEQ  0
* BEISPIELE FR WEITERE MGLICHE KOMMENTARE
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$30
.AUT1:
 DC.B  "	;#'0'",0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$39
.AUT1:
 DC.B  "	;#'9'",0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$41
.AUT1:
 DC.B  "	;#'A'",0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$5A
.AUT1:
 DC.B  "	;#'Z'",0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$7A
.AUT1:
 DC.B  "	;#'z'",0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$61
.AUT1:
 DC.B  "	;#'a'",0
 EVEN
.AUT2:
 LOCAL
 ENDIF
 DC.W  0         * DAMIT MU DIE DATEI ABSCHLIEEN!
 END
