**************************************************
* Beispiel-Druckertreiber zum Programm DIGITAL   *
* fr EPSON-kompatible Drucker                   *
*                                                *
* (Source fr Metacomco-Assembler)               *
*                                                *
*                               Erich Eder, 1988 *
**************************************************

      TEXT
*
* Initialisierungsroutine:
* bergibt dem Hauptprogramm Adressen
*
         LEA      DRUCK,A0             ;Adresse der Druckroutine -> A0
         LEA      TABELLE,A1           ;Tabelle mit Textzeigern  -> A1
         MOVEQ    #2,D0                ;Zwei Druckmodi           -> D0
         RTS                           ;... und zurck

*
* Druckroutine:
* Wird bei Druckanforderung aufgerufen
*
* Registerbelegung bei Aufruf:
*    D0,D1: Breite, Hhe des zu druckenden Bereichs
*    D2   : Druckmodus (hier 0 oder 1)
*    A5   : Adresse der Zeichenausgabe-Routine
*    A6   : Adresse der Routine, die die Punktfarbe liefert
*
DRUCK:
         MOVE     D0,BREITE            ;Bildgre retten
         MOVE     D1,HOEHE
         TST      D2                   ;Welcher Modus ?
         BNE      SCHOEN

         ; Schnelldruck-Modus
         CLR      D7                   ;D7: Y-Koordinate = 0
M1:      LEA      PLOTTER,A0           ;Druckzeilenheader fr Plotter Graphics
         MOVE     BREITE,D0
         MOVE     D0,6(A0)             ;Low Byte der Druckbreite
         AND      #$FF,6(A0)
         LSR      #8,D0
         MOVE     D0,8(A0)             ;High Byte der Druckbreite
         BSR      FOLGE                ;Header ausgeben
         CLR      D6                   ;D6: X-Koordinate = 0
M2:      CLR      D5                   ;D5: Druckbyte
         MOVEQ    #7,D4                ;8 Bits untereinander sammeln
         MOVE     D7,D3                ;Hilfs-Y-Position -> D3
M3:      LSL      #1,D5                ;Druckbits um 1 Stelle nach High
         MOVE     D6,D0                ;X-Position bergeben
         MOVE     D3,D1                ;Y-Position bergeben
         JSR      (A6)                 ;Punktfarbe holen
         OR       D0,D5                ;Bit in Druckbyte stellen
         ADDQ     #1,D3                ;Hilfs-Y-Position erhhen
         DBRA     D4,M3                ;Nchstes Bit holen
         MOVE     D5,D0                ;Druckbyte bergeben ...
         JSR      (A5)                 ;... und ausgeben
         ADDQ     #1,D6                ;X-Position erhhen
         CMP      BREITE,D6            ;Schon am rechten Rand ?
         BLT.S    M2                   ;Nchste Spalte
         LEA      LF_24,A0
         BSR      FOLGE                ;Zeilenvorschub
         ADDQ     #8,D7                ;Y-Position um 8 Pixels erhhen
         CMP      HOEHE,D7             ;Schon am unteren Rand ?
         BLT.S    M1                   ;Nchste Druckzeile
         RTS                           ;Fertig !

SCHOEN:  ; Schndruck-Modus
         CLR      D7                   ;D7: Y-Koordinate = 0
M10      MOVEQ    #2,D2                ;Doppeldruck
M11:     LEA      QUADRUPLE,A0         ;Druckzeilenheader fr 4-fache Dichte
         MOVE     BREITE,D0
         MULU     #3,D0                ;Jede Spalte 3 mal ausgeben
         MOVE     D0,6(A0)             ;Low Byte der Druckbreite
         AND      #$FF,6(A0)
         LSR      #8,D0
         MOVE     D0,8(A0)             ;High Byte der Druckbreite
         BSR      FOLGE                ;Header ausgeben
         CLR      D6                   ;D6: X-Koordinate = 0
M12:     CLR      D5                   ;D5: Druckbyte
         MOVEQ    #7,D4                ;8 Bits untereinander sammeln
         MOVE     D7,D3                ;Hilfs-Y-Position -> D3
M13:     LSL      #1,D5                ;Druckbits um 1 Stelle nach High
         MOVE     D6,D0                ;X-Position bergeben
         MOVE     D3,D1                ;Y-Position bergeben
         JSR      (A6)                 ;Punktfarbe holen
         OR       D0,D5                ;Bit in Druckbyte stellen
         ADDQ     #1,D3                ;Hilfs-Y-Position erhhen
         DBRA     D4,M13               ;Nchstes Bit holen
         MOVE     D5,D0                ;Druckbyte bergeben ...
         JSR      (A5)                 ;... und ausgeben
         MOVE     D5,D0                ;Und das drei mal
         JSR      (A5)
         MOVE     D5,D0
         JSR      (A5)
         ADDQ     #1,D6                ;X-Position erhhen
         CMP      BREITE,D6            ;Schon am rechten Rand ?
         BLT.S    M12                  ;Nchste Spalte
         SUBQ     #1,D2                ;Lagenzhler erniedrigen
         BEQ.S    M14                  ;Keine Lage mehr !
         LEA      LF_1,A0
         BSR      FOLGE                ;1/216" Zeilenvorschub
         BRA      M11                  ;Nchste Lage
M14      LEA      LF_23,A0
         BSR      FOLGE                ;23/216 " Zeilenvorschub
         ADDQ     #8,D7                ;Y-Position um 8 Pixels erhhen
         CMP      HOEHE,D7             ;Schon am unteren Rand ?
         BLT.S    M10                  ;Nchste Druckzeile
         RTS                           ;Fertig !

*
* Unterprogramm:
* Gibt Wortfolge, die mit -1 abgeschlossen ist, aus
*
* Parameter:
*    A0: Zeiger auf Wortfolge
*    A5: Zeiger auf Ausgaberoutine
*
FOLGE:   MOVE     (A0)+,D0             ;Wort bergeben
         JSR      (A5)                 ;Ausgabe
         TST      (A0)                 ;Schon am Ende ?
         BPL.S    FOLGE                ;Nchstes Wort
         RTS


*********************
* Datendefinitionen *
*********************

         DATA

BREITE:     DS    1
HOEHE:      DS    1

* Drucker- und Modusbezeichnungen
TABELLE:    DC.L  DRNAME,MODUS1,MODUS2
DRNAME:     DC.B  "EPSON / Beispiel",0
MODUS1:     DC.B  "Schnelldruck",0
MODUS2:     DC.B  "Schndruck",0
            DS    0

* Drucker-Steuersequenzen
PLOTTER:    DC    $1B,$2A,5,0,0,-1
QUADRUPLE:  DC    $1B,$2A,3,0,0,-1
LF_1:       DC    $0D,$1B,$4A,1,-1
LF_23:      DC    $0D,$1B,$4A,23,-1
LF_24:      DC    $0D,$1B,$4A,24,-1

         END

