/*----------------------------------------------------------------------*/
/*          A_PAINT - Demo zur Benutzung des VDI im AUTO-Ordner         */
/*                    Implementiert in Turbo C                          */
/*----------------------------------------------------------------------*/ 
/* Includes                                                             */
/*----------------------------------------------------------------------*/ 
#include <vdi.h>
#include <tos.h>                       /* fr andere Compiler osbind.h  */
/*----------------------------------------------------------------------*/ 
/* Typendefinitionen                                                    */
/*----------------------------------------------------------------------*/ 
typedef enum{FALSE,TRUE} boolean;
/*----------------------------------------------------------------------*/    
/* Globale Variablen                                                    */
/*----------------------------------------------------------------------*/
int   contrl[12],
      intin[128],
      intout[128],
      ptsin[128],
      ptsout[128],
      work_in[11],
      work_out[57],
      handle;
/*----------------------------------------------------------------------*/    
/* Funktionsdeklarationen                                               */
/*----------------------------------------------------------------------*/
extern int vq_aes(void);
void  open_work(void);
/*----------------------------------------------------------------------*/    
/* ffnen einer Workstation mit v_opnwk                                 */
/*----------------------------------------------------------------------*/
void open_work(void)                                                                         
{
   register int index;
   
   for(index = 0; index < 10;work_in[index++] = 1);
/*
*  work_in[0]  = 1 ;Bildschirmtreiber in aktueller Auflsung
*  work_in[1]  = 1 ;Linienstil       : durchgehend
*  work_in[2]  = 1 ;Linienfarbe      : schwarz
*  work_in[3]  = 1 ;Markertyp        : Punkt
*  work_in[4]  = 1 ;Markerfarbe      : schwarz
*  work_in[5]  = 1 ;Zeichensatznummer: Systemzeichensatz
*  work_in[6]  = 1 ;Textfarbe        : schwarz
*  work_in[7]  = 1 ;Flltyp          : voll
*  work_in[8]  = 1 ;Fllmusterindex  : bei diesem Flltyp unwichtig
*  work_in[9]  = 1 ;Fllmusterfarbe  : schwarz
*/                                                                      
   work_in[10] = 2;                       /* Koordinatenflag (RC-System)*/
   v_opnwk(work_in,&handle,work_out);     /* Workstation ffnen         */
   if(handle == 0) Pterm(-1);             /* v_opnwk fehlgeschlagen ?   */ 
}

/*----------------------------------------------------------------------*/ 
/* Hauptprogramm                                                        */
/*----------------------------------------------------------------------*/ 
main(void)
{
   int   du,                              /* Dummy-Variable             */
         mitte_x,                         /* Bildmitte-x                */
         mitte_y,                         /* Bildmitte-y                */
         x,                               /* horizontale Mausposition   */
         y,                               /* vertikale Mausposition     */
         taste;                           /* Maustastenstatus           */
   
   if (vq_aes()== -1) Pterm(-1);          /* AES schon installiert ?    */
   open_work();                           /* Workstation ffnen         */    
   
   mitte_x=work_out[0]/2;                 /* Bildmitte                  */
   mitte_y=work_out[1]/2;
   
   vswr_mode(handle,1);                   /* Schreibmodus 1 (REPLACE)   */ 
   vsf_color(handle,1);                   /* Fllfarbe 1 (schwarz)      */
   vsf_interior(handle,2);                /* Flltyp 2 (gemustert)      */
   vsf_style(handle,1);                   /* Fllindex 1                */

   ptsin[0]=100;                          /* Koordinaten des Rechtecks  */
   ptsin[1]=100;
   ptsin[2]=200;
   ptsin[3]=200;
   v_bar(handle,ptsin);                   /* geflltes Reckteck zeichnen*/

   vst_font(handle,1);                    /* Systemzeichensatz einstellen  */
   vst_color(handle,1);                   /* Textfarbe 1 (schwarz)      */
   vst_height(handle,13,&du,&du,&du,&du); /* Texthhe von 13 Pixeln     */
   vst_alignment(handle,1,0,&du,&du);     /* hor. und vert. Ausrichtung */
   vst_rotation(handle,0);                /* keine Textrotation         */
   vst_effects(handle,9);                 /* fett und unterstrichen     */
   v_gtext(handle,mitte_x,13,"A_PAINT - Beispiel fr Benutzung des VDI im AUTO-Ordner");
   vst_effects(handle,0);                 /* keine Texteffekte          */
   v_gtext(handle,mitte_x,29,"Linke Maustaste => Zeichnen");
   v_gtext(handle,mitte_x,45,"Rechte Maustaste => Ende");
   
   v_show_c(handle,0);                    /* Maus an                    */
   vsin_mode(handle,1,2);                 /* Maus im SAMPLE-Modus       */
   vsm_locator(handle,mitte_x,mitte_y,&du,&du,&du);
   
   vsl_color(handle,1);                   /* Linienfarbe 1 (schwarz)    */
   vsl_type(handle,1);                    /* Linientyp 1 (durchgehend)  */
   vsl_width(handle,1);                   /* Linienbreite 1             */
   vsl_ends(handle,0,0);                  /* eckige Linienenden         */
   
   do
   {
      vq_mouse(handle,&taste,&x,&y);
      if (taste==1)                       /* linke Maustaste gedrckt ? */
      {
         v_hide_c(handle);                /* Maus aus                   */
         ptsin[0]=x;                      /* Linien-Koordinaten         */
         ptsin[1]=y;
         ptsin[2]=x;
         ptsin[3]=y;
         v_pline(handle,2,ptsin);         /* Punkt setzen               */
         v_show_c(handle,0);              /* Maus an                    */
      }
   }
   while (taste!=2);                      /* rechte Maustaste gedrckt ?*/

   v_clswk(handle);                       /* Workstation schlieen      */
   return(0);                             /* Ende                       */
}
/*----------------------------------------------------------------------*/ 
/* That's it !!                                                         */
/*----------------------------------------------------------------------*/ 
   

      
