(*************************************************************************
  Desktoprechner	Copyright (c) 1992 by Application Systems Heidelberg.
  ==============	Alle Rechte vorbehalten.

  Autor:				Dietmar Rabich
  Unit:					HANDLER.PAS
  Entwicklungssystem:	PurePascal

  Der Handler bernimmt alle Eingabeauswertung (bis auf die Information).

*************************************************************************)

UNIT Handler;


(* Die Schnittstelle zu den anderen Moduln *)
INTERFACE


(* Konstanten *)
CONST	(* Gltige Tasten *)
		KeyEnter		=	CHR(13);
		KeyClear		=	'(';
		KeyChangeSign	=	'.';
		Key0			=	'0';
		Key1			=	'1';
		Key2			=	'2';
		Key3			=	'3';
		Key4			=	'4';
		Key5			=	'5';
		Key6			=	'6';
		Key7			=	'7';
		Key8			=	'8';
		Key9			=	'9';
		KeyFirstNumber	=	Key0;
		KeyLastNumber	=	Key9;
		KeyMemory		=	'm';
		KeyReMemory		=	'r';
		KeyClearMemory	=	'c';
		KeySwitchMemory	=	's';
		KeyAdd			=	'+';
		KeyMul			=	'*';
		KeySub			=	'-';
		KeyDiv			=	'/';


(* Typen *)
TYPE	(* Fehlertypen *)
		ErrorType	=	(NoError, Overflow, DivisionBy0);

		(* Objekt Rechner *)
		Calculator	=	OBJECT

							(* Variablen fr Speicher,
								gegenwrtige Zahl und
								aktuelle Zahl im Speicher *)
							Memory,
							Current,
							Buffer		:	LONGINT;

							(* letzte Taste und letzte Operation *)
							LastKey,
							LastOp		:	CHAR;

							(* gltige Tasten *)
							KeyValid,
							KeyOper		:	SET OF CHAR;

							(* (letzter) Fehler *)
							Error		:	ErrorType;

							(* Konstruktor *)
							CONSTRUCTOR Init;

							(* Eingabe *)
							FUNCTION Input(c : CHAR) : BOOLEAN;

							(* Ergebnis *)
							FUNCTION Result : LONGINT;

							(* Abfrage auf Speicher *)
							FUNCTION MemoryEmpty	: BOOLEAN;

							(* Abfrage des Fehlers *)
							FUNCTION IsError : ErrorType;
						END;


(* Implementierung *)
IMPLEMENTATION


(* Funktion, die die Anzahl der Ziffern zhlt *)
FUNCTION Numbers(x : LONGINT) : INTEGER;

(* Variablen *)
VAR	LNumbers	:	INTEGER;

BEGIN

	(* Ist die Zahl 0? Dann nehmen wir keine Ziffer an! *)
	IF x = 0 THEN
		Numbers	:=	0
	ELSE
	BEGIN

		(* Anzahl der Ziffern erst einmal 0 *)
		LNumbers	:=	0;

		(* Schleife durchfhren, bis Zahl 0 ist *)
		WHILE x <> 0 DO
		BEGIN

			(* noch eine Ziffer! *)
			INC(LNumbers);

			(* nchste Ziffer *)
			x	:=	x DIV 10

		END;

		(* Anzahl der Ziffern *)
		Numbers	:=	LNumbers
	END
END;


(* Konstruktor zum Initialisieren *)
CONSTRUCTOR Calculator.Init;
BEGIN

	(* Menge der gltigen Tasten *)
	KeyValid	:=	[KeyFirstNumber..KeyLastNumber, KeyEnter, KeyClear,
					 KeyChangeSign, KeyMemory, KeyReMemory, KeyClearMemory,
					 KeySwitchMemory, KeyAdd, KeySub, KeyMul, KeyDiv];

	(* Menge der gltigen Operationen *)
	KeyOper		:=	[KeyAdd, KeySub, KeyMul, KeyDiv];

	(* Alle Speicher lschen *)
	Current		:=	0;
	Memory		:=	0;
	Buffer		:=	0;

	(* letzte Operation vorerst 0 *)
	LastOp		:=	CHR(0)

END;


(* Eingabeauswertung *)
FUNCTION Calculator.Input(c : CHAR) : BOOLEAN;

(* Variablen *)
VAR	Temp	:	LONGINT;
	TempR	:	REAL;

BEGIN

	(* Erst einmal annehmen, da kein Fehler auftritt *)
	Error	:=	NoError;

	(* Eingabe wird als wahr angenommen *)
	Input	:=	TRUE;

	(* Falls keine gltige Taste, nichts machen und Fehler melden *)
	IF NOT(c IN KeyValid) THEN
	BEGIN
		Input	:=	FALSE;
		EXIT
	END;

	(* Auswertung der Taste *)
	CASE c OF

		(* Zifferntaste? *)
		KeyFirstNumber..KeyLastNumber	:

			(* Kein Platz mehr? *)
			IF Current > 1E7 THEN
				Error	:=	Overflow
			ELSE
				Current	:=	Current * 10 + ORD(c) - ORD(KeyFirstNumber);

		(* Vorzeichenwechsel? *)
		KeyChangeSign	:
			Current	:=	Current * -1;

		(* Lschen? *)
		KeyClear		:
			IF LastKey = KeyClear THEN
				Current	:=	0
			ELSE
				Current	:=	Current DIV 10;

		(* aktuellen Wert speichern? *)
		KeyMemory		:
			Memory	:=	Current;

		(* Wert aus dem Speicher holen? *)
		KeyReMemory		:
			Current	:=	Memory;

		(* Speicher ls                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                (*************************************************************************
  Desktoprechner	Copyright (c) 1992 by Application Systems Heidelberg.
  ==============	Alle Rechte vorbehalten.

  Autor:				Dietmar Rabich
  Unit:					HANDLER.PAS
  Entwicklungssystem:	PurePascal

  Der Handler bernimmt alle Eingabeauswertung (bis auf die Information).

*************************************************************************)

UNIT Handler;


(* Die Schnittstelle zu den anderen Moduln *)
INTERFACE


(* Konstanten *)
CONST	(* Gltige Tasten *)
		KeyEnter		=	CHR(13);
		KeyClear		=	'(';
		KeyChangeSign	=	'.';
		Key0			=	'0';
		Key1			=	'1';
		Key2			=	'2';
		Key3			=	'3';
		Key4			=	'4';
		Key5			=	'5';
		Key6			=	'6';
		Key7			=	'7';
		Key8			=	'8';
		Key9			=	'9';
		KeyFirstNumber	=	Key0;
		KeyLastNumber	=	Key9;
		KeyMemory		=	'm';
		KeyReMemory		=	'r';
		KeyClearMemory	=	'c';
		KeySwitchMemory	=	's';
		KeyAdd			=	'+';
		KeyMul			=	'*';
		KeySub			=	'-';
		KeyDiv			=	'/';


(* Typen *)
TYPE	(* Fehlertypen *)
		ErrorType	=	(NoError, Overflow, DivisionBy0);

		(* Objekt Rechner *)
		Calculator	=	OBJECT

							(* Variablen fr Speicher,
								gegenwrtige Zahl u