      PROGRAM gemdemo
*
*     Date: 5  June  1987
*
*     This simple GEM program displays an alert, and then
*     draws a graph in a window.  It illustrates the most
*     basic use of GEM.  Normal use of GEM would require
*     event-handling and redraw logic, and a resource file.
*     (Such a program is normally a thousand or more lines
*     long.)
*

      IMPLICIT NONE

      INTEGER*4 handle, desk_x, desk_y, desk_w, desk_h
      INTEGER*4 wx, wy, ww, wh, my_window, dummy
*     Clip rectangle:
      INTEGER*2 clip_rect(0:3)
*     Variable used for setting the window's title:
      CHARACTER*17 my_title
*     Variables used to calculate graph points:
      REAL a, b, x_scale, y_scale
*     VDI parameter arrays:
      INTEGER*2 points(0:200), work_in(0:10), work_out(0:56)
*     DO loops:
      INTEGER*4 I

      INCLUDE 'GEMCONST'
      INCLUDE 'GEMFUNCS'

*     Initialise AES
      CALL appl_init

*     Open virtual workstation
      handle = graf_handle(dummy, dummy, dummy, dummy)
      DO 1 I = 0, 9
1     work_in(I) = 1
      work_in(3) = 3         ! Marker style 3
      work_in(7) = 0         ! Fill interior hollow
      work_in(10) = 2        ! RC coordinate system
      CALL v_opnvwk(work_in, handle, work_out)
      IF (handle .eq. 0) GOTO 999     ! open failed

*     Display an alert, with button 1 as default
      dummy = form_alert(1,
     +'[1][This program draws|a graph in a window.][ OK ]'//char(0))

*     Determine desktop window work area size
      CALL wind_get(0, WF_WXYWH, desk_x, desk_y, desk_w, desk_h)

*     Determine my window work area size
      ww = desk_w/2
      wh = desk_h/2
      wx = desk_x+ww/2
      wy = desk_y+wh/2

*     Create window half size
      my_window = wind_create(1, wx, wy, ww, wh)

*     Set the window's name
      my_title = 'y=sin(ax)exp(bx)'//CHAR(0)

      CALL wind_title(my_window, my_title)

*     Open the window
      CALL wind_open(my_window, wx, wy, ww, wh)

*     Set clip rectangle to work area of window
      CALL wind_get(my_window, WF_WXYWH, wx, wy, ww, wh)
      clip_rect(0) = wx
      clip_rect(1) = wy
      clip_rect(2) = wx+ww
      clip_rect(3) = wy+wh
      CALL vs_clip(handle, 1, clip_rect)

*     Hide mouse while drawing
      CALL graf_mouse(256, 0)

*     Fill rectangle with background (white)
      CALL vr_recfl(handle, clip_rect)

*     Calculate the points on the curve
      a = 0.3
      b = 0.02
      x_scale = ww/100.0
      y_scale = wh/10.0
      DO 5 I=0, 198, 2
      points(I) = wx + I*x_scale
5     points(I+1) = wy+wh/2 - SIN(a*I)*EXP(b*I)*y_scale

*     Draw the curve
      CALL v_pline(handle, 100, points)

*     Mark every fifth point
      DO 10 I = 0, 38, 2
      points(I) = points(I*5)
10    points(I+1) = points(I*5+1)
      CALL v_pmarker(handle, 20, points)

*     Show mouse after update
      CALL graf_mouse(0, 0)
      CALL graf_mouse(257, 0)

*     Wait for any key before closing window
      CALL evnt_keybd
      CALL wind_close(my_window)

*     Application exit
      CALL v_clsvwk(handle)
999   CALL appl_exit
      END

