	program printf
*
*   Utility program to copy a variable-length formatted
*   file from disc (where the first character of each line
*   has not been interpreted as carriage-control)
*   to the printer (with carriage-control interpretation)
*
*   To print a disc file, install the executable file PRINTF.PRG
*   as a TOS-takes-parameters application (or alternatively rename
*   the executable file as PRINTF.TTP), and, after executing the
*   program by double-clicking, type the name of the disc file to
*   be printed in the Parameters line of the OPEN APPLICATION box
*
	parameter (maxlen = 200)
	character fname*65, pname*4, text1*12, text*78, line*(maxlen)
	parameter (text1 = 'Cannot open ')
	parameter (pname = 'PRN:')
	integer funit, punit, ind
	parameter (funit = 5, punit = 6)
*   Get the filename from the command line
	call getcom(fname)
*   Open the disc file
	open (funit, file = fname, status = 'old', err = 90)
*   Open the printer
	open (punit, file = pname, status = 'new', err = 91)
*   Main loop to read each line from the disc file, and then
*   send it to the printer, having removed trailing blanks
10	read (funit, 80, err = 92, end = 100) line
	do 20 ind = maxlen, 1, -1
	if (line(ind:ind) .ne. ' ') goto 30
20	continue
30	if (ind .lt. 1) ind = 1
	write (punit, 80, err = 93) line(1:ind)
	goto 10
*   Format
80	format(A)
*   Errors
90	text = text1//fname
	goto 99
91	text = text1//pname
	goto 99
92	text = 'Cannot read '//fname
	goto 99
93	text = 'Cannot write '//pname
99	print *, text
*   Terminate
100	end
