{$S4,A+,T-,D-}      { Accessory - 4 KByte Stack }

{
  Dieses Programm als GEM Applikation bersetzen, in *.ACC umbenennen, auf die
  Bootdiskette kopieren und neu booten.
}


PROGRAM Sample_Accessory ;

  CONST
    {$I gemconst.pas}

  TYPE
    {$I gemtype.pas}

  VAR
    window,                     { Die Handle-Nummer des Fensters }
    ap_id,                      { Die Handle-Nummer der Applikation }
    menu_id : integer ;         { Index des Menueintrags im "Desk" Menu }
    our_name,                   { Der Name des Accessoirs }
    wind_name : Str255 ;        { Der Titel des Fensters }

  {$I gemsubs.pas}


  { Falls des Fenster nicht geoefnet ist, wird es nun geoffnet. War es bereits
    geoeffnet wird es in den Vordergrund gesetzt. }

  PROCEDURE Do_Open ;

    BEGIN
      { Existiert unser Fenster schon? }
      IF window <> No_Window THEN
        Bring_To_Front( window )        { Ja, nur in den Vordergrund bringen }
      ELSE
        BEGIN                           { Nein, neues Fenster oeffnen }
          wind_name := ' Accessory Test ' ;
          window := New_Window( G_Name|G_Close|G_Size|G_Move, wind_name,
                                0, 0, 0, 0 ) ;
          Open_Window( window, 0, 0, 0, 0 )
        END
    END ;



  { Schliessen des Fensters und Beseitigung aus dem System }

  PROCEDURE Do_Close ;

    BEGIN
      Close_Window( window ) ;
      Delete_Window( window ) ;
      window := No_Window
    END ;



  { Neuzeichnen eines Ausschnitts unseres Fensters. Der Ausschnitt wird durch
    die Parameter x0, y0, w0 und h0 beschrieben. Der Einfachheit halber
    zeichnen wir lediglich ein Rechteck in der gleichen Groesse wie den
    Ausschnitt in den ein X gezeichnet wird. Dies ist interessant zu
    beobachten, da hier zu sehen ist, was die Mitteilungen zum Neuzeichen GEM
    uebermitteln. }


  PROCEDURE Do_Redraw( handle, x0, y0, w0, h0 : integer ) ;

    VAR
      x,                { Diese vier Variablen werden dazu verwendet, die   }
      y,                { Groesse des aktuellen Rechtecks zu sichern.       }
      w,
      h : integer ;

    BEGIN
      Begin_Update ; { Wir teilen GEM mit, dass wir das Fenster aktualisieren }
      Hide_Mouse ;   { Wir machen die Maus unsichtbar, damit der Bildchirm
                       nicht zerstoert wird. }
      Paint_Color( White ) ;    { Wir fuellen das Rechteck weiss aus. }
      { Diese Schleife ist vertraut, weil sie aus dem Pascal Handbuch
        uebernommen wurde. }
      First_Rect( handle, x, y, w, h ) ;
      WHILE (w <> 0) AND (h <> 0) DO
        BEGIN
          IF Rect_Intersect( x0, y0, w0, h0, x, y, w, h ) THEN
            BEGIN
              { Das einzige Neue ist, dass wir zeichnen: }
              Set_Clip( x, y, w, h ) ;
              Paint_Rect( x, y, w, h ) ;        { Zuerst mit weiss loeschen }
              Frame_Rect( x, y, w, h ) ; { Nun den Rand des Rechtecks zeichnen}
              PLine( x, y, x+w-1, y+h-1 ) ;     { und zwei Linien fuer ein X. }
              PLine( x+w-1, y, x, y+h-1 ) ;
            END ;
          Next_Rect( handle, x, y, w, h ) ;
        END ;
      Show_Mouse ;              { OK, wir koennen die Maus wieder zeigen }
      End_Update ;              { und GEM mitteilen, dass wir fertig sind. }
    END ;



  { Die folgende Routine verwaltet alle Ereignisse, die wir von GEM erhalten.
    da dies ein Accessoir ist, werden wir nie einen Zustand erreichen, in dem
    die Routine stopt. Die folgende Schleife ist also - gleich welches Ereignis
    eintritt - eine Endlosschleife! }

  PROCEDURE Event_Loop ;

    VAR
      event, dummy : integer ;
      msg : Message_Buffer ;

    BEGIN
      WHILE true DO
        BEGIN
          { Erfassen eines Ereignisses. Uns interessieren nur Nachrichten. }
          event := Get_Event( E_Message, 0, 0, 0, 0,
                        false, 0, 0, 0, 0, false, 0, 0, 0, 0,
                        msg, dummy, dummy, dummy, dummy, dummy, dummy ) ;
          CASE msg[0] OF
            AC_Open:
            { Vorausgestzt unser Menueintrag wurde angewaehlt! In der Routine
              Menu_Register ist ein Fehler: Siel liefert nicht die korrekte
              Applikationsnummer zurueck. Das it aber OK, solange wir nur
              eine "AC_OPEN"-Nachricht bekommen, wenn es sich um unseren
              Menueintrag handelt. }
          (*  IF msg[4] = menu_id THEN*){ Wenn unser Menueintrag angesprochen }
                Do_Open ;               { wurde, Fenster oeffnen! }
            AC_Close:
              { Falls wir das Fenster nicht geschlossen haben, schliesst es
                GEM fuer uns. }
              IF (msg[3] = menu_id) AND (window <> No_Window) THEN
                BEGIN
                  window := No_Window
                END ;
            WM_Sized, {Erlaubt jede Groesse oder Position auf dem Bildschirm }
            WM_Moved:
              Set_WSize( msg[3], msg[4], msg[5], msg[6], msg[7] ) ;
            WM_Closed:          { Anwender will das Fenster schliesen. }
              Do_Close ;
            WM_Redraw:  { Wird zum Neuzeichnen von Fensterteilen gebraucht. }
              Do_Redraw( msg[3], msg[4], msg[5], msg[6], msg[7] ) ;
            WM_Topped:  { Aha, Anwender will unser Fenster im Vordergrund. }
              Bring_To_Front( msg[3] ) ;
          END
        END
    END ;


  { Hauptprogramm: Initialisierung von GEM. Dann wird der Name in das "Desk"
    Menu eingesetzt und zu unserer Abfrage-Schleife gesprungen. Diese
    Routine wird nie zurueckkehren. Deshalb benoetigen wir keinen Exit_Gem-
    Aufruf am Ende des Programms. }

  BEGIN
    ap_id := Init_Gem ; { Wir muessen unsere Applikationsnummer sichern. }
    IF ap_id >= 0 THEN
      BEGIN
        { Wir beginnen mit keinem Fenster auf dem Bildschirm }
        window := No_Window ;
        { Sie muessen immer zwei Freizeichen vor den Namen des Accessoirs }
        { setzen. }
        our_name := '  Sample Accessory' ;
        { Hier benoetigen wir nun die Applikationsnummer.}
        menu_id := Menu_Register( ap_id, our_name ) ;
        Event_Loop ;
      END
  END.
