PROGRAM bitblt_demo;

  { Dies ist ein Demonstrationsprogramm fr die Prozedur BITBLT der LINE-A
    Routinen. Bitte erschrecken Sie nicht ber seine Lnge, denn zustzlich
    ist es eine Demonstration der Benutzung von Fenstern in ST Pascal plus.
    Wenn Sie die Geschwindigkeit einmal erleben wollen, starten Sie das
    Programm zuerst. Whlen Sie dann unter "Demonstration" den Eintrag
    "Muster". Nach kurzer Zeit erscheint in Fenster 1 ein Muster. Aktivieren
    Sie dann das Fenster 2 durch einen Mausklick in diesem und erzeugen Sie
    auch hier ein Muster (es sieht etwas anders aus).
    Sie knnen jetzt die Geschwindigkeit des Neuzeichnens erleben, indem Sie
    die Funktion "Tauschen" mehrfach nacheinander anwhlen.
    Nach dieser Einfhrung sollten Sie noch den "ber BITBLT"-Eintrag ansehen
    und die Fenster auch einmal verschieben.
    Ein interessantes Experiment ist auch das Aufrufen von Accessories, ins-
    besondere des Kontrollfeldes und des VT52-Emulators.

    Dieses Programm stammt von Jens Schmidt und darf beliebig weitergegeben
    und bearbeitet werden. }


  CONST max_windows = 3;
  {$I gemconst.pas}

  TYPE
  {$I gemtype.pas}
       picture      = PACKED ARRAY [1 .. 32000] OF BYTE;
       picture_p    = ^picture;
       area         = RECORD xmin     : INTEGER;   { Linke Spalte              }
                             ymin     : INTEGER;   { Obere Zeile               }
                             form     : picture_p; { Adresse des Speichers     }
                             nextword : INTEGER;   { Abstand auf selber Ebene  }
                             nextline : INTEGER;   { Abstand der Zeilen        }
                             nextplane: INTEGER    { Abstand der Ebenen        }
                      END { RECORD };
       pattern      = ARRAY [0 .. 15] OF INTEGER;
       pattern_p    = ^pattern;
       pattern_desc = RECORD buffer   : pattern_p; { Die Verwendung ist leider }
                             nextline : INTEGER;   { noch unklar, aber mit     }
                             nextplane: INTEGER;   { buffer = NIL wird dieser  }
                             mask     : INTEGER    { Teil einfach ignoriert.   }
                      END { RECORD };
       oper_table   = PACKED RECORD f0b0: BYTE;    { Beide Farben 0            }
                                    f0b1: BYTE;    { Vorn 0, Hinten 1          }
                                    f1b0: BYTE;    { Vorn 1, Hinten 0          }
                                    f1b1: BYTE     { Beide Farben 1            }
                             END { RECORD };
       { Werte fr die "oper_table"-Felder:
           0   D' := 0         (Lschen)
           1   D' := S & D     (Und)
           2   D' := S & ~D    (Rcksetzen)
           3   D' := S         (Kopie)
           4   D' := ~S & D
           5   D' := D         (Zeitverschwendung)
           6   D' := S <> D    (Exklusives Oder)
           7   D' := S | D     (Oder)
           8   D' := ~(S | D)  (Nor)
           9   D' := S = D     (quivalenz)
          10   D' := ~D        (Invertierung)
          11   D' := S | ~D
          12   D' := ~S
          13   D' := ~S | D
          14   D' := ~ (S & D) (Nand)
          15   D' := 1         (Fllen) }

       blt_parm     = RECORD pxl_width       : INTEGER; { Breite in Punkten    }
                             pxl_height      : INTEGER; { Hhe in Punkten      }
                             plane_count     : INTEGER; { Anzahl Farbebenen    }
                             foreground_color: INTEGER; { Vordergrundfarbe     }
                             background_color: INTEGER; { Hintergrundfarbe     }
                             operation_table : oper_table;
                             source          : area;
                             destination     : area;
                             pattern         : pattern_desc;
                             filler          : PACKED ARRAY [1 .. 24]
                                                      OF BYTE
                     END { RECORD };
       window_typ  = RECORD nummer: INTEGER;
                            name  : window_title;
                            empty : BOOLEAN;
                            buffer: picture_p
                     END;

  VAR bitblt_parm  : blt_parm;
      window       : ARRAY [1 .. max_windows] OF window_typ;
      menu         : menu_ptr;
      dialog       : dialog_ptr;
      demo_title,
      muster,
      tausch, ende : tree_index;

  {$I gemsubs.pas}

  PROCEDURE create_menu;
    VAR dummy: tree_index;
    BEGIN menu := new_menu (10, '  ber BITBLT');
          demo_title := add_mtitle (menu, ' Demonstration ');
          muster := add_mitem (menu, demo_title, '  Muster   ');
          tausch := add_mitem (menu, demo_title, '  Tauschen ');
          dummy  := add_mitem (menu, demo_title, '-----------');
          ende   := add_mitem (menu, demo_title, '  Ende     ');
          menu_disable (menu, dummy);
          draw_menu (menu)
    END { create_menu };

  PROCEDURE kill_menu;
    BEGIN erase_menu (menu);
          delete_menu (menu)
    END { kill_menu };

  PROCEDURE create_dialog;
    VAR dummy: tree_index;
    BEGIN dialog := new_dialog (4, 0, 0, 24, 7);
          dummy := add_ditem (dialog, g_text, none,
                              2, 1, 20, 1, 0, black * 256);
          set_dtext (dialog, dummy, 'BITBLT-Demonstration',
                     system_font, te_left);
          dummy := add_ditem (dialog, g_text, none,
                              2, 2, 20, 1, 0, black * 256);
          set_dtext (dialog, dummy, 'mit ST-Pascal plus',
                     system_font, te_left);
          dummy := add_ditem (dialog, g_text, none,
                              2, 3, 20, 1, 0, black * 256);
          set_dtext (dialog, dummy, 'von Jens Schmidt',
                     system_font, te_left);
          dummy := add_ditem (dialog, g_button, selectable | default | exit_btn,
                              16, 5, 6, 1, 0, 0);
          set_dtext (dialog, dummy, 'OK', system_font, te_center);
          center_dialog (dialog)
    END { create_dialog };

  PROCEDURE kill_dialog;
    BEGIN delete_dialog (dialog)
    END { kill_dialog };

  PROCEDURE create_windows;
    VAR index     : INTEGER;
        x, y, w, h: INTEGER;
    BEGIN work_rect (0, x, y, w, h);
          w := w DIV max_windows - 50;
          h := h - 50;
          FOR index := 1 TO max_windows
          DO WITH window [index]
             DO BEGIN name := CONCAT (' Fenster ', CHR (index + ORD ('0')), ' ');
                      nummer := new_window (g_name | g_move, name, 0, 0, 0, 0);
                      open_window (nummer, x + (index - 1) * (w + 50) + 25,
                                   y + 25, w, h);
                      empty := TRUE;
                      NEW (buffer) { In diesem Puffer wird eine Kopie des aktu-
                                     ellen Fensterinhalts abgelegt. }
                END;
          bring_to_front (window [1].nummer)
    END { create_windows };

  PROCEDURE kill_windows;
    VAR index: INTEGER;
    BEGIN FOR index := 1 TO max_windows
          DO WITH window [index]
             DO BEGIN close_window (nummer);
                      delete_window (nummer)
                END
    END { kill_windows };

  PROCEDURE redraw_window (VAR window: window_typ; x, y, w, h: INTEGER);

    TYPE resolution = (low_res, mid_res, high_res);

    VAR x2, y2, w2, h2, 
        xoffset, yoffset: INTEGER;
        bitblt_desc     : blt_parm;

    FUNCTION physbase: picture_p;
      XBIOS (2);
    FUNCTION getres: resolution;
      XBIOS (4);

    BEGIN work_rect (window.nummer, x2, y2, w2, h2);
          xoffset := x2;
          yoffset := y2;
          WITH window
          DO BEGIN first_rect (nummer, x2, y2, w2, h2);
                   begin_update;
                   WHILE (w2 <> 0) OR (h2 <> 0)
                   DO BEGIN IF rect_intersect (x, y, w, h, x2, y2, w2, h2)
                            THEN WITH bitblt_desc
                                 DO BEGIN hide_mouse;
                                          CASE getres
                                          OF low_res : plane_count := 4;
                                             mid_res : plane_count := 2;
                                             high_res: plane_count := 1
                                          END { CASE };
                                          foreground_color := 0;
                                          background_color := 0;
                                          WITH source
                                          DO BEGIN form := window.buffer;
                                                   CASE getres
                                                   OF low_res : BEGIN
                                                                 nextword := 8;
                                                                 nextline := 160
                                                                END;
                                                      mid_res : BEGIN
                                                                 nextword := 4;
                                                                 nextline := 160
                                                                END;
                                                      high_res: BEGIN
                                                                 nextword := 2;
                                                                 nextline := 80
                                                                END
                                                   END { CASE };
                                                   nextplane := 2
                                             END;
                                          destination := source;
                                          destination.form := physbase;
                                          pattern.buffer := NIL;
                                          pxl_width := w2;
                                          pxl_height := h2;
                                          source.xmin := x2 - xoffset;
                                          source.ymin := y2 - yoffset;
                                          destination.xmin := x2;
                                          destination.ymin := y2;
                                          WITH operation_table
                                          DO IF empty
                                             THEN BEGIN f0b0 := 0;
                                                        f0b1 := 0;
                                                        f1b0 := 0;
                                                        f1b1 := 0
                                                  END
                                             ELSE BEGIN f0b0 := 3;
                                                        f0b1 := 3;
                                                        f1b0 := 3;
                                                        f1b1 := 3
                                                  END;
                                          BITBLT (bitblt_desc);
                                          show_mouse
                                    END;
                            next_rect (nummer, x2, y2, w2, h2)
                      END;
                   end_update
             END
    END { redraw_window };

  PROCEDURE muster_erzeugen;

    TYPE resolution = (low_res, mid_res, high_res);

    VAR bitblt_desc  : blt_parm;
        x, y, w, h   : INTEGER;
        muster, front: INTEGER;
        index        : INTEGER;
        oldbase      : picture_p;

    FUNCTION logbase: picture_p;
      XBIOS (3);
    PROCEDURE setscreen (logical   : picture_p;
                         physical  : LONG_INTEGER;
                         resolution: INTEGER);
      XBIOS (5);
    FUNCTION getres: resolution;
      XBIOS (4);

    BEGIN front := front_window;
          work_rect (front, x, y, w, h);
          WITH bitblt_desc
          DO BEGIN pxl_width := w;
                   pxl_height := h;
                   CASE getres
                   OF low_res : plane_count := 4;
                      mid_res : plane_count := 2;
                      high_res: plane_count := 1
                   END { CASE };
                   WITH destination
                   DO BEGIN form := window [front].buffer;
                            xmin := 0;
                            ymin := 0;
                            CASE getres
                            OF low_res : BEGIN nextword := 8;
                                               nextline := 160
                                         END;
                               mid_res : BEGIN nextword := 4;
                                               nextline := 160
                                         END;
                               high_res: BEGIN nextword := 2;
                                               nextline := 80
                                         END
                            END { CASE };
                            nextplane := 2
                      END;
                   source := destination;
                   WITH operation_table
                   DO BEGIN f0b0 := 15 * ORD (ODD (front));
                            f0b1 := 0;
                            f1b0 := 0;
                            f1b1 := 0
                      END;
                   pattern.buffer := NIL;
                   foreground_color := 0;
                   background_color := 0
             END;
          hide_mouse;
          begin_update;
          BITBLT (bitblt_desc); { Lscht den Pufferinhalt }
          end_update;
          show_mouse;
          oldbase := logbase;
          setscreen (window [front].buffer, -1, -1);
          { Ab hier wird nicht auf den Bildschirm, sondern in den Fenster-
            Puffer gezeichnet! }
          draw_mode (3);
          line_style (1);
          FOR index := 0 TO w - 1
          DO pline (index, 0, w - 1 - index, h - 1);
          FOR index := 0 TO h - 1
          DO pline (0, index, w - 1, h - 1 - index);
          setscreen (oldbase, -1, -1);
          window [front].empty := FALSE;
          redraw_window (window [front], x, y, w, h) { Zeichnung anzeigen }
    END { muster_erzeugen };

  PROCEDURE tauschen;
    VAR temp_picture     : picture_p;
        temp_empty       : BOOLEAN;
        index, x, y, w, h: INTEGER;
    BEGIN temp_picture := window [1].buffer;
          temp_empty := window [1].empty;
          FOR index := 2 TO max_windows
          DO BEGIN window [index - 1].buffer := window [index].buffer;
                   window [index - 1].empty := window [index].empty
             END;
          window [max_windows].buffer := temp_picture;
          window [max_windows].empty := temp_empty;
          FOR index := 1 TO max_windows
          DO BEGIN work_rect (window [index].nummer, x, y, w, h);
                   redraw_window (window [index], x, y, w, h)
             END
    END { tauschen };

  PROCEDURE zeige_about_dialog;
    VAR item: tree_index;
    BEGIN item := do_dialog (dialog, 0);
          end_dialog (dialog);
          obj_setstate (dialog, item,
                        obj_state (dialog, item) & ~selected, FALSE)
    END { zeige_about_dialog };

  PROCEDURE event_loop;
    VAR event, dummy, index: INTEGER;
        vorbei             : BOOLEAN;
        message            : message_buffer;
    BEGIN vorbei := FALSE;
          REPEAT event := get_event (e_message, 0, 0, 0, 0,
                                     FALSE, 0, 0, 0, 0,
                                     FALSE, 0, 0, 0, 0,
                                     message,
                                     dummy, dummy, dummy, dummy, dummy, dummy);
                 CASE message [0]
                 OF mn_selected: BEGIN IF message [4] = ende
                                       THEN vorbei := TRUE
                                       ELSE IF message [4] = muster
                                            THEN muster_erzeugen
                                            ELSE IF message [4] = tausch
                                                 THEN tauschen
                                                 ELSE zeige_about_dialog;
                                       menu_normal (menu, message [3])
                                 END;
                    wm_redraw  : redraw_window (window [message [3]], message [4],
                                                message [5], message [6],
                                                message [7]);
                    wm_topped  : bring_to_front (message [3]);
                    wm_moved   : set_wsize (message [3], message [4],
                                            message [5], message [6],
                                            message [7])
                 END { CASE }
          UNTIL vorbei
    END { event_loop };

  BEGIN IF init_gem >= 0
        THEN BEGIN init_mouse;
                   create_menu;
                   create_dialog;
                   create_windows;
                   event_loop;
                   kill_menu;
                   kill_dialog;
                   kill_windows;
                   exit_gem
             END
        ELSE WRITELN ('Fehler: Init_Gem nicht mglich!')
  END.

