{ gemconst.pas - Personal Pascal GEM library constant definitions. }

        Screen_Device  = 1;
        Printer_Device = 21;
        No_Port        = 0;
        No_Window      = -1;
        Root           = 0;     { Index of root w/in object tree }
        Null_Index     = -1;    { Index of a non-existent item }
        Max_Len        = 81;    { Max string length }
        Max_Depth      = 8;     { Max depth of search or draw }
        Max_Tree       = 100;   { Max size of object tree }

        Max_C_String = 255;     { Max length of "C" style string (for our    }
                                { purposes--obviously there is no such limit }
                                { for "real" C strings!)                     }

        Max_Fn          = 12;   { Max length of file and path names }
        Max_Path        = 80;
        Max_WTitle      = 80;

        R_Tree          = 0;    { Resource types... }
        R_String        = 5;

  { Event values: }
        E_Keyboard      = 1;
        E_Button        = 2;
        E_Mouse1        = 4;
        E_Mouse2        = 8;
        E_Message       = 16;
        E_Timer         = 32;

  { Graphics command constants: }
        { Drawing modes: }
        Replace_Mode    = 1;
        Trans_Mode      = 2;
        XOR_Mode        = 3;
        Rev_Trans_Mode  = 4;

        { Paint patterns: }
        { Use None for no fill }
        Solid           = 1;
        Pat1            = 2;
        Pat2            = 3;
        Pat3            = 4;
        Pat4            = 5;
        Pat5            = 6;
        Pat6            = 7;
        Pat7            = 8;
        Pat8            = 9;
        Pat9            = 10;
        Pat10           = 11;
        Pat11           = 12;
        Pat12           = 13;
        Pat13           = 14;
        Pat14           = 15;
        Pat15           = 16;
        Pat16           = 17;
        Pat17           = 18;
        Pat18           = 19;
        Pat19           = 20;
        Pat20           = 21;
        Pat21           = 22;
        Pat22           = 23;
        Pat23           = 24;
        Pat24           = 25;
        Hatch1          = 26;
        Hatch2          = 27;
        Hatch3          = 28;
        Hatch4          = 29;
        Hatch5          = 30;
        Hatch6          = 31;
        Hatch7          = 32;
        Hatch8          = 33;
        Hatch9          = 34;
        Hatch10         = 35;
        Hatch11         = 36;
        Hatch12         = 37;
  { Line styles: }
        { Solid is same as Paint pattern }
        LongDash        = 2;
        Dotted          = 3;
        DashDot         = 4;
        Dashed          = 5;
        DashDotDot      = 6;

  { Text effects: }
        Normal          = 0;
        Thickened       = 1;
        Lightened       = 2;
        Slanted         = 4;
        Underlined      = 8;
        Outlined        = 16;
        Shadowed        = 32;

  { Font types: }
    System_Font = 3;
    Small_Font  = 5;

  { Graphic types of obs: }
    G_Box       = 20;
    G_Text      = 21;
    G_BoxText   = 22;
    G_Image     = 23;
    G_ProgDef   = 24;
    G_IBox      = 25;
    G_Button    = 26;
    G_BoxChar   = 27;
    G_String    = 28;
    G_FText     = 29;
    G_FBoxText  = 30;
    G_Icon      = 31;
    G_Title     = 32;

  { Object flags: }
    None        = $000;    { Also used for fill pattern and text effects. }
    Selectable  = $001;
    Default     = $002;
    Exit_Btn    = $004;
    Editable    = $008;
    Radio_Btn   = $010;
    Last_Ob     = $020;
    Touch_Exit  = $040;
    Hide_Tree   = $080;
    Indirect    = $100;

  { Object states }
        { Use Normal for no special state }
    Selected    = $01;
    Crossed     = $02;
    Checked     = $04;
    Disabled    = $08;
        { Outlined and Shadowed are defined under text effects }

  { Window elements: }
    G_Name    = $001 ;
    G_Close   = $002 ;
    G_Full    = $004 ;
    G_Move    = $008 ;
    G_Info    = $010 ;
    G_Size    = $020 ;
    G_UpArrow = $040 ;
    G_DnArrow = $080 ;
    G_VSlide  = $100 ;
    G_LArrow  = $200 ;
    G_RArrow  = $400 ;
    G_HSlide  = $800 ;
    G_All     = $FEF ;          { All elements, except info line }

  { Color register shorthands: }
    White       = 0 ;
    Black       = 1 ;
    Red         = 2 ;
    Green       = 3 ;
    Blue        = 4 ;
    Cyan        = 5 ;
    Yellow      = 6 ;
    Magenta     = 7 ;
    L_White     = 8 ;
    L_Black     = 9 ;
    L_Red       = 10 ;
    L_Green     = 11 ;
    L_Blue      = 12 ;
    L_Cyan      = 13 ;
    L_Yellow    = 14 ;
    L_Magenta   = 15 ;

  { Predefined GEM messages: }
    MN_Selected         = 10 ;
    WM_Redraw           = 20 ;
    WM_Topped           = 21 ;
    WM_Closed           = 22 ;
    WM_Fulled           = 23 ;
    WM_Arrowed          = 24 ;
    WM_HSlid            = 25 ;
    WM_VSlid            = 26 ;
    WM_Sized            = 27 ;
    WM_Moved            = 28 ;

  { Wind_Get/Set field values: }
    WF_PrevXYWH         = 6 ;
    WF_FullXYWH         = 7 ;
    WF_HSlide           = 8 ;
    WF_VSlide           = 9 ;
    WF_HSlSize          = 15 ;
    WF_VSlSize          = 16 ;

  { Desk-Accessoir values: }
    AC_Open             = 40;
    AC_Close            = 41;
{ End of gemconst.pas }

