{************************************************************************** 
* 
*       TRIXSUBS.PAS - Declarations for PASTRIX library 
*       04/27/87 MJC 
* 
***************************************************************************} 
 
{************************************************************************* 
* 
*       Peek/poke routines 
* 
*************************************************************************} 
 
FUNCTION Peek( Address: Long_Integer ): Long_Integer; 
  EXTERNAL; 
FUNCTION Wpeek( Address: Long_Integer ): Long_Integer; 
  EXTERNAL; 
FUNCTION Lpeek( Address: Long_Integer ): Long_Integer; 
  EXTERNAL; 
 
PROCEDURE Poke( Address: Long_Integer; Value: Byte ); 
  EXTERNAL; 
PROCEDURE Wpoke( Address: Long_Integer; Value: Integer ); 
  EXTERNAL; 
PROCEDURE Lpoke( Address, Value: Long_Integer ); 
  EXTERNAL; 
 
 
{************************************************************************* 
* 
*       Supervisor status goodies. 
* 
*************************************************************************} 
 
FUNCTION InSuper : Boolean; 
  EXTERNAL; 
PROCEDURE Super( YesNo : Boolean );  
  EXTERNAL; 
 
 
{************************************************************************* 
* 
*       Block memory move routines 
* 
*************************************************************************} 
 
PROCEDURE Move_L( Source, Dest, Count : Long_Integer ); 
  EXTERNAL; 
PROCEDURE Move_W( Source, Dest, Count : Long_Integer ); 
  EXTERNAL; 
PROCEDURE Move_B( Source, Dest, Count : Long_Integer ); 
  EXTERNAL; 
 
{************************************************************************* 
* 
*       Pascal to C routine interface routines 
* 
*************************************************************************} 
 
PROCEDURE CtoPstr( Cstr : Cstring; Var Pstr : string ); 
  EXTERNAL; 
PROCEDURE PtoCstr( Pstr : string; Var Cstr : Cstring ); 
  EXTERNAL; 
 
{************************************************************************* 
* 
*       date stuff 
* 
*************************************************************************} 
 
PROCEDURE SetDate( Day, Mon, Yr : Integer ); 
   EXTERNAL; 
PROCEDURE SetTime( Hour, Min, Sec : Integer ); 
   EXTERNAL; 
PROCEDURE GetDate( VAR Day, Mon, Yr : Integer ); 
   EXTERNAL; 
PROCEDURE GetTime( VAR Hour, Min, Sec : Integer ); 
   EXTERNAL; 
 
{************************************************************************* 
* 
*       Screen functions 
* 
*************************************************************************} 
 
 
PROCEDURE Get_Screen( Var Buf : Screen_Type ); 
  EXTERNAL; 
PROCEDURE Put_Screen( Var Buf : Screen_Type ); 
  EXTERNAL; 
 
FUNCTION Read_Screen( Format:integer; Name : String ; Var Buf : Screen_Type ) : Err_Code; 
  EXTERNAL; 
FUNCTION Write_Screen( Format:integer; Name : String ; Var Buf : Screen_Type ) : Err_Code; 
  EXTERNAL; 
 
{************************************************************************* 
* 
*       Ptr/Adr routines 
* 
*************************************************************************} 
 
 
FUNCTION Ptr_Byte( Addr : Long_Integer ) : B_Ptr; 
  EXTERNAL; 
FUNCTION Ptr_Char( Addr : Long_Integer ) : C_Ptr; 
  EXTERNAL; 
FUNCTION Ptr_Integer( Addr : Long_Integer ) : I_Ptr; 
  EXTERNAL; 
FUNCTION Ptr_Long_Integer( Addr : Long_Integer ) : L_Ptr; 
  EXTERNAL; 
 
FUNCTION Adr_Byte( Var Bvar : Byte ) : Long_Integer; 
  EXTERNAL; 
FUNCTION Adr_Char( Var Cvar : Char ) : Long_Integer; 
  EXTERNAL; 
FUNCTION Adr_Integer( Var Ivar : Integer ) : Long_Integer; 
  EXTERNAL; 
FUNCTION Adr_Long_Integer( Var Lvar : Long_Integer ) : Long_Integer; 
  EXTERNAL; 
 
 
{************************************************************************* 
* 
*    vt52 functs - use with write,writeln in non-gem programs 
* 
**************************************************************************} 
 
  
PROCEDURE End_of_line; 
EXTERNAL; 
  
PROCEDURE Clear_home; 
EXTERNAL; 
  
PROCEDURE Delete_line; 
EXTERNAL; 
 
PROCEDURE Insert_line; 
EXTERNAL; 
 
PROCEDURE Gotoxy( x, y: integer ); 
EXTERNAL;
  
PROCEDURE Inv_On; 
EXTERNAL; 
  
PROCEDURE Inv_Off; 
EXTERNAL; 
 
PROCEDURE Select_color( color: integer ); 
EXTERNAL; 
  
PROCEDURE Select_background( color: integer ); 
EXTERNAL; 
 
PROCEDURE Cur_up; 
EXTERNAL; 
  
PROCEDURE Cur_down; 
EXTERNAL; 
 
PROCEDURE Cur_right; 
EXTERNAL; 
  
PROCEDURE Cur_left; 
EXTERNAL; 
  
PROCEDURE Cursor_home; 
EXTERNAL; 
  
PROCEDURE Cur_up_scroll; 
EXTERNAL; 
  
PROCEDURE End_of_screen; 
EXTERNAL; 
  
PROCEDURE Cur_on; 
EXTERNAL; 
  
PROCEDURE Cur_off; 
EXTERNAL; 

PROCEDURE Cur_down_scroll;
EXTERNAL;
 
PROCEDURE Start_of_screen;
EXTERNAL;
 
PROCEDURE Save_cursor;
EXTERNAL;

PROCEDURE Restore_cursor;
EXTERNAL;

PROCEDURE Clear_line;
EXTERNAL;

PROCEDURE Start_of_line;
EXTERNAL;
 
PROCEDURE Wrap_on;
EXTERNAL;

PROCEDURE Wrap_off;
EXTERNAL;

PROCEDURE grafchar (which: char);
EXTERNAL;

{End of TRIXSUBS}
