/*
 * SINCOS.C   -   Sinus/Cosinus Berechnung (Andreas Schwerendt 7.8.1985)
 *
 * Winkel:      0...359
 * Funktionswert:   -32768...+32767
 */

static int value[] = {   0,   572,   1144,   1715,
         2286,   2856,   3425,   3993,
         4560,   5126,   5690,   6252,
         6813,   7371,   7927,   8481,
         9032,   9580,   10126,   10668,
         11207,   11743,   12275,   12803,
         13328,   13848,   14364,   14876,
         15383,   15886,   16383,   16876,
         17364,   17846,   18323,   18794,
         19260,   19720,   20173,   20621,
         21062,   21497,   21925,   22347,
         22762,   23170,   23571,   23964,
         24351,   24730,   25101,   25465,
         25821,   26169,   26509,   26841,
         27165,   27481,   27788,   28087,
         28377,   28659,   28932,   29196,
         29451,   29697,   29934,   30162,
         30381,   30591,   30791,   30982,
         31163,   31335,   31498,   31650,
         31794,   31927,   32051,   32165,
         32269,   32364,   32448,   32523,
         32587,   32642,   32687,   32722,
         32747,   32762 };

icos(x)
int x;
{
   return isin(x + 90);
}

isin(x)
int x;
{
   while(x < 0)
      x += 360;

   while(x > 359)
      x -= 360;

   if(x > 179)
      return -isin(x - 180);

   return x < 90 ? value[x] : value[179 - x];
}
