{$R-} {$S-} {$M 5,150,150,1}
Program Vector;

Uses EasyGraf,Bios;

{ Filename: Vector.pas        }
{ Coder   : Jacob V. Pedersen }
{ Coded   : 4-8-1990          }
{ Purpose : Example           }

{ The mouse is not shown if you enter .TOS in the OPTIONS/Linker dialog }

{ Set "Memory for program" to 300 Kb in the OPTIONS/Run dialog. }

{ If you want to rotate some of your own objects, you can get }
{ some help by reading the VECTOR.DAT file in the \GRAFDEMO dir. }

Const
        Max_Vector_Points =    50;
        Max_Antal_Linier  =    50;
        ScrSize           = 32256;
        MoveSize          = 32000; 
Type
        ScrBasis          = ^BigData;
        BigData           = Packed Array[1..ScrSize] OF Byte;
        D3_Point          = RECORD
                              X,Y,Z : Integer;
                            END;
        Folge_Basis       = RECORD
                              Fra,Til : Integer;
                            END;
Var
        MaxFrames,
        StartStep, 
        ZoomStep          : Integer;
        Folge             : Array[1..Max_Antal_Linier] OF Folge_Basis;
        Antal_Folge       : Integer;
        Point_3D          : Array[1..Max_Vector_Points] OF D3_Point;
        D2                : Array[1..Max_Antal_Linier,1..2] of Integer;
        Co,Si             : Array[1..360] OF Integer;
        DataFile          : Text;
        MidX,MidY,
        Zoom,
        Pers,
        X,
        Vector_Points,
        Antal_Linier,
        Ax,Ay,Az,
        X_a,Y_a,Z_a       : Integer;
        OldExitProc,
        OldPhys,
        OldLog            : Pointer;
        Scr1,
        Scr2,
        Hold              : ScrBasis;


Procedure DrawFigure;
Var L : Byte; 
Begin
  For L := 1 to Antal_Linier DO
    With Folge[L] DO
      Line( D2[fra,1], D2[fra,2], D2[til,1], D2[til,2] );
  Hold := Scr2;
  Scr2 := Scr1;
  Scr1 := Hold; 
  SetScreen( -1, Scr2, Scr1 );
  ClearDevice; 
End; { DrawFigure }


Procedure AdjustAngles;
Begin
  Inc(X_a,Ax); 
  If (X_a < 0) OR (X_A > 360) then X_A := ABS(X_A-360);
  Inc(Y_a,Ay);
  If (Y_a < 0) OR (Y_A > 360) then Y_A := ABS(Y_A-360);
  Inc(Z_a,Az);
  If (Z_a < 0) OR (Z_A > 360) then Z_A := ABS(Z_A-360);
End; { AdjustAngles }


Procedure ReadData(  R : Boolean; Find : String );
Var
        T        : Byte;        
        Data     : String;
Begin
  Zoom     := 30000;
  Pers     :=   600; 
  If (R) then ZoomStep := 26500 DIV StartStep; 
  Antal_Linier  := 0;
  Vector_Points := 0;
  Reset( DataFile );
  While NOT(Eof(DataFile)) DO
    Begin
      ReadLn(DataFile,Data);
      If (Length(Data) > 0) AND (Data[1] IN ['A'..'Z']) then
        If (Pos(Find,Data) > 0) then
          Begin
            Readln(DataFile);
            Readln(DataFile,Vector_Points);
            For T := 1 to Vector_Points DO
              With Point_3d[T] DO
                Readln(DataFile,X,Y,Z);
            Readln(DataFile,Antal_Linier);
            For T := 1 to Antal_Linier DO
              With Folge[T] DO
                Readln(DataFile,Fra,Til);
          End;
    End;
End; { ReadData }


Procedure Make_SinCos;
Begin
  For X := 1 to 360 DO
    Begin
      Si[x] := Round(SIN(X*(PI/180))*5000);
      Co[x] := Round(COS(X*(PI/180))*5000);
    End;
End; { Make_SinCos }


Procedure RotatePoints;
Var
   X,Y,Z,
   X1,Y1,Z1 : LongInt;
   RealVal  : Extended;
   XX       : Integer;
Begin
  For XX := 1 to Vector_Points DO
    Begin
      X1 := Point_3D[XX].X;
      Y1 := Point_3D[XX].Y;
      Z1 := Point_3D[XX].Z;
      X  := ((Co[Z_a]*X1)-(Si[Z_a]*Y1)) DIV Zoom;
      Y1 := ((Co[Z_a]*Y1)+(Si[Z_a]*X1)) DIV Zoom;
      Z  := ((Co[X_a]*Z1)-(Si[X_a]*Y1)) DIV Zoom;
      Y  := ((Co[X_a]*Y1)+(Si[X_a]*Z1)) DIV Zoom;
      Z1 := Z;
      X1 := X;
      Z  := ((Co[Y_a]*Z1)-(Si[Y_a]*X1)) DIV Zoom;  
      X  := ((Co[Y_a]*X1)+(Si[Y_a]*Z1)) DIV Zoom;       
      If (Z+Pers = 0) then
        RealVal := 1
      ELSE
        RealVal := Pers / (Z+Pers);             
      D2[xx,1] := Round((RealVal * X))+MidX;
      D2[xx,2] := Round((RealVal * Y))+MidY; 
    End;
End; { RotatePoints }


Procedure Make_Entry;
Begin
  X_a := 180;
  Y_a :=   1;
  Z_a := 360;
  For X := 1 to StartStep DO
    Begin
      If (KeyPressed) then HALT; 
      Dec(Zoom,ZoomStep);
      RotatePoints;
      DrawFigure;
    End;
End; { Make_Entry }


Procedure Make_Rotat;
Begin
  For X := StartStep+1 to MaxFrames-StartStep DO
    Begin
      If (KeyPressed) then HALT; 
      AdjustAngles;
      RotatePoints;
      DrawFigure;
    End;
End; { Make_Rotat }


Procedure Make_Exit;
Begin
  For X := MaxFrames-StartStep to MaxFrames DO
    Begin
      If (KeyPressed) then HALT; 
      Inc(Zoom,ZoomStep);
      AdjustAngles;
      RotatePoints;
      DrawFigure;
    End; 
End; { Make_Exit }

                       
Function AdjustScreen : ScrBasis;
Var
        Screen : ScrBasis;  
Begin
   New(Screen); 
   Screen := Ptr(Ord(Screen)+(256-(Ord(Screen) MOD 256))); 
   AdjustScreen := Screen;
End; { AdjustScreen }

  
Procedure MyExit;
 Begin
  ExitProc := OldExitProc;
  Close(DataFile);
  Move(Scr2^,OldLog^,MoveSize);           
  DeInitGraphics;         
  SetScreen( -1 , OldLog, OldPhys );
  Dispose(Scr1);
  Dispose(Scr2);
  Dispose(Hold); 
End; { MyExit }


BEGIN { main }
  Reset( DataFile, '\GRAFDEMO\VECTOR.DAT' ,10000 );
  OldExitProc := ExitProc;
  ExitProc    := @MyExit;
  Make_SinCos;
  Initgraphics;
  ClearDevice;
  MidX := MaxX DIV 2;
  MidY := MaxY DIV 2;
  OldPhys := PhysBase;
  OldLog  := LogBase;
  Scr1    := AdjustScreen;
  Scr2    := AdjustScreen;
  Hold    := AdjustScreen;
  SetScreen( GetRez, Scr1, Scr2 );
  Repeat
    MaxFrames := 20;
    StartStep := 10;
    Ax := 0; Ay := 0; Az := 0;
    ZoomStep := 27500 DIV StartStep;
    ReadData(False,'HIGH'); Make_Entry;
    ReadData(False,'SPEED'); Make_Entry;
    ReadData(False,'PASCAL'); Make_Entry;

    MaxFrames := 96;
    StartStep := 30;
    ZoomStep := 27200 DIV StartStep;
    Ax := 0; Ay := 0; Az := 6;
    ReadData(False,'PYRAMID2');

    Make_Entry; Make_Rotat;
    Ay := 10; Az := 0;
    Make_Rotat; Make_Exit;

    Az := 6;
    ZoomStep := 27000 DIV StartStep;
    ReadData(True,'BOX'); Make_Entry; Make_Rotat; Make_Exit;

    ZoomStep := 27200 DIV StartStep;
    Ax := 10; Ay := 0; Az := 0;
    ReadData(False,'HIGH'); Make_Entry; Delay(1000);
    Make_Rotat; Delay(500); Az := 5; Make_Exit;
    Az := 0;
    ReadData(False,'SPEED'); Make_Entry; Delay(1000);
    Make_Rotat; Delay(500); Az := 5; Make_Exit;
    Az := 0;
    ReadData(False,'PASCAL'); Make_Entry; Delay(1000);
    Make_Rotat; Delay(500); Az := 5; Make_Exit;

    Ax := 0; Ay := 2; Az := 10;
    ZoomStep := 27500 DIV StartStep;
    ReadData(False,'BIGPYRA'); Make_Entry; Make_Rotat; Make_Exit;
    ZoomStep := 27000 DIV StartStep;
    Ax := 10; Ay := 0; Az := 0;
    ReadData(False,'DISK'); Make_Entry; Make_Rotat; Make_Exit;
  Until False;
END.
