
IMPLEMENTATION MODULE Lines;

(* Atari Demo : Bouncing lines *)

(* --------------------------------------------------------------- *)
(* (c) Copyright Modula 2 Software Ltd 1986.  All rights reserved. *)
(* --------------------------------------------------------------- *)
(* (c) Copyright TDI Software Inc 1985, 1986. All rights reserved. *)
(* --------------------------------------------------------------- *)

(*$A+*)

FROM GEMVDIbase IMPORT
     (* types *) VDIWorkInType, VDIWorkOutType;

FROM VDIControls IMPORT
     (* procs *) OpenVirtualWorkstation, CloseVirtualWorkstation ;

FROM VDIOutputs IMPORT
     (* procs *) PolyLine ;

FROM VDIAttribs IMPORT
     (* procs *) SetWritingMode ;

FROM AESGraphics IMPORT
     (* procs *) GrafHandle;

FROM GemDem IMPORT
     (* vars  *) WorkX, WorkY, WorkWidth, WorkHeight ;

(*=========================================================================*)
   
MODULE RandomNumbers;

EXPORT Random;

CONST M  = 100000000;
      m1 = 10000;
      b  = 31415821;

VAR seed : LONGCARD;

PROCEDURE Random ( maxvalue : LONGCARD ) : CARDINAL;

  PROCEDURE Multiply ( p, q : LONGCARD ) : LONGCARD;

  VAR p0, p1, q0, q1 : LONGCARD;

  BEGIN
    p1 := p DIV m1;
    p0 := p MOD m1;
    q1 := q DIV m1;
    q0 := q MOD m1;
    RETURN (((p0*q1+p1*q0) MOD m1) * m1 + p0*q0) MOD M;
  END Multiply;

BEGIN
  seed := (Multiply (seed, b) + 1) MOD M;
  RETURN CARDINAL((((seed DIV m1) * maxvalue) DIV m1) MOD 65536);
END Random;

BEGIN (* MODULE *)
  seed := 349867;
END RandomNumbers;

(*=========================================================================*)
VAR handle : INTEGER;
     
PROCEDURE Animation;  (* Moving line segments *)

CONST maxLines     = 20;
      maxDrawLines = 4000;
 
TYPE LineDescr  = ARRAY [0..3] OF INTEGER;

VAR Ball,
    Vel,
    max          : LineDescr;
    maxX, maxY, min : INTEGER ;
    Lines        : ARRAY [0..maxLines-1] OF LineDescr;
    index, t,
    i, new, old  : INTEGER;

BEGIN
  maxX := WorkX+WorkWidth ; maxY := WorkY+WorkHeight ;
  max [0] := maxX; max [1] := maxY; max [2] := maxX; max [3] := maxY;
  FOR i := 0 TO 3 DO
    Vel [i] := Random(16)-8;
    Ball [i] := Random (LONGCARD(max[i]-100)) + 50;
    END;
  new := 0; old := 0;
  FOR index := 0 TO maxDrawLines DO
    FOR i := 0 TO 3 DO 
      t := Ball [i] + Vel [i];
      IF t >= max [i] THEN
        t := max [i] * 2 - Vel [i] - Ball [i];
        Vel [i] := - Vel [i];
      END;
      IF ODD(i) THEN (* y coord *)
        min := WorkY ;
      ELSE (* x coord *)
        min := WorkX ;
      END ;
      IF t < min THEN
        IF t < 0 THEN
          t := - t;
        ELSE
          t := min ;
        END ;
        Vel [i] := - Vel [i];
      END;
      Ball [i] := t;
    END; (* FOR *)
    IF (new >= maxLines) THEN         (* undraw old line *)
      PolyLine (handle, 2, Lines [old MOD maxLines]);
      INC (old);
    END;
    Lines [new MOD maxLines] := Ball;  (* draw new line *)
    INC (new);
    PolyLine (handle, 2, Ball);
  END;  (* FOR index *)
END Animation;

VAR j : INTEGER;
   In : VDIWorkInType;
   Out : VDIWorkOutType;

PROCEDURE DoLines ;
BEGIN
  handle := GrafHandle (j, j, j, j);
  FOR j := 0 TO 9 DO In [j] := 1 END;
  In [10] := 2;
  OpenVirtualWorkstation (In, handle, Out);
  j := SetWritingMode (handle, 3);
  Animation;
  CloseVirtualWorkstation(handle);
END DoLines ;

END Lines.
