***************************************************************************
*                                                                         *
*                            Alternate-Help-Men                          *
*                                                                         *
***************************************************************************
*  Version : 14.06.1987		(verw. Assembler : IDEAL)		  *
*                                                                         *
*  (c) 1987 by          Sven Krppel                                      *
*                                                                         *
***************************************************************************

gemdos=1       ; Trap-Nummer des GEMDOS
xbios=14       ; Trap-Nummer des XBIOS
setprt=33      ; XBIOS-Funktion	zum Setzen der Drucker-Konfiguration
wvbl=37        ; XBIOS-Funktion zum Warten auf den nchsten VBL
super=38       ; XBIOS-Funktion zum Wechsel in den Supervisor-Modus
term=$0        ; GEMDOS-Funktion zum terminieren eines Programms
con_in=$1      ; GEMDOS-Funktion zum Einlesen eines Zeichens von der Console
con_out=$2     ; GEMDOS-Funktion zur Ausgabe eines Zeichens
nec_in=$7      ; GEMDOS-Funktion zum Einlesen eines Zeichens ohne Echo
prt_line=$9    ; GEMDOS-Funktion zur Ausgabe einer Text-Zeile
setdrv=$e      ; GEMDOS-Funktion zur Festlegung des aktuellen Laufwerks
akt_disk=$19   ; GEMDOS-Funktion zur Abfrage des aktuellen Laufwerks
chdir=$3b      ; GEMDOS-Funktion zur Festlegung des Pathnamen
create=$3c     ; GEMDOS-Funktion zum kreieren einer Datei
close=$3e      ; GEMDOS-Funktion zum Schlieen einer Datei
write=$40      ; GEMDOS-Funktion zum Schreiben in eine Datei
getdir=$47     ; GEMDOS-Funktion zum Ermitteln des Pathnamen
keep=$31       ; GEMDOS-Funktion zum Verlassen eines Programms
malloc=$48     ; GEMDOS-Funktion zur Freistellung von Speicherplatz
m_free=$49     ; GEMDOS-Funktion zur Rckgabe von Speicherplatz
setblock=$4a   ; GEMDOS-Funktion zur Rckgabe des nicht bentigten Speichers
basepage=4     ; Offset zur Base Page Adresse
text_seg=12    ; Lnge des Text-Segmentes
data_seg=20    ; Lnge des Daten-Segmentes
bss_seg=28     ; Lnge des Block-Storage Segmentes
err_hand=$404  ; Critical-Error-Handle
nvbls=$454     ; Anzahl der VBI-Slots
v_bas_ad=$44e  ; Bildschirmspeicher-Startadresse
vblqueue=$456  ; Zeiger auf VBI-Slots
dumpflg=$4ee   ; Alternate-Help-Flag
ESC=27         ; ASCII-Code des Escape-Zeichens
BS=8           ; ASCII-Code des Backspace-Zeichens

***************************************************************************
*                         Programmstart                                   *
***************************************************************************

start:    movea.l basepage(sp),a0 ; Startadresse des Programms nach a0
          move.l #$100,d6        ; Programmlnge: 100 Bytes Base-Page
          add.l text_seg(a0),d6   ; + Lnge des Text-Segments
          add.l data_seg(a0),d6   ; + Lnge des Data-Segments
          add.l bss_seg(a0),d6    ; + Lnge des BSS-Segments
          move.l d6,-(sp)         ; nicht bentigten Speicherplatz zurck-
          move.l a0,-(sp)         ; geben
          clr -(sp)
          move #setblock,-(sp)
          trap #gemdos
          adda.l #12,sp
          tst.l d0                ; Falls d0 ungleich 0, dann ist ein
          bne fehler              ; Fehler aufgetreten
          movem.l d6,-(sp)        ; Register retten
          move.l #install,-(sp)   ; Installationsroutine im Supervisormodus
          move #super,-(sp)       ; ausfhren
          trap #xbios             ; Supervisormodus aufrufen
          add.l #6,sp             ; Stack restaurieren
          movem.l (sp)+,d6        ; Register zurckholen
          clr -(sp)
          move.l d6,-(sp)
          move #keep,-(sp)
          trap #gemdos            ; Programm resident halten und terminieren

***************************************************************************
*                  neuen Vektor installieren                              *
***************************************************************************

install:  move nvbls,d0       ; Anzahl der VBI-Slots nach d0
          lsl #2,d0           ; d0*4, da Slot long
          move.l vblqueue,a0  ; Adresse der VBI-Slots nach a0
          clr d1              ; Slotpointer=0
suche:    tst.l 0(a0,d1)      ; Slot leer ?
	  beq gefunden	      ;	ja, dann gefunden
	  movea.l 0(a0,d1),a1 ;	berprfen, ob die Routine schon installiert
	  cmpi.l #'SVEN',2(a1);	ist.
	  beq fehler	      ;	schon vorhanden, daher Installation verlassen
          add #4,d1           ; nein, dann Slotpointer um 1 erhhen  
          cmp d0,d1           ; alle Slots abgefragt ?
          bne suche           ; nein, also nchsten Slot abfragen
          jmp extend          ; ja, dann Queue vergrern
gefunden: lea 0(a0,d1),a2     ; Adresse des freien Slots nach a2
          move.l #new_vbl,(a2); neue Routine in Slot eintragen
          rts

***************************************************************************
*                  VBL-Queue um 8 Slots erweitern (extend)                *
***************************************************************************

extend:   move nvbls,d5       ; VBI-Slot-Anzahl nach d5
          addi #8,d5          ; 8 neue Slots
          ext.l d5            ; d5 auf long erweitern
          move.l d5,d4        ; Kopie der Slot-Anzahl
          lsl.l  #2,d4        ; Anzahl Bytes, die die neue Queue bentigt
          move.l d4,-(sp)     ; Speicherplatz fr neue Queue holen
          move #malloc,-(sp)
          trap #gemdos
          addq.l #6,sp
          tst.l d0            ; Fehler aufgetreten
          ble fehler          ; ja, dann springe zur Fehlerbehandlung
          movea.l d0,a1       ; Adresse der neuen Queue nach a1
          movea.l a1,a5       ; Adresse der neuen Queue nach a5
          movea.l vblqueue,a0 ; Adresse der alten Queue nach a0
          movea.l a0,a6       ; Adresse der alten Queue nach a6
          move nvbls,d6       ; alte Slot-Anzahl in d6
          subq #1,d6
copy:     move.l (a6)+,(a5)+  ; alte Queue in neue Queue kopieren
          dbf d6,copy
          move.l #new_vbl,(a5)+; neue VBL-Routine eintragen
          move #6,d6          ; Anzahl der nun freien Slots minus 1
delete:   move.l #0,(a5)+     ; freie Slots lschen
          dbf d6,delete
          move.l a1,vblqueue  ; neue Queue aktivieren
          move nvbls,d6       ; alte Slotanzahl nach d6
          move d5,nvbls       ; neue Slotanzahl bergeben
          cmpi #8,d6          ; falls die alte Slotanzahl=8, dann kann
          beq ende            ; das Installationsprogramm beendet werden.
          move.l a0,-(sp)     ; Andernfalls wird der Speicherplatz der
          move #m_free,-(sp)  ; alten Queue wieder freigegeben
          trap #gemdos
          addq.l #6,sp
ende:     rts                 ; Rcksprung zum Hauptprogramm

***************************************************************************
*           Fehlerbehandlung                                              *
***************************************************************************

fehler:  move.l #mesag,-(sp)  ; Fehlermeldung ausgeben
         move   #prt_line,-(sp)
         trap   #gemdos
         addq.l  #6,sp
	 move	#nec_in,-(sp) ;	auf Tastendruck	warten
         trap #gemdos
         addq.l #2,sp
         clr -(sp)            ; Programm terminieren
         trap #gemdos

***************************************************************************
*  Ab hier beginnt die Routine, die beim VBL-Interrupt ausgefhrt wird.   *
***************************************************************************

new_vbl:  bra.s	ok
	  .dc.b	'SVEN'	      ;	Codewort, das anzeigt, ob Men installiert

*************************************************************************
*	       Zeitlupe							*
*************************************************************************

ok:	  move verzoege,d0
wait:	  dbf d0,wait

***************************************************************************
* untersuchen, ob Alternate-Help-Men, Hardcopy	oder nichts aufgerufen	  *
* werden soll. Folgende	Tabelle	wird dazu benutzt :			  *							      *
*     dumpflg !	hardflag ! Funktion					  *
*     --------+----------+----------------------------------		  *
*	-1    !	  -1	 ! keine Funktion				  *
*	 0    !	  -1	 ! Alternate-Help-Men (1. Aufruf)		  *
*	-1    !	   0	 ! Alternate-Help-Men (nach Hardcopy zurck ins  *
*	 0    !	   0	 ! Hardcopy				    Men  *
* Die Abfrage basiert darauf, da durch	Addition von dumpflg und	  *
* hardflag immer eine eindeutige Aussage entsteht. Alternate-Help-Men	  *
* darf also nur	aufgerufen werden, wenn	die Summe gleich -1 ist.	  *
***************************************************************************

	  move dumpflg,d0     ;	dumpflg	und hardflag addieren
	  add  hardflag,d0
	  cmp #-1,d0	      ;	Alternate-Help-Men aufrufen ?
	  bne return	      ;	nein, dann Alternate-Help-Men verlassen

	  tst  dumpflg	      ;	Alternate-Help gedrckt	?
	  bne  ok1	      ;	nein
	  move #-1,dumpflg    ;	ja, dann Alternate Help	zurcksetzen
	  bra  init
ok1:	  move #-1,hardflag   ;	Hardflag zurcksetzen

***************************************************************************
*           Initialisierungen                                             *
***************************************************************************

init:	  move.l #$7d00,-(sp) ;	Speicherplatz fr neuen	Bildschirm anfordern
          move #malloc,-(sp)
          trap #gemdos
          addq.l #6,sp
          tst.l d0            ; Fehler aufgetreten
          ble return          ; ja, dann springe zur Fehlerbehandlung
	  ******** original Bildschirminhalt retten ********************
          move.l d0,screen    ; Adresse des neuen Screens speichern
          movea.l screen,a1   ; Adresse des Hilfsscreens nach a1
          movea.l v_bas_ad,a0 ; Adresse des Video-Rams nach a0
          move    #$7d00,d0   ; Gre des Video-RAMs
          lsr #2,d0           ; Gre in Langworten
          subq #1,d0
s_copy1:  move.l (a0)+,(a1)+  ; Video-Daten in zweiten Screen kopieren
          dbf d0,s_copy1
          move #ESC,-(sp)     ; Cursor-Position speichern
          move #con_out,-(sp)
          trap #gemdos
          addq.l #4,sp
          move #'j',-(sp)
          move #con_out,-(sp)
          trap #gemdos
          addq.l #4,sp

***************************************************************************
*  Men darstellen                                                        *
***************************************************************************

menue:    ********* Men darstellen *************************************
	  move.l #text1,-(sp)  ; Bildschirm beschriften
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
          move.l #text2,-(sp)  ; Bildschirm beschriften
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
          move.l #text3,-(sp)  ; Bildschirm beschriften
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
          move.l #text4,-(sp)  ; Bildschirm beschriften
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
	  move.l #text8,-(sp)  ; Bildschirm beschriften
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
          move.l #text5,-(sp)  ; Bildschirm beschriften
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
          move.l #text6,-(sp)  ; Bildschirm beschriften
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
          move.l #text7,-(sp)  ; Bildschirm beschriften
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp

**************************************************************************
* Zeichen einlesen und auswerten                                         *
**************************************************************************

input:    move   #nec_in,-(sp) ; Zeichen von der Tastatur einlesen
          trap #gemdos
          addq.l #2,sp
auswert:  cmpi   #'0',d0       ; wurde eine Zahl eingegeben ?
	  blt	 handle_h
          cmpi   #'9',d0
	  bgt	 handle_h
          bra zeitlupe
handle_h: bclr #5,d0	       ; nur Grobuchstaben zugelassen
	  cmpi	 #'H',d0       ; Hardcopy gewnscht ?
	  bne	 handle_p
          bra hardcopy
handle_p: cmpi	 #'P',d0       ; Druckerparameter einstellen ?
	  bne	 handle_s
	  bra p_konfig
handle_s: cmpi   #'S',d0       ; Speichern gewnscht ?
          bne    handle_w
	  jsr disk	       ; disk als Subroutine, wegen Critical-Error-
	  bra menue	       ; Handler
handle_w: cmpi   #'W',d0       ; Screen wechseln ?
	  bne	 handle_q
          bra flip
handle_q: cmpi   #'Q',d0       ; Alternate-Help-Men verlassen ?
          bne    input
          bra quit

*************************************************************************
*	       Zeitlupenfaktor einstellen				*
*************************************************************************

zeitlupe: sub #'0',d0	       ; ASCII-Code in Faktor umwandeln
	  mulu #$250,d0	       ; Zeitlupen-Zhlwert
	  move d0,verzoege     ; speichern
	  tst d0	       ; Zeitlupe ein- oder ausgeschaltet ?
	  bne zeit_ein	       ; eingeschaltet
	  move.l #zeit1,-(sp)  ; ausgeschaltet
	  bra zeit_aus
zeit_ein: move.l #zeit2,-(sp)
zeit_aus: move	 #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
	  move #nec_in,-(sp)   ; auf Tastendruck warten
          trap #gemdos
          addq.l #2,sp
	  jmp menue	       ; zurck	zum Men

*************************************************************************
*              Hardcopy auslsen                                        *
*************************************************************************

hardcopy: jsr s_copy           ; Original-Bildschirminhalt darstellen
	  clr hardflag	       ; Hardcopy-Flag auf >>Hardcopy<<	setzen
          clr dumpflg          ; Hardcopy auslsen
          move #wvbl,-(sp)     ; auf VBL-Interrupt warten
          trap #xbios
          addq.l #2,sp
	  rts		       ; Alternate-Help-Men verlassen.	Durch die
			       ; Verwendung von	dumpflg	und hardflag gelangt
			       ; man Dank (?) der Interrupt-Strukur des	ST
			       ; automatisch wieder im Alternate-Help-Men

*************************************************************************
*	       Druckerparameter	einstellen				*
*************************************************************************

p_konfig: clr.l	d5	       ; d5 enthlt die	neuen Parameter
	  clr d6	       ; d6 enthlt die	Bitnummer des Parameters
	  clr.l	d4	       ; d4 enthlt den	Tabellenoffset
	  move.l #para1,-(sp)  ; Logo ausgeben
	  move	 #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
	  lea	 para_tab,a5   ; Adresse der Texttabelle nach a5
schleife: move.l 0(a5,d4),-(sp); Schleife, die alle Parameter einliest
	  move	 #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
	  move #nec_in,-(sp)   ; auf Tastendruck warten
          trap #gemdos
          addq.l #2,sp
	  cmp  #'0',d0	       ; Bit gesetzt ?
	  bne set_bit	       ; ja
	  bra next_par	       ; nein
set_bit:  bset d6,d5	       ; Bit in	der Konfiguration setzen
next_par: addq.l #4,d4	       ; Parameter-Zhler erhhen
	  addq #1,d6
	  cmp #6,d6	       ; alle Parameter	eingegeben ?
	  bne schleife	       ; nein
	  move d5,-(sp)	       ; ja, dann Druckerparameter setzen
	  move #setprt,-(sp)
	  trap #xbios
	  addq.l #4,sp
	  jmp menue	       ; zurck	zum Men

*************************************************************************
*  Bildschirminhalt auf Diskette speichern (Screendump)                 *
*************************************************************************

disk:	  move.l err_hand,s_critic ; Critical-Error-Handler zw.speichern
	  move.l #tos_err,err_hand ; und umbiegen
	  *********** Filename einlesen	*********************************
          move.l #78,-(sp)    ; Speicherplatz fr Pfad anfordern
          move #malloc,-(sp)
          trap #gemdos
          addq.l #6,sp
          tst.l d0            ; Fehler aufgetreten
          ble return          ; ja, dann springe zur Fehlerbehandlung
          move.l d0,path
	  clr d2	      ;	kein Zeichen
	  movea.l d0,a2	      ;	Zeiger auf Pfad-Anfang nach a2
	  clr.b	(a2)	      ;	Pfad lschen
          ************** Bildschirm beschriften *************************
f_weiter: move.l #disk1,-(sp)  ; Bildschirm beschriften
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
	  move.l #disk2,-(sp)  ; Bildschirm beschriften
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l #6,sp
	  move.l path,-(sp)    ; Pfadnamen ausgeben
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
f_input:  move #nec_in,-(sp)   ; auf Tastendruck warten
          trap #gemdos
          addq.l #2,sp
          cmp #'_',d0          ; Unterstrich ?
          beq char_ok          ; ja
          cmp #':',d0          ; Doppelpunkt ?
          beq char_ok          ; ja
          cmp #'.',d0          ; Punkt ?
          beq char_ok          ; ja
          cmp #'\',d0          ; Backslash ?
          beq char_ok          ; ja
          cmp #'0',d0          ; Zahl ?
          blt char1
          cmp #'9',d0
          bgt char1            ; nein
          bra char_ok          ; ja
char1:    cmp #'A',d0          ; Grobuchstabe ?
          blt char2
          cmp #'Z',d0
          bgt char2            ; nein
          bra char_ok          ; ja
char2:    cmp #'a',d0          ; Kleinbuchstabe ?
          blt test_bs
          cmp #'z',d0
          bgt test_bs          ; nein
          bra char_kl          ; ja
test_bs:  cmp #BS,d0           ; Backspace ?
          beq b_space          ; ja
          cmp #13,d0           ; Return ?
          beq save             ; ja, dann Screendump
          cmp #ESC,d0          ; ESC ?
          beq exit_sd          ; ja
          bra f_input          ; unzulssiges Zeichen, daher Rcksprung
char_kl:  subi #32,d0          ; Klein- in Grobuchstaben umwandeln
          bra char_ok
b_space:  tst d2               ; erstes Zeichen
          beq f_input
          clr.b -(a2)          ; Zeichen in Path kopieren
          subq #1,d2           ; Zeichenanzahl erniedrigen
          move.l #bs_text,-(sp)  ; Zeichen rechts vom Cursor lschen
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
          bra f_input
char_ok:  move.b d0,(a2)+      ; Zeichen in Path kopieren
          addq #1,d2           ; Zeichenanzahl erhhen
          move d0,-(sp)        ; Zeichen ausgeben
          move #con_out,-(sp)
          trap #gemdos
          addq.l #4,sp
          bra f_input
          ************** Screendump auf Diskette *************************
save:	  clr.b	(a2)	       ; Pathnamen beenden
	  jsr s_copy	       ; Original-Bildschirminhalt darstellen
	  clr -(sp)	       ; Diskettendatei	kreieren
	  move.l path,-(sp)
	  move #create,-(sp)
	  trap #gemdos
	  adda.l #8,sp
	  tst d0	       ; Fehler	aufgetreten ?
	  bmi tos_err	       ; ja
	  move d0,d6	       ; File-Handle nach d6
	  move.l v_bas_ad,-(sp); Bildschirmdaten abspeichern
	  move.l #$7d00,-(sp)  ; 32K-Video-RAM schreiben
	  move d6,-(sp)	       ; File-Handle
	  move #write,-(sp)
	  trap #gemdos
	  adda.l #12,sp
	  tst.l	d0	       ; Fehler	aufgetreten ?
	  bmi tos_err2	       ; ja
f_close:  move d6,-(sp)	       ; Datei schlieen
	  move #close,-(sp)
	  trap #gemdos
	  addq.l #4,sp
	  tst.w	d0	       ; Fehler	aufgetreten ?
	  bmi tos_err	       ; ja
	  *********** Screendump-Routine verlassen **********************
exit_sd:  move.l path,-(sp) ; Speicherplatz fr Hilfsscreen zurckgeben
          move   #m_free,-(sp)
          trap   #gemdos
          addq.l #6,sp
	  move.l s_critic,err_hand
	  rts

*************************************************************************
*              Page-Flipping                                            *
*************************************************************************

flip:     jsr s_copy          ; Original-Bildschirminhalt darstellen
          move   #nec_in,-(sp) ; auf Tastendruck warten
          trap #gemdos
          addq.l #2,sp
          jmp menue           ; zurck zum Men

*************************************************************************
*              Original-Bildschirminhalt darstellen                     *
*************************************************************************

s_copy: move.l #screen,a1
          movea.l screen,a1   ; Adresse des Hilfsscreens nach a1
          movea.l v_bas_ad,a0 ; Adresse des Video-Rams nach a0
          move    #$7d00,d0   ; Gre des Video-RAMs
          lsr #2,d0           ; Gre in Langworten
          subq #1,d0
s_copy2:  move.l (a1)+,(a0)+  ; Video-Daten zurckkopieren
          dbf d0,s_copy2
          rts

*************************************************************************
*              Alternate-Help-Men verlassen                            *
*************************************************************************

quit:     jsr s_copy          ; Original-Bildschirminhalt zurckkopieren
          move.l screen,-(sp) ; Speicherplatz fr Hilfsscreen zurckgeben
          move   #m_free,-(sp)
          trap   #gemdos
          addq.l #6,sp
          move #ESC,-(sp)     ; TOS-Cursor an ursprngliche Position
          move #con_out,-(sp) ; zurcksetzen
          trap #gemdos
          addq.l #4,sp
          move #'k',-(sp)
          move #con_out,-(sp)
          trap #gemdos
          addq.l #4,sp
return:   rts

*************************************************************************
*              Fehlermeldung ausgeben                                   *
*************************************************************************

tos_err:  move.l #mesag2,-(sp) ; Fehlermeldung ausgeben
	  move	 #prt_line,-(sp)
	  trap	 #gemdos
	  addq.l  #6,sp
	  move	#nec_in,-(sp)  ; auf Tastendruck warten
	  trap #gemdos
	  addq.l #2,sp
          jmp exit_sd          ; zurck ins Men

tos_err2: move.l #mesag3,-(sp) ; Fehlermeldung ausgeben
          move   #prt_line,-(sp)
          trap   #gemdos
          addq.l  #6,sp
	  move	#nec_in,-(sp)  ; auf Tastendruck warten
          trap #gemdos
          addq.l #2,sp
          jmp f_close          ; Datei schlieen

.data
.even
verzoege: .dc.w	0  ; Zeitlupe ausgeschaltet
hardflag: .dc.w	-1 ; Hardcopy oder Alternate-Help-Men ?
para_tab: ; Tabelle mit	Zeigern, die auf die Texte der Druckerpara-
	  ; meter-Einstellung zeigen
	  .dc.l	para2,para3,para4,para5,para6,para7
mesag:	.dc.b 'Routine nicht installiert ! Bitte Taste drcken !',0
mesag2: .dc.b ESC,'Y',52,33,'Disketten-Fehler ! Bitte Taste drcken !',0
mesag3: .dc.b ESC,'Y',52,33,'Schreib-Fehler ! Bitte Taste drcken !',0
bs_text:.dc.b BS,' ',BS,0
text1:	.dc.b ESC,'E',ESC,'Y',35,60,ESC,'p ALTERNATE - HELP - MEN ',ESC,'q',0
text2:  .dc.b ESC,'Y',37,60,'(c) 1987 by Sven Krppel',0
text3:  .dc.b ESC,'Y',39,49,'<0> - <9> : Zeitlupe',0
text4:  .dc.b ESC,'Y',40,55,'<H> : Hardcopy',0
text5:	 .dc.b ESC,'Y',42,55,'<S> : Screendump',0
text6:	 .dc.b ESC,'Y',43,55,'<W> : Bildschirm wechseln',0
text7:	.dc.b ESC,'Y',45,55,'<Q> : Alternate-Help-Men verlassen',0
text8:	.dc.b ESC,'Y',41,55,'<P> : Druckerparameter einstellen',0
disk1:	.dc.b ESC,'Y',50,33,'ESC -> zurck',0
disk2:	.dc.b ESC,'Y',51,33,'Filename >',0
zeit1:	.dc.b ESC,'Y',50,33,'Zeitlupe ausgeschaltet ! Bitte Taste drcken !',0
zeit2:	.dc.b ESC,'Y',50,33,'Zeitlupe eingeschaltet ! Bitte Taste drcken !',0
para1:	.dc.b ESC,'E',ESC,'Y',35,59,'Druckparameter einstellen',0
para2:	.dc.b ESC,'Y',37,53,'0:Matrixdrucker / 1:Typenraddrucker',0
para3:	.dc.b ESC,'Y',38,53,'0:S/W-Drucker   / 1:Farbdrucker',0
para4:	.dc.b ESC,'Y',39,53,'0:Breite=1280   / 1:Breite=960',0
para5:	.dc.b ESC,'Y',40,53,'0:Test-Modus    / 1:Schnschrift',0
para6:	.dc.b ESC,'Y',41,53,'0:Centronics    / 1:RS232',0
para7:	.dc.b ESC,'Y',42,53,'0:Endlospapier  / 1:Einzelblatt',0
.even
.bss
screen:	  .ds.l	1 ; Vektor auf den Hilfsbildschirm
path:	  .ds.l	1 ; Zeiger auf den Pfadnamen
s_critic: .ds.l	1 ; Zwischenspeicher fr Critical-Error-Handler
