;------------------------------------------------------------------------
;                                  TRAPPER
;                                  =======
;
;                         started 04/15/86 by KS & TS
;
; The TRAPPER provides an alternative to the TOS's way of dealing with
; exception errors.
; Mushrooms (or little bombs) may be funny, but are not very informative,
; and counting them can get frustrating, it even frustrated us to the point
; we decided  to do something against it.
;
; The TRAPPER is started once (ideally during system setup) and stays in
; memory. It tries to cope with exception errors and informs you about
; the circumstances of the trap.
; You should be familiar, however, with the TOS and the 68000 processor to
; be able to use (understand) that information.
;
; (This source was written for the SEKA assembler, before being able to
;  assemble it with other assemblers, you might have to do some syntax
;  modifications ... )
;
;------------------------------------------------------------------------

start: jmp entry

;---------------------------------------
;       define some constants
;---------------------------------------

vduhireg   = $ff8201
vdumidreg  = $ff8203

homeline   = 25
homecol    = 20

;---------------------------------------
;    define memory storage locations
;---------------------------------------
vduaddress: dc.l $f8000 ; holds video address
fontbase:   dc.l 0 ; init stores font character data address here

errnumber:  dc.w 0 ; holds the exception vector number
accessinfo: dc.w 0 ; valid only for bus & address error
accessadr:  dc.l 0 ; ----------------------------------
instreg:    dc.w 0 ; ----------------------------------

colpos:    dc.l 0 ; cursor column
linpos:    dc.l 0 ; cursor line

           even

;-----------------------------------
;    define utility routines
;-----------------------------------

calcvdu: ;
         ; compute video memory start adress,return in d0
         ; and store in vduaddress
         ;
         move.l #clcvdu1,-(sp)
         move.w #38,-(sp)
         trap #14
         addq.l #6,sp
         rts
clcvdu1: clr.l d0
         move.b vduhireg,d0
         asl.w #8,d0
         move.b vdumidreg,d0
         asl.l #8,d0
         move.l d0,vduaddress
         rts

calchar: ; compute 8x8 system font base address & store
         dc.w $a000 ; line A call (get params,a1 points to fonts)
         move.l  4(a1),a0 ; 8x8 font's adress is second in table
         move.l 76(a0),a0 ; at offset 76 is the pointer to font data
         move.l a0,fontbase ; store
         rts

writec:  ; output character in d0 (ascii) to screen.
         ; suppose vdu start and font start are setup OK
         ;
         movem.l d0/a0/a1,-(sp) ; those will be modified
         and.l #$ff,d0 ; mask off upper bits
         cmp.b #$d,d0 ; got to do CRLF ?
         beq writecr

         move.l fontbase,a0
         add.l d0,a0   ; a0 points to character bits
         move.l linpos,d0
         mulu  #640,d0
         add.l colpos,d0
         add.l vduaddress,d0
         move.l d0,a1  ; a1 points into video ram
         move.b     (a0), 80(a1)
         move.b $100(a0),160(a1)
         move.b $200(a0),240(a1)
         move.b $300(a0),320(a1)
         move.b $400(a0),400(a1)
         move.b $500(a0),480(a1)
         move.b $600(a0),560(a1)
         move.b $700(a0),640(a1)
         addq.l #1,colpos
testpos: cmp.l #80,colpos
         bne writec1
         clr.l colpos
         addq.l #1,linpos
         cmp.l #25,linpos
         bne writec1
         clr.l linpos
writec1: movem.l (sp)+,d0/a0/a1
         rts
writecr: addq.l #1,linpos
         move.l #homecol,colpos
         bra testpos

writes:  ; write (null terminated) string pointed at by a0
         movem.l d0-d1/a0,-(sp)
         move.w #2000,d1
writes1: move.b (a0)+,d0
         beq qwrites
         jsr writec
         dbra d1,writes1 ; max 2000 chrs if terminator is missing ...
qwrites: movem.l (sp)+,d0-d1/a0
         rts


hextab:  dc.b '0123456789ABCDEF' ; quick&dirty

writen:  ; write nibble in lower 4 bits of d0
         movem.l d0/a0,-(sp)
         and.l  #$0f,d0
         move.l #hextab,a0
         add.l d0,a0
         move.b (a0),d0
         jsr writec
         movem.l (sp)+,d0/a0
         rts

writeb:  ; write lower d0 byte
         ror.b #4,d0
         jsr writen
         ror.b #4,d0
         jsr writen
         rts

writew:  ; write lower word in d0
         ror.w #8,d0
         jsr writeb
         ror.w #8,d0
         jsr writeb
         rts

writel:  ; write d0 as longword
         swap d0
         jsr writew
         swap d0
         jsr writew
         rts

crtsetup: jsr calchar
          jsr calcvdu
          move.l #homeline,linpos
          move.l #homecol,colpos
          rts

entry:    move.l #init,-(sp)
          move.w #38,-(sp)  ; have to call init in supervisor mode.
          trap #14
          addq.l #6,sp
          move.w #1,-(sp)
          trap #1
          addq.l #2,sp
          clr.w -(sp)
          move.l #256+last-start,-(sp) ; nonorthodox, but should work here
          move.w #$31,-(sp) ; terminate & stay resident
          trap #1

init:     jsr crtsetup
          move.l #signon,-(sp) ; say hello
          move.w #9,-(sp)
          trap #1
          addq.l #6,sp
          lea $8,a0
          move.l (a0),a1   ; get current bus error address
          move.l -4(a1),d0 ; get id (if present)
          cmp.l trapid,d0  ; trapper here already ?
          bne install      ; no, install it
          move.l #heremsg,-(sp)
          move.w #9,-(sp)
          trap #1
          addq.l #6,sp
          bra skipinst

install:  move.l #busaderr+$2000000,$8 ; n.b. :if you've got more than 16Mb
          move.l #busaderr+$3000000,$c ; address space, this trick will
          move.l #4,d0                 ; not work on your machine ...
          move.l #8,d1
          jsr vinit
          ;
          ; move.l #11,d0
          ; move.l #24,d1
          ; jsr vinit
          ;

skipinst: move.l #keymsg,-(sp)
          move.w #9,-(sp)
          trap #1
          addq.l #6,sp
          rts

vinit:    sub.l d0,d1
vinit1:   pea traperr
          move.b d0,(sp)
          move.l (sp)+,a0
          move.l d0,a1
          add.l a1,a1
          add.l a1,a1
          move.l a0,(a1)
          addq.l #1,d0
          dbra  d1,vinit1
          rts

getnbr:   move.b (sp),d0
          move.b d0,errnumber
          rts

trapcmd:  dc.l $00000000 ; reserved for future expansion ...
trapid:   dc.l $00493498 ; used to determine if trapper's here.

busaderr: move.w (sp)+,accessinfo
          move.l (sp)+,accessadr
          move.w (sp)+,instreg
          jsr getnbr
          jsr trapwrite
          move.l #errmsg4,a0
          jsr writes
          move.l accessadr,d0
          jsr writel
          bra quitrap


trapwrite: jsr crtsetup
          move.l #clrfield,a0
          jsr writes
          move.l #homeline,linpos
          move.l #homecol,colpos
          move.l #errmsg1,a0
          jsr writes
          move.b errnumber,d0
          jsr writeb
          move.l #errmsg5,a0
          jsr writes
          clr.l d0
          move.b errnumber,d0
          asl #1,d0
          move.l #nametab,a1
          add.l d0,a1
          move.l #0,a0
          move.w (a1),a0
          add.l #xt,a0
          jsr writes

          move.l #errmsg2,a0
          jsr writes
          move.l 6(sp),d0
          jsr writel
          rts

traperr:  jsr getnbr
          jsr trapwrite

quitrap:  move.l #hitkey,a0
          jsr writes
          move.w #1,-(sp)
          trap #1
          addq.l #2,sp
          clr.w -(sp)
          trap #1

signon:   dc.b 27,$45,$0d,$0a,"                "
          dc.b "*** Trapper Version 0.3 21/04/86 by KS & TS ***",0
heremsg:  dc.b $d,$a,$a,"             "
          dc.b "the Trapper seems to be here already (not installed).",0
keymsg:   dc.b $d,$a,$a,"                        "
          dc.b "--- Hit any key to continue --- ",0

clrfield: dc.b    "                                       ",$d
          dc.b    "                                       ",$d
          dc.b    "                                       ",$d
          dc.b    "                                       ",$d
          dc.b    "                                       ",$d
          dc.b    "                                       ",$d
          dc.b    "                                       ",$d
          dc.b    "                                       ",$d,0


errmsg1:  dc.b    "---------------------------------------",$d
          dc.b    "     TRAPPER: detected error # ",0
errmsg2:  dc.b $d,"         at absolute address : ",0
errmsg3:  dc.b $d," offset into current program : ",0
errmsg4:  dc.b $d,"  accessing absolute address : ",0
hitkey:   dc.b $d
          dc.b $d,"        HIT A KEY TO CONTINUE          "
          dc.b $d,"---------------------------------------",$d,0
errmsg5:  dc.b $d," --> ",0

xt:
x00:      dc.b "Bad error !",0
x02:      dc.b "Bus error",0
x03:      dc.b "Address error",0
x04:      dc.b "Illegal Instruction",0
x05:      dc.b "Division by Zero",0
x06:      dc.b "CHK Trap (Out of range)",0
x07:      dc.b "TRAPV Trap (Overflow)",0
x08:      dc.b "Privilege Violation",0
x09:      dc.b "Trace is on",0
x10:      dc.b "Line A Emulator",0
x11:      dc.b "Line F Emulator",0
x12:      dc.b "Unassigned",0
x15:      dc.b "Uninitialised Interrupt",0
x24:      dc.b "Spurious Interrupt",0

          even

nametab:  dc.w x00-xt,x00-xt,x02-xt,x03-xt,x04-xt,x05-xt,x06-xt
          dc.w x07-xt,x08-xt,x09-xt,x10-xt,x11-xt,x12-xt,x12-xt
          dc.w x12-xt,x15-xt,x12-xt,x12-xt,x12-xt,x12-xt,x12-xt
          dc.w x12-xt,x12-xt,x12-xt,x24-xt

          even

last:
          end
 
