*	Mapping routine for convex polygons
*	 Lousy but short code: PATAPOM/HMD
*
* This mapping routine allows you to put your coordinates of the
* texture anywhere, you can even cross thousand times the pattern
* if you want to or make the texture rotate as a rotator-zoomer...

* IN: A6 = Address of the 256*256 Texture
*     D7 = Number of vertices for polygon
*     The address of the screen is provided by the 'Phyzik' long word

* You also have to fill those two arrays down there with the coords of the
* polygon on the screen for the first one and the coords in the texture for
* every vertex for the second, always remember to duplicate the first 2
* entries of the 2 arrays at the end of each of them...

* OUT: Well, you'll see by yourself

Poly_XY	dc.w	0,0
	dc.w	0,0
	dc.w	0,0
	dc.w	0,0
	dc.w	0,0

Texture_XY	dc.w	0,0
	dc.w	0,0
	dc.w	0,0
	dc.w	0,0
	dc.w	0,0

Y_Min	dc.w	0
Y_Max	dc.w	0

Map_Polygon	move.l	a6,usp	Keep texture address

	lea	Poly_XY(pc),a6
	lea	Texture_XY(pc),a5

	move	#$7fff,Y_Min
	move	#0,Y_Max

*	Start tracing shape of polygon

	subq	#1,d7
.Loop_Trace	move	d7,-(sp)

	move	(a6)+,d0	X0
	move	(a6)+,d1	Y0
	move	(a6),d2	X1
	move	2(a6),d3	Y1

	cmp	Y_Max(pc),d1
	ble.s	.Not_Greater
	move	d1,Y_Max
.Not_Greater
	cmp	Y_Min(pc),d1
	bge.s	.Not_Lower
	move	d1,Y_Min
.Not_Lower
	move	(a5)+,d4	X0 in texture
	move	(a5)+,d5	Y0 in texture
	move	(a5),d6	X1 in texture
	move	2(a5),d7	Y1 in texture

	bsr	Shape_Tracing

	move	(sp)+,d7
	dbf	d7,.Loop_Trace

*	Test if polygon can be displayed

	cmpi	#199,Y_Min
	bgt	No_Mapping
	tst	Y_Max
	bmi	No_Mapping

	movem	Y_Min(pc),d0/d7
	cmp	d0,d7
	ble	No_Mapping

*               Fill polygon

	tst	d0
	bpl.s	.Ok0
	moveq	#0,d0
.Ok0
	cmp	#200,d7
	ble.s	.Ok1
	move	#200,d7
.Ok1
	sub	d0,d7	Dy
	move	d7,d1
	lsr	d1	Dy / 2

	move.l	usp,a6	Retrieve texture address
	lea	(Txt_Right,pc,d0.w*4),a4
	lea	(Txt_Left,pc,d0.w*4),a3
	lea	(X_Right,pc,d0.w*2),a2
	lea	(X_Left,pc,d0.w*2),a1

	move	(a1,d1.w*2),d2
	cmp	(a2,d1.w*2),d2
	ble.s	.No_Problem
	exg	a1,a2
	exg	a3,a4
.No_Problem

	move.l	Phyzik+4(pc),a0	   Screen address
	mulu	#2*320,d0
	adda.l	d0,a0

	moveq	#$19,d6
	movec	d6,CACR	Cache reset

	subq	#1,d7
.Loop_Line	move	(a1)+,d0	Left X
	move	(a2)+,d6	Right X

	sub	d0,d6	Dx
	bmi	.Skip_Line

	lea	(0.b,a0,d0.w*2),a5	Good screen address

*	Calculate slopes for mapping

	movem	(a3),d0-d1	Start offset in texture
	movem	(a4),d2-d3	End offset in texture

	ext.l	d6

	sub	d0,d2	Texture Dx
	swap	d2
	clr	d2
	divs.l	d6,d2	Texture Dx / Dx
	swap	d2
	move	d2,d4	Keep X Integer

	sub	d1,d3	Texture Dy
	swap	d3
	clr	d3
	divs.l	d6,d3	Texture Dy / Dx
	lsr.l	#8,d3
	move	d3,d2	X Ratio.W + Y Integer.B + Y Ratio.B

	andi	#$00ff,d0	0.W + 0.B + X Start.B
	ext.l	d1
	lsl	#8,d1	0.W + Y Start.B + 0.B

	move	d4,d3	?.W + X Integer.W
	moveq	#0,d4

*	D0 = 0.W + X Start.W
*	D1 = 0.W + Y Start.B + 0.B
*	D2 = X Ratio.W + Y Integer.B + Y Ratio.B
*	D3 = ?.W + X Integer.W
*	D4 = 0.L
	
.Loop_Fill	move	d1,d4
	move.b	d0,d4
	move	(0.b,a6,d4.l*2),(a5)+

	add.l	d2,d1
	addx	d3,d0
	dbf	d6,.Loop_Fill

.Skip_Line	lea	2*320(a0),a0	Next line
	addq	#4,a3
	addq	#4,a4
	dbf	d7,.Loop_Line

No_Mapping	rts

*	IN:    D0-D1 = Vertice0
*	       D2-D3 = Vertice1
*
*	       D4-D5 = Texture vertice0
*	       D6-D7 = Texture vertice1

*	Trace shape

Shape_Tracing	lea	Txt_Right(pc),a1
	lea	X_Right(pc),a0

	cmp	d1,d3
	bge.s	.No_Change

	lea	Txt_Left(pc),a1
	lea	X_Left(pc),a0
.No_Change
	cmp	d0,d2	Be sure to always draw on the righthand
	bge.s	.No_Exchange
	exg	d0,d2
	exg	d1,d3
	exg	d4,d6
	exg	d5,d7
.No_Exchange
	sub	d4,d6	Texture Dx
	sub	d5,d7	Texture Dy

	sub	d0,d2	Dx
	sub	d1,d3	Dy
	beq.s	.No_Trace
	bpl.s	.Left_Hand

	add	d2,d0	Start x is the other vertice
	add	d3,d1	Start y is the other vertice also
	add	d6,d4	Texture start x is the other vertice
	add	d7,d5	Texture start y is the other vertice also

.Left_Hand	lea	(a0,d1.w*2),a0	Starting buffer address
	lea	(a1,d1.w*4),a1	Starting texture buffer address

	ext.l	d3	Denominator is a .L !!

	swap	d2
	clr	d2
	divs.l	d3,d2	Dx / Dy
	swap	d2
	move.l	d2,d1	Ratio.W + Integer.W for X tracing

	swap	d6
	clr	d6
	divs.l	d3,d6	Texture Dx / Dy
	swap	d6
	move.l	d6,d2	X Ratio.W + X Integer.W for texture

	swap	d7
	clr	d7
	divs.l	d3,d7	Texture Dy / Dy
	swap	d7
	move.l	d7,d6

	move	d3,d7	ABS(Dy) is tracing heigth
	bpl.s	.No_Invert
	neg	d7
.No_Invert	subq	#1,d7	DBF ROULZES!!!

	move.l	d6,d3	Y Ratio.W + Y Integer.W for texture

	ext.l	d0	X Start
	ext.l	d4	X Texture start
	ext.l	d5	Y Texture start
	moveq	#0,d6

*	D0 = 0.W + X Start.W
*	D1 = X Ratio.W + X Integer.W for shape drawing
*	D2 = X Ratio.W + X Integer.W for texture
*	D3 = Y Ratio.W + Y Integer.W for texture
*	D4 = 0.W + X Texture Start.W
*	D5 = 0.W + Y Texture Start.W
*	D6 = 0.L
*	D7 = 0.W + Tracing_Heigth.W

.Loop_Miracle	move	d0,(a0)+	Stock current X
	move	d4,(a1)+	Stock current X texture
	move	d5,(a1)+	Stock current Y texture

	add.l	d1,d0	Add ratio + integer
	addx	d6,d0	Add carry to integer value

	add.l	d2,d4	Add X Ratio + X Integer
	addx	d6,d4	Add carry to X integer value

	add.l	d3,d5	Add Y Ratio + Y Integer
	addx	d6,d5	Add carry to Y integer value

	dbf	d7,.Loop_Miracle

.No_Trace	rts

