/*
 * The following code has been used in PARCP v0.70b. I have included its
 * source for those of you who would like to use my UNI-BI adapter in your own
 * applications.
 */

/*
 * PARallel CoPy - written for transferring large files between any two
 * machines with parallel ports
 *
 * (c) Petr Stehlik, 1996
 *
 * You will need a special UNI-BI HW adapter if your PC offers unidirectional
 * parallel ports only.
 */

typedef unsigned char	BYTE;
typedef unsigned int 	WORD;
typedef enum {FALSE,TRUE} BOOLEAN;

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#ifdef __MSDOS__
#include <dos.h>
#include <conio.h>
#include <time.h>
#include <sys\stat.h>

int print_port;
int gcontrol = (1 << 2);	/* Ucc pro HW interface */

#define SET_CTRL(x)	outportb(print_port+2, gcontrol = (gcontrol | (1 << x)))
#define CLR_CTRL(x)	outportb(print_port+2, gcontrol = (gcontrol &~(1 << x)))
#define STATUS	inportb(print_port+1)

/* Po resetu PC: STROBE, AUTOLF, INIT jsou +5V, zatimco SLCTIN je 0V) */
/* STROBE je 0. bit a je negovany - log.1 = 0V, log.0 = +5V */
/* AUTOLF je 1. bit a je negovany - log.1 = 0V, log.0 = +5V */
/* SLCTIN je 3. bit a je negovany - log.1 = 0V, log.0 = +5V */
/* INIT je 2. bit, log.1 = +5V, coz napaji HW interface */

#define STROBE_HIGH	CLR_CTRL(0)
#define STROBE_LOW	SET_CTRL(0)
#define IS_READY	!(STATUS & 0x80)

#define CLOCK_LOW	SET_CTRL(3)
#define CLOCK_HIGH	CLR_CTRL(3)
#define CLOCK_RAISE	{CLOCK_LOW; CLOCK_HIGH;}	/* impuls pro latch k presypani dat na vystup */
#define GET_LOW_NIBBLE	((STATUS >> 3) & 0x0f)
#define GET_HIGH_NIBBLE	((STATUS << 1) & 0xf0)

#define SET_OUTPUT	SET_CTRL(1)
#define SET_INPUT	CLR_CTRL(1)
#define GET_BYTE(x)				\
	{							\
		CLOCK_LOW;				\
		x=GET_LOW_NIBBLE;		\
		CLOCK_HIGH;				\
		x|=GET_HIGH_NIBBLE;		\
	}

#define PUT_BYTE(x)				\
	{							\
		outportb(print_port,x);	\
		CLOCK_RAISE; 			\
	}

#define GODMODE		/* ma smysl jen pro TOS */
#define USERMODE	/* ma smysl jen pro TOS */

#define KEYPRESSED	kbhit()

#endif	/* __MSDOS__ */

/*******************************************************************************/

#ifdef __TOS__
#include <tos.h>
#include <ext.h>

BYTE	*DATAREAD=(BYTE *)0xffff8800L,
		*REGSEL=(BYTE *)0xffff8800L,
		*DATAWRITE=(BYTE *)0xffff8802L,
		*GPIP=(BYTE *)0xfffffa01L;

int cli(void)	0x40c0;	/* move.w sr,d0 */
void sti(int)	0x46c0; /* move.w d0,sr */

int status_register;
#define CLI		sti((status_register=cli()) | 0x700)
#define STI		sti(status_register)

#define SET_CTRL(x,y)	{CLI; *REGSEL=x; *DATAWRITE=*DATAREAD | (1 << y); STI;}
#define CLR_CTRL(x,y)	{CLI; *REGSEL=x; *DATAWRITE=*DATAREAD &~(1 << y); STI;}

#define STROBE_HIGH	SET_CTRL(14,5)
#define STROBE_LOW	CLR_CTRL(14,5)
#define SET_OUTPUT	SET_CTRL(7,7)
#define SET_INPUT	CLR_CTRL(7,7)

#define IS_READY	(*GPIP & 1)
#define GET_BYTE(x)	{CLI; *REGSEL=15; x=*DATAREAD; STI;}
#define PUT_BYTE(x)	{CLI; *REGSEL=15; *DATAWRITE=x; STI;}

static BOOLEAN SuSuper=FALSE;
static void *stack;
#define	GODMODE		{ if (! SuSuper) {stack=(void *)Super(0L); SuSuper = TRUE; } }
#define	USERMODE	{ if (SuSuper) { Super(stack); SuSuper = FALSE; } }

#define KEYPRESSED	(Kbshift(-1)&3)

#endif	/* __TOS__ */

/*******************************************************************************/
#define EXIT(a)	{ USERMODE; errexit(a); }

#define TIMEOUT_CYCLE	1E6
#define WAIT_LOW		{long i=TIMEOUT_CYCLE; while(IS_READY && i>0) i--; if (i == 0) EXIT("Timeout.");}
#define WAIT_HIGH		{long i=TIMEOUT_CYCLE; while(! IS_READY && i>0) i--; if (i == 0) EXIT("Timeout.");}
#define WAIT_LOW_KEY	{while(IS_READY) if (KEYPRESSED) EXIT("Stopped.");}
#define WAIT_HIGH_KEY	{while(! IS_READY) if (KEYPRESSED) EXIT("Stopped.");}

void read_block(BYTE *block, long n)
{
	BYTE x;
	long i;

	GODMODE;

	SET_INPUT;
	WAIT_LOW_KEY;

	STROBE_LOW;WAIT_HIGH;

	for(i=0; i<n; i++) {
		GET_BYTE(x);
		block[i++]=x;
		STROBE_HIGH;WAIT_LOW;

		GET_BYTE(x);
		block[i]=x;
		STROBE_LOW;WAIT_HIGH;
	}
	STROBE_HIGH;WAIT_HIGH;

	USERMODE;
}

void write_block(BYTE *block, long n)
{
	long i;
	BYTE x;

	GODMODE;

	STROBE_LOW;WAIT_LOW_KEY;

	SET_OUTPUT;
	for(i=0; i<n; i++) {
		PUT_BYTE(x=block[i++]);
		STROBE_HIGH;WAIT_HIGH;

		PUT_BYTE(x=block[i]);
		STROBE_LOW;WAIT_LOW;
	}
	SET_INPUT;
	STROBE_HIGH;WAIT_HIGH;

	USERMODE;
}
