;*======================================================================*
;*                TITLE:    STARTUP.S                                   *
;*                Function: Startup Routines and Main Loop              *
;*                          NOTE: Link this file <<<< FIRST >>>>        *
;*                                                                      *
;*                Project #:              JAGUAR                        *
;*                                                                      *
;*                Programmer:             Cary J. Gee                   *
;*                                                                      *
;*              COPYRIGHT 1992,1993 Atari U.S. Corporation              *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.                      *
;*                                                                      *
;*======================================================================*
	.title  "STARTUP.S - System Startup Routines"

;*======================================================================*
;*      INCLUDE FILES
;*======================================================================*
	include "jaguar.inc"
	include "3ddemo.inc"
        include "joytrick.inc"

;*======================================================================*
;*      EXTERNAL SYMBOLS
;*======================================================================*

;*======================================================================*
;*      EXTERNAL ROUTINES
;*======================================================================*

	.extern InitJag
	.extern _main
;*======================================================================*
;*      PUBLIC SYMBOLS
;*======================================================================*
	.globl  framecnt
	.globl  DISPBUF0
	.globl  DISPBUF1
	.globl  ZBUF
;*======================================================================*
;*      PUBLIC ROUTINES
;*======================================================================*

	.globl  startup
	.globl  done
;*======================================================================*
;*      LOCAL EQUATES
;*======================================================================*

;*======================================================================*
;*      SUBROUTINE AREA
;*======================================================================*

	.text

;*======================================================================*
;*      startup - Link this file ************** FIRST ***************
;*======================================================================*
startup:
	move.l  #INITSTACK,a7

	jsr     InitJag
	jsr     _main

done:
	rts

;*======================================================================*
;*      LOCAL RAM
;*======================================================================*

BUFFERSIZE      EQU     (320*200*2)     ; screen 320 X 200 in 16 bit color mode

	.bss

;*==============================================================*
	.phrase
NewScreen:
DISPBUF0:       ds.b    3*BUFFERSIZE
DISPBUF1        equ     DISPBUF0+8
ZBUF            equ     DISPBUF1+8
SCREENPAD:      ds.b    256

framecnt:
	ds.l    1


	.end


;*======================================================================*
;*                              EOF
;*======================================================================*
