;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Jaguar Example Source Code
; Jaguar Workshop Series #1
; Copyright (c)1994 Atari Corp.
; ALL RIGHTS RESERVED
;
; Program: hv.cof	- Minimum time object list update
;  Module: hv_init.s	- Program entry and initialization
;
; Revision History:
; 6/4/94   - SDS: Created
; 6/8/94   - SDS: Working 'black' screen (no bitmap yet)
; 6/13/94  - SDS: Bitmap working after zeroing the $@$%^@ VMODE variable
;                 Coalesced several .s files into this one
; 7/15/94  - SDS: Changed from RAM bitmap to ROM bitmap
;                 Changed move.w #$1F00,INT1 to move.w #$FFFF,VI
;                 Use UpdateFields instead of copying buffered list

		.include	"jaguar.inc"
		.include	"hv3.inc"

; Globals
		.globl		InitMoveVars

		.globl		bra1
		.globl		bra2
		.globl		bm1
		.globl		gpu1
		.globl		stop1
		.globl		stop2
		.globl		bmp_highl
		.globl		bmp_lowl
		.globl		count_x
		.globl		count_y
		.globl		x_motion
		.globl		y_motion
		.globl		x_pos
		.globl		y_pos
		.globl		x_min
		.globl		x_max
		.globl		y_min
		.globl		y_max
		.globl		upd_freqx
		.globl		upd_freqy
		.globl		a_hdb
		.globl		a_hde
		.globl		a_vdb
		.globl		a_vde
		.globl		width
		.globl		height
		.globl		image1
		.globl		image2
		.globl		image3
; Externals
		.extern		InitGPU
		.extern		InitLister
		.extern		UpdateList

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Program Entry Point Follows...

		.text

		move.l	#$00070007,G_END	; big-endian mode
		move.w	#$FFFF,VI					; disable video interrupts

		move.l	#INITSTACK,a7			; Setup a stack
			
		jsr	    InitVideo					; Setup our video registers.
    jsr     InitMoveVars  		; Initialize Object vars
		jsr	    InitLister				; Initialize Object Display List

		jsr     InitGPU   	  		; Load GPU Interrupt Code
						           	  		; and start the gpu code

		jsr	    InitVBint					; Initialize our VBLANK routine

		move.l	d0,OLP						; Value of D0 from InitLister
		move.w	#$6C1,VMODE				; Configure Video

		illegal										; Bye bye...

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: InitVBint 
; Install our vertical blank handler and enable interrupts
;

InitVBint:
		move.l	d0,-(sp)

		move.l	#UpdateList,LEVEL0	; Install our Auto-Vector 0 handler

		move.w	a_vde,d0		; Must be ODD
		ori.w	#1,d0
		move.w	d0,VI

		move.w	INT1,d0			; Enable video interrupts
		ori.w	#1,d0
		move.w	d0,INT1

		move.w	sr,d0
		and.w	#$F8FF,d0		; Lower the 68k IPL to allow interrupts
		move.w	d0,sr

		move.l	(sp)+,d0
		rts
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Procedure: InitVideo (same as in vidinit.s)
;            Build values for hdb, hde, vdb, and vde and store them.
;
 						
InitVideo:
		movem.l	d0-d6,-(sp)		
			
		move.w	CONFIG,d0		; Also is joystick register
		andi.w	#VIDTYPE,d0		; 0 = PAL, 1 = NTSC
		beq	palvals

		move.w	#NTSC_HMID,d2
		move.w	#NTSC_WIDTH,d0

		move.w	#NTSC_VMID,d6
		move.w	#NTSC_HEIGHT,d4

		bra	calc_vals
palvals:
		move.w	#PAL_HMID,d2
		move.w	#PAL_WIDTH,d0

		move.w	#PAL_VMID,d6
		move.w	#PAL_HEIGHT,d4

calc_vals:
		move.w	d0,width
		move.w	d4,height

		move.w	d0,d1
		asr	#1,d1			; Width/2

		sub.w	d1,d2			; Mid - Width/2
		add.w	#4,d2			; (Mid - Width/2)+4

		sub.w	#1,d1			; Width/2 - 1
		ori.w	#$400,d1		; (Width/2 - 1)|$400
		
		move.w	d1,a_hde
		move.w	d1,HDE

		move.w	d2,a_hdb
		move.w	d2,HDB1
		move.w	d2,HDB2

		move.w	d6,d5
		sub.w	d4,d5
		move.w	d5,a_vdb

		add.w	d4,d6
		move.w	d6,a_vde

		move.w	a_vdb,VDB
		move.w	#$FFFF,VDE
			
		move.l	#0,BORD1		; Black border
		move.w	#0,BG			; Init line buffer to black
			
		movem.l	(sp)+,d0-d6
		rts
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: InitMoveVars
;            Initialize variables for our moving bitmap
;            Note: x_pos and y_pos are initialized in mov_list.s
;
; Registers: None
;

InitMoveVars:
		movem.l	d0-d4/a0,-(sp)

		clr.l		d2
		move.w	width,d2
		lsr.w		#2,d2
		sub.w		#BMP_WIDTH,d2
		sub.w   #1,d2

		move.w	a_vdb,d3
		andi.w	#$FFFE,d3

		move.w	a_vde,d4
		sub.w		#BMP_LINES,d4
		andi.w	#$FFFE,d4
		sub.w		#2,d4

		move.w	#COUNT_BM-1,d0
		move.w	#1,d1
		move.l	#count_x,a0

loop:
		move.w	#0,(a0)										; count_x

		move.w	#0,COUNT_BM*2(a0)					; count_y

		move.w	#1,COUNT_BM*4(a0)					; x_motion

		move.w	#1,COUNT_BM*6(a0)					; y_motion

		move.w	d0,d1
		add.w		#250,d1
		move.w	d1,COUNT_BM*8(a0)					; x_pos

		move.w	d0,d1
		add.w		#250,d1
		move.w	d1,COUNT_BM*10(a0)				; y_pos

		move.w	#10,COUNT_BM*12(a0)				; x_min

		move.w	d3,COUNT_BM*14(a0)				; y_min

		move.w	d2,COUNT_BM*16(a0)				; x_max

		move.w	d4,COUNT_BM*18(a0)				; y_max

		move.w	d0,d1
		add.w		#2,d1
		move.w	d1,COUNT_BM*20(a0)				; upd_freqx

		move.w	d0,d1
		add.w		#2,d1
		move.w	d1,COUNT_BM*22(a0)				; upd_freqy

		adda.l	#2,a0
		dbra		d0,loop

		movem.l	(sp)+,d0-d4/a0
		rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Uninitialized Data!!!           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Storage space for our object lists
;
          .bss
          .phrase

bra1:						ds.l    1*2
bra2:						ds.l    1*2
bm1:						ds.l    2*2*COUNT_BM
stop1:					ds.l    1*2
gpu1:						ds.l    1*2
stop2:					ds.l    1*2

bmp_highl:			ds.l		1*COUNT_BM
bmp_lowl:				ds.l		1*COUNT_BM

count_x:  	    ds.w    1*COUNT_BM
count_y:    	  ds.w    1*COUNT_BM
x_motion:     	ds.w    1*COUNT_BM
y_motion:      	ds.w    1*COUNT_BM
x_pos:   	      ds.w    1*COUNT_BM
y_pos:    	    ds.w    1*COUNT_BM
x_min:      	  ds.w    1*COUNT_BM
y_min:    	    ds.w    1*COUNT_BM
x_max:        	ds.w    1*COUNT_BM
y_max:      	  ds.w    1*COUNT_BM
upd_freqx:			ds.w    1*COUNT_BM
upd_freqy:			ds.w    1*COUNT_BM

          .phrase
a_hdb:					ds.w	  1
a_hde:					ds.w	  1
a_vdb:					ds.w	  1
a_vde:					ds.w	  1
width:					ds.w	  1
height:   			ds.w	  1

          .phrase
image1:					ds.l		2048
image2:					ds.l		2048
image3:					ds.l		2048

		.end