#
# This file is auto-generated. ***ANY*** changes here will be lost
#

package Errno;
use vars qw(@EXPORT_OK %EXPORT_TAGS @ISA $VERSION %errno $AUTOLOAD);
use Exporter ();
use Config;
use strict;

"$Config{'archname'}-$Config{'osvers'}" eq
"m68k-atari-mint-" or
	die "Errno architecture (m68k-atari-mint-) does not match executable architecture ($Config{'archname'}-$Config{'osvers'})";

$VERSION = "1.111";
@ISA = qw(Exporter);

@EXPORT_OK = qw(EREAD EPIPE ECOMM EIDRM EBADMSG EWOULDBLOCK ENODATA
	EREMOTEIO EADDRNOTAVAIL EAGAIN ESOCKTNOSUPPORT ENOTDIR EL2HLT ESRCH
	EDQUOT ENOPROTOOPT ERPCMISMATCH ENOSTR EINSERT EPROGMISMATCH ENOLCK
	EINTR ELOOP EDEADLK ENONET EPROTOTYPE ECONNRESET EBREAK ESTALE ENFILE
	EBADARG ERESTART EACCES ENOSR ETIMEDOUT EREMOTE EUCLEAN ELIBMAX
	EPFNOSUPPORT ENODEV ENOANO ESBLOCK EADV ELOCKED EPROCUNAVAIL ENXIO
	EUSERS EPROTO EADDRINUSE E2BIG EBUSY ECONNABORTED ENMFILES ESNDLOCKED
	EBACKGROUND ENOTEMPTY ENETRESET ENSLOCK EBADSLT ENOBUFS EBADSEC
	ETXTBSY EHOSTDOWN EILSEQ EPROGUNAVAIL ENOLINK ENOTSOCK ENOSPC EFTYPE
	EISCONN EBADRPC ENOTTY EOPNOTSUPP EGENERIC EAFNOSUPPORT ESHUTDOWN
	ENETUNREACH EPROCLIM ECHRNG EINPROGRESS EISDIR EROFS ELNRNG EEXIST
	EBADE EBADF EINTERNAL EXFULL EINVAL ENOMSG EL3RST ENOMEDIUM ENAVAIL
	EBADR ENAMETOOLONG EBFONT ESRMNT ENOTBLK EMSGSIZE EDESTADDRREQ ETIME
	EBADRQC EPROTONOSUPPORT ECONNREFUSED EDRVNRSP EIO EAUTH ENETDOWN EFBIG
	ENOEXEC ENOPKG ENOTCONN EPERM ENOCSI ERANGE EUKCMD ESPIPE EPAPER
	EDEADLOCK ENOMEM ENOSYS EXDEV ECHILD ESTRPIPE EMULTIHOP EL2NSYNC
	ESECTOR EL3HLT ENEEDAUTH ESNDNOTLOCK ELIBACC ENOTNAM EALREADY ELIBSCN
	EMLINK EXCPT EDOTDOT EUNATCH ETOOMANYREFS ECRC ENOENT EWRITE ECHMEDIA
	EERROR EDOM ELIBEXEC EHOSTUNREACH EFAULT ELIBBAD EMFILE EOVERFLOW
	EMEDIUMTYPE);

%EXPORT_TAGS = (
    POSIX => [qw(
	E2BIG EACCES EADDRINUSE EADDRNOTAVAIL EAFNOSUPPORT EAGAIN EALREADY
	EBADF EBUSY ECHILD ECONNABORTED ECONNREFUSED ECONNRESET EDEADLK
	EDESTADDRREQ EDOM EDQUOT EEXIST EFAULT EFBIG EHOSTDOWN EHOSTUNREACH
	EINPROGRESS EINTR EINVAL EIO EISCONN EISDIR ELOOP EMFILE EMLINK
	EMSGSIZE ENAMETOOLONG ENETDOWN ENETRESET ENETUNREACH ENFILE ENOBUFS
	ENODEV ENOENT ENOEXEC ENOLCK ENOMEM ENOPROTOOPT ENOSPC ENOSYS ENOTBLK
	ENOTCONN ENOTDIR ENOTEMPTY ENOTSOCK ENOTTY ENXIO EOPNOTSUPP EPERM
	EPFNOSUPPORT EPIPE EPROCLIM EPROTONOSUPPORT EPROTOTYPE ERANGE EREMOTE
	ERESTART EROFS ESHUTDOWN ESOCKTNOSUPPORT ESPIPE ESRCH ESTALE ETIMEDOUT
	ETOOMANYREFS ETXTBSY EUSERS EWOULDBLOCK EXDEV
    )]
);

sub EDRVNRSP () { 0 }
sub EERROR () { 1 }
sub EBUSY () { 2 }
sub EUKCMD () { 3 }
sub ECRC () { 4 }
sub EBADR () { 5 }
sub ESPIPE () { 6 }
sub EMEDIUMTYPE () { 7 }
sub ESECTOR () { 8 }
sub EPAPER () { 9 }
sub EWRITE () { 10 }
sub EREAD () { 11 }
sub EGENERIC () { 12 }
sub EROFS () { 13 }
sub ECHMEDIA () { 14 }
sub ENODEV () { 15 }
sub EBADSEC () { 16 }
sub ENOMEDIUM () { 17 }
sub EINSERT () { 18 }
sub ESRCH () { 20 }
sub ECHILD () { 21 }
sub EDEADLK () { 22 }
sub EDEADLOCK () { 22 }
sub ENOTBLK () { 23 }
sub EISDIR () { 24 }
sub EINVAL () { 25 }
sub EFTYPE () { 26 }
sub EILSEQ () { 27 }
sub ENOSYS () { 32 }
sub ENOENT () { 33 }
sub ENOTDIR () { 34 }
sub EMFILE () { 35 }
sub EACCES () { 36 }
sub EBADF () { 37 }
sub EPERM () { 38 }
sub ENOMEM () { 39 }
sub EFAULT () { 40 }
sub ENXIO () { 46 }
sub EXDEV () { 48 }
sub ENMFILES () { 49 }
sub ENFILE () { 50 }
sub ELOCKED () { 58 }
sub ENSLOCK () { 59 }
sub EBADARG () { 64 }
sub EINTERNAL () { 65 }
sub ENOEXEC () { 66 }
sub ESBLOCK () { 67 }
sub EBREAK () { 68 }
sub EXCPT () { 69 }
sub ETXTBSY () { 70 }
sub EFBIG () { 71 }
sub ELOOP () { 80 }
sub EPIPE () { 81 }
sub EMLINK () { 82 }
sub ENOTEMPTY () { 83 }
sub EEXIST () { 85 }
sub ENAMETOOLONG () { 86 }
sub ENOTTY () { 87 }
sub ERANGE () { 88 }
sub EDOM () { 89 }
sub EIO () { 90 }
sub ENOSPC () { 91 }
sub EPROCLIM () { 100 }
sub EUSERS () { 101 }
sub EDQUOT () { 102 }
sub ESTALE () { 103 }
sub EREMOTE () { 104 }
sub EBADRPC () { 105 }
sub ERPCMISMATCH () { 106 }
sub EPROGUNAVAIL () { 107 }
sub EPROGMISMATCH () { 108 }
sub EPROCUNAVAIL () { 109 }
sub ENOLCK () { 110 }
sub EAUTH () { 111 }
sub ENEEDAUTH () { 112 }
sub EBACKGROUND () { 113 }
sub EBADMSG () { 114 }
sub EIDRM () { 115 }
sub EMULTIHOP () { 116 }
sub ENODATA () { 117 }
sub ENOLINK () { 118 }
sub ENOMSG () { 119 }
sub ENOSR () { 120 }
sub ENOSTR () { 121 }
sub EOVERFLOW () { 122 }
sub EPROTO () { 123 }
sub ETIME () { 124 }
sub E2BIG () { 125 }
sub ERESTART () { 126 }
sub ECHRNG () { 127 }
sub EINTR () { 128 }
sub ESNDLOCKED () { 129 }
sub ESNDNOTLOCK () { 130 }
sub EL2NSYNC () { 131 }
sub EL3HLT () { 132 }
sub EL3RST () { 133 }
sub ELNRNG () { 134 }
sub EUNATCH () { 135 }
sub ENOCSI () { 136 }
sub EL2HLT () { 137 }
sub EBADE () { 138 }
sub EXFULL () { 139 }
sub ENOANO () { 140 }
sub EBADRQC () { 141 }
sub EBADSLT () { 142 }
sub EBFONT () { 143 }
sub ENONET () { 144 }
sub ENOPKG () { 145 }
sub EADV () { 146 }
sub ESRMNT () { 147 }
sub ECOMM () { 148 }
sub EDOTDOT () { 149 }
sub ELIBACC () { 150 }
sub ELIBBAD () { 151 }
sub ELIBSCN () { 152 }
sub ELIBMAX () { 153 }
sub ELIBEXEC () { 154 }
sub ESTRPIPE () { 155 }
sub EUCLEAN () { 156 }
sub ENOTNAM () { 157 }
sub ENAVAIL () { 158 }
sub EREMOTEIO () { 159 }
sub ENOTSOCK () { 300 }
sub EDESTADDRREQ () { 301 }
sub EMSGSIZE () { 302 }
sub EPROTOTYPE () { 303 }
sub ENOPROTOOPT () { 304 }
sub EPROTONOSUPPORT () { 305 }
sub ESOCKTNOSUPPORT () { 306 }
sub EOPNOTSUPP () { 307 }
sub EPFNOSUPPORT () { 308 }
sub EAFNOSUPPORT () { 309 }
sub EADDRINUSE () { 310 }
sub EADDRNOTAVAIL () { 311 }
sub ENETDOWN () { 312 }
sub ENETUNREACH () { 313 }
sub ENETRESET () { 314 }
sub ECONNABORTED () { 315 }
sub ECONNRESET () { 316 }
sub EISCONN () { 317 }
sub ENOTCONN () { 318 }
sub ESHUTDOWN () { 319 }
sub ETIMEDOUT () { 320 }
sub ECONNREFUSED () { 321 }
sub EHOSTDOWN () { 322 }
sub EHOSTUNREACH () { 323 }
sub EALREADY () { 324 }
sub EINPROGRESS () { 325 }
sub EWOULDBLOCK () { 326 }
sub EAGAIN () { 326 }
sub ENOBUFS () { 327 }
sub ETOOMANYREFS () { 328 }

sub TIEHASH { bless [] }

sub FETCH {
    my ($self, $errname) = @_;
    my $proto = prototype("Errno::$errname");
    my $errno = "";
    if (defined($proto) && $proto eq "") {
	no strict 'refs';
	$errno = &$errname;
        $errno = 0 unless $! == $errno;
    }
    return $errno;
}

sub STORE {
    require Carp;
    Carp::confess("ERRNO hash is read only!");
}

*CLEAR = \&STORE;
*DELETE = \&STORE;

sub NEXTKEY {
    my($k,$v);
    while(($k,$v) = each %Errno::) {
	my $proto = prototype("Errno::$k");
	last if (defined($proto) && $proto eq "");
    }
    $k
}

sub FIRSTKEY {
    my $s = scalar keys %Errno::;	# initialize iterator
    goto &NEXTKEY;
}

sub EXISTS {
    my ($self, $errname) = @_;
    my $proto = prototype($errname);
    defined($proto) && $proto eq "";
}

tie %!, __PACKAGE__;

1;
__END__

=head1 NAME

Errno - System errno constants

=head1 SYNOPSIS

    use Errno qw(EINTR EIO :POSIX);

=head1 DESCRIPTION

C<Errno> defines and conditionally exports all the error constants
defined in your system C<errno.h> include file. It has a single export
tag, C<:POSIX>, which will export all POSIX defined error numbers.

C<Errno> also makes C<%!> magic such that each element of C<%!> has a
non-zero value only if C<$!> is set to that value. For example:

    use Errno;

    unless (open(FH, "/fangorn/spouse")) {
        if ($!{ENOENT}) {
            warn "Get a wife!\n";
        } else {
            warn "This path is barred: $!";
        } 
    } 

If a specified constant C<EFOO> does not exist on the system, C<$!{EFOO}>
returns C<"">.  You may use C<exists $!{EFOO}> to check whether the
constant is available on the system.

=head1 CAVEATS

Importing a particular constant may not be very portable, because the
import will fail on platforms that do not have that constant.  A more
portable way to set C<$!> to a valid value is to use:

    if (exists &Errno::EFOO) {
        $! = &Errno::EFOO;
    }

=head1 AUTHOR

Graham Barr <gbarr@pobox.com>

=head1 COPYRIGHT

Copyright (c) 1997-8 Graham Barr. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

