-*- text -*-
Changes in 2.13:

* Support for the Fujitsu FRV architecture added by Red Hat. Models for FR400
  and FR500 included.

Changes in version 2.13:

* DEC VAX ELF support, by Matt Thomas.

Changes in version 2.12:

* Support for Don Knuth's MMIX, by Hans-Peter Nilsson.

* Support for the OpenRISC 32-bit embedded processor by OpenCores.

* Support for -z nocopyreloc in the x86 ELF linker, which disables
  production of copy relocs.  Warning: using this option may result in
  non-sharable applications.

* Support for -z combreloc in the ELF linker, which puts dynamic
  relocations against the same symbol together, so that dynamic linker
  can use an one-entry symbol lookup cache.

* Support for ELF SHF_MERGE section merging, by Jakub Jelinek.

Changes in version 2.11:

* Support for AMD x86-64 architecture, by Jan Hubicka, SuSE Labs.

* Support added for eliminating duplicate DWARF2 debug information by
  having the compiler generate the information in sections called
  .gnu.linkonce.wi.XXXX where XXXX is a checksum for the contents.  The
  linker then merges these sections together into the normal .debug_info
  section.

* The native ELF linker now searches the directories in DT_RUNPATH or
  DT_RPATH of a shared library for shared libraries needed by it.

* TI C54x support, by Timothy Wall.

* Added command line switch --section-start to set the start address of any
  specified section. 

* Added ability to emit full relocation information in linked executables,
  enabled by --emit-relocs.  Some post-linkage optimization tools need
  this information in order to be able to correctly identify and perform
  symbol relative addressing in the event of changes in section contents
  (instructions being added or deleted, extending data sections, etc.)

* Support for i860, by Jason Eckhardt (preliminary, alpha quality).

* Support for CRIS (Axis Communications ETRAX series).

Changes in version 2.10:

* Added AT> to the linker script language to allow load-time allocation of 
  sections into regions.

* Added garbage collection of unused sections, enabled by --gc-sections. 
  It does require a bit of backend support; currently implemented are
  arm-elf, avr-elf, d10v-elf, fr30-elf, i386-elf, m32r-elf, m68k-elf,
  mcore-elf, mips-elf, mn10300-elf, ppc-elf, sh-elf, sparc-elf, and v850-elf.
  Others will ignore the option.

* Added SORT to the linker script language to permit sorting sections by file
  name or section name.

* Added EXTERN to the linker script language as an equivalent to the -u
  command-line option.

* Added ASSERT to the linker script language.

* Added EXCLUDE_FILE to the linker script language for further control over
  wildcard file names.

* Added -O option to optimize linker output (as of this writing, this only
affects ELF shared library generation).

* The -e option now accepts a number as well as a symbol name.

* Added --no-undefined option to disallow undefined symbols when creating a
  shared library.

* The linker now issues a warning, not an error, for an undefined symbol when
  using -Bsymbolic; use the new --no-undefined option to get the old
  behaviour.

* Added --demangle and --no-demangle options.

Changes in version 2.9:

* Added SQUAD to the linker script language.

* New option --no-warn-mismatch.

* The MEMORY command now parses the attributes to determine where sections that
  are not placed in a specific memory region are placed.

Changes in version 2.8:

* Linker scripts may now contain shell wildcard characters for file and section
  names.

* The linker now supports symbol versions in ELF.

* The NOCROSSREFS command was added to the linker script language.

* The LOADADDR expression was added to the linker script language.

* MAX and MIN functions were added to the linker script language.

* The OVERLAY construct was added to the linker script language.

* New option --warn-section-align to warn when the address of an output section
  changes due to alignment of an input section.

* New options --filter/-F and --auxiliary/-f.

Changes in version 2.7:

* New option --cref to print out a cross reference table.

* New option --wrap SYMBOL.

* New option --no-whole-archive, to turn off the effect of --whole-archive.

* Input sections assigned to the output section /DISCARD/ in the linker script
  are not included in the output file.

* The SunOS and ELF linkers now merge stabs debugging information which uses
  the N_BINCL and N_EINCL stab types.  This reduces the amount of debugging
  information generated.

Changes in version 2.6:

* When an ELF section name is representable as a C identifier (this is not true
of most ELF section names), the linker will automatically define symbols
__start_SECNAME and __stop_SECNAME, where SECNAME is the section name, at the
beginning and the end of the section.  This is used by glibc.

* When an ELF section named .gnu.warning is encountered in an input file, the
contents of the section are displayed as an error message, and the section is
not copied into the output file.  This is used by glibc.

* When an ELF section named .gnu.warning.SYMBOL is encountered in an input
file, and the symbol SYMBOL is referenced by some object file, the contents of
the section are displayed as an error message.  The section is not copied into
the output file, unless doing a relocateable or shared link.  This is used by
glibc.

* New options -split-by-reloc and -split-by-file.

* The linker now supports linking PIC compiled code on SPARC SunOS.  It can
also create SPARC SunOS shared libraries, and, like the native SunOS linker,
will do so whenever there is an undefined symbol in the link and neither the -e
nor the -r option was used.

* The -rpath option may be used on SunOS to set the list of directories to be
searched at run time.  This overrides the default of building the list from the
-L options.

* The COFF linker now combines debugging information for structs, unions, and
enums, so that even if the same type is defined in multiple input files it will
only be defined once in the output file.  The --traditional-format switch will
prevent this optimization.

Changes in version 2.5:

* The linker now supports linking against SunOS shared libraries.  It still can
not link SunOS PIC (Position Independent Code) files, so it can not be used to
generate shared libaries.

* The linker now supports linking against ELF shared libraries for the i386
(UnixWare) and SPARC (Solaris).  It can also link ELF PIC files, and can be
used to generate shared libraries.  Shared library generation is not well
tested; please report any problems encountered.  The linker is now enabled for
Solaris again.

* Eric Youngdale has contributed Linux support code, including linking against
Linux a.out shared libraries.  The linker produces Linux QMAGIC binaries.

* The ELF backend has been converted to the new linker code.  To use the new
ELF linker, each particular target requires a relocation function.  So far,
this function has been written for i386 (UnixWare), SPARC (Solaris) MIPS (Irix
5), and HPPA ELF targets.

* The -( (--start-group) and -) (--end-group) options have been added to
support searching a group of archives as though they were a single archive.
This can also be used in a linker script, as GROUP ( files ).

* When a file is named on the command line, and the linker does not recognize
it as an object file, the linker will now treat the file as a linker script
file.  A linker script named in this way augments, but does not replace, the
default linker script.

* The -warn-once option was added.  It causes the linker to only warn once per
undefined symbol, rather than once per reference.

* The COFF backend has been converted to the new linker code.  As with ELF, to
use the new linker, each particular target requires a relocation function.  So
far, this function has been written for the i386, m68k, a29k and SH targets.

* The -V flag was made a synonym for -v, for SVR4 compatibility.  The old -V
behaviour is available via --verbose.

Changes in version 2.4:

* New linker code, by Steve Chamberlain and Ian Taylor.  For a.out and ecoff
  formats (so far), this should result in considerable savings in time
  and memory used while linking; slightly poorer performance than
  before for formats not converted yet.

* Command-line parsing is no longer done with flex.  This means
  oddball characters in filenames won't get treated as argument
  separators.

* HP-PA ELF support, by Jeff Law.  (No SOM support yet.)

* Mach i386 support, by David Mackenzie.

* Irix 4 shared libraries are now supported (Irix 5 uses ELF, and ELF shared
  libraries are not yet supported).

* COFF shared libraries (as on SCO) should work as well.

* The linker is disabled for Solaris.  (Actually, it was in 2.3 also, I just
  forgot to note it.)  Some of their C library routines don't work when
  statically linked, and the GNU linker doesn't support dynamic linking yet.

Changes in version 2.3:

* Weak symbols are now supported.

* ELF support has been added.  The linker has been bootstrapped on
  UnixWare and Solaris.

* Alpha OSF/1 support has been added (non dynamic linking only).

Changes in version 2.2:

* The `bfd' library has been updated to reduce a.out-format string
  table size.  The effect of this is that files linked from many input
  files with duplicate symbols (`-g' debugging records, or identical
  static symbols) should be much smaller.

Changes in version 2.1:

* The ld -ySYMBOL flag (to trace references to SYMBOL) is now implemented.

* There is now support for writing ECOFF files, so ld and the
  other utilities should work on Risc/Ultrix and Irix.


Local variables:
fill-column: 79
End:
