********************************************************************************

version         EQU 1                   ; 0 testversion - 1 programmversion
bcol            EQU $00000001           ; rasterbalken farbe
frqtabnr        EQU 0                   ; 0 = norm   1 = netherworld  2 = spectrum
;                                 3 = live and let die
freia6          EQU 0                   ; 1 = a6 frei    <> 1 a6 benutzt
;                               ; 2 = psg im timer zustzlich selecten
teff2           EQU 0                   ; timer effekt frequenz anpassen   0=aus  1=an
phase3          EQU 0                   ; 0 = lassen  1 = umselectieren
routs           EQU 1                   ; 0= timer routinen nicht assemblieren 1= timer notwendig
midi            EQU 0                   ; 1 = midi output an  0 = aus

********************************************************************************
                PART 'first'

                IF version=1
                OPT D-

                clr.w   -(a7)
                pea     $00200000
                trap    #1
                ELSE
                OPT D+

                ENDC
                ENDPART

                PART 'init'
                bra     drber
pt:             DC.B 'A:\',0
loadtitel:      DC.B ' LOAD COMPLETE MUSIC ',0
savetitel:      DC.B ' SAVE COMPLETE MUSIC ',0
musicmask:      DC.B '*.MV2',0
digp:           DC.B 'A:\',0
digk:           DC.B '*.4BT',0
digloadtxt:     DC.B 'LOAD 4BIT-DIGI',0
digsavetxt:     DC.B 'SAVE 4BIT-DIGI',0
iloadtxt:       DC.B 'LOAD INSTRUMENT',0
isavetxt:       DC.B 'SAVE INSTRUMENT',0
instk:          DC.B '*.INS',0
                EVEN
nmi:            BREAKPT ' **** scheisse nmi !!! *** '

drber:         move    #$2700,sr


                move.l  #nmi,$00000060.w
                move.l  #nmi,$0000007C.w

                clr.l   $FFFF8240.w
                clr.l   $FFFF8244.w
                clr.l   $FFFF8248.w
                clr.l   $FFFF824C.w
                clr.l   $FFFF8250.w
                clr.l   $FFFF8254.w
                clr.l   $FFFF8258.w
                clr.l   $FFFF825C.w

                lea     stack,a7
                clr.l   $FFFFFA06.w
                move.l  #keyint,$00000118.w

                move.b  #$15,$FFFFFC04.w

                tst.b   $FFFFFC02.w
                moveq   #-1,d0
                dbra    d0,*-2
                moveq   #$1A,d0
                bsr     sendikbd
                moveq   #-1,d0
                dbra    d0,*-2
                moveq   #$12,d0
                bsr     sendikbd
                moveq   #-1,d0
                dbra    d0,*-2


                move.b  #$40,$FFFFFA09.w
                move.l  #vbl,$00000070.w
                move.l  #$000F0000,logscr
                move.l  logscr(pc),d0
                lsr.w   #8,d0
                move.l  d0,$FFFF8200.w

                sf      $FFFFFA1B.w
                bset    #0,$FFFFFA07.w
                bset    #0,$FFFFFA13.w
                bclr    #0,$FFFFFA0F.w
                bclr    #3,$FFFFFA17.w
                move.l  #hbl,$00000120.w

                bsr     makecon

                bsr     cls

                stop    #$2300
                stop    #$2300
                move.b  #1,$FFFF8260.w
                stop    #$2300
                move.b  #1,$FFFF8260.w
                stop    #$2300


                ENDPART

                PART 'control'
                bsr     new
showall:
                move.l  #patlist,patternp
                move.l  #instlist,instrp
                move.l  #testsong,songp
                move.l  #digilist,digidrums

                clr.w   reloflag
                bsr     cls
                lea     t(pc),a1
                moveq   #0,d0
                moveq   #0,d1
test:
                bsr     print
                addq.w  #1,d1
                tst.b   (a1)
                bne.s   test

                lea     fsel153(pc),a1
                moveq   #45,d0
                moveq   #0,d1
                bsr     print


                move.l  actinst(pc),d1
                lea     instlist,a0
                moveq   #0,d0
                addq.w  #1,d0
                cmp.l   (a0)+,d1
                bne.s   *-6

                bsr     showinst

                move.w  acttracknr(pc),d0
                bsr     showsong

                move.w  actpatnr(pc),d0
                bsr     showpat

                bsr     showdig

                stop    #$2300

                move.w  #1,$FFFF8240.w
                move.w  #$0664,$FFFF8242.w
                move.w  #$0775,$FFFF8244.w
                move.w  #$0004,$FFFF8246.w


control:        move.l  key(pc),d0
                beq.s   control
                clr.l   key
                swap    d0
                tst.w   ctrl
                bne     co3                ;co4

                cmp.b   #$47,d0
                bne.s   con0
                move.w  #2,cy
                move.w  #4,cx
                bra.s   control

con0:
                cmp.b   #$61,d0
                bne.s   con0b
                move.w  #19,cy
                move.w  #6,cx
                bra.s   control
con0b:
                cmp.b   #$62,d0
                bne.s   con0c
                move.w  #2,cy
                move.w  #32,cx
                bra.s   control
con0c:

                cmp.b   #$3B,d0            ; f1 play actpat
                bne.s   con1
                bsr     createtest
                bra.s   control
con1:           cmp.b   #$44,d0            ;f10 stop playing
                bne.s   con2a
                bsr     ruhe
                bra.s   control
con2a:          cmp.b   #$3D,d0            ; set screen mittich
                bne.s   con2
                move    #$2700,sr
                move.b  #0,$FFFF8260.w
                move.b  #1,$FFFF8260.w
                stop    #$2300

*        bsr     ruhe
*       bsr     timerinit
                bra     control

con2:           cmp.b   #$3C,d0
                bne.s   cont
                bsr     startsong
                bra     control
cont:           cmp.b   #$4D,d0
                bne.s   co0
                cmpi.w  #78,cx
                beq     control
                addq.w  #2,cx
                bra     control
co0:            cmp.b   #$4B,d0
                bne.s   co1
                tst.w   cx
                beq     control
                subq.w  #2,cx
                bra     control
co1:            cmp.b   #$48,d0
                bne.s   co2
                tst.w   cy
                beq     control
                subq.w  #1,cy
                bra     control
co2:            cmp.b   #$50,d0
                bne.s   co3
                cmpi.w  #26,cy
                beq     control
                addq.w  #1,cy
                bra     control

co3:
                cmpi.w  #26,cy
                bne.s   co4b
                cmpi.w  #10,cx
                bne.s   co4b
                bsr     digiedit
                bsr     showdig
                bra     control
co4b:
                cmpi.w  #19,cy
                blt.s   co4
                bsr     instedit
                bra     control

co4:
                cmpi.w  #1,cy
                blt.s   co5
                cmpi.w  #28,cx
                blt.s   co4a
                bsr     songedit
                bra     control
co4a:           bsr     patedit
                bra     control
co5:
                tst.w   ctrl
                beq.s   no_disc
                swap    d0
                cmp.w   #'q',d0
                beq.s   quit
                cmp.w   #'s',d0            ; Save
                bne.s   con0a
                bsr     ruhe
                bsr     packer
                bra     showall
con0a:          cmp.w   #'l',d0            ; Load
                bne.s   no_disc
                clr.l   mvblp
                bsr     ruhe
                bsr     repack
                bra     showall
no_disc:        swap    d0
                bra     control
quit:
                clr.w   -(a7)
                trap    #1
                ENDPART

                PART
t:
                DC.B " [Quit]  [Load]  [Save]     Ti.:  :     File:                            X~TROLL",0
                DC.B '__N:__01_{Ptname}___L:__00______________Nr.:..______Spd:..______Rpt:..__________',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '00                        |',0
                DC.B '________________________________________________________________________________',0
                DC.B '  N:               -     -',0
                DC.B '  A:',0
                DC.B '  R:',0
                DC.B '  M:',0
                DC.B '  Vi:                                          < 80=rept  81=cont  82=stop',0
                DC.B '  Bl:                                          < 80=rept  81=cont  82=stop',0
                DC.B '__Ti:_________<_8=\|\__a=\/\__c=/|/__e=/\/__9=\__d=/____________________________',0
                DC.B '__Digi:___00_________________________|__Rasta:00__Insts:00__Pats:00__Tracks:00__',0
                DC.B 'HTTP://XTROLL.ATARI.ORG  ------   XTROLL@MOUSEATTACK.DE   The-legandary-X-TROLLS',0
                DC.B 0
                EVEN
                ENDPART

                PART 'print d0=x d1=y a1=text'
printxy:
                movem.l d0-d2/a0/a2,-(a7)
                moveq   #0,d0
                moveq   #0,d1
                move.w  px(pc),d0
                move.w  py(pc),d1
                bra.s   print0
print:
* a1=text
* d0=x d1=y
                movem.l d0-d2/a0/a2,-(a7)

print0:         movea.l logscr(pc),a0

                moveq   #0,d2
                move.w  d0,d2
                exg     d0,d2

                mulu    #8*160,d1
                move.w  d0,d2
                and.w   #1,d2
                and.w   #%1111111111111110,d0
                lsl.w   #1,d0
                add.w   d2,d0
                add.w   d1,d0
                lea     0(a0,d0.l),a0

                move.l  #$00030001,d2
                and.w   #1,d0
                beq.s   *+2
                swap    d2

nextchar:       moveq   #0,d0
                move.b  (a1)+,d0
                beq.s   schluss
                lsl.w   #2,d0
                movea.l contab(pc,d0.w),a2

                move.b  (a2)+,(a0)
                move.b  (a2)+,160(a0)
                move.b  (a2)+,320(a0)
                move.b  (a2)+,480(a0)
                move.b  (a2)+,640(a0)
                move.b  (a2)+,800(a0)
                move.b  (a2)+,960(a0)
                move.b  (a2)+,1120(a0)

                adda.w  d2,a0
                swap    d2
                bra.s   nextchar
schluss:
                movem.l (a7)+,d0-d2/a0/a2
                rts
********************************************************************************
contab:         DS.L 256
********************************************************************************
makecon:        lea     contab(pc),a0
                move.w  #255,d0
                move.l  #chars+tablen*8,d1
fillcon:        move.l  d1,(a0)+
                dbra    d0,fillcon

                lea     tab1(pc),a0
                lea     contab(pc),a1
                moveq   #tablen,d1
conv0:
                moveq   #0,d0
                move.b  0(a0,d1.w),d0
                lsl.w   #2,d0
                move.l  d1,d2
                lsl.w   #3,d2
                add.l   #chars,d2
                move.l  d2,0(a1,d0.w)
                dbra    d1,conv0
                rts

tab1:           DC.B ' !"'
                DC.B "#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                DC.B '[\]^_abcdefghijklmnopqrstuvwxyz{|}~'
tablen          EQU *-tab1-1
                EVEN

                ENDPART


                PATH 'D:\DATA\'
chars:          IBYTES '8X8_2.FNT'



********************************************************************************
logscr:         DC.L $000F0000
                ENDPART

                PART 'vbl-hbl'

vbl:            movem.l d0-a5,-(a7)
                clr.b   $FFFFFA1B.w
                move.b  #1,$FFFFFA07.w
                move.b  #$C7,$FFFFFA21.w
                move.b  #8,$FFFFFA1B.w


                addq.l  #1,$000004BA.w

                subq.w  #1,rpt
                bne.s   vbl1
                move.w  #1,rpt
                move.l  lastkey(pc),key
vbl1:
                bsr     cursor

                movem.l (a7)+,d0-a5
rte:            rte

mvblp:          DC.L 0


hbl:
*********rand auf*************************
                move.l  d0,-(a7)
hbl1:           move.b  $FFFF8209.w,d0
                cmp.b   #$70,d0
                blt.s   hbl1
                sub.b   #$70,d0
                not.w   d0
                lsr.w   d0,d0
                DS.W 50,$00004E71
                clr.b   $FFFF820A.w
                DS.W 10,$00004E71
                move.b  #2,$FFFF820A.w
                not.w   $FFFF8240.w
                not.w   $FFFF8240.w
                move.l  (a7)+,d0
*****************************************
                move.l  d0,-(a7)

                move.l  mvblp(pc),d0
                beq.s   hbl2
                move.l  a0,-(a7)
                movea.l d0,a0
hbl3:           move.b  $FFFFFA21.w,d0
                cmp.b   $FFFFFA21.w,d0
                beq.s   hbl3
                move.w  $FFFFFA20.w,-(a7)
                move.w  $FFFF8240.w,-(a7)
                move.w  #bcol,$FFFF8240.w
                jsr     (a0)
                move.w  (a7)+,$FFFF8240.w
                move.w  (a7)+,d0

                sub.w   $FFFFFA20.w,d0

                movea.l (a7)+,a0

                cmp.b   rasta(pc),d0
                bgt.s   rm1

                subq.w  #1,rc
                bne.s   rm2
rm1:            move.w  #50,rc
                move.b  d0,rasta
                move.l  px(pc),-(a7)
                move.w  #46,px
                move.w  #26,py
                bsr     phex
                move.l  (a7)+,px
rm2:
hbl2:
                move.l  (a7)+,d0
                rte

rasta:          DC.W 0
rc:             DC.W 1



                move.l  (a7)+,d0


                rte
                ENDPART

cursor:         PART 'control cursor'
                moveq   #0,d0
                moveq   #0,d1
                move.w  cx(pc),d0
                move.w  cy(pc),d1
                bsr     scradr
                lea     (a0),a1            ; neupos
                move.w  ocx(pc),d0
                move.w  ocy(pc),d1
                bsr     scradr             ; a0=altpos
                move.l  cx(pc),d0
                cmp.l   ocx(pc),d0
                beq.s   nomove
                clr.w   (a0)
                clr.w   160(a0)
                clr.w   320(a0)
                clr.w   480(a0)
                clr.w   640(a0)
                clr.w   800(a0)
                clr.w   960(a0)
                moveq   #-1,d0
                move.w  d0,(a1)
                move.w  d0,160(a1)
                move.w  d0,320(a1)
                move.w  d0,480(a1)
                move.w  d0,640(a1)
                move.w  d0,800(a1)
                move.w  d0,960(a1)
                move.l  cx(pc),ocx
                move.w  #30,crc
                rts
nomove:
                subq.w  #1,crc
                bne.s   nomove0
                move.w  #24,crc
                not.w   (a1)
                not.w   160(a1)
                not.w   320(a1)
                not.w   480(a1)
                not.w   640(a1)
                not.w   800(a1)
                not.w   960(a1)
nomove0:
                rts
scradr:
                movem.l d0-d2,-(a7)
                movea.l logscr(pc),a0
                mulu    #8*160,d1
                move.w  d0,d2
                and.w   #1,d2
                and.w   #%1111111111111110,d0
                lsl.w   #1,d0
                add.w   d2,d0
                add.w   d1,d0
                lea     2(a0,d0.l),a0
                movem.l (a7)+,d0-d2
                rts

crc:            DC.W 1
cx:             DC.W 0
cy:             DC.W 0
ocx:            DC.W 0
ocy:            DC.W 0


                ENDPART

                PART 'key $118'
sendikbd:       tst.b   $FFFFFC02.w
                btst    #0,$FFFFFC00.w
                bne.s   sendikbd
                move.b  d0,$FFFFFC02.w
                rts

keyint:         move.l  d0,-(a7)
keyint1:        move.b  $FFFFFC00.w,d0
                tst.b   $FFFFFC06.w
                btst    #7,d0
                beq     no_key
                btst    #0,d0
                beq     no_key
                move.b  $FFFFFC02.w,d0

                cmp.b   #$38,d0
                bne.s   k1
                st      alt
                moveq   #0,d0
k1:             cmp.b   #$0038+128,d0
                bne.s   k2
                sf      alt
                moveq   #0,d0
k2:             cmp.b   #$2A,d0
                bne.s   k3
                st      shift
                moveq   #0,d0
k3:             cmp.b   #$002A+128,d0
                bne.s   k4
                sf      shift
                moveq   #0,d0
k4:             cmp.b   #$1D,d0
                bne.s   k4a
                st      ctrl
                moveq   #0,d0
k4a:            cmp.b   #$001D+128,d0
                bne.s   k4b
                sf      ctrl
                moveq   #0,d0
k4b:

                tst.b   d0
                bpl.s   *+2
                moveq   #0,d0

                move.b  ttab(pc,d0.w),key+3
                move.b  ttab(pc,d0.w),lastkey+3
                tst.w   shift
                beq.s   k5
                add.w   #ttabs-ttab,d0
                move.b  ttab(pc,d0.w),key+3
                move.b  ttab(pc,d0.w),lastkey+3

k5:
                move.b  d0,key+1
                move.b  d0,lastkey+1
                move.w  #20,rpt

                btst    #4,$FFFFFA01.w
                bne     keyint1

no_key:         move.l  (a7)+,d0
                rte

lastkey:        DC.L 0
key:            DC.L 0
ctrl:           DC.W 0
shift:          DC.W 0
alt:            DC.W 0
rpt:            DC.W 0

keytab:
ttab:           DC.B 0,"1234567890' qwertzuiop+  asdfghjkl   yxcvbnm .- "
                DC.B '  	'
                DS.B 256,' '

ttabs:          DC.B 0,'!"$%&/()=?` QWERTZUIOP*  ASDFGHJKL   YXCVBNM :_ '
                DC.B '  	'
                DS.B 256,' '

                ENDPART

cls:            PART 'clear screen'
                movea.l logscr(pc),a0
                move.w  #300*160/4-1,d0
                moveq   #0,d1
                move.l  d1,(a0)+
                dbra    d0,*-4
                rts
                ENDPART
pdez:
                movem.l d0-a6,-(a7)
                and.l   #$000000FF,d0
                move.w  d0,d1
                divu    #10,d0
                move.b  d0,hz
                mulu    #10,d0
                sub.b   d0,d1
                move.b  d1,hz+1
                addi.b  #'0',hz
                addi.b  #'0',hz+1
                lea     hz(pc),a1
                move.w  px(pc),d0
                move.w  py(pc),d1
                bsr     print
                movem.l (a7)+,d0-a6
                rts

phex:           PART 'hexprint d0'      ; an px,py
                movem.l d0-d3/a0-a2,-(a7)
                move.w  d0,d1
                and.w   #15,d0
                move.b  hexnums(pc,d0.w),hz+1
                lsr.w   #4,d1
                and.w   #15,d1
                move.b  hexnums(pc,d1.w),hz
                lea     hz(pc),a1
                move.w  px(pc),d0
                move.w  py(pc),d1
                bsr     print
                movem.l (a7)+,d0-d3/a0-a2
                rts

hexnums:        DC.B '0123456789abcdef'
hz:             DC.B 0,0,0
                EVEN
px:             DC.W 0
py:             DC.W 0
                ENDPART

                PART 'song'
insert:         mulu    #12,d1
                movea.l acttrack(pc),a0
                lea     0(a0,d1.w),a0

                movea.l tracksendp(pc),a1
                adda.l  #12,a1
                move.l  a1,tracksendp
ins1:           move.w  -14(a1),-(a1)
                cmpa.l  a0,a1
                bne.s   ins1
                clr.l   (a0)+
                clr.l   (a0)+
                clr.l   (a0)+
                movea.l a0,a2

                lea     tracklist,a0
ins2:           tst.w   (a0)
                bmi.s   ins3
                cmpa.l  (a0),a2
                bgt.s   *+2
                addi.l  #12,(a0)
                addq.l  #6,a0
                bra.s   ins2

ins3:           addq.w  #1,taktanz

                move.w  acttracknr(pc),d0
                bsr     showsong
                bra     send
********************************************************************************
delete:         mulu    #12,d1
                movea.l acttrack(pc),a0
                lea     0(a0,d1.w),a0
                adda.l  #12,a0
                tst.w   (a0)               ; letzten nicht lschen
                bmi     send

                movea.l a0,a2
; trackliste verndern
                movea.l tracksendp(pc),a1
del0:           cmpa.l  a0,a1
                beq.s   del1
                move.w  (a0)+,-14(a0)
                bra.s   del0
del1:           subi.l  #12,tracksendp
                subq.w  #1,taktanz

                lea     tracklist,a0
del2:           tst.w   (a0)
                bmi.s   del3
                cmpa.l  (a0),a2
                bgt.s   *+2
                subi.l  #12,(a0)
                addq.l  #6,a0
                bra.s   del2

del3:           move.w  acttracknr(pc),d0
                bsr     showsong
                bra     send

sca:
                moveq   #0,d2
                move.w  trackoff(pc),d2
                divu    #12,d2
                add.w   #16,d2
                cmp.w   taktanz(pc),d2
                bgt     send
                addi.w  #12,trackoff
                move.w  acttracknr(pc),d0
                bsr     showsong
                bra     send
scb:            tst.w   trackoff
                beq     send
                subi.w  #12,trackoff
                move.w  acttracknr(pc),d0
                bsr     showsong
                bra     send

newtrack:       lea     tracklist,a0
nt0:            tst.w   (a0)
                bmi.s   nt1
                addq.l  #6,a0
                bra.s   nt0

nt1:            move.l  tracksendp(pc),(a0)+
                move.b  #5,(a0)+
                move.b  #0,(a0)+
                move.l  #-1,(a0)+

                movea.l tracksendp(pc),a0
                clr.l   (a0)+
                clr.l   (a0)+
                clr.l   (a0)+
                move.l  #-1,(a0)+
                move.l  a0,tracksendp

                addq.w  #1,trackanz
                move.w  #0,taktanz
                move.w  trackanz(pc),d0
                subq.w  #1,d0
                move.w  d0,acttracknr
                clr.w   trackoff
                bsr     showsong
                bra     send
nexttrack:      move.w  acttracknr(pc),d0
                addq.w  #1,d0
                cmp.w   trackanz(pc),d0
                beq     send
                move.w  d0,acttracknr
                clr.w   trackoff
                bsr     showsong
                bra     send
prevtrack:
                move.w  acttracknr(pc),d0
                beq     send
                subq.w  #1,d0
                move.w  d0,acttracknr
                clr.w   trackoff
                bsr     showsong
                bra     send



deltrack:       cmpi.w  #1,trackanz
                beq     send
                subq.w  #1,trackanz
                move.w  acttracknr(pc),d0
                mulu    #6,d0
                lea     tracklist,a0
                lea     0(a0,d0.w),a0

                tst.w   6(a0)
                bpl.s   dt1
                move.l  (a0),tracksendp
                move.l  #-1,(a0)
                subq.w  #1,acttracknr
                bra.s   dt4

dt1:            movea.l (a0),a1
                movea.l 6(a0),a2
                move.l  a2,d0
                sub.l   a1,d0
dt2:            move.w  (a2)+,(a1)+
                cmpa.l  tracksendp(pc),a2
                bne.s   dt2
                move.l  a1,tracksendp

dt3:            tst.w   6(a0)
                bmi.s   dt5
                move.l  6(a0),(a0)
                sub.l   d0,(a0)
                move.w  10(a0),4(a0)
                addq.l  #6,a0
                bra.s   dt3

dt5:            move.l  #-1,(a0)


dt4:            move.w  acttracknr(pc),d0
                bsr     showsong
                bra     send


ss7:
                cmpi.w  #1,cy
                bne     send

                cmpi.w  #56,cx
                bne.s   ss8

                swap    d0

                bsr     d2x
                bne     send
                move.w  d0,d1
                lsl.w   #4,d1
                bsr     waitkey
                bsr     d2x
                bne     send
                or.w    d1,d0
                move.w  acttracknr(pc),d1
                mulu    #6,d1
                lea     tracklist,a0
                move.b  d0,4(a0,d1.w)
                move.w  acttracknr(pc),d0
                bsr     showsong
                bra     send

ss8:            cmpi.w  #68,cx
                bne.s   ss9

                swap    d0

                bsr     d2x
                bne     send
                move.w  d0,d1
                lsl.w   #4,d1
                bsr     waitkey
                bsr     d2x
                bne     send
                or.w    d1,d0
                move.w  acttracknr(pc),d1
                mulu    #6,d1
                lea     tracklist,a0
                move.b  d0,5(a0,d1.w)
                move.w  acttracknr(pc),d0
                bsr     showsong
                bra     send

ss9:            cmpi.w  #$002C,cx
                bne     send
                cmp.w   #$0052,d0
                beq     newtrack
                cmp.w   #$0053,d0
                beq     deltrack
                swap    d0
                cmp.w   #'+',d0
                beq     nexttrack
                cmp.w   #'-',d0
                beq     prevtrack

                bra     send
songedit:
                movem.l d1-a5,-(a7)


                move.w  cy(pc),d1
                subq.w  #2,d1
                bmi     ss7
                moveq   #0,d2
                move.w  trackoff(pc),d2
                divu    #12,d2
                add.w   d2,d1
                cmp.w   taktanz(pc),d1
                bgt     send

                tst.w   ctrl
                beq.s   ss0

                cmp.w   #$0052,d0
                beq     insert
                cmp.w   #$0053,d0
                beq     delete
                cmp.w   #$0050,d0
                beq     sca
                cmp.w   #$0048,d0
                beq     scb

ss0:
                swap    d0




                moveq   #0,d2
                cmpi.w  #32,cx
                beq     se1
                cmpi.w  #34,cx
                beq     se2
                cmpi.w  #36,cx
                beq.s   se3
                addq.w  #1,d2
                cmpi.w  #38,cx
                beq.s   se3
                moveq   #4,d2
                cmpi.w  #48,cx
                beq     se1
                cmpi.w  #50,cx
                beq     se2
                cmpi.w  #52,cx
                beq.s   se3
                addq.w  #1,d2
                cmpi.w  #54,cx
                beq.s   se3
                moveq   #8,d2
                cmpi.w  #64,cx
                beq     se1
                cmpi.w  #66,cx
                beq     se2
                cmpi.w  #68,cx
                beq.s   se3
                addq.w  #1,d2
                cmpi.w  #70,cx
                beq.s   se3
                bra     send

se3:            bsr     d2x
                bne     send

                move.w  d0,d1
                lsl.w   #4,d1
                bsr     waitkey
                bsr     d2x
                bne     send
                or.w    d1,d0
                addq.w  #2,d2

se3in:          tst.w   d0
                beq.s   no_inst2

                move.w  d0,d1
                subq.w  #1,d1
                add.w   d1,d1
                add.w   d1,d1
                lea     instlist,a0
                lea     0(a0,d1.w),a0
                tst.l   (a0)
                ble     pend
testliste2:     cmpa.l  #instlist,a0
                beq.s   no_inst2
                subq.l  #4,a0
                tst.l   (a0)
                bmi     send
                bra.s   testliste2


no_inst2:       move.w  cy(pc),d1
                subq.w  #2,d1
                mulu    #12,d1
                add.w   d2,d1
                movea.l acttrack(pc),a1
                adda.w  trackoff(pc),a1
                adda.w  d1,a1
                move.b  d0,(a1)

                move.w  acttracknr(pc),d0
                bsr     showsong
                moveq   #0,d0
                bra     send



se2:            bsr     d2x
                bne     send

                move.w  d0,d1
                lsl.w   #4,d1
                bsr     waitkey
                bsr     d2x
                bne     send
                or.w    d1,d0
                addq.w  #1,d2

                move.w  cy(pc),d1
                subq.w  #2,d1
                mulu    #12,d1
                add.w   d2,d1
                movea.l acttrack(pc),a1
                adda.w  trackoff(pc),a1
                adda.w  d1,a1
                move.b  d0,(a1)

                move.w  acttracknr(pc),d0
                bsr     showsong
                moveq   #0,d0
                bra.s   send

se1:
                bsr     d2x
                bne.s   send

                move.w  d0,d1
                lsl.w   #4,d1
                bsr     waitkey
                bsr     d2x
                bne.s   send
                or.w    d1,d0

                move.w  cy(pc),d1
                subq.w  #2,d1
                mulu    #12,d1
                add.w   d2,d1
                movea.l acttrack(pc),a1
                adda.w  trackoff(pc),a1
                adda.w  d1,a1

                tst.w   d0
                beq.s   no_pat

                move.w  d0,d1
                subq.w  #1,d1
                mulu    #12,d1
                lea     patlist,a0
                lea     0(a0,d1.w),a0
                tst.l   (a0)
                ble.s   send
testliste1:     cmpa.l  #patlist,a0
                beq.s   no_pat
                lea     -12(a0),a0
                tst.l   (a0)
                bmi.s   send
                bra.s   testliste1

no_pat:         move.b  d0,(a1)
*           clr.b   1(a1)              ; transponierer

                move.w  acttracknr(pc),d0
                bsr.s   showsong
                moveq   #0,d0

send:
                movem.l (a7)+,d1-a5
                rts

taktanz:        DC.W 0
trackanz:       DC.W 0
acttracknr:     DC.W 0
acttrack:       DC.L 0
trackoff:       DC.W 0
tracksendp:     DC.L 0
tracksanfp:     DC.L 0

showsong:       move.w  #44,px
                move.w  #1,py
                bsr     phex               ; songnr

                lea     tracklist,a0
                mulu    #6,d0
                lea     0(a0,d0.w),a0

                movea.l (a0)+,a1

                move.b  (a0)+,d0
                move.w  d0,d7              ; merken fr zeitberechnung
                move.w  #56,px
                move.w  #1,py
                bsr     phex               ; speed

                move.b  (a0)+,d0
                move.w  #68,px
                move.w  #1,py
                bsr     phex               ; rept

                move.w  trackanz(pc),d0
                move.w  #76,px
                move.w  #26,py
                bsr     phex               ; songanz

                move.l  a1,acttrack
                movea.l a1,a0
                move.w  #-1,taktanz
counttakt:      tst.w   (a0)
                bmi.s   countend
                addq.w  #1,taktanz
                adda.l  #12,a0
                bra.s   counttakt
countend:
                moveq   #0,d0
                moveq   #0,d1
                moveq   #0,d2
                move.w  taktanz(pc),d0     ; fr lngenberechnung
                addq.w  #1,d0
                move.w  #0,py
                move.w  #32,px
* speed*takte*16=vbl's    vbls/50=seconds
                mulu    #16,d0
                mulu    d7,d0              ; vbls
                divu    #50,d0             ; sekunden
                move.w  d0,d2
                divu    #60,d2             ; minuten
                move.w  d2,d1
                mulu    #60,d1
                sub.w   d1,d0
; rest sekunden in d0
                exg     d0,d2
                bsr     pdez
                addq.w  #3,px
                exg     d0,d2
                bsr     pdez

                adda.w  trackoff(pc),a1
                movea.l a1,a0
                moveq   #15,d2
                move.w  #2,py
                moveq   #0,d3
                move.w  trackoff(pc),d3
                divu    #12,d3

ss1:            tst.w   (a0)
                bmi     ss4
                moveq   #15,d0
                sub.w   d2,d0
                add.w   d3,d0
                move.w  #28,px
                bsr     phex               ; zeilennummer

                move.w  #32,px
                moveq   #2,d1

ss2:
                moveq   #0,d0
                move.b  (a0)+,d0           ; Patnr
                bsr     phex
                addq.w  #2,px
                move.w  d0,d7
                move.b  (a0)+,d0           ; Trans
                bsr     phex
******

                move.b  (a0)+,d0
                addq.w  #2,px              ; i1
                bsr     phex
                move.b  (a0)+,d0
                addq.w  #2,px              ; i2
                bsr     phex
******
                move.w  d7,d0
                addq.w  #3,px              *
                lea     patlist,a2
                mulu    #12,d0
                lea     -12(a2,d0.w),a2
                lea     namebuf(pc),a1
                move.l  6(a2),(a1)
                move.w  10(a2),4(a1)
                tst.w   d0
                bne.s   ss3
                move.l  #'....',(a1)
                move.w  #'..',4(a1)
ss3:            clr.b   6(a1)
                bsr     printxy            ; patternnames
                addi.w  #7,px              *
                dbra    d1,ss2
                bra.s   ss5
ss4:            lea     namebuf(pc),a2
                movea.l a2,a1
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.l  #'    ',(a2)+
                move.w  #'  ',(a2)+
                move.b  #' ',(a2)+
                clr.b   (a2)
                move.w  #28,px
                bsr     printxy
ss5:            addq.w  #1,py
                dbra    d2,ss1

                rts

                ENDPART

                PART 'pat'
delpat:         cmpi.w  #1,patanz
                beq     pend

                bsr     ruhe

                subq.w  #1,patanz
                move.w  actpatnr(pc),d0
                subq.w  #1,d0
                move.w  d0,actpatnr
                mulu    #12,d0
                lea     patlist,a0
                lea     0(a0,d0.w),a0
                movea.l (a0),a1
                clr.l   (a0)
                tst.l   12(a0)
                bpl.s   dp0
                move.l  #-1,(a0)
dp0:
                move.w  4(a0),d0
                mulu    #64,d0
                move.l  d0,d7
                movea.l a1,a0
                move.l  a1,d1
                adda.w  d0,a1
                cmpa.l  patendp(pc),a1
                beq.s   dp3

dp1:            move.l  (a1)+,(a0)+
                cmpa.l  patendp(pc),a1
                bne.s   dp1
dp3:            sub.l   d7,patendp

                lea     patlist-12,a0
dp2:            lea     12(a0),a0
                tst.l   (a0)
                bmi.s   dp4
                beq.s   dp2
                cmp.l   (a0),d1
                bgt.s   dp2
                sub.l   d7,(a0)
                bra.s   dp2
dp4:
                move.w  actpatnr(pc),d0
                bsr     showpat
                bra     pend





taktdown:
                move.w  #2,cy

                movea.l actpatp(pc),a0
                move.w  4(a0),d0
                lsl.w   #6,d0
                move.w  patoff(pc),d1
                add.w   #64,d1
                cmp.w   d1,d0
                beq     pend
                move.w  d1,patoff
                move.w  actpatnr(pc),d0
                bsr     showpat
                bra     pend

taktup:
                tst.w   patoff
                beq     pend
                subi.w  #64,patoff
                move.w  actpatnr(pc),d0
                bsr     showpat
                bra     pend
********************************************************************************
newpat:         addq.w  #1,patanz
                lea     patlist-12,a0
                moveq   #0,d0
newpat1:        addq.w  #1,d0
                lea     12(a0),a0
                tst.l   (a0)
                bgt.s   newpat1
                beq.s   newpat2
                move.l  #-1,12(a0)
newpat2:        move.w  d0,actpatnr
                move.w  #1,4(a0)
                move.l  #'Empt',6(a0)
                move.w  #'y ',10(a0)

                move.l  patendp(pc),(a0)
                movea.l (a0),a0
                moveq   #64/4-1,d1
                clr.l   (a0)+
                dbra    d1,*-4
                move.l  a0,patendp

                clr.w   patoff
                move.w  actpatnr(pc),d0
                bsr     showpat
                bra     pend
********************************************************************************
taktins:        move.w  #2,cy

                movea.l actpatp(pc),a0
                addq.w  #1,4(a0)

                movea.l actpat(pc),a2
                addi.w  #64,patoff
                adda.w  patoff(pc),a2

                movea.l patendp(pc),a0

                movea.l a0,a1
                lea     64(a1),a0
                move.l  a0,patendp

                cmpa.l  a1,a2
                beq.s   ansende

                lea     patlist-12,a3
ti0:            lea     12(a3),a3
                move.l  (a3),d0
                bmi.s   ti1
                beq.s   ti0
                cmp.l   a2,d0
                blt.s   ti0
                addi.l  #64,(a3)
                bra.s   ti0

ti1:            move.l  -(a1),-(a0)
                cmpa.l  a2,a1
                bne.s   *-6

ansende:        moveq   #64/4-1,d0
                clr.l   (a2)+
                dbra    d0,*-4

                move.w  actpatnr(pc),d0
                bsr     showpat
                bra     pend
********************************************************************************

taktdel:        movea.l actpatp(pc),a0
                cmpi.w  #1,4(a0)
                beq     pend

                bsr     ruhe

                subq.w  #1,4(a0)

                movea.l actpat(pc),a2
                adda.w  patoff(pc),a2

                subi.w  #64,patoff
                bpl.s   td3
                clr.w   patoff
td3:
                movea.l a2,a1
                lea     64(a2),a0

td1:            move.l  (a0)+,(a1)+
                cmpa.l  patendp(pc),a1
                bne.s   td1
                subi.l  #64,patendp

                lea     patlist-12,a3
td0:            lea     12(a3),a3
                move.l  (a3),d0
                bmi.s   td2
                beq.s   td0
                cmp.l   a2,d0
                ble.s   td0
                subi.l  #64,(a3)
                bra.s   td0
td2:

                move.w  actpatnr(pc),d0
                bsr     showpat
                bra     pend


nextpat:        move.w  actpatnr(pc),d0
                lea     patlist,a0
                cmp.w   patanz(pc),d0
                beq     pend
nextpat1:       cmp.w   patanz(pc),d0
                bgt     pend
                addq.w  #1,d0
                move.w  d0,d1
                mulu    #12,d1
                tst.l   -12(a0,d1.w)
                beq.s   nextpat1
                clr.w   patoff
                move.w  d0,actpatnr
                bsr     showpat
                bra     pend


prevpat:        move.w  actpatnr(pc),d0
                lea     patlist,a0
                cmp.w   #1,d0
                beq     pend
prevpat1:       cmp.w   #1,d0
                blt     pend
                subq.w  #1,d0
                move.w  d0,d1
                mulu    #12,d1
                tst.l   -12(a0,d1.w)
                beq.s   prevpat1
                clr.w   patoff

                move.w  d0,actpatnr
                bsr     showpat
                bra     pend

patedit:
                movem.l d1-a5,-(a7)

                tst.w   ctrl
                beq.s   pe0
                cmp.w   #$0048,d0
                beq     taktup
                cmp.w   #$0050,d0
                beq     taktdown
                cmp.w   #$0052,d0
                beq     taktins
                cmp.w   #$0053,d0
                beq     taktdel

pe0:
                cmpi.l  #$00060001,cx
                bne.s   pe9
                cmp.w   #$0052,d0
                beq     newpat
                cmp.w   #$0053,d0
                beq     delpat

pe9:
                cmp.w   #$001C,d0
                bne.s   pe7
oktin:          cmpi.w  #17,cy
                bne.s   pe8
                move.w  #4,cx
                bra     taktdown
pe8:
                move.w  #4,cx
                addq.w  #1,cy
                bra     pend
pe7:


                swap    d0
                cmp.w   #'+',d0
                beq     nextpat
                cmp.w   #'-',d0
                beq     prevpat

                lea     patcon(pc),a0
                movem.w cx(pc),d1-d2
pe1:
                tst.w   (a0)
                bmi     pend
                cmp.w   2(a0),d2
                bne.s   pe2
                cmp.w   (a0),d1
                beq.s   pe3
pe2:            addq.w  #6,a0
                bra.s   pe1
pe3:            movem.w d1-d2,px

                cmpi.l  #$000A0001,cx
                bne.s   ped
                move.l  #$000A0001,px
                move.l  d0,key
                moveq   #6,d2
                bsr     input
                movea.l actpatp(pc),a0
                move.l  namebuf(pc),6(a0)
                move.w  namebuf+4(pc),10(a0)
                move.w  actpatnr(pc),d0
                bsr     showpat
                bra     pend

ped:
                cmpi.w  #4,cx
                bne.s   pe4


                bsr     d2x
                bne     pend

                move.w  d0,d1
                lsl.w   #4,d1
                bsr     waitkey
                bsr     d2x
                bne     pend
                or.w    d1,d0
                movea.l actpat(pc),a1
                adda.w  patoff(pc),a1
                adda.w  4(a0),a1


                tst.w   d0
                beq.s   no_inst

                move.w  d0,d1
                subq.w  #1,d1
                add.w   d1,d1
                add.w   d1,d1
                lea     instlist,a0
                lea     0(a0,d1.w),a0
                tst.l   (a0)
                ble     pend
testliste:      cmpa.l  #instlist,a0
                beq.s   no_inst
                subq.l  #4,a0
                tst.l   (a0)
                bmi     pend
                bra.s   testliste


no_inst:        move.b  d0,(a1)

                moveq   #0,d0
                addi.w  #14,cx
                move.w  actpatnr(pc),d0
                bsr     showpat
                bra     pend

pe4:
                cmpi.w  #18,cx
                bne.s   pe5
                lea     noteint(pc),a2
                moveq   #11,d1

search1:        cmp.b   -(a2),d0
                dbeq    d1,search1
                bne     pend

                movea.l actpat(pc),a1
                adda.w  patoff(pc),a1
                adda.w  4(a0),a1

                moveq   #0,d0
                move.b  (a1),d0
                divu    #12,d0
                mulu    #12,d0
                add.w   d0,d1

                move.b  d1,(a1)

                addq.w  #2,cx
                move.w  actpatnr(pc),d0
                bsr     showpat
                bra     pend
pe5:
                cmpi.w  #20,cx
                bne.s   pe6

                sub.b   #'0',d0
                bmi.s   pend
                cmp.b   #8,d0
                bgt.s   pend

                movea.l actpat(pc),a1
                adda.w  patoff(pc),a1
                adda.w  4(a0),a1
                moveq   #0,d1
                move.b  (a1),d1
                divu    #12,d1
                swap    d1
                mulu    #12,d0
                add.w   d1,d0
                move.b  d0,(a1)
                move.w  actpatnr(pc),d0
                bsr     showpat
                bra     oktin
pe6:
                cmpi.w  #22,cx
                beq.s   porta1
                cmpi.w  #24,cx
                bne.s   pend
porta1:

                bsr     d2x
                bne.s   pend

                move.w  d0,d1
                lsl.w   #4,d1
                bsr     waitkey
                bsr     d2x
                bne.s   pend
                or.w    d1,d0
                movea.l actpat(pc),a1
                adda.w  patoff(pc),a1
                adda.w  4(a0),a1

                move.b  d0,(a1)

                move.w  actpatnr(pc),d0
                bsr     showpat
                moveq   #0,d0
pend:
                movem.l (a7)+,d1-a5

                rts

                DC.B 'cCdDefFgGaAh'
noteint:
                EVEN

patcon:
z               SET 0
                REPT 16
                DC.W 4,2+z,z*4          ; 4=6
                DC.W 18,2+z,1+z*4
                DC.W 20,2+z,1+z*4
                DC.W 22,2+z,2+z*4
                DC.W 24,2+z,3+z*4
z               SET z+1
                ENDR
                DC.W 10,1,0
                DC.W -1

actpatp:        DC.L 0
actpat:         DC.L 0
actpatnr:       DC.W 1
patoff:         DC.W 0
patanz:         DC.W 0
patanfp:        DC.L 0
patendp:        DC.L 0



ruhe:           clr.l   mvblp
                moveq   #0,d0
                bra     selectsong

startsong:
                clr.l   mvblp
                move.l  #tracklist,songp
                move.w  acttracknr(pc),d0
                moveq   #0,d1
                move.w  d0,d1
                mulu    #6,d1
*                BREAKPT 'l'
                lea     tracklist,a0
                moveq   #0,d2
                move.w  trackoff(pc),d2
                add.l   d2,0(a0,d1.w)
                addq.w  #1,d0
                bsr     selectsong
                sub.l   d2,0(a0,d1.w)
                move.l  #playit,mvblp
                rts

createtest:
                movem.l d0-a5,-(a7)
                movea.l actpatp(pc),a0
                move.w  actpatnr(pc),d1

                move.w  4(a0),d0           ; lnge in takten

                move.w  acttracknr(pc),d2
                mulu    #6,d2
                lea     tracklist,a1
                move.b  4(a1,d2.w),d2

                movea.l testsong(pc),a1
                move.b  d2,4+testsong

                movea.l a1,a2

                clr.l   mvblp

ct0:
                clr.l   (a1)+
                clr.l   (a1)+
                clr.l   (a1)+
                subq.w  #1,d0
                bne.s   ct0
                move.l  #-1,(a1)+
                move.b  d1,8(a2)
                clr.b   9(a2)

                move.l  #testsong,songp
                moveq   #1,d0
                bsr     selectsong


*msd:            bsr     playit
*               bra     msd


                move.l  #playit,mvblp

                movem.l (a7)+,d0-a5
                rts

showpat:

                move.w  #6,px
                move.w  #1,py
                bsr     phex               ; patternnummer

                move.w  d0,d1

                subq.w  #1,d0
                lea     patlist,a0
                mulu    #12,d0
                lea     0(a0,d0.w),a0
                move.l  a0,actpatp
                move.l  (a0),actpat
                lea     namebuf(pc),a1

                move.l  6(a0),(a1)
                move.w  10(a0),4(a1)
                clr.b   6(a1)
                move.w  #10,px
                move.w  #1,py
                bsr     printxy            ; patternname

                move.w  #24,px
                move.w  4(a0),d0
                bsr     phex

                moveq   #15,d2
                movea.l actpat(pc),a2
                adda.w  patoff(pc),a2

sp0:
                addq.w  #1,py
                move.w  #0,px
                moveq   #15,d0
                sub.w   d2,d0
                move.w  patoff(pc),d1
                lsr.w   #2,d1
                add.w   d1,d0
                bsr     phex               ; zeilennummmer

                addq.w  #4,px
                moveq   #0,d0
                move.b  (a2),d0
                bsr     phex

                addq.w  #4,px
                lea     namebuf(pc),a1
                subq.w  #1,d0
                bpl.s   sp1
                move.l  #'----',(a1)
                move.l  #'----',4(a1)
                bra.s   sp2
sp1:            add.w   d0,d0
                add.w   d0,d0
                lea     instlist,a0
                movea.l 0(a0,d0.w),a0
                move.l  (a0),(a1)
                move.l  4(a0),4(a1)
sp2:            move.w  #'  ',8(a1)
                moveq   #0,d0
                move.b  1(a2),d0
                add.w   d0,d0
                add.w   d0,d0
                move.l  notetab(pc,d0.w),10(a1)

*                move.b  2(a2),d0
*               add.w   #'0',d0

*              move.b  d0,12(a1)
*                clr.b   13(a1)

                bsr     printxy

                addi.w  #14,px
                moveq   #0,d0
                move.b  2(a2),d0           ; portawert 1
                bsr     phex

                addq.w  #2,px
                moveq   #0,d0
                move.b  3(a2),d0
                bsr     phex

                addq.l  #4,a2

                dbra    d2,sp0

                move.w  #65,px
                move.w  #26,py
                move.w  patanz(pc),d0
                bra     phex


notetab:
qw              SET '0'
                REPT 8
                DC.B 'c ',qw,0
                DC.B 'c#',qw,0
                DC.B 'd ',qw,0
                DC.B 'd#',qw,0
                DC.B 'e ',qw,0
                DC.B 'f ',qw,0
                DC.B 'f#',qw,0
                DC.B 'g ',qw,0
                DC.B 'g#',qw,0
                DC.B 'a ',qw,0
                DC.B 'a#',qw,0
                DC.B 'b ',qw,0
qw              SET qw+1
                ENDR

                ENDPART

showinst:       PART 'ausgabe instr'    ; in d0 nummer 1=intrument 0

                move.w  #19,py
                move.w  #6,px
                bsr     phex

                subq.w  #1,d0
                lea     instlist,a0
                add.w   d0,d0
                add.w   d0,d0
                movea.l 0(a0,d0.w),a0
                move.l  a0,actinst

                lea     namebuf(pc),a1
                move.l  (a0),(a1)
                move.l  4(a0),4(a1)
                clr.b   9(a1)

                move.w  #10,px
                bsr     printxy

                move.b  8(a0),d0
                move.w  #22,px
                bsr     phex

                lea     space(pc),a1
                tst.b   8(a0)
                beq.s   in0
                lea     dig(pc),a1
in0:            move.w  #28,px
                bsr     printxy


                lea     42(a0),a2          ; anschlagtab
                move.w  #20,py
                move.w  #10,px
                moveq   #32-1,d1
                bsr     phexline
                lea     10(a0),a2          ; rausch
                move.w  #21,py
                move.w  #10,px
                moveq   #32-1,d1
                bsr     phexline
                lea     110(a0),a2         ; mix
                move.w  #22,py
                move.w  #10,px
                moveq   #32-1,d1
                bsr     phexline
                lea     75(a0),a2          ; vibrato
                move.w  #23,py
                move.w  #6,px
                move.b  74(a0),d0
                bsr     phex
                move.w  #10,px
                moveq   #16-1,d1
                bsr     phexline
                lea     92(a0),a2          ; blubber
                move.w  #24,py
                move.w  #6,px
                move.b  91(a0),d0
                bsr     phex
                move.w  #10,px
                moveq   #16-1,d1
                bsr     phexline
                move.w  #25,py
                move.w  #6,px
                move.b  109(a0),d0
                bsr     phex
                move.w  #10,px
                move.b  108(a0),d0
                bsr     phex

                move.w  #56,px
                move.w  #26,py
                move.w  instanz(pc),d0
                bra     phex

namebuf:        DS.B 80
space:          DC.B 'PSG-Sound ',0
dig:            DC.B 'Digisample',0

                EVEN
phexline:       move.b  (a2)+,d0
                bsr     phex
                addq.w  #2,px
                dbra    d1,phexline
                rts

                ENDPART

instedit:       PART


                cmpi.w  #19,cy
                bne.s   ie0
                cmpi.w  #6,cx
                bne.s   ie0

                cmp.w   #$0052,d0
                beq     newinst
                cmp.w   #$0053,d0
                beq     delinst
                tst.w   ctrl
                beq.s   ie0
                swap    d0
                cmp.b   #'l',d0
                bne.s   ie0a
                bsr     loadinst

                tst.l   (a7)+
                bra     showall


ie0a:           cmp.b   #'s',d0
                bne.s   ie0b

                bsr     saveinst
                tst.l   (a7)+
                bra     showall


ie0b:           swap    d0
ie0:

                swap    d0

                cmp.w   #'+',d0
                beq     nextinst
                cmp.w   #'-',d0
                beq     previnst

                movem.l d1-a5,-(a7)
                lea     convert(pc),a0
                movem.w cx(pc),d1-d2
ie1:
                tst.w   (a0)
                bmi.s   iend
                cmp.w   2(a0),d2
                bne.s   ie2
                cmp.w   (a0),d1
                beq.s   ie3
ie2:            addq.w  #6,a0
                bra.s   ie1
ie3:            movem.w d1-d2,px

                cmpi.w  #'in',4(a0)
                bne.s   ie4
                move.l  #$000A0013,px
                move.l  d0,key
                moveq   #8,d2
                bsr     input
                movea.l actinst(pc),a0
                move.l  namebuf(pc),(a0)+
                move.l  namebuf+4(pc),(a0)
                bra.s   iend
ie4:
                bsr     d2x
                bne.s   iend
                move.w  d0,d1
                lsl.w   #4,d1
                bsr     waitkey
                bsr     d2x
                bne.s   iend
                or.w    d1,d0
                movea.l actinst(pc),a1
                adda.w  4(a0),a1
                move.b  d0,(a1)
                bsr     phex

                moveq   #0,d0
                addq.w  #2,cx

iend:           movem.l (a7)+,d1-a5
                rts



nextinst:       move.l  actinst(pc),d0
                lea     instlist,a0
                moveq   #0,d1
                addq.w  #1,d1
                cmp.l   (a0)+,d0
                bne.s   *-6

                tst.l   (a0)               ; Ende ?
                bpl.s   *+2
                rts

                addq.w  #1,d1
                tst.l   (a0)+
                beq.s   *-6
                move.w  d1,d0
                bra     showinst
previnst:       move.l  actinst(pc),d0
                lea     instlist,a0
                moveq   #0,d1
                moveq   #0,d2
previnst0:      addq.w  #1,d1
                cmp.l   (a0),d0
                beq.s   previnst1
                tst.l   (a0)+
                beq.s   previnst0
                move.w  d1,d2
                bra.s   previnst0
previnst1:      move.w  d2,d0
                bne.s   *+2
                rts
                bra     showinst


delinst:        cmpi.w  #1,instanz
                bgt.s   *+2
                rts
                subq.w  #1,instanz

                move.l  actinst(pc),d0
                lea     instlist,a0
                cmp.l   (a0)+,d0
                bne.s   *-4
                clr.l   -4(a0)
                tst.l   (a0)
                bpl.s   delinst1
                subq.l  #4,a0
                tst.l   (a0)
                beq.s   *-6
                move.l  #-1,4(a0)
delinst1:       movea.l instendp(pc),a0
                lea     -192(a0),a0
                move.l  a0,instendp
                cmp.l   a0,d0
                beq.s   delinst2

                lea     instlist,a2
                cmpa.l  (a2)+,a0
                bne.s   *-4
                subq.l  #4,a2
                move.l  d0,(a2)

                movea.l d0,a1
                moveq   #192/4-1,d0
                move.l  (a0)+,(a1)+
                dbra    d0,*-4

delinst2:
                lea     instlist,a0
                moveq   #0,d0
                addq.w  #1,d0
                tst.l   (a0)+
                beq.s   *-6
                bra     showinst


newinst:        addq.w  #1,instanz
                lea     instlist,a0
                moveq   #0,d0
                addq.w  #1,d0
                tst.l   (a0)+
                bgt.s   *-6
                beq.s   newinst1
                move.l  #-1,(a0)
newinst1:       subq.l  #4,a0
                move.l  instendp(pc),(a0)
                movea.l (a0),a0
                moveq   #192/4-1,d1
                clr.l   (a0)+
                dbra    d1,*-4
                move.l  a0,instendp
                lea     -192(a0),a0
                bsr.s   makeinst
                bsr     showinst
                rts
makeinst:
                move.l  #'Not ',(a0)
                move.l  #'Used',4(a0)

                st      41(a0)
                st      73(a0)
                st      11(a0)
                st      43(a0)
                st      110+31(a0)
                st      110+1(a0)
                move.b  #130,76(a0)
                move.b  #130,90(a0)
                move.b  #130,93(a0)
                move.b  #130,107(a0)
                rts


saveinst:
                pea     0.w
                pea     instk(pc)
                pea     isavetxt(pc)
                bsr     fsel
                bpl.s   *+2
                rts
                movea.l actinst(pc),a1
                move.l  #192,d0
                bsr     save

                rts


loadinst:
                pea     0.w
                pea     instk(pc)
                pea     iloadtxt(pc)
                bsr     fsel
                bpl.s   *+2
                rts
                movea.l actinst(pc),a1
                bsr     load

                rts




input:
* an x=d0 und y=d1 nach namebuf  -  d2 anzahl zeichen
                lea     namebuf(pc),a5
                move.w  d2,d0
                movea.l a5,a1
                subq.w  #1,d0
inp0a:          move.b  #' ',(a1)+
                dbra    d0,inp0a
                clr.b   (a1)

inp0:           move.l  key(pc),d0
                beq.s   inp0
                clr.l   key
                swap    d0
                cmp.b   #$1C,d0
                bne.s   inp1
                moveq   #1,d2
                bra.s   inp2
inp1:           swap    d0
                move.b  d0,(a5)+
inp2:
                lea     namebuf(pc),a1
                bsr     printxy
                subq.w  #1,d2
                bne.s   inp0
                rts



instanfp:       DC.L 0
instendp:       DC.L 0
instanz:        DC.W 0

getinstinf:     lea     instlist,a0
                move.l  (a0),d0
                move.l  (a0),d1
                moveq   #0,d2
getinst1:
                tst.l   (a0)
                beq.s   getinst2
                addq.w  #1,d2
                cmp.l   (a0),d0
                ble     *+2
                move.l  (a0),d0
                cmp.l   (a0),d1
                bge     *+2
                move.l  (a0),d1
getinst2:       addq.l  #4,a0
                tst.l   (a0)
                bpl.s   getinst1
                move.l  d0,instanfp
                add.l   #192,d1
                move.l  d1,instendp
                move.w  d2,instanz
                rts

d2x:            cmp.b   #'a',d0
                blt.s   d2x1
                sub.b   #'a'-'0'-10,d0
d2x1:           sub.b   #'0',d0
                bpl.s   *+2
                rts
                cmp.w   #15,d0
                ble.s   *+2
                rts
                ori     #4,ccr
                rts

waitkey:
                clr.l   $FFFF8244.w
                move.l  #0,ocx
wk2:            move.l  key(pc),d0
                beq.s   wk2
                clr.l   key
                move.l  #$07750004,$FFFF8244.w
                rts

convert:
********************************************************************************
                DC.W 22,19,8            ; I

z               SET 0
                REPT 32
                DC.W 10+z,20,42+z/2     ; x,y,offset auf instrument
z               SET z+2
                ENDR
z               SET 0
                REPT 32
                DC.W 10+z,21,10+z/2     ; x,y,offset auf instrument
z               SET z+2
                ENDR
z               SET 0
                REPT 32
                DC.W 10+z,22,110+z/2    ; x,y,offset auf instrument
z               SET z+2
                ENDR

                DC.W 6,23,74            ; V
z               SET 0
                REPT 16
                DC.W 10+z,23,75+z/2     ; x,y,offset auf instrument
z               SET z+2
                ENDR

                DC.W 6,24,91            ; B
z               SET 0
                REPT 16
                DC.W 10+z,24,92+z/2     ; x,y,offset auf instrument
z               SET z+2
                ENDR

                DC.W 6,25,109           ; T
                DC.W 10,25,108

                DC.W 10,19,'in'

                DC.W -1

********************************************************************************
actinst:        DC.L 0
                ENDPART

showdig:        move.w  actdignr(pc),d0
                move.w  #10,px
                move.w  #26,py
                bsr     phex
                rts

digiedit:       PART
                cmp.w   #$0053,d0
                beq.s   deldig
                swap    d0
                cmp.w   #'+',d0
                beq.s   nextdig
                cmp.w   #'-',d0
                beq.s   prevdig
                tst.w   ctrl
                bne.s   *+2
                rts

                cmp.w   #'l',d0
                beq     digload
                cmp.w   #'s',d0
                beq     digsave
                rts

nextdig:        move.w  actdignr(pc),d0
                cmp.w   #50,d0
                bne.s   *+2
                rts
                addq.w  #1,d0
                move.w  d0,actdignr
                rts
prevdig:        move.w  actdignr(pc),d0
                cmp.w   #1,d0
                bgt.s   *+2
                rts
                subq.w  #1,d0
                move.w  d0,actdignr
                rts

                IF 1=0
qwe:            addq.w  #1,diganz
                move.w  diganz(pc),d0
                move.w  d0,actdignr
                subq.w  #1,d0
                add.w   d0,d0
                add.w   d0,d0
                add.w   d0,d0
                lea     digilist,a0
                lea     0(a0,d0.w),a0
                clr.l   (a0)+
                clr.l   (a0)+
                move.l  #-1,(a0)+
                rts
                ENDC


deldig:         tst.w   diganz
                beq.s   no_del

                move.w  actdignr(pc),d0
                subq.w  #1,d0
                add.w   d0,d0
                add.w   d0,d0
                add.w   d0,d0
                lea     digilist,a0
                lea     0(a0,d0.w),a0
                move.l  (a0),d2            ; Adresse
                beq.s   no_del
                move.l  4(a0),d0
                sub.l   d0,digendp

                clr.l   (a0)+
                clr.l   (a0)+
                lea     digilist,a0
dd3:            tst.l   (a0)
                bmi.s   dd2
                cmp.l   (a0),d2
                bgt.s   *+2
                sub.l   d0,(a0)
                addq.w  #8,a0
                bra.s   dd3
dd2:            movea.l d2,a0
                movea.l a0,a1
                adda.l  d0,a1
                bra.s   dd6
dd5:            move.b  (a1)+,(a0)+
dd6:            cmpa.l  digendp(pc),a0
                bne.s   dd5

                subq.w  #1,diganz
no_del:         rts

digload:
                bsr     ruhe
*                pea     0.w
*               pea     0.w
*                pea     0.w
                pea     digp(pc)
                pea     digk(pc)
                pea     digloadtxt(pc)
                bsr     fsel
                bmi.s   no_digload
                move.l  a0,-(a7)
                bsr.s   deldig             ; sample vorher lschen
                movea.l (a7)+,a0

                move.w  actdignr(pc),d0
                subq.w  #1,d0
                add.w   d0,d0
                add.w   d0,d0
                add.w   d0,d0
                lea     digilist,a2
                lea     0(a2,d0.w),a2
                move.l  digendp(pc),(a2)
                movea.l (a2),a1
                move.l  a2,-(a7)
                bsr     load
                movea.l (a7)+,a2
                movea.l (a2),a0

teste:          subq.l  #1,d7
                ble.s   durch
                tst.b   (a0)+
                bpl.s   teste
                move.b  -2(a0),d1
                or.b    #$80,d1
                subq.l  #1,a0
durch:          move.w  #200,d0
                move.b  d1,(a0)+
                dbra    d0,*-4
                move.l  a0,d7
                sub.l   (a2),d7
                move.l  d7,4(a2)
                add.l   d7,digendp

                addq.w  #1,diganz

no_digload:     tst.l   (a7)+
                bra     showall
digsave:

                bsr     ruhe

                pea     digp(pc)
                pea     digk(pc)
                pea     digsavetxt(pc)
                bsr     fsel
                bpl.s   *+2
                rts

                move.w  actdignr(pc),d0
                add.w   d0,d0
                add.w   d0,d0
                add.w   d0,d0
                lea     digilist,a1
                move.l  4(a1),d0
                movea.l (a1),a1
                bsr     save
                tst.l   (a7)+
                bra     showall
********************************************************************************
actdigp:        DC.L 0
actdignr:       DC.W 1
diganz:         DC.W 0
diganfp:        DC.L 0
digendp:        DC.L 0

                ENDPART

                PART 'new'
********************************************************************************
new:            lea     tracklist,a0
                move.l  #trackmem,(a0)+
                move.b  #5,(a0)+
                move.b  #0,(a0)+
                move.l  #-1,(a0)+

                lea     trackmem,a0
                move.l  a0,tracksanfp
                clr.l   (a0)+
                clr.l   (a0)+
                clr.l   (a0)+
                move.l  #-1,(a0)+
                move.l  a0,tracksendp

                move.w  #1,trackanz
                move.w  #0,taktanz
                clr.w   acttracknr
                clr.w   trackoff

                lea     patlist,a0
                move.l  #patmem,(a0)+
                move.w  #1,(a0)+
                move.l  #'Empt',(a0)+
                move.w  #'y ',(a0)+
                move.l  #-1,(a0)+

                lea     patmem,a0
                moveq   #64/4-1,d0
                clr.l   (a0)+
                dbra    d0,*-4

                move.l  #patmem,patanfp
                move.l  #patmem+64,patendp
                move.w  #1,patanz
                move.w  #1,actpatnr
                clr.w   patoff

                lea     instlist,a0
                move.l  #instmem,(a0)+
                move.l  #-1,(a0)+

                lea     instmem,a0
                move.l  a0,instanfp
                move.l  a0,actinst
                moveq   #192/4-1,d0
                clr.l   (a0)+
                dbra    d0,*-4
                move.l  a0,instendp
                lea     instmem,a0
                bsr     makeinst
                move.w  #1,instanz

                clr.w   diganz
                move.w  #1,actdignr
                lea     digimem,a0
                move.l  a0,diganfp
                move.l  a0,digendp
                lea     digilist,a0
                moveq   #49,d0
                clr.l   (a0)+
                clr.l   (a0)+
                dbra    d0,*-6
                move.l  #-1,(a0)
                rts

*                bra     getinstinf


                ENDPART

testsong:       DC.L tsong
                DC.B 5,0
                DC.L -1

                PART 'packer'
musicmem:       DC.L 0

packer:         move.l  #mend-music,musicmem
                move.w  #-1,reloflag

                lea     mem(pc),a0
********************************************************************************
                adda.l  musicmem,a0
********************************************************************************

                move.l  musicmem(pc),patbegin

                movea.l patanfp(pc),a1

pa1:            move.l  (a1)+,(a0)+
                cmpa.l  patendp(pc),a1
                bne.s   pa1


                lea     patlist,a1


pa2:            move.l  (a1)+,d0
                beq.s   pa2a
                bmi.s   pa3
                sub.l   patanfp(pc),d0
                add.l   musicmem(pc),d0
pa2a:           move.l  d0,(a0)+
                move.l  (a1)+,(a0)+
                move.l  (a1)+,(a0)+
                bra.s   pa2
pa3:            move.l  d0,(a0)+

                move.l  patendp(pc),d2
                sub.l   patanfp(pc),d2
                add.l   d2,musicmem

                move.l  musicmem(pc),patternp

                suba.l  #patlist,a1
                move.l  a1,d0
                add.l   d0,musicmem


                move.l  musicmem(pc),instbegin

                movea.l instanfp(pc),a1
pa5:            move.l  (a1)+,(a0)+
                cmpa.l  instendp(pc),a1
                bne.s   pa5

                lea     instlist,a1

pa6:            move.l  (a1)+,d0
                beq.s   pa6a
                bmi.s   pa8
                sub.l   instanfp(pc),d0
                add.l   musicmem(pc),d0
pa6a:           move.l  d0,(a0)+
                bra.s   pa6
pa8:            move.l  d0,(a0)+

                move.l  instendp(pc),d2
                sub.l   instanfp(pc),d2
                add.l   d2,musicmem

                move.l  musicmem(pc),instrp
                suba.l  #instlist,a1
                move.l  a1,d0
                add.l   d0,musicmem


                movea.l tracksanfp(pc),a1
                move.l  musicmem(pc),songbegin

pa9:            move.w  (a1)+,(a0)+
                cmpa.l  tracksendp(pc),a1
                bne.s   pa9

                lea     tracklist,a1

pa10:           move.l  (a1)+,d0
                beq.s   pa10a
                bmi.s   pa11
                sub.l   tracksanfp(pc),d0
                add.l   musicmem(pc),d0
pa10a:          move.l  d0,(a0)+
                move.w  (a1)+,(a0)+
                bra.s   pa10
pa11:           move.l  d0,(a0)+

                move.l  tracksendp(pc),d2
                sub.l   tracksanfp(pc),d2
                add.l   d2,musicmem

                move.l  musicmem(pc),songp
                suba.l  #tracklist,a1
                move.l  a1,d0
                add.l   d0,musicmem


                move.l  musicmem(pc),digibegin

                movea.l diganfp(pc),a1
                bra.s   pab1
pab:            move.w  (a1)+,(a0)+
pab1:           cmpa.l  digendp(pc),a1
                blt.s   pab
                suba.l  diganfp,a1
                move.l  a1,d2

                lea     digilist,a1

pac:            move.l  (a1)+,d0
                bmi.s   pad
                beq.s   pac1
                sub.l   diganfp(pc),d0
                add.l   musicmem(pc),d0
pac1:           move.l  d0,(a0)+
                move.l  (a1)+,(a0)+
                bra.s   pac
pad:            move.l  d0,(a0)+

                add.l   d2,musicmem

                move.l  musicmem(pc),digidrums
                suba.l  #digilist,a1
                move.l  a1,d0
                add.l   d0,musicmem

********************************************************************************
                lea     music(pc),a1
                lea     mem(pc),a0
xx:             move.w  (a1)+,(a0)+
                cmpa.l  #mend,a1
                bne.s   xx

                pea     pt(pc)
                pea     musicmask(pc)
                pea     savetitel(pc)

                bsr     fsel
                bpl.s   save_music
                rts

save_music:     lea     mem(pc),a1
                move.l  musicmem(pc),d0
                bsr     save
                rts
********************************************************************************
repack:         pea     pt(pc)
                pea     musicmask(pc)
                pea     loadtitel(pc)
                bsr     fsel
                bpl.s   load_music
                rts
load_music:     lea     mem(pc),a1
                bsr     load
                lea     mem(pc),a0
                move.l  patp+4(a0),d0
                sub.l   patp(a0),d0
                adda.l  patp(a0),a0        ;patbegin

                lea     patmem,a1
                move.l  a1,patanfp

rpa1:           move.w  (a0)+,(a1)+
                subq.w  #2,d0
                bne.s   rpa1
                move.l  a1,patendp

                lea     mem(pc),a0
                move.l  instp(a0),d0
                sub.l   patp+4(a0),d0
                adda.l  patp+4(a0),a0      ;patbegin
                lea     patlist,a1

                move.w  #1,actpatnr
                clr.w   patoff
                clr.w   patanz
rpa2:           move.l  (a0)+,d0
                beq.s   rpa2a
                cmp.l   #-1,d0
                beq.s   rpa3
                addq.w  #1,patanz
                sub.l   mem+patp(pc),d0
                add.l   #patmem,d0
rpa2a:          move.l  d0,(a1)+
                move.l  (a0)+,(a1)+
                move.l  (a0)+,(a1)+
                bra.s   rpa2
rpa3:           move.l  d0,(a1)+
********************************************************************************
                lea     mem(pc),a0
                move.l  instp+4(a0),d0
                sub.l   instp(a0),d0
                adda.l  instp(a0),a0       ;instbegin

                lea     instmem,a1
                move.l  a1,instanfp

rpaa3:          move.w  (a0)+,(a1)+
                subq.w  #2,d0
                bne.s   rpaa3
                move.l  a1,instendp

                lea     mem(pc),a0
                move.l  sngp(a0),d0
                sub.l   instp+4(a0),d0
                adda.l  instp+4(a0),a0
                lea     instlist,a1
                clr.w   instanz


rpa4:           move.l  (a0)+,d0
                beq.s   rpa4a
                cmp.l   #-1,d0
                beq.s   rpa5
                addq.w  #1,instanz
                sub.l   mem+instp(pc),d0
                add.l   #instmem,d0
rpa4a:          move.l  d0,(a1)+
                bra.s   rpa4
rpa5:           move.l  d0,(a1)+

                move.l  #instmem,actinst   ; aufs erste stellen

********************************************************************************
                lea     mem(pc),a0
                move.l  sngp+4(a0),d0
                sub.l   sngp(a0),d0
                adda.l  sngp(a0),a0        ;trackbegin

                lea     trackmem,a1

                move.l  a1,tracksanfp
rpa6:           move.w  (a0)+,(a1)+
                subq.w  #2,d0
                bne.s   rpa6
                move.l  a1,tracksendp

                lea     mem(pc),a0
                adda.l  sngp+4(a0),a0
                lea     tracklist,a1
                clr.w   trackanz
                move.w  #0,taktanz
                clr.w   acttracknr
                clr.w   trackoff


rpa7:           move.l  (a0)+,d0
                beq.s   rpa7a
                cmp.l   #-1,d0
                beq.s   rpa8
                addq.w  #1,trackanz
                sub.l   mem+sngp(pc),d0
                add.l   #trackmem,d0
rpa7a:          move.l  d0,(a1)+
                move.w  (a0)+,(a1)+
                bra.s   rpa7
rpa8:           move.l  d0,(a1)+
                lea     tracklist,a0
                movea.l (a0),a0
y0:             tst.w   6(a0)
                bmi.s   y1
                addq.w  #1,taktanz
                addq.l  #6,a0
                bra.s   y0
y1:
********************************************************************************
                lea     mem(pc),a0
                move.l  digip+4(a0),d0
                sub.l   digip(a0),d0
                adda.l  digip(a0),a0       ;digibegin

                lea     digimem,a1
                move.l  a1,diganfp

                tst.l   d0
                beq.s   no_dig1
rpaa9:          move.w  (a0)+,(a1)+
                subq.w  #2,d0
                bne.s   rpaa9
no_dig1:        move.l  a1,digendp

                lea     mem(pc),a0
                move.l  digip+8(a0),d0
                sub.l   digip+4(a0),d0
                adda.l  digip+4(a0),a0
                lea     digilist,a1
                clr.w   diganz

rpaa:           move.l  (a0)+,d0
                beq.s   rpaa1
                cmp.l   #-1,d0
                beq.s   rpab
                sub.l   mem+digip(pc),d0
                add.l   #digimem,d0
                addq.w  #1,diganz
rpaa1:          move.l  d0,(a1)+
                move.l  (a0)+,(a1)+

                bra.s   rpaa
rpab:           move.l  d0,(a1)+
                move.w  #1,actdignr

*                bsr     getinstinf
                rts

load:

*********************************
* in a0 adresse des filenames,0 *
* in a1 loadadress              *
*********************************

                clr.w   -(a7)
                pea     (a0)
                move.w  #$003D,-(a7)
                trap    #1
                addq.w  #6,a7
                pea     (a1)
                pea     $000A0000
                move.w  d0,-(a7)
                move.w  #$003F,-(a7)
                trap    #1
                adda.w  #12,a7
                move.l  d0,d7              ; geladene lnge
                move.w  #$003E,-(a7)
                trap    #1
                addq.w  #4,a7
                rts

save:

*************************
* in a0 filename,0      *
* in a1 saveadress      *
* in d0 laenge          *
*************************

                move.l  d0,d7
                move.w  #0,-(a7)           ; f_attribut
                pea     (a0)
                move.w  #$003C,-(a7)
                trap    #1
                addq.w  #8,a7
                pea     (a1)
                move.l  d7,-(a7)
                move.w  d0,-(a7)
                move.w  #$0040,-(a7)
                trap    #1
                addq.w  #2,a7
                move.w  #$003E,-(a7)
                trap    #1
                adda.w  #12,a7
                rts
                ENDPART



                EVEN
********************************************************************************
fsel:           PART 'fsel'
fsel1           REG d0-d6/a2-a4
fsel2           EQU 32

                bsr     fsel42
                bsr.s   fsel3
                move.l  (a7)+,(a7)
                move.l  (a7)+,(a7)
                move.l  (a7)+,(a7)
                bra     fsel41

fsel3:          moveq   #0,d0
                move.b  fsel145(pc),d0
                sub.b   #'A',d0
                move.w  d0,-(a7)
                move.w  #$000E,-(a7)       ; Drive setzen
                trap    #1
                addq.l  #4,a7

*                clr.w   -(a7)              ; Free-Disk-Space
*               pea     fsel113(pc)
**              move.w  #$0036,-(a7)
*            trap    #1
*           addq.l  #8,a7
                move.l  fsel113+8(pc),d0
                move.l  fsel113+12(pc),d1
                mulu    d1,d0
                move.l  fsel113(pc),d1
                mulu    d1,d0

                lea     fsel150(pc),a1
                move.b  fsel145(pc),(a1)+
                move.b  fsel145+1(pc),(a1)+
                addq.w  #1,a1
                bsr     fsel106

                move.l  #32*6*160+40,d0
                lea     fsel150(pc),a1
                bsr     fsel127

fsel4:          bsr     fsel87

fsel5:          bsr     fsel72

                bsr     fsel74

                move.w  fsel143(pc),d0     ; Balken lschen
                mulu    #4*6,d0
                lea     fsel57+15*4(pc),a2
                lea     0(a2,d0.w),a2
                move.l  #$01110444,d0
                REPT 6
                move.l  d0,(a2)+
                ENDR
                ENDPART

                tst.w   fsel140
                beq.s   fsel6

                lea     fsel57+15*4(pc),a2 ; Balken auf 1. Zeile setzen
                lea     fsel58(pc),a1
                REPT 5
                move.l  (a1)+,(a2)+
                ENDR

                clr.w   fsel143
                move.l  #fsel158,fsel142

fsel6:          bsr     fsel67
                ENDPART
********************************************************************************
                cmp.b   #$3B,d0            ; Sortieren nach Name/Extension
                bne.s   fsel7
                not.w   fsel144
                movea.l fsel141(pc),a4
                bsr     fsel91
                bra.s   fsel5
********************************************************************************
fsel7:          cmp.b   #$4B,d0
                bne.s   fsel8
                PART 'aus ordner'
                bsr     fsel59
                bmi.s   fsel6
                clr.b   1(a0)
                bra     fsel4
                ENDPART
********************************************************************************
fsel8:          cmp.b   #$1C,d0            ; Select Input-Name
                bne.s   fsel9
                PART 'return 2'
                tst.w   fsel151
                beq.s   fsel6
                lea     fsel152(pc),a0
                lea     fsel153(pc),a1
                bsr     fsel62
                clr.b   (a1)
                lea     fsel153(pc),a0
                moveq   #0,d0
                rts
                ENDPART
********************************************************************************
fsel9:          cmp.b   #$61,d0            ; UNDO
                bne.s   fsel10
                moveq   #-1,d0
                rts
********************************************************************************
fsel10:         tst.w   alt                ;fsel70
                beq.s   fsel12
                PART 'Driveselect'
                swap    d0
                move.w  d0,d1
                move.l  $000004C2.w,d2
                sub.w   #'A',d1
                btst    d1,d2
                beq.s   fsel6

                cmp.b   #'B',d0
                bne.s   fsel11
                cmpi.w  #2,$000004A6.w     ; Drive B: angeschlossen ?
                blt     fsel6              ; nein
fsel11:         move.b  d0,fsel145

                bsr     fsel65
                addq.w  #1,d1
                move.w  d1,-(a7)
                pea     fsel145+2(pc)
                move.w  #$0047,-(a7)
                trap    #1
                addq.l  #8,a7
                lea     fsel145(pc),a0
                tst.b   (a0)+
                bne.s   *-4
                subq.w  #1,a0
                move.b  #'\',(a0)+
                clr.b   (a0)
                bra     fsel3
                ENDPART
********************************************************************************
fsel12:         cmp.b   #$3C,d0
                bne.s   fsel13
                move.l  fsel146(pc),d0
                move.l  fsel146+4(pc),fsel146
                move.l  d0,fsel146+4
                bra     fsel4
********************************************************************************
fsel13:         tst.w   fsel140
                beq     fsel6
********************************************************************************
                cmp.b   #$50,d0
                bne     fsel25
                PART 'down'
                movea.l fsel142(pc),a1
                cmpa.l  fsel141(pc),a1
                beq     fsel6

                lea     fsel2(a1),a1
                move.l  a1,fsel142

                addq.w  #1,fsel143
                cmpi.w  #19,fsel143
                ble     fsel23
                move.w  #19,fsel143

                lea     fsel156,a0
                lea     fsel156+6*20,a5

                moveq   #18,d7
fsel122         SET 0
fsel15:
                REPT 3
                movem.l (a5)+,fsel1
                movem.l fsel1,fsel122(a0)
fsel122         SET fsel122+40
                ENDR
                lea     6*20(a0),a0
                dbra    d7,fsel15

                lea     -6*20(a5),a0
                bsr     fsel130

                lea     fsel156+19*6*20,a1

                moveq   #5,d1
fsel17:
                bsr     fsel65

                movea.l fsel134(pc),a0
                lea     16*160+40(a0),a0

                moveq   #120-2,d0
fsel122         SET 0
fsel19:         REPT 10
                move.w  160+fsel122(a0),fsel122(a0)
fsel122         SET fsel122+8
                ENDR
                lea     160(a0),a0
                dbra    d0,fsel19
fsel122         SET 0
                REPT 10
                move.w  (a1)+,fsel122(a0)
fsel122         SET fsel122+8
                ENDR

                dbra    d1,fsel17

                bsr     fsel74

                bra     fsel6

fsel23:         move.w  fsel143(pc),d0
                subq.w  #1,d0
                mulu    #4*6,d0
                lea     fsel57+15*4(pc),a0
                lea     0(a0,d0.w),a0
                moveq   #5,d1
fsel24:         movea.l a0,a2
                bsr     fsel65
                lea     fsel58(pc),a1
                move.l  #$01110444,(a2)+
                REPT 5
                move.l  (a1)+,(a2)+
                ENDR
                addq.l  #4,a0
                dbra    d1,fsel24
                bra     fsel6
                ENDPART
********************************************************************************
fsel25:         cmp.b   #$48,d0
                bne     fsel37
                PART 'up'
********************************************************************************
                movea.l fsel142(pc),a1
                cmpa.l  #fsel158,a1
                beq     fsel6

                lea     -fsel2(a1),a1
                move.l  a1,fsel142

                subq.w  #1,fsel143
                bge     fsel35
                clr.w   fsel143

                lea     fsel156+6*19*20,a0
                lea     fsel156+6*20*20,a5

                moveq   #18,d7
fsel122         SET 0
fsel27:
                REPT 3
fsel122         SET fsel122-40
                movem.l fsel122(a0),fsel1
                movem.l fsel1,-(a5)
                ENDR
                lea     -6*20(a0),a0
                dbra    d7,fsel27

                bsr     fsel130

                lea     fsel156+6*20,a1

                moveq   #5,d1
fsel29:
                bsr     fsel65

                movea.l fsel134(pc),a0
*      lea     16*160+112+20*6*160(a0),a0
                lea     $54D0(a0),a0

                moveq   #120-2,d0
fsel122         SET 0
fsel31:         REPT 10
                move.w  -160+fsel122(a0),fsel122(a0)
fsel122         SET fsel122-8
                ENDR
                lea     -160(a0),a0
                dbra    d0,fsel31
fsel122         SET 0
                REPT 10
                move.w  -(a1),fsel122(a0)
fsel122         SET fsel122-8
                ENDR

                dbra    d1,fsel29


                bsr     fsel74

                bra     fsel6
fsel35:         move.w  fsel143(pc),d0
                addq.w  #1,d0
                mulu    #4*6,d0
                lea     fsel57+15*4(pc),a0
                lea     -4(a0,d0.w),a0
                moveq   #5,d1
fsel36:         movea.l a0,a2
                bsr     fsel65
                lea     fsel58(pc),a1
                REPT 5
                move.l  (a1)+,(a2)+
                ENDR
                move.l  #$01110444,(a2)+
                subq.l  #4,a0
                dbra    d1,fsel36
                bra     fsel6

                ENDPART
********************************************************************************
fsel37:         cmp.b   #$4D,d0
                bne.s   fsel39
                PART 'in ordner'

                movea.l fsel142(pc),a0
                cmpi.b  #'',(a0)+
                bne     fsel6
                lea     fsel145(pc),a1
fsel38:         tst.b   (a1)+
                bne.s   fsel38
                subq.l  #1,a1

                bsr     fsel62
                move.b  #'\',(a1)+
                clr.b   (a1)
                bra     fsel4
                ENDPART
********************************************************************************w6:
fsel39:         cmp.b   #$1C,d0            ; Select Balken
                bra.s   fsel40
                PART 'return'
                movea.l fsel142(pc),a0
                cmpi.b  #'',(a0)+
                beq     fsel6
                lea     fsel153(pc),a1
                bsr     fsel62
                clr.b   (a1)
                lea     fsel153(pc),a0
                moveq   #0,d0
                rts
                ENDPART
********************************************************************************
fsel40:         swap    d0
                cmp.b   #' ',d0
                beq     fsel6
                bra     fsel115
********************************************************************************
                PART 'init'
********************************************************************************
fsel41:         bsr     fsel65
                move    #$2700,sr
                lea     fsel155,a1
                move.l  (a1)+,$FFFF8240.w
                move.l  (a1)+,$FFFF8244.w
                move.l  (a1)+,$00000070.w
                move.l  (a1)+,$00000120.w
                lea     $FFFFFA07.w,a2
                move.l  (a1)+,d1
                movep.l d1,0(a2)
                move.l  (a1)+,d1
                movep.l d1,8(a2)
                move.l  (a1)+,d1
                movep.l d1,16(a2)
                move    (a1)+,sr
                clr.b   $FFFFFA07.w
                stop    #$2300
                stop    #$2300
                move.b  #1,$FFFF8260.w
                stop    #$2300
                move.b  #1,$FFFF8260.w
                stop    #$2300
                tst.w   d0
                rts
********************************************************************************
fsel42:         lea     fsel155,a1
                move.l  $FFFF8240.w,(a1)+
                move.l  $FFFF8244.w,(a1)+

                move.l  $00000070.w,(a1)+
                move.l  $00000120,(a1)+
                lea     $FFFFFA07.w,a0
                movep.l 0(a0),d0
                move.l  d0,(a1)+
                movep.l 8(a0),d0
                move.l  d0,(a1)+
                movep.l 16(a0),d0
                move.l  d0,(a1)+
                move    sr,(a1)+

                clr.l   $FFFFFA06.w
                move.b  #$40,$FFFFFA09.w

                moveq   #-1,d0
                dbra    d0,*-2
fsel43:         tst.b   $FFFFFC02.w
                move.b  $FFFFFC00.w,d0
                btst    #0,d0
                bne.s   fsel43

                bclr    #3,$FFFFFA17.w
                clr.b   $FFFFFA1B.w
                move.l  #fsel50,$00000070.w
                move.l  #fsel49,$00000120.w
                move    #$2300,sr

                move.l  $00000466.w,d0
                cmp.l   $00000466.w,d0
                beq.s   *-6
*                stop    #$2300
*               stop    #$2300
                clr.b   $FFFF8260.w
*              stop    #$2300
                bsr     fsel65
                bset    #0,$FFFFFA07.w
                bset    #0,$FFFFFA13.w
                bclr    #0,$FFFFFA0F.w
                move.b  #1,$FFFFFA21.w
                move.b  #8,$FFFFFA1B.w

                move.l  $FFFF8200.w,d0
                lsl.w   #8,d0
                and.l   #$00FFFFFF,d0
                move.l  d0,fsel134

                movea.l d0,a0
                move.w  #$1F3F,d0
                clr.l   (a0)+
                dbra    d0,*-4

                bsr     fsel135            ; Konvertiertabelle fr Print erzeugen

                pea     fsel113(pc)
                move.w  #$001A,-(a7)
                trap    #1
                addq.l  #6,a7

                tst.l   8(a7)
                beq.s   fsel44
                move.l  #1*160+40,d0
                movea.l 8(a7),a1
                bsr     fsel127
fsel44:
                move.l  #fsel147,fsel146
                move.l  #fsel147,fsel146+4
                tst.l   12(a7)
                beq.s   fsel45
                move.l  12(a7),fsel146
fsel45:
                lea     fsel145(pc),a4
                tst.l   16(a7)
                bne.s   fsel46
                move.w  #$0019,-(a7)
                trap    #1
                addq.l  #2,a7
                add.b   #'A',d0
                move.b  d0,(a4)+
                move.b  #':',(a4)+

                clr.w   -(a7)
                pea     (a4)
                move.w  #$0047,-(a7)
                trap    #1
                addq.l  #8,a7
                lea     fsel145(pc),a4
                tst.b   (a4)+
                bne.s   *-4
                move.b  #'\',-1(a4)
                clr.b   (a4)
                bra.s   fsel47
fsel46:         movea.l 16(a7),a0
                move.b  (a0)+,(a4)+
                bne.s   *-4
fsel47:         move.l  #25*6*160+40,d0
                lea     fsel148(pc),a1
                bsr     fsel127

                move.w  #12,fsel151
                move.l  fsel153(pc),fsel152
                move.l  fsel153+4(pc),fsel152+4
                move.l  fsel153+8(pc),fsel152+8
                bra     fsel124
********************************************************************************
                ENDPART

                PART 'interrupts'
fsel48:         DC.L 0
fsel49:         move.l  #0,$FFFF8240.w
                move.l  a6,-(a7)
                movea.l fsel48(pc),a6
                move.l  (a6)+,fsel49+2
                move.l  a6,fsel48
                movea.l (a7)+,a6
                rte

fsel50:         addq.l  #1,$00000466.w     ; VBL-Counter
                addq.l  #1,$000004BA.w     ; TimerC-Counter


                move.l  a6,-(a7)
                movea.l fsel56(pc),a6
                move.l  (a6)+,fsel49+2
                move.l  a6,fsel48
                movea.l (a7)+,a6

                subq.w  #1,rpt
                bne.s   fsel50a
                move.w  #1,rpt
                move.l  lastkey(pc),key
fsel50a:

                rte
fsel54:         DC.W 0
fsel55:         DC.W 0


fsel56:         DC.L fsel57
fsel57:
                DS.L 5,$01110742
                DS.L 3,$01110444
                DS.L 6,$00000444
                DS.L 135-14,$01110444
                DS.L 6,$00000444
                DS.L 3,$01110444
                DS.L 10,$01110247
                DS.L 10,$01110444
                DS.L 6,$00000444
                DS.L 9,$01110444
                DS.L 5,$01110444
                DS.L 7,$01110444
                DS.L 5,$01110444
                DS.L 20,$01110444

fsel58:         DS.L 5,$02220666
                ENDPART

                PART 'subs'
fsel59:         lea     fsel145(pc),a0
fsel60:         tst.b   (a0)+
                bne.s   fsel60
                subq.l  #2,a0

fsel61:         cmpi.b  #':',-(a0)
                bne.s   *+4
                moveq   #-1,d0
                rts
                cmpi.b  #'\',(a0)
                bne.s   fsel61
                moveq   #0,d0
                rts

fsel62:         moveq   #11,d0
fsel63:         move.b  (a0)+,d1
                cmp.b   #' ',d1
                beq.s   fsel64
                move.b  d1,(a1)+
fsel64:         dbra    d0,fsel63
                rts

fsel65:
                move.l  d0,-(a7)
                move.l  $00000466.w,d0
fsel66:         cmp.l   $00000466.w,d0
                beq.s   fsel66
                move.l  (a7)+,d0
                rts

                illegal

fsel67:
                tst.l   key
                beq.s   fsel67
                moveq   #0,d0
                move.w  key(pc),d0
                clr.l   key

                move.b  fsel71(pc,d0.w),d1
                swap    d0
                move.b  d1,d0
                swap    d0
********************************************************************************
                cmp.b   #$38,d0
                bne.s   fsel68
                st      fsel70
fsel68:         cmp.b   #$0038+$0080,d0
                bne.s   fsel69
                sf      fsel70
fsel69:
                rts

fsel70:         DC.W 0

fsel71:         DC.B " 1234567890' QWERTZUIOP   ASDFGHJKL   YXCVBNM ._ "
                DC.B '  	'
                DS.B 256,' '
                EVEN

                ENDPART

fsel72:         PART 'makeblock'
                lea     fsel158,a3
                lea     fsel156,a4
                moveq   #19,d7
fsel73:         move.l  d6,d0
                movea.l a3,a1
                movea.l a4,a0
                bsr     fsel130
                lea     32(a3),a3
                lea     6*20(a4),a4
                dbra    d7,fsel73
                rts
                ENDPART

fsel74:         PART 'blockout'
                movea.l fsel134(pc),a0
                lea     16*160+40(a0),a0
                lea     fsel156,a1
                moveq   #19,d7

fsel122         SET 0
fsel76:         REPT 6
                movem.w (a1)+,fsel1
                move.w  d0,fsel122(a0)
fsel122         SET fsel122+8
                move.w  d1,fsel122(a0)
fsel122         SET fsel122+8
                move.w  d2,fsel122(a0)
fsel122         SET fsel122+8
                move.w  d3,fsel122(a0)
fsel122         SET fsel122+8
                move.w  d4,fsel122(a0)
fsel122         SET fsel122+8
                move.w  d5,fsel122(a0)
fsel122         SET fsel122+8
                move.w  d6,fsel122(a0)
fsel122         SET fsel122+8
                move.w  a2,fsel122(a0)
fsel122         SET fsel122+8
                move.w  a3,fsel122(a0)
fsel122         SET fsel122+8
                move.w  a4,fsel122(a0)
fsel122         SET fsel122+8+80
                ENDR
                lea     6*160(a0),a0
                dbra    d7,fsel76
                rts
                ENDPART

fsel87:         PART 'einlesen'

                lea     fsel158,a4
                lea     (a4),a0
                clr.w   fsel140
                move.l  #$20202020,d0

fsel88:         movea.l a0,a1
                REPT 16
                move.l  d0,(a1)+
                ENDR
                clr.b   20(a0)
                movea.l a1,a0
                cmpa.l  #fsel159,a0
                blt.s   fsel88

********************************************************************************
                pea     fsel145(pc)
                move.w  #$003B,-(a7)       ; Set Path
                trap    #1
                addq.l  #6,a7
********************************************************************************
                lea     fsel149+9(pc),a1
                moveq   #' ',d0
                moveq   #11,d1
                move.b  d0,(a1)+
                dbra    d1,*-4
                bsr     fsel59
                bmi.s   fsel90

                lea     -12(a1),a1
                movea.l a1,a2
                addq.w  #1,a0

fsel89:         move.b  (a0)+,d0
                beq.s   fsel90
                cmp.b   #'.',d0
                bne.s   *+4
                lea     8(a2),a1
                move.b  d0,(a1)+
                bra.s   fsel89

fsel90:         lea     fsel149(pc),a1
                move.l  #30*6*160+40,d0
                bsr     fsel127
********************************************************************************
                move.w  #$0010,-(a7)       ; Alle Ordner
                pea     fsel147(pc)
                move.w  #$004E,-(a7)       ; SFirst
                trap    #1
                addq.l  #8,a7
                st      fsel98
                bsr     fsel99
                sf      fsel98

                move.w  #%0000000000100111,-(a7) ; Rest mit Maske
                move.l  fsel146(pc),-(a7)
                move.w  #$004E,-(a7)       ; SFirst
                trap    #1
                addq.l  #8,a7
                bsr     fsel99

                lea     -fsel2(a4),a4
                move.l  a4,fsel141

fsel91:         lea     fsel158,a0
                lea     fsel158+fsel2,a1
                sf      fsel112
                move.w  fsel140(pc),d4
                subq.w  #1,d4
                bmi     fsel97
                bra     fsel96

fsel92:         move.b  (a0),d0            ; Ordner-Prioritt
                and.b   #$07,d0
                move.b  (a1),d1
                and.b   #$07,d1
                cmp.b   d1,d0
                blt.s   fsel94
                bgt.s   fsel95

                tst.w   fsel144
                bne.s   fsel93
                move.l  10(a0),d0          ; Extension-Prioritt
                move.l  10(a1),d1
                cmp.l   d1,d0
                blt.s   fsel95
                bgt.s   fsel94
fsel93:
                movem.l (a0),d0-d1         ; Namen-Reihenfolge
                cmp.l   (a1),d0
                blt.s   fsel95
                bgt.s   fsel94
                cmp.l   4(a1),d1
                blt.s   fsel95
                bgt.s   fsel94

                tst.w   fsel144
                beq.s   fsel95
                move.l  10(a0),d0          ; Extension-Prioritt
                move.l  10(a1),d1
                cmp.l   d1,d0
                ble.s   fsel95
*                bgt.s   sort2

fsel94:         st      fsel112
                REPT fsel2/4
                move.l  (a0),d0
                move.l  (a1),(a0)+
                move.l  d0,(a1)+
                ENDR
                bra.s   fsel96

fsel95:         lea     fsel2(a0),a0
                lea     fsel2(a1),a1
fsel96:         dbra    d4,fsel92
                tst.b   fsel112
                bne     fsel91
fsel97:
                rts

fsel98:         DC.W 0                  ; falls gesetzt, werden nur Ordner gesucht

fsel99:
                tst.w   d0
                bne.s   fsel105

                lea     fsel113(pc),a0

                cmpi.b  #'.',30(a0)
                beq.s   fsel104

                moveq   #'',d3
                btst    #4,21(a0)
                bne.s   fsel100

                tst.w   fsel98             ; drfen nur Ordner
                bne.s   fsel104            ; ja

                moveq   #' ',d3
                move.l  26(a0),d0
                lea     13(a4),a1

                bsr.s   fsel106

fsel100:
                addq.w  #1,fsel140

                clr.b   20(a4)
                movea.l a4,a1

                move.b  d3,(a4)+

                lea     30(a0),a0
fsel101:        move.b  (a0)+,d0
                beq.s   fsel103
                cmp.b   #'.',d0
                bne.s   fsel102
                lea     9(a1),a4
fsel102:        move.b  d0,(a4)+
                bra.s   fsel101
fsel103:
                lea     fsel2(a1),a4

fsel104:
                move.w  #$004F,-(a7)       ; SNext
                trap    #1
                addq.l  #2,a7

                bra.s   fsel99
fsel105:        rts
********************************************************************************
fsel106:
* d0 = zahl
* a1 = ziel

                lea     fsel111(pc),a2
fsel107:
                moveq   #-1,d2

fsel108:        addq.w  #1,d2
                sub.l   (a2),d0
                bpl.s   fsel108

                add.b   #'0',d2
                move.b  d2,(a1)+
                add.l   (a2)+,d0
                tst.l   (a2)
                bne.s   fsel107

                moveq   #6,d0
                lea     -7(a1),a1
                bra.s   fsel110
fsel109:
                move.b  #32,(a1)+
fsel110:        cmpi.b  #'0',(a1)

                dbne    d0,fsel109

                rts

fsel111:        DC.L 1000000,100000,10000,1000,100,10,1,0



fsel112:        DC.W 0
fsel113:        DS.B 45
fsel114:        DS.B 128
                EVEN
                ENDPART

                PART 'inputer'
fsel115:        cmp.b   #'	',d0
                beq.s   fsel120
                cmp.b   #'',d0
                beq     fsel125
                cmp.b   #'',d0
                beq.s   fsel119
                cmp.b   #'.',d0
                bne.s   fsel116
                move.w  #9,fsel151
                bra     fsel6
fsel116:        move.w  fsel151(pc),d1
                lea     fsel152(pc),a0
                move.b  d0,0(a0,d1.w)
                cmpi.w  #12,d1
                beq.s   fsel118
                addq.w  #1,d1
                cmp.b   #8,d1
                bne.s   fsel117
                addq.w  #1,d1
fsel117:        move.w  d1,fsel151
                bsr     fsel124
                bra     fsel6
fsel118:        move.b  d0,11(a0)
                clr.b   12(a0)
                bra.s   fsel117

fsel119:        bsr.s   fsel123
                bra     fsel6

fsel120:        movea.l fsel142(pc),a0
                cmpi.b  #'',(a0)+
                beq     fsel6
fsel122         SET 0
                REPT 12
                move.b  (a0)+,fsel152+fsel122
fsel122         SET fsel122+1
                ENDR
                move.w  #12,fsel151
                bsr.s   fsel124
                bra     fsel6

fsel123:        clr.w   fsel151
                lea     fsel152(pc),a0
                move.l  #'    ',(a0)+
                move.l  #'    ',(a0)+
                move.l  #'.   ',(a0)+
* bra     pname
fsel124:
                lea     fsel152(pc),a1
                move.l  #25*6*160+40+32+1,d0
                bra.s   fsel127
fsel125:
                lea     fsel152(pc),a0
                move.w  fsel151(pc),d1
                beq     fsel6

                subq.w  #1,d1
                cmp.b   #8,d1
                bne.s   fsel126
                subq.w  #1,d1
fsel126:        move.w  d1,fsel151
                cmpi.b  #' ',0(a0,d1.w)
                beq.s   fsel125
                move.b  #' ',0(a0,d1.w)

                bsr.s   fsel124
                bra     fsel6

                ENDPART

                PART 'print superfast'

* a1=text
* d0=x y
fsel127:        movea.l fsel134(pc),a0
                lea     0(a0,d0.w),a0

                move.l  #$00070001,d2
                and.w   #1,d0
                beq.s   *+2
                swap    d2

fsel128:        moveq   #0,d0
                move.b  (a1)+,d0
                beq.s   fsel129
                lsl.w   #2,d0
                movea.l fsel133(pc,d0.w),a2

                move.b  (a2)+,(a0)
                move.b  (a2)+,160(a0)
                move.b  (a2)+,320(a0)
                move.b  (a2)+,480(a0)
                move.b  (a2)+,640(a0)

                adda.w  d2,a0
                swap    d2
                bra.s   fsel128
fsel129:        rts
********************************************************************************
fsel130:
fsel131:        moveq   #0,d0
                move.b  (a1)+,d0
                beq.s   fsel132
                lsl.w   #2,d0
                movea.l fsel133(pc,d0.w),a2
                move.b  (a2)+,(a0)
                move.b  (a2)+,20(a0)
                move.b  (a2)+,40(a0)
                move.b  (a2)+,60(a0)
                move.b  (a2)+,80(a0)
                addq.w  #1,a0
                bra.s   fsel131
fsel132:        rts
********************************************************************************
fsel133:        DS.L 256
********************************************************************************
fsel134:        DC.L $00000000
********************************************************************************
fsel135:        lea     fsel133(pc),a0
                move.w  #255,d0
                move.l  #fsel154+fsel139*8,d1
fsel136:        move.l  d1,(a0)+
                dbra    d0,fsel136


                lea     fsel138(pc),a0
                lea     fsel133(pc),a1
                moveq   #fsel139,d1
fsel137:
                moveq   #0,d0
                move.b  0(a0,d1.w),d0
                lsl.w   #2,d0
                move.l  d1,d2
                lsl.w   #3,d2
                add.l   #fsel154,d2
                move.l  d2,0(a1,d0.w)
                dbra    d1,fsel137

                rts


fsel138:        DC.B 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+*/:.!?()_"'
                DC.B "' "
fsel139         EQU *-fsel138-1
                EVEN

                ENDPART

fsel140:        DC.W 0
fsel141:        DC.L 0
fsel142:        DC.L 0
fsel143:        DC.W 0
fsel144:        DC.W 0
fsel145:        DS.B 256

fsel146:        DC.L 0,0
fsel147:        DC.B '*.*',0
fsel148:        DC.B 'FILENAME:............',0
fsel149:        DC.B 'FOLDER:  ............  ',0
fsel150:        DC.B 'D: 1234567 BYTES FREE',0
                EVEN
fsel151:        DC.W 0
fsel152:        DC.B '            ',0
                EVEN
fsel153:        DC.B 'NONAME.MV2  ',0
                EVEN
                PATH 'D:\DATA\'
fsel154:        IBYTES 'CHARS6.FNT'
                EVEN
********************************************************************************

                OPT O-

music:          BASE A5,music

********************************************************************************

selectsong:     bra     songselect
callsample:     bra     startsample
playit:         bra     pvbl
counti:         DC.W 0
mvol:           DC.B 0,0
********************************************************************************
patp            EQU *-music
patbegin:       DC.L 0
patternp:       DC.L patlist
instp           EQU *-music
instbegin:      DC.L 0
instrp:         DC.L instlist
sngp            EQU *-music
songbegin:      DC.L 0
songp:          DC.L 0
digip           EQU *-music
digibegin:      DC.L 0
digidrums:      DC.L digilist
digifxp:        DC.L 0
********************************************************************************

                OPT O+
                DC.B 'Music by '
                DC.B 'Mirko Moenninghoff - XTROLL.ATARI.ORG - '
                DC.B '45527 Hattingen - MIRKO@MOUSEATTACK.DE  '
                EVEN

                PART 'vbl'

pvbl:

                movem.l d0-a5,-(a7)
                lea     music(pc),a5

                tst.w   play(a5)
                beq     keinvbl

                subq.w  #1,speed(a5)
                bne.s   pvbl1
                move.w  mspeed(pc),speed(a5)
                bsr     getnote
pvbl1:
                lea     psgbuf(pc),a1
                moveq   #0,d0
                lea     vdat1(pc),a0
                jsr     effekts(pc)
                moveq   #0,d0
                lea     vdat2(pc),a0
                bsr.s   effekts
                moveq   #1,d0              ; digi mglich
                lea     vdat3(pc),a0
                bsr.s   effekts

                move.b  #7,(a1)+
                move.b  mixreg(a5),d0
                or.b    splmask(a5),d0
                move.b  d0,(a1)+
                st      (a1)+


                lea     psgbuf(pc),a0
                lea     $FFFF8800.w,a1

                IF freia6<>2
                move    sr,d1
                move    #$2700,sr
                ENDC

more:           move.w  (a0)+,d0
                bmi.s   all
                movep.w d0,0(a1)
                bra.s   more
all:

                IF freia6<>2
                move.b  #10,(a1)           ; sel vol reg 3
                move    d1,sr
                ENDC


                IF freia6<>1
                movea.l tpoint(pc),a4
                ENDC

                tst.b   splact(a5)
                ble.s   spl0
                st      splact(a5)         ; negativ wenn spl an

                IF freia6<>1
                movea.l splp(a5),a4
                move.l  a4,tpoint(a5)
                ELSE
                movea.l splp(a5),a6
                ENDC

                IF routs=1
                ori.b   #$01,$FFFFFA1D.w
                ENDC

spl0:
                tst.b   splact(a5)
                bpl.s   spl1

                IF freia6<>1
                tst.b   (a4)
                ELSE
                tst.b   (a6)
                ENDC

                bpl.s   spl1

                IF routs=1
                andi.b  #$F0,$FFFFFA1D.w
                ENDC

                IF phase3=1
                move.b  #15,$FFFF8800.w
                ENDC

                clr.w   digifx(a5)
                sf      splact(a5)
                sf      splmask(a5)
                ori.b   #%00100100,mixreg(a5)
spl1:

keinvbl:
                movem.l (a7)+,d0-a5
                rts

                ENDPART
                PART 'effekte'



effekts:
                tst.b   inf(a0)
                beq.s   normsound
                tst.w   d0
                bne.s   *+2
                rts

                tst.w   splflag(a5)
                bmi.s   *+2
                rts
                clr.w   splflag(a5)
                move.b  d0,splact(a5)      ; positiv
                move.b  #%00100100,splmask(a5) ; fr digiboost
                rts
masktab:        DC.B %00111111,%00111000,%00000111,0
normsound:
                tst.w   d0
                beq.s   nextvoice
                tst.w   digifx(a5)         ; digieffekt an ?
                beq.s   *+2
                rts
                clr.w   splmask(a5)
                sf      splact(a5)         * hoffentlich bleiben die effekte ...

                IF routs=1
                andi.b  #$F0,$FFFFFA1D.w   ; normsound timer stop
                ENDC

nextvoice:
                move.l  rauschp(a0),d0
                beq.s   rtabend
                movea.l d0,a2
                move.b  (a2)+,d0
                bpl.s   rtab0
                clr.l   rauschp(a0)
                bra.s   rtabend
rtab0:          move.l  a2,rauschp(a0)
                move.b  #6,(a1)+
                move.b  d0,(a1)+
rtabend:
                moveq   #0,d0
                move.l  mixp(a0),d1
                beq.s   mtabend
                movea.l d1,a2
                move.b  (a2)+,d0
                bpl.s   mtab0
                clr.l   mixp(a0)
                bra.s   mtabend
mtab0:
                move.l  a2,mixp(a0)

                move.b  mixreg(pc),d1
                move.b  mixmask(a0),d2
                move.b  masktab(pc,d0.w),d0
                and.b   d2,d0
                not.b   d2
                and.b   d2,d1
                or.b    d0,d1
                move.b  d1,mixreg(a5)
mtabend:

                moveq   #$80,d5
                moveq   #$81,d6
                moveq   #$82,d7

                movea.l frqp(a0),a4

                adda.w  trans(a0),a4

                move.w  (a4),d2            ; d2 frequenz

                IF teff2=1
                tst.b   effset(a0)
                beq.s   okok
                and.w   #%0000111111110000,d2
okok:
                ENDC

                move.l  blubp(a0),d0
                beq.s   noblub

                tst.w   blubc(a0)
                beq.s   noblub
                subq.w  #1,blubc(a0)
                bne.s   noblub
                addq.w  #1,blubc(a0)


                movea.l d0,a2
                move.b  (a2)+,d0
                bpl.s   doblub
                cmp.b   d5,d0
                bne.s   blub0
                movea.l blubres(a0),a2
                move.b  (a2)+,d0           *+
                bra.s   doblub
blub0:          cmp.b   d6,d0
                bne.s   blub1
                subq.l  #2,a2
                move.b  (a2)+,d0
                bra.s   doblub
blub1:          cmp.b   d7,d0
                bne.s   doblub
                moveq   #0,d0
                suba.l  a2,a2
doblub:         move.l  a2,blubp(a0)
                ext.w   d0
                add.w   d0,d0

                movea.l frqp(a0),a4
                lea     0(a4,d0.w),a4      ; freqp
                move.l  a4,frqp(a0)
                adda.w  trans(a0),a4
                move.w  (a4),d2
                bpl.s   blob2
                move.w  allnotes(pc),d2
                bra.s   noblub
blob2:
                lea     allnotes(pc),a3
                cmpa.l  a3,a4
                bge.s   blubok
                move.w  (a3),d2            ; tiefst mglicher ton
noblub:

blubok:

                move.l  vibp(a0),d0
                beq.s   novib

                tst.w   vibc(a0)
                beq.s   novib
                subq.w  #1,vibc(a0)
                bne.s   novib
                addq.w  #1,vibc(a0)

                movea.l d0,a2
                move.b  (a2)+,d0
                bpl.s   dovib
                cmp.b   d5,d0
                bne.s   vib0
                movea.l vibres(a0),a2
                move.b  (a2)+,d0
                bra.s   dovib
vib0:           cmp.b   d6,d0
                bne.s   vib1
                subq.l  #2,a2
                move.b  (a2)+,d0
                bra.s   dovib
vib1:           cmp.b   d7,d0
                bne.s   dovib
                moveq   #0,d0
                suba.l  a2,a2
dovib:          move.l  a2,vibp(a0)
                ext.w   d0


                add.w   d0,d2              ; neue frequenz

novib:

                move.w  porta(a0),d0
                beq.s   notporta
                move.w  poff(a0),d4
                movea.l frqdest(a0),a2
                move.l  a2,d5
                adda.w  trans(a0),a2       ; wichtich !
                move.w  (a2),d1

                tst.w   d0
                bmi.s   lowmark

                add.w   d0,d4
                add.w   d4,d2
                cmp.w   d2,d1
                bgt.s   porta0
                move.w  d1,d2
                clr.w   porta(a0)
                move.l  d5,frqp(a0)
                bra.s   notporta
lowmark:
                add.w   d0,d4
                add.w   d4,d2
                cmp.w   d2,d1
                blt.s   porta0
                move.w  d1,d2
                clr.w   porta(a0)
                move.l  d5,frqp(a0)
                bra.s   notporta
porta0:         move.w  d4,poff(a0)
notporta:

                moveq   #0,d3

                move.b  eff(a0),d0
                beq.s   notimer

                subq.b  #1,effc(a0)
                bne.s   notimer
                sf      eff(a0)

                move.b  d0,d1
                lsr.b   #4,d1
                bne.s   effda
                move.b  d0,eff(a0)
                bra.s   notimer
effda:
                and.b   #15,d0
                move.w  d2,d3
                lsr.w   d0,d3
                move.w  #$0C00,(a1)+       * higbyte lschen
                move.b  #13,(a1)+
                move.b  d1,(a1)+
                move.b  #11,(a1)+
                move.b  d3,(a1)+

*                BREAKPT 'l'

                st      volo(a0)           ; damit lautstr gesetzt wird
                moveq   #16,d3             ; or auf l
notimer:
                move.b  fchan(a0),d0
                move.b  d0,(a1)+
                move.b  d2,(a1)+
                addq.b  #1,d0
                move.b  d0,(a1)+
                lsr.w   #8,d2
                move.b  d2,(a1)+


                move.l  volp(a0),d0
                beq.s   novtab
                movea.l d0,a2
                move.b  (a2)+,d0
                cmp.b   #$80,d0
                bne.s   normvol
* norm timer effekt
                move.b  #13,(a1)+          ; hllkurve select
                move.b  eff(a0),(a1)+      ; fr hllkurve
                move.b  #12,(a1)+          ; highbyte
                move.b  (a2)+,(a1)+
                move.b  #11,(a1)+          ; low
                move.b  (a2)+,(a1)+
                move.b  volreg(a0),(a1)+
                st      (a1)+
                suba.l  a2,a2
                bra.s   vtabend

normvol:        tst.b   d0
                bmi.s   vtab2
                cmp.b   volo(a0),d0
                beq.s   vtabend
                move.b  d0,volo(a0)
                sub.b   mvol(a5),d0
                beq.s   vtab1
                bpl.s   vtab0
                moveq   #0,d0
                bra.s   vtab0
vtab2:          suba.l  a2,a2
                bra.s   vtabend
vtab0:          or.b    d3,d0
vtab1:          move.b  volreg(a0),(a1)+
                move.b  d0,(a1)+
vtabend:        move.l  a2,volp(a0)

novtab:
                rts
                ENDPART
                PART 'getnewnote'

getnote:
                subq.w  #1,taktc(a5)
                bne.s   onlypat
                move.w  #16,taktc(a5)

                movea.l aktsongp(pc),a2
getpats:
                lea     trans+vdat1(pc),a1
                lea     patp1(pc),a0
                bsr     pattest
                lea     trans+vdat2(pc),a1
                lea     patp2(pc),a0
                bsr     pattest
                lea     trans+vdat3(pc),a1
                lea     patp3(pc),a0
                bsr     pattest
                move.l  a2,aktsongp(a5)


onlypat:
                IF midi=1
                lea     midich1(pc),a0
                move.l  a0,midip(a5)
                ENDC
                lea     patp1(pc),a0
                lea     vdat1(pc),a1
                bsr.s   getpdata


                IF midi=1
                lea     midich2(pc),a0
                move.l  a0,midip(a5)
                ENDC
                lea     patp2(pc),a0
                lea     vdat2(pc),a1
                bsr.s   getpdata


                IF midi=1
                lea     midich3(pc),a0
                move.l  a0,midip(a5)
                ENDC
                lea     patp3(pc),a0
                lea     vdat3(pc),a1
getpdata:
                move.l  (a0),d0
                beq.s   mret
                movea.l d0,a2
                addq.l  #4,(a0)

                moveq   #0,d0
                move.b  (a2)+,d0           ; a2-instnr,ton,okt,porta
                beq.s   mret
                move.b  comp(a1),d1
                beq.s   nochange
                cmp.b   d0,d1
                bne.s   nochange
                move.b  repl(a1),d0
                beq.s   mret
nochange:
                subq.b  #1,d0

                movea.l instrp(pc),a0
                add.w   d0,d0
                add.w   d0,d0
                movea.l 0(a0,d0.w),a0      ; a0 = intrument

                moveq   #0,d0
                move.b  iinf(a0),d0
                move.b  d0,inf(a1)         ; inf
                beq.s   psgsound
                tst.w   digifx(a5)         ; sound effekt
                bne.s   mret
                subq.w  #1,d0              ; digidrumnummer
                add.w   d0,d0
                add.w   d0,d0
                add.w   d0,d0
                movea.l digidrums(pc),a0
                move.l  0(a0,d0.w),splp(a5) ; sample
                st      splflag(a5)        ; -1 = digidrum
mret:           rts

psgsound:
                lea     irausch(a0),a3
                move.l  a3,rauschp(a1)
                lea     ivol(a0),a3
                move.l  a3,volp(a1)
                lea     imix(a0),a3
                move.l  a3,mixp(a1)
                move.b  iblubc(a0),blubc+1(a1)
                move.b  ivibc(a0),vibc+1(a1)
                move.b  ieffc(a0),effc(a1)
                IF teff2=1
                move.b  ieff(a0),d0        ;eff(A1)
                move.b  d0,eff(a1)
                and.b   #%11110000,d0
                move.b  d0,effset(a1)
                ELSE
                move.b  ieff(a0),eff(a1)
                ENDC
                lea     ivib(a0),a3
                move.l  a3,vibp(a1)
                move.l  a3,vibres(a1)
                lea     iblub(a0),a3
                move.l  a3,blubp(a1)
                move.l  a3,blubres(a1)

                moveq   #0,d0
                moveq   #0,d2
                move.b  (a2)+,d0           ; ton+12*oktave

                IF midi=1
                bsr     sendmidi
                ENDC

                add.w   d0,d0
                lea     allnotes(pc,d0.w),a3
                move.w  (a3),d2
                move.b  (a2)+,d0           ; porta transpo
                beq.s   noporta
                moveq   #0,d3
                move.b  (a2)+,d3           ; porta speed
                beq.s   noporta            ; wenn 0 divisoin durch null verhindern

                move.l  a3,frqdest(a1)     ; zielfrequenz zeiger beim pitch bending
                movea.l a3,a4
                ext.w   d0
                add.w   d0,d0
                adda.w  d0,a3
                move.l  a3,frqp(a1)        ; source frq zeiger
                move.w  trans(a1),d0       *
                lea     0(a3,d0.w),a3      *
                lea     0(a4,d0.w),a4      *

*                adda.w  trans(A1),A3
*                adda.w  trans(A1),A4

                move.w  (a3),d1
                move.w  (a4),d2
                sub.w   d1,d2
                ext.l   d2
                divs    d3,d2
                move.w  d2,porta(a1)
                clr.w   poff(a1)
                rts

noporta:        move.l  a3,frqp(a1)
                move.w  d2,frq(a1)
                clr.w   porta(a1)          ; porta killen
                rts
allnotes:

lowtone         EQU $00000FFF

                SWITCH frqtabnr

                CASE 0
************** tfmx  *************************
                DC.W $0EEE,$0E17,$0D4D,$0C8E,$0BD9,$0B2F,$0A8E,$09F7,$0967,$08E0,$0861,$07E8,$0777,$070B,$06A6,$0647
                DC.W $05EC,$0597,$0547,$04FB,$04B3,$0470,$0430,$03F4,$03BB,$0385,$0353,$0323,$02F6,$02CB,$02A3,$027D
                DC.W $0259,$0238,$0218,$01FA,$01DD,$01C2,$01A9,$0191,$017B,$0165,$0151,$013E,$012C,$011C,$010C,$00FD
                DC.W $00EE,$00E1,$00D4,$00C8,$00BD,$00B2,$00A8,$009F,$0096,$008E,$0086,$007E,$0077,$0070,$006A,$0064
                DC.W $005E,$0059,$0054,$004F,$004B,$0047,$0043,$003F,$003B,$0038,$0035,$0032,$002F,$002C,$002A,$0027
                DC.W $0025,$0023,$0021,$001F,$001D,$001C,$001A,$0019,$0017,$0016,$0015,$0013,$0012,$0011,$0010,$000F
pseudoo:
                DC.W 13,12,12,11,11,10,10,9,9,8,8,7

                CASE 1

************    von netherworld   ****************
                DC.W $0861,$07E9,$0777,$070C,$06A7,$0647,$05ED,$0598,$0547,$04FC,$04B4,$0470,$0431,$03F4,$03BC,$0386
                DC.W $0353,$0324,$02F6,$02CC,$02A4,$027E,$025A,$0238,$0218,$01FA,$01DE,$01C3,$01AA,$0192,$017B,$0166
                DC.W $0152,$013F,$012D,$011C,$010C,$00FD,$00EF,$00E1,$00D5,$00C9,$00BE,$00B3,$00A9,$009F,$0096,$008E
                DC.W $0086,$007F,$0077,$0071,$006A,$0064,$005F,$0059,$0054,$0050,$004B,$0047,$0043,$003F,$003C,$0038
                DC.W $0035,$0032,$002F,$002D,$002A,$0028,$0026,$0024,$0022,$0020
                DC.W 26,24,23,22,21,20,19,18,16,15,14
pseudoo:        DC.W 13,12,12,11,11,10,10,9,9,8,8,7

                CASE 2

****** vom zx spectrum ********************************
                DC.W $0D3D,$0C7F,$0BCC,$0B22,$0A82,$09EB,$095D,$08D6,$0857,$07DF,$076E,$0703,$069F,$0640,$05E6,$0591
                DC.W $0541,$04F6,$04AE,$046B,$042C,$03F0,$03B7,$0382,$034F,$0320,$02F3,$02C8,$02A1,$027B,$0257,$0236
                DC.W $0216,$01F8,$01DC,$01C1,$01A8,$0190,$0179,$0164,$0150,$013D,$012C,$011B,$010B,$00FC,$00EE,$00E0
                DC.W $00D4,$00C8,$00BD,$00B2,$00A8,$009F,$0096,$008D,$0085,$007E,$0077,$0070,$006A,$0064,$005E,$0059
                DC.W $0054,$004F,$004B,$0047,$0043,$003F,$003B,$0038,$0035,$0032,$002F,$002D,$002A,$0028,$0025,$0023
                DC.W $0021,$001F
                DC.W 26,24,23,22,21,20,19,18,16,15,14
pseudoo:        DC.W 13,12,12,11,11,10,10,9,9,8,8,7

                CASE 3

                DC.W $0EEE,$0E18,$0D4D,$0C8E
                DC.W $0BDA,$0B2F,$0A8F,$09F7,$0968,$08E1,$0861,$07E9,$0777,$070C,$06A7,$0647,$05ED,$0598,$0547,$04FC
                DC.W $04B4,$0470,$0431,$03F4,$03BC,$0386,$0353,$0324,$02F6,$02CC,$02A4,$027E,$025A,$0238,$0218,$01FA
                DC.W $01DE,$01C3,$01AA,$0192,$017B,$0166,$0152,$013F,$012D,$011C,$010C,$00FD,$00EF,$00E1,$00D5,$00C9
                DC.W $00BE,$00B3,$00A9,$009F,$0096,$008E,$0086,$007F,$0077,$0071,$006A,$0064,$005F,$0059,$0054,$0050
                DC.W $004B,$0047,$0043,$003F,$003C,$0038,$0035,$0032,$002F,$002D,$002A,$0028,$0026,$0024,$0022,$0020
                DC.W 26,24,23,22,21,20,19,18,16,15,14
pseudoo:        DC.W 13,12,12,11,11,10,10,9,9,8,8,7

                ENDS

pattest:
                moveq   #0,d0
                move.b  (a2)+,d0
                beq.s   nonewpat
                cmp.b   #$FF,d0
                beq.s   songende
                subq.w  #1,d0
*       mulu    #12,D0          ; 1L adr  1B taktlen 1B trans

                move.w  d0,d4              ; ????
                add.w   d0,d0
                add.w   d4,d0
                add.w   d0,d0
                add.w   d0,d0

                movea.l patternp(pc),a3
                move.l  0(a3,d0.w),(a0)
                move.w  4(a3,d0.w),4(a0)   ;len

                move.b  (a2)+,d0           ; trans !!!
                cmp.b   #$80,d0
                bne.s   qwe
                addq.w  #1,counti(a5)
                moveq   #0,d0
qwe:
                ext.w   d0
                add.w   d0,d0
                move.w  d0,(a1)+           ; trans !
; a1 auf comp +1 =rpl
                move.w  (a2)+,(a1)+        ; instswapper !
*                move.b  (A2)+,(A1)+
                rts

nonewpat:
                addq.l  #3,a2

                move.w  4(a0),d0

                subq.w  #1,d0
                beq.s   killpat
                move.w  d0,4(a0)
                rts
killpat:        clr.l   (a0)
                rts

songende:
*              BREAKPT '** songende **'

                tst.w   rept(a5)
                beq.s   newstart
                sf      play(a5)
                addq.l  #4,a7              *
                lea     psginit(pc),a0
                lea     $FFFF8800.w,a1
makeoff:        move.w  (a0)+,d0
                bmi.s   makeoff0
                movep.w d0,0(a1)
                bra.s   makeoff
makeoff0:       rts                        *

newstart:
                movea.l songstart(pc),a2
                addq.l  #4,a7
                bra     getpats

                IF midi=1


midich1:
                DC.B %10000000          ; channel 1 note off
                DC.B 0                  ; hier tonhhe
                DC.B 0                  ; anschlag
                DC.B %10010000          ; channel 1 note on
                DC.B 0                  ; hier tonhhe
                DC.B 64                 ; anschlag

midich2:        DC.B %10000001          ; channel 2 note off
                DC.B 0                  ; hier tonhhe
                DC.B 0                  ; anschlag
                DC.B %10010001          ; channel 2 note on
                DC.B 0                  ; hier tonhhe
                DC.B 64                 ; anschlag

midich3:
                DC.B %10000010          ; channel 3 note off
                DC.B 0                  ; hier tonhhe
                DC.B 0                  ; anschlag
                DC.B %10010010          ; channel 3 note on
                DC.B 0                  ; hier tonhhe
                DC.B 64                 ; anschlag

midikill:
                DC.B %11111110
                DC.B %10110000          ; all notes off
                DC.B %01111011
                DC.B %00000000


midip:          DC.L 0
sendmidi:
                move.w  d0,-(a7)
                move.w  d1,-(a7)
                move.w  d2,-(a7)
                pea     (a0)
                movea.l midip(pc),a0

                moveq   #6-1,d2
                move.w  trans(a1),d1
                lsr.w   #1,d1
                add.w   d1,d0
                add.w   #24,d0
                move.b  d0,4(a0)
sender:
                move.b  (a0)+,d0
                bsr     waiter
                dbra    d2,sender

                move.b  d0,-5(a0)

                movea.l (a7)+,a0
                move.w  (a7)+,d2
                move.w  (a7)+,d1
                move.w  (a7)+,d0
                rts

waiter:         tst.b   $FFFFFC06.w
                move.b  $FFFFFC04.w,d1
                btst    #1,d1
                beq.s   waiter
                move.b  d0,$FFFFFC06.w
                rts

                ENDC



                ENDPART
                PART 'timerkram'
timerd:
                SWITCH freia6

                CASE 1
                IF routs=1
                move.b  (a6)+,$FFFF8802.w
                ENDC
                rte

                CASE 0
                move    a0,usp
                lea     tpoint(pc),a0
                addq.l  #1,(a0)
                movea.l (a0),a0
                move.b  (a0),$FFFF8802.w
                move    usp,a0
                rte
tpoint:         DC.L 0

                CASE 2
                move    a0,usp
                lea     tpoint(pc),a0
                addq.l  #1,(a0)
                movea.l (a0),a0
                move.b  #10,$FFFF8800.w
                move.b  (a0),$FFFF8802.w
                move    usp,a0
                rte
tpoint:         DC.L 0

                ENDS


timerstop:
                IF routs=1
                andi.b  #$F0,$FFFFFA1D.w
                ENDC
                IF phase3=1
                move.b  #15,$FFFF8800.w
                ENDC
                rts

inittimer:
                pea     (a5)
                IF phase3=1
                move.b  #15,$FFFF8800.w
                ENDC
                lea     music(pc),a5
                clr.l   splp(a5)
                clr.w   splact(a5)
                clr.w   splflag(a5)
                clr.w   splmask(a5)
                IF routs=1
                andi.b  #$F0,$FFFFFA1D.w
                bset    #4,$FFFFFA09.w
                bset    #4,$FFFFFA0D.w
                bset    #4,$FFFFFA11.w
                bset    #4,$FFFFFA15.w
                bclr    #3,$FFFFFA17.w     ; auto enable mode
                move.b  #$50,$FFFFFA25.w
                pea     timerd(pc)
                move.l  (a7)+,$00000110.w
                ENDC
                movea.l (a7)+,a5
                rts

startsample:
                movem.l d0/a0/a5,-(a7)
                lea     music(pc),a5
                tst.w   d0                 ; sample 0 kann nicht unterbrechen
                bne.s   call1
                tst.w   digifx(a5)
                bne.s   call2
call1:          add.w   d0,d0
                add.w   d0,d0
                add.w   d0,d0
                movea.l digifxp(pc),a0
                move.l  0(a0,d0.w),splp(a5)
                st      digifx(a5)
                move.b  #1,splact(a5)
                move.b  #%00100100,splmask(a5) ; fr digiboost
call2:          movem.l (a7)+,d0/a0/a5
                rts


                ENDPART
                PART 'inits'
songselect:
* d0 liednummer
                cmp.l   #'moff',d1
                beq.s   no_dig2
                bsr     inittimer
no_dig2:
                movem.l d0-a5,-(a7)

                lea     music(pc),a5

                clr.w   play(a5)

                IF routs=1
                andi.b  #$F0,$FFFFFA1D.w
                ENDC

                tst.w   reloflag(a5)
                beq.s   relook

                move.l  a0,d1
                btst    #0,d1
                bne.s   i1
                move.l  a0,d2
                move.l  (a0)+,d1
                cmp.l   #'d4bt',d1
                bne.s   i1
                move.l  a0,digifxp(a5)
i0:             tst.w   (a0)
                bmi.s   i1
                add.l   d2,(a0)
                addq.l  #8,a0
                bra.s   i0
i1:
                move.l  a5,d1
                add.l   d1,instrp(a5)
                add.l   d1,patternp(a5)
                add.l   d1,songp(a5)
                add.l   d1,digidrums(a5)

                movea.l instrp(a5),a0
i2:             tst.w   (a0)
                bmi.s   i3
                add.l   d1,(a0)+
                bra.s   i2
i3:
                movea.l patternp(a5),a0
i4:             tst.w   (a0)
                bmi.s   i5
                add.l   d1,(a0)+
                addq.l  #8,a0
                bra.s   i4
i5:
                movea.l songp(a5),a0
i6:             tst.w   (a0)
                bmi.s   i7
                add.l   d1,(a0)+
                addq.l  #2,a0
                bra.s   i6
i7:
                movea.l digidrums(a5),a0
i8:             tst.w   (a0)
                bmi.s   i9
                add.l   d1,(a0)+
                addq.l  #4,a0
                bra.s   i8
i9:
                clr.w   reloflag(a5)
relook:
                lea     psginit(pc),a0
                lea     $FFFF8800.w,a1
sel0:
                move.w  (a0)+,d1
                bmi.s   sel1
                movep.w d1,0(a1)
                bra.s   sel0
sel1:

                subq.b  #1,d0
                bmi.s   stopall
                movea.l songp(pc),a0
                mulu    #6,d0
                move.l  0(a0,d0.w),d1
                move.l  d1,songstart(a5)
                move.l  d1,aktsongp(a5)
                move.b  4(a0,d0.w),mspeed+1(a5)
                move.b  5(a0,d0.w),rept+1(a5)
                move.w  #1,speed(a5)
                move.w  #1,taktc(a5)
                st      mixreg(a5)

                moveq   #0,d0
                move.w  d0,counti(a5)
                lea     patp1(pc),a0
                lea     vdat1(pc),a1
                bsr.s   reset
                lea     patp2(pc),a0
                lea     vdat2(pc),a1
                bsr.s   reset
                lea     patp3(pc),a0
                lea     vdat3(pc),a1
                bsr.s   reset

                clr.w   splact(a5)
                clr.w   splmask(a5)
                clr.w   digifx(a5)
                clr.w   splflag(a5)

                st      play(a5)

stopall:
                IF midi=1
                lea     midikill(pc),a0
                move.b  (a0)+,d0
                bsr     waiter
                move.b  (a0)+,d0
                bsr     waiter
                move.b  (a0)+,d0
                bsr     waiter
                move.b  (a0)+,d0
                bsr     waiter
                ENDC

                movem.l (a7)+,d0-a5
                rts


reset:
                move.l  d0,(a0)+
                move.w  d0,(a0)+
                moveq   #(vd1x-(vdat1+inf))/2-1,d1
                lea     inf(a1),a1
res0:           move.w  d0,(a1)+
                dbra    d1,res0
                rts

psginit:        DC.B 0,0,1,0,2,0,3,0,4,0,5,0,6,$FF,7,$FF,8,0,9,0,10,0,11,0,12,0,13,0,-1,-1
                EVEN

                ENDPART
                PART 'voice paras'
vv:
vdat1:
volreg          EQU *-vv
                DC.B 8,0
mixmask         EQU *-vv
                DC.B %00001001,0
fchan           EQU *-vv
                DC.B 0,1
inf             EQU *-vv
                DC.W 0
instnr          EQU *-vv
                DC.W 0
frq             EQU *-vv
                DC.W 0
frqp            EQU *-vv
                DC.L 0
frqdest         EQU *-vv
                DC.L 0
frqof           EQU *-vv
                DC.W 0
trans           EQU *-vv
                DC.W 0
comp            EQU *-vv
                DC.B 0
repl            EQU *-vv
                DC.B 0
vol             EQU *-vv
                DC.W 0
volo            EQU *-vv
                DC.W 0
volp            EQU *-vv
                DC.L 0
rauschp         EQU *-vv
                DC.L 0
mixp            EQU *-vv
                DC.L 0
mix             EQU *-vv
                DC.W 0
vibp            EQU *-vv
                DC.L 0
vibres          EQU *-vv
                DC.L 0
vibc            EQU *-vv
                DC.W 0
blubp           EQU *-vv
                DC.L 0
blubres         EQU *-vv
                DC.L 0
blubc           EQU *-vv
                DC.W 0
eff             EQU *-vv
                DC.W 0
effc            EQU *-vv
                DC.W 0
porta           EQU *-vv
                DC.W 0
poff            EQU *-vv
                DC.W 0
effset          EQU *-vv
                DC.W 0

vd1x:

vdat2:          DC.B 9,0,%00010010,0,2,3
                DS.B vd1x-vdat1
vdat3:          DC.B 10,0,%00100100,0,4,5
                DS.B vd1x-vdat1

                EVEN

iname           EQU 0
inr             EQU 9
iinf            EQU 8
irausch         EQU 10
ivol            EQU 42
ivib            EQU 75
ivibc           EQU 74
iblub           EQU 92
iblubc          EQU 91
imix            EQU 110
ieff            EQU 108
ieffc           EQU 109


                ENDPART
                PART 'main vars'

play:           DC.W 0
mspeed:         DC.W 5
speed:          DC.W 1
mixreg:         DC.W $FFFF
oldmix:         DC.W $FFFF
rreg:           DC.W 0

patp1:          DC.L 0,0
patp2:          DC.L 0,0
patp3:          DC.L 0,0

taktc:          DC.W 1
rept:           DC.W 0

songstart:      DC.L 0
aktsongp:       DC.L 0

splact:         DC.W 0
splp:           DC.L 0
splflag:        DC.W 0
digifx:         DC.W 0
splmask:        DC.W 0

reloflag:       DC.W 0

psgbuf:         DS.B 128

                ENDPART

mend:
********************************************************************************
                BSS
mem:            DS.B 64000
patlist:        DS.B 12*256
patmem:         DS.B 64*256
instlist:       DS.L 200
instmem:        DS.B 192*50
tracklist:      DS.B 6*30
trackmem:       DS.B 12*200*20
tsong:          DS.B 64*100
digilist:       DS.L 2*50+1
digimem:        DS.B 5*10000
                DS.L 256
stack:
fsel155:        DS.L 20                 ; organizer
fsel156:        DS.B 20*6*80            ; Grafik-Block, 1-planig
fsel157:        DS.L 4                  ; fr disk-space
fsel158:        DS.B 112*fsel2          ; Filenames
fsel159:

scrmem:         DS.B 50000
                END
