









                 |          |          |         |
                || |        |      |  || |     | |     |    |
            |  ///#||    |  |      |  || //#   //#     |  |//# |    |
    |       | //#//#|  | |  || |   || || //# | //#    || ||//# ||   |    |
   |||  |  || //####|///#|//#//#////# |////# | //# |  ////#////#|  ||  | ||
 __|||__|__||_#///#|//#//#//#//#//#//#//#//#_|_//#_|_//#//#//#//#__||__|_||____
      ||  |  ||##//#//#//#//#//#//#//#//#//#| |//#| |//#//#//#//#|   || |  |
      ||  |   //#//#//#//#//#//#//#//#//#//#| |//#| |//#//#//#//#    ||
       |      #///###///###///##//#//##////#| |/////##////#////##    |
              |####  #### |#### ###### #####|  ######|##########
               |     |     |    |||  |    |||   |   |   |
               |                 |        | |       |

                           Version 1.0  May 2, 1992

                              by Damien M. Jones































                                 dmj software
                                PSC 8  Box 657
                                 APO AE 09109








         Sound Lab 1.0                                         Page 2



         --- Copyright

         Sound Lab and this manual are Copyright 1992 Damien M. Jones,
         All Rights Reserved.  You may not modify this program in any
         way; however, you may copy it as you wish, provided all of
         the files listed in READTHIS.1ST are included.  You may not
         charge for these copies, except reasonable charges to cover
         the cost of the media it is distributed on (as in Public
         Domain/Shareware distributors).  This charge should not
         exceed $10.

         --- Shareware

         This program is Shareware.  If you like it and use it, please
         send $20 to the address on the front cover.  In return for
         registering you will receive a printed manual, information on
         how to use digitized sound in your own programs (GFA BASIC,
         C, and assembly), and free disk updates.  Updates to the
         manual (which usually occur only with major revisions) will
         be available for modest ($5 or less) cost.

         If you got this program through a Public Domain/Shareware
         distributor, you haven't paid for the program; you've just
         paid the distributor to put the program on a disk and send it
         to you.  Please show your support by registering.

         --- Disclaimer

         I am not in any way responsible for damage to your equipment,
         reputation, or mental or physical health caused by the use or
         misuse of this program.

         --- About This Manual

         The text for this manual was created entirely with ST Writer
         Elite 4.2.

         --- About the Program

         Sound Lab was written mostly in GFA BASIC (over 10,000
         lines), with the high-speed editing routines (almost 2,000
         lines) in assembly.  The graphics were designed with a custom
         paint program.

         --- Feedback

         It's always been my experience that the best improvements to
         software always come from its users.  My beta testers
         reinforced that belief.  So if you have any comments or
         questions, please let me know!












         Sound Lab 1.0                                         Page 3



         --- Table of Contents

         Introduction   .   .   .   .   .   .   .   .   .   .   .   4
             What Is Digitized Sound? .   .   .   .   .   .   .     4
             Using This Manual  .   .   .   .   .   .   .   .   .   5
         The Basics   .   .   .   .   .   .   .   .   .   .   .     6
             Installing Your Digitzer Cartridge .   .   .   .   .   6
             Loading (or Copying) Sound Lab   .   .   .   .   .     6
             The Main Screen    .   .   .   .   .   .   .   .   .   7
             "Help" and "Quit"    .   .   .   .   .   .   .   .     7
             Loading and Playing Sounds .   .   .   .   .   .   .   8
             File Formats .   .   .   .   .   .   .   .   .   .     9
             Recording Sounds   .   .   .   .   .   .   .   .   .  10
             Saving Sounds    .   .   .   .   .   .   .   .   .    10
         Blocks .   .   .   .   .   .   .   .   .   .   .   .   .  12
             Marking Blocks   .   .   .   .   .   .   .   .   .    12
             Playing and Recording a Block  .   .   .   .   .   .  12
             "Hide Blk", "Zoom In", and "Zoom Out"    .   .   .    12
             "Cut", "Copy", "Insert", and "Play Buf"    .   .   .  13
             "Remove" and "Trim"  .   .   .   .   .   .   .   .    15
             Looping    .   .   .   .   .   .   .   .   .   .   .  15
             "Overlay"    .   .   .   .   .   .   .   .   .   .    16
             Inserting or Overlaying a File .   .   .   .   .   .  17
             Loading or Saving the Buffer .   .   .   .   .   .    17
         Effects    .   .   .   .   .   .   .   .   .   .   .   .  18
             "Clear" and "Gap"    .   .   .   .   .   .   .   .    18
             "Volume"   .   .   .   .   .   .   .   .   .   .   .  18
             "Fade"   .   .   .   .   .   .   .   .   .   .   .    19
             "Echo" .   .   .   .   .   .   .   .   .   .   .   .  20
             "Reverse"    .   .   .   .   .   .   .   .   .   .    20
             "Convert"  .   .   .   .   .   .   .   .   .   .   .  20
         Menus    .   .   .   .   .   .   .   .   .   .   .   .    22
             /Info/ .   .   .   .   .   .   .   .   .   .   .   .  22
             /Rename File/    .   .   .   .   .   .   .   .   .    22
             /Delete File(s)/   .   .   .   .   .   .   .   .   .  22
             /Create Folder/  .   .   .   .   .   .   .   .   .    22
             /Remove Folder/    .   .   .   .   .   .   .   .   .  23
             /Free Space/ .   .   .   .   .   .   .   .   .   .    23
             /Format Disk/  .   .   .   .   .   .   .   .   .   .  23
             /Quit/   .   .   .   .   .   .   .   .   .   .   .    23
         Tips for Using Sound Lab   .   .   .   .   .   .   .   .  24
             Moving Dialogs   .   .   .   .   .   .   .   .   .    24
             Bypassing the Title Screen .   .   .   .   .   .   .  24
             Choosing a Sampling Rate .   .   .   .   .   .   .    24
             "High Bit" .   .   .   .   .   .   .   .   .   .   .  24
             Loading and Saving Blocks - Partial Files    .   .    25
             Loading .BAK Files .   .   .   .   .   .   .   .   .  26
             Echo Effects .   .   .   .   .   .   .   .   .   .    26
             Background Sounds  .   .   .   .   .   .   .   .   .  26
             Preferences  .   .   .   .   .   .   .   .   .   .    27
         Using the _Fileselector_   .   .   .   .   .   .   .   .  29
         If Something Goes Wrong...   .   .   .   .   .   .   .    32
         Quick Reference & Keyboard Shortcuts   .   .   .   .   .  34
         Index    .   .   .   .   .   .   .   .   .   .   .   .    40








         Sound Lab 1.0                                         Page 4



         -------- Introduction

         Digitized sound: you've undoubtedly heard it.  These days you
         can find digitized sound in games, demos, and even music.
         It's the only way to twist the ST's sound chip into producing
         more than three limited tones.  If you're not interested in
         how digitized sound works (or if you already know) then
         please skip this next section.

         --- What is Digitized Sound?

         Before explaining digitized sound, let me explain how a
         speaker works.  As the electric current provided to the
         speaker changes, the speaker itself moves in and out.  This
         movement makes the air next to the speaker move as well,
         creating sound waves that we can actually hear.  Computers,
         however, don't record things (like the current provided to a
         speaker) in a steady stream.  They handle things in a digital
         fashion--lots of little bits that, when put together, make up
         the whole.  Whereas an analog tape records the current to the
         speaker in a continuous wave, digitized sound records the
         current many times per second.  The more times per second you
         record the current, the better your approximation of the
         actual sound wave.  Compact discs work like that; they record
         the current 44250 times per second; this is so fast (and so
         precise) that it sounds even better than audio tape (which is
         an analog recording).

         The quality of digitized sound is measured in three ways:
         sampling rate, resolution, and the number of channels.
         Sampling rate refers to how often you sample--or record--the
         current applied to the speaker.  This is usually specified in
         Hz (times per second) or KHz (how many thousands of times per
         second).  Thus a CD has a sampling rate of 44250Hz, or
         44.25KHz.  Usually a sampling rate of 7.5KHz to 10KHz is
         adequate; 20KHz can be used for exceptionally high quality.

         The second way to measure the quality of digitized sound is
         resolution.  This refers to how precisely the current to the
         speaker is measured.  A CD has a resolution of 16 bits--the
         current has 65,536 possible values.  A home computer (as in
         the ST) usually uses 8-bit resolution, measuring the same
         range of current as a CD, but with only 256 values.  You'd be
         hard-pressed to tell the difference in most sounds.

         The third way to measure sound quality is the number of
         channels.  This is simply how many sounds are played
         simultaneously.  Compact discs are in stereo--two channels
         (like the STe).  Most digitized sound is mono--one channel,
         although this is beginning to change.

         Now that you know basically how digitized sound works, let me
         explain what Sound Lab is capable of.  You can record and
         playback at sampling rates from 4.9KHz to 30.72KHz, on a








         Sound Lab 1.0                                         Page 5



         single (mono) channel at 8-bit resolution.  This is perfectly
         sufficient for use on the ST.

         --- Using This Manual

         Sound Lab makes extensive use of the mouse, alerts, dialogs,
         and menus.  Throughout this manual, buttons will always be
         referred to like this: "Button".  Dialogs will always be
         referred to like this: _Dialog_.  Menu items will be referred
         to like this: /Menu/.  The manual has been organized as a
         tutorial; you should be able to read it straight through.
         For help with a specific item, use the Table of Contents or
         the Index to find it.

















































         Sound Lab 1.0                                         Page 6



         -------- The Basics

         This section will get you started using Sound Lab.  It covers
         installing cartridges, loading and copying Sound Lab, the
         main screen, loading and playing sounds, file formats,
         recording sounds, and saving sounds.

         --- Installing Your Digitizer

         What?  You don't have a sound digitizer?  Well, go get one!
         This software works with both the ST Replay cartridge and
         Pandaal's DaataSound cartridge.  Others have not been
         tested.

         To install your cartridge, turn your ST off.  Insert your
         cartridge into the ST's cartridge port, label side up.  It
         should go in firmly.  When fully inserted, turn your ST back
         on.  You can connect the input jack (the only jack on the
         DaataSound) to the output of any small sound source--the
         headphone jack of a portable cassette recorder or CD player
         are good examples.  Unless you want to see smoke curling from
         the innards of your computer, you should never connect the
         input jack to the high-power output of a stereo or other
         amplifier; doing so may damage your stereo, digitizer, and
         ST.  To remove your cartridge (which may be necessary on
         occasion) just turn off your ST, gently pull the cartridge
         straight out (don't wiggle it) and turn your ST back on.
         UNDER NO CIRCUMSTANCES SHOULD YOU INSERT OR REMOVE YOUR
         CARTRIDGE WITH THE ST'S POWER ON.  Doing so can very, very
         easily damage your ST, as well as the cartridge.  For further
         information, consult the instructions for your cartridge.

         --- Loading (or Copying) Sound Lab

         There's nothing really to this.  Just double-click on
         SOUNDLAB.TOS from any ST resolution.  If you want to copy
         Sound Lab to another folder (as in, on your hard drive)
         you'll need not only SOUNDLAB.TOS but also these files:

         SOUNDLAB.COL   Dialog information for MEDIUM resolution.  If
                        you want to run the program using a color
                        monitor, you'll need this file.  (Sound Lab
                        switches to medium res if run from low res.)

         SOUNDLAB.MON   Dialog information for HIGH resolution.  If
                        you want to run the program using a monochrome
                        monitor, you'll need this file.

         SOUNDLAB.HLP   The help file.  If it's not present, there
                        will be no online help.

         SOUNDLAB.PRF   This is the preferences file; without it, all
                        of Sound Lab's options will be reset to the
                        default settings.








         Sound Lab 1.0                                         Page 7



         If there isn't enough memory for Sound Lab to run, or if it
         can't find the appropriate data file for the resolution
         you're in, it will tell you what went wrong and then exit to
         the Desktop.  If nothing goes wrong, the program will load
         and display the title screen.  Press any key, and you're
         ready to begin.

         It is possible to put Sound Lab in an AUTO folder.  If you're
         using a 512K machine, this is recommended, since it will give
         you more memory for using samples.  To run Sound Lab from an
         AUTO folder, rename SOUNDLAB.TOS to SOUNDLAB.PRG and copy it
         into the AUTO folder.  You can put any other things in there
         that you want, but remember that you must put them in before
         you put SOUNDLAB.PRG in, or they won't run until after you
         exit Sound Lab.  Also remember that other AUTO folder
         programs will probably consume valuable memory.  All the
         other files (.COL, .MON, .HLP, and .PRF) should go in the
         root directory.  To run Sound Lab, just boot the disk.

         If you use Sound Lab with a monochrome monitor, you obviously
         won't see any of the colors described in the manual.  Light
         blue on a color monitor corresponds to medium grey on a
         monochrome monitor; dark blue shows as dark grey.

         --- The Main Screen

         At this point (program loaded, ready to use) I'll give you a
         tour of the screen, since there's quite a bit here.  At the
         top you'll see the program's name, version, and completion
         date.  You'll also see, over to the right, the "Memory size";
         this is just how big Sound Lab's area for editing samples is.
         Below this title area is a large window, covering about
         three-fourths of the screen.  In the title bar you will see
         some information.  Inside the window you'll see a black line
         across the middle; this is where you can see a visual
         representation of the sample.  The bottom border of the
         window has a slider, used to move around the sample.  Below
         the window are twenty-four buttons, which are your main
         control panel for using Sound Lab.

         --- "Help" and "Quit"

         Of the twenty-four buttons at the bottom of the main screen,
         two are very important.  The first is "Help", the top button
         on the far right.  You can either click this or press the
         HELP key to access the online help; should the online help
         fail to give you the information you want (which it
         shouldn't), you can always refer to the manual.  You can
         press HELP anywhere.

         The other important button is "Quit", the bottom button in
         the right-most column.  Select this to exit the program.
         You'll be asked if you're sure; if you are, click "Yes", or
         click "No" if you've changed your mind.








         Sound Lab 1.0                                         Page 8



         You can also find the "Quit" option in the menus.  To access
         the menus, just move the mouse pointer into the "Sound Lab"
         box at the top left of the screen.  The menus will appear
         under the mouse.  You'll find Quit at the bottom of the
         File/Disk menu.  Please note that if you have any desk
         accessories loaded, you will not be able to access them;
         Sound Lab is a TOS program (I bet you forgot that) and
         accessories only work from GEM (.PRG) programs.

         From here on, click on all buttons with the left mouse
         button, unless specifically told to do otherwise.  Some of
         the buttons at the bottom of the screen have dual purposes.
         To see the names of those buttons, move the mouse to the very
         bottom of the screen, so it's not over any of the buttons.
         Then hold down the right mouse buttons.  You'll see several
         of the buttons change.  These are the functions that are
         accessed with the right mouse button.  Use it just like you
         would the left.

         --- Loading and Playing Samples

         Digitized sound is what Sound Lab is all about, so it
         wouldn't hurt to know how to load some samples in.  To load a
         sample into Sound Lab, click on "Load" (seventh column).  The
         _Fileselector_ dialog will appear, allowing you to select a
         sample to load.  You can load .SPL, .SAM, and .AVR files into
         Sound Lab.  (Only these types will appear in the
         _Fileselector_.)  Just click on the sample you want, then
         click on "Okay", or double-click on the filename.  (See the
         _Fileselector_ section for more help; see the File Formats
         section for more information about the different file
         types.)

         Once the sample is loaded, you'll see several things change.
         First, the sample window's title bar will change to show you
         information about the file you've just loaded.  The name will
         change, as will the file size, offset, zoom level, speed, and
         block size.  You'll also see the sample displayed in the
         window.

         Now that it's loaded, let's make sure it's at the correct
         speed.  If you loaded an .AVR type file, Sound Lab will
         automatically change the speed for you.  The other file
         types, .SAM and .SPL, don't tell the proper speed of the
         sample, so you have to guess.  Click on "Speed" (second
         column).  A dialog will appear with a large number of
         buttons: eleven with numbers, four labeled "x2", "x", "Tone
         Up", and "Tone Down", and four more labeled "Convert",
         "Play", "Okay", and "Cancel".  Between the top set of buttons
         and the bottom set is a slider and a text field.

         The text field in this dialog shows the current speed, in
         KHz.  You can change this speed in many ways; the easiest to
         click on one of the eleven preset speed buttons.  These








         Sound Lab 1.0                                         Page 9



         include some ST Replay 4 speeds, some Macintosh speeds, and
         some STe speeds.  You can double or halve the speed by
         clicking on the "x2" or "x" buttons.  With the "Tone Up" and
         "Tone Down" buttons, you can change the speed to the next
         musical tone up or down.  You can adjust the speed with the
         slider, or you can enter the speed you want directly into the
         text field.

         The digitized sound routines used by Sound Lab (and most
         every other sample editor or player) use the timers built
         into the ST.  Because of this, not every speed can be used.
         Sound Lab will automatically round off any speed you enter to
         the nearest speed available.  Also, Sound Lab only allows
         speeds from 4.915KHz to 30.72KHz.

         After setting your speed, you can click on the "Play" button
         inside the dialog to hear the sample at the new speed.  You
         can either wait for it to finish by itself, or press the
         space bar or mouse button to stop the sound early.  If you
         want to keep the new speed, click on "Okay"; otherwise you
         can click on "Cancel".  Don't worry about the "Convert"
         button for now.

         Well, the speed has been set.  You can now use the "Play"
         button on the main screen to play the sound, if you want.
         You can use the space bar or mouse button here as well to
         stop the sound.  If you do stop it early, a flashing vertical
         bar will show you where it stopped (this will be handy
         later).  The bar will disappear as soon as you click on
         another button, press a key to activate another button, or
         select a menu item.

         --- File Formats

         Sound Lab recognizes three types of digitized sound files.
         They are .AVR, .SPL, and .SAM.

         The .AVR file type is the kind used by the newer ST Replay
         software.  If you want to save the speed of the sound, as
         well as any looping information (more on that later), you'll
         need to save in .AVR format, as only this type of file
         records that information.  For the same reason, Sound Lab
         also sets this information when you load an .AVR file.
         Usually you will use .AVR format files when loading or
         saving.

         The .SPL file type is called "raw data".  It contains only
         the sound, the whole sound, and nothing but the sound.  This
         is a good format if you know the speed of the sound, and you
         want to include it in your own programs.

         The last type, .SAM, is similar to .SPL.  The difference is
         that .SAM is signed data, whereas .SPL is unsigned.  Signed
         data is stored as a series of bytes, ranging from -128 to








         Sound Lab 1.0                                         Page 10



         127.  Unsigned data records the same information in the range
         0 to 255.  If you're not sure which to use, just try one; if
         the sample ends up sounding very noisy, use the other.

         --- Recording Samples

         If you have a digitizer cartridge, this section will tell you
         how to use Sound Lab to record sounds from it.  It's not
         difficult at all.

         First of all, you need to insure that the volume is properly
         adjusted.  Click on "Monitor" (first column).  You'll see a
         moving display right over the sample window.  Adjust the
         volume on your sound source so that the display shows strong
         movement, but isn't clipped much at the top or bottom of the
         display.  Clipped points will stick briefly to the top and
         bottom of the display, making it easy to see when clipping
         occurs.  A little clipping is all right, but a lot of
         clipping will result in distorted sounds.  Press any key or
         mouse button to exit Monitor.

         If you want to hear the quality of your sound before
         recording it, click on "Monitor" with the RIGHT mouse button;
         you'll see it change to "Listen", which will then begin.  Now
         you'll be able to hear exactly what the digitized sound would
         be like, without having to actually record anything.  This is
         a good way to find out which speed to record at.  Press the
         space bar or mouse button to exit Listen.

         What you're really interested in, though, is recording sound.
         To do this, click on the "Record" (first column) button.  An
         alert will appear, asking whether to wait for the sound,
         start recording, or cancel.  Selecting "Wait" will cause
         Sound Lab to wait for an incoming sound before beginning to
         record.  The mouse pointer will flash while Sound Lab is
         waiting for a sound.  Selecting "Start" will start recording
         right away.  "Cancel" will abort the record.  Recording,
         naturally enough, erases the previous sample.  It's like
         recording over an old audio tape.  Sound Lab will stop
         recording as soon as the sound fills up the memory; how
         quickly this happens depends on your selected speed and the
         amount of memory you have.  You can also stop the recording
         by pressing the space bar or mouse button.

         You'll hear the sound while it's being recorded, as with
         Listen.  For some help on choosing a sampling rate to record
         at, see the Tips section.

         --- Saving Sounds

         After recording a sound, you'll probably want to save it.
         This is simple.  Just click on "Save" (seventh column) and
         the _Fileselector_ will appear.  Enter the filename you want
         to use for your file, and click on "Okay".  "Cancel" will, of








         Sound Lab 1.0                                         Page 11



         course, abort the save.

         If nothing went wrong, your file will be saved to disk.
         There are three very simple things that might go wrong, but
         aren't really a big deal.  The first thing that might go
         wrong is that the disk is full.  Since samples can get very
         large, this can happen a lot; if it does, you'll have to use
         another disk.  If you don't have another formatted disk
         handy, see the Format Disk section for information on how to
         format a disk.

         The second thing that might go wrong is that you might have
         left the write-protect tab in the wrong place.  You can't
         save to a disk that's write-protected; either select "Cancel"
         from the alert, or fix the problem and select "Retry".

         The third thing that might go wrong is that you tried to save
         your sample with a name that's already being used.  The alert
         that appears will give you three options: "Erase", "Rename",
         and "Cancel".  The first option, "Erase", simply erases the
         old file and saves your new file with that name.  The second
         option, "Rename", is a bit more complicated; it renames the
         old file so that it ends in .BAK (erasing any file that had
         the .BAK name), and then saves your file with the name you
         requested.  An example will make this clearer; if you try to
         save MCHAMMER.AVR, and there is already an MCHAMMER.AVR on
         the disk, the alert will appear; you select "Rename".  The
         MCHAMMER.AVR on the disk is renamed to MCHAMMER.BAK, and any
         MCHAMMER.BAK that was there is erased.  Then your new sound
         is saved as MCHAMMER.AVR.  Keep in mind that since samples
         can be very large, you can run out of room _very_ quickly if
         you keep a lot of backup (.BAK) files, even if you're using a
         hard drive.  The "Cancel" button from the alert cancels the
         save, of course.




























         Sound Lab 1.0                                         Page 12



         -------- Blocks

         Sound Lab is more than just a sound loader, player, recorder,
         and saver.  It's also a sound editor.  You can cut and paste
         sections of sound much like you would cut and paste text in a
         word processor; you can also do much more.

         --- Marking Blocks

         In order to do anything with your sound, you must tell Sound
         Lab which part of the sound to use.  To do this, you will
         need to mark off a block of the sound.  This is really quite
         easy to do.  First, load up a sound.  Then move the mouse
         pointer into the sample window, right over the sample.  Click
         the left mouse button.  All of the sound to the left of where
         you clicked has now turned light blue; the remainder, to the
         right, has stayed black.  The black part of the sample is
         your block; what you've just done is to position the left
         block marker with the left mouse button.  Logically enough,
         you position the right block marker with the right mouse
         button.  Just click the right button with the mouse pointer
         somewhere between your left block marker (the boundary
         between the light blue and black sample) and the right edge
         of the screen.  Voila!  You now have a small block marked.

         You've probably noticed that a vertical bar appears while
         you're holding down the mouse button.  This bar will follow
         the mouse pointer as long as the pointer is inside the sample
         window.  This can help you position the block markers more
         accurately.

         --- Playing and Recording a Block

         Just about every single function that does anything in Sound
         Lab only works on the currently marked block.  "Play" and
         "Record" are no exceptions.  After marking off a block, click
         on "Play".  Notice that you only hear the part you've marked?
         This makes it very easy to isolate a particular sound from a
         longer sound.  "Record" works the same way--it will only
         record over the section of block that you have marked.

         --- "Hide Blk", "Zoom In", and "Zoom Out"

         Although blocks are very useful (you'll find out just how
         useful shortly), marking them can be a nuisance.  So these
         three buttons have been included to make things simpler.

         The first button, "Hide Blk" (third column), simply
         repositions your block markers at the beginning and end of
         the entire sample.  After clicking on it, you'll notice that
         it seems to stick in place; if you click on it again, it will
         come unstuck, and restore your block markers to their
         previous positions.









         Sound Lab 1.0                                         Page 13



         The other buttons, "Zoom In" and "Zoom Out" (second column),
         change the magnification of the sample in the window.
         Normally, the magnification is set to "Max", which means the
         entire sample is displayed in the window, regardless of its
         size.  With large samples, this can make the accurate
         positioning of the block markers difficult.  "Zoom In" comes
         to the rescue; just click on it.  Now you've switched to 16x
         magnification, in which each pixel across the screen
         represents 16 bytes of digitized sound.  The slider at the
         bottom of the screen will now change to reflect how much of
         the sample is actually being displayed; you can move it
         around, and the screen will display the corresponding portion
         of your sample.  You can click "Zoom In" again, to zoom in to
         8x; then again, to 4x, and then 2x and 1x, in which each
         pixel on the screen represents exactly one byte of digitized
         sound.  You can click "Zoom Out" again to back out a zoom
         level.

         At the very bottom of the window, just above the slider,
         you'll notice that a very thin line changes as you mark your
         blocks.  It starts out as a solid white line, but after
         marking a block, the white portion shrinks--roughly to the
         same place on the screen as your block markers!  This white
         line shows you how much of your sample has been marked as
         your block.  It's sized to match the slider right below it.
         When you're at maximum magnification, it's not needed, since
         you can always see both ends of your block.  When you start
         zooming in, though, you won't always be able to see your
         block markers; you can use that thin line as a guide to
         positioning the slider.  That way, you can use maximum
         magnification to quickly place your block markers in the
         general area you want them; then zoom in, move the slider,
         and fine-tune your positioning.

         Zooming in and out all the time can get repetitive.  Usually
         1x is the best for positioning block markers, but you have to
         hit "Zoom In" five times (with a reasonably large sample) to
         get to it!  That's where "Min Zoom" and "Max Zoom" come in.
         You've probably noticed that those buttons don't appear at
         the bottom of the screen.  That's because you need to use the
         right mouse button to get to them.  They're "under" the "Zoom
         In" and "Zoom Out" buttons; just click on "Zoom In" with the
         right mouse button, and it will change to "Min Zoom".  This
         will take you to 1x magnification, without seeing any of the
         in-between zoom levels.  Using the same technique, click on
         "Zoom Out" with the right button to get "Max Zoom", which
         takes you back to maximum magnification.

         --- "Cut", "Copy", and "Insert"

         Now that you know how to mark blocks, let's do something with
         them.  Your basic block functions are "Cut", "Copy", and
         "Insert".









         Sound Lab 1.0                                         Page 14



         "Cut" takes your block out of the sample and stores it in the
         buffer.  This buffer is a section of memory marked off for
         blocks that have been cut and copied; for the rest of these
         instructions, it will always be called the buffer.

         Once "Cut" has taken out your block, the rest of your sample
         is moved down to fill in the gap.  An example should make
         this completely clear.  Let's say you have a sample of George
         Bush saying "Read my lips."  You set your block markers so
         that only "my" is marked.  Click on "Cut".  That chunk of
         sound has just disappeared!  Click on "Hide Blk" so that the
         entire sample is marked; now click on "Play".  George Bush
         now says "Read lips."

         The "Copy" button works very similarly to the "Cut" button.
         It also copies your block into the buffer, but unlike "Cut",
         it does not remove the block from the sample.  Since it
         doesn't remove the block, it is possible that you won't have
         enough memory to make a copy of the block.  If this happens,
         an alert will appear to tell you.

         Once you have a block stored in the buffer, you can then
         "Insert" it.  That will take the block and insert it where
         your left block marker is.  Going back to our George Bush
         example, let's say your block is "my".  You "Copy" the block
         to the buffer, and then "Insert" it.  Your left block marker
         was still before "my", so when you insert "my", George Bush
         says "Read my my lips."  I had no idea he had a stuttering
         problem.

         As with "Copy", it is possible that you don't have enough
         memory for an "Insert".  When this happens, an alert will
         appear, giving you four options.  Before explaining them, let
         me explain that the buffer, where cut or copied blocks are
         stored, is the last part of the memory area.  If you have a
         memory size of 400K, then you can have up to 400K of
         digitized sound in memory.  If you load a 200K sample into
         memory, that leaves 200K for cutting and copying blocks.  And
         if you were to cut a 20K chunk from that 200K sample, it
         would be stored in the _last_ 20K of the memory.  That
         explained, the options presented when you have insufficient
         memory for an "Insert" are "Lose Sample", "Lose Buffer",
         "Insert to Fit", and "Cancel".  "Lose Sample" means that the
         entire buffer will be inserted, but the end of your sample
         (whatever doesn't fit) will be lost.  "Lose Buffer" means
         that the entire buffer will be inserted, and all of your
         sound will be saved, but the start of the sample in the
         buffer will be lost.  "Insert to Fit" will insert as much of
         the buffer as will fit without losing the buffer.  "Cancel",
         of course, aborts the "Insert".

         Phew!  I realize that took a bit of explaining, but hopefully
         it's much better than having Sound Lab say "Insufficient
         Memory for Insert" and then do nothing.








         Sound Lab 1.0                                         Page 15



         After cutting or copying a block into the buffer, you may
         want to play the buffer again, to remind yourself what's in
         there.  To do this, click on "Play" with the right mouse
         button.  You'll see it change to "Play Buf", and the buffer
         will be played, instead of the block.

         --- "Remove" and "Trim"

         These are two buttons you may find useful.  They are both in
         the fifth column, but "Trim" is "under" the "Remove" button;
         by this, I mean you use the right mouse button to select it,
         instead of the left.

         "Remove" is very similar to "Cut".  The only difference is
         that the block is not stored in the buffer; it's just removed
         from the sample.  This is much faster, since then Sound Lab
         doesn't have to rearrange the data.  Since this can't be
         undone, you will be asked if you are sure.

         "Trim" is a special function, useful after a sound has been
         recorded.  Often you'll find "pops" at the beginning and end
         of sounds.  Using "Cut" or "Remove" to get rid of them would
         require that you isolate the pops, by carefully positioning
         the block markers, and cutting them out.  Instead, you can
         position the block markers around the sound you want to keep.
         Then click on "Trim" (by clicking on "Remove" with the right
         mouse button) and everything before and after your marked
         block will disappear.  Since this, like "Remove", cannot be
         undone, you will be asked if you are sure.

         --- Looping

         Looping is a very useful technique when you use digitized
         sound in music.  What it does is let you choose a part of
         your sample to play repeatedly.  So if you had a short sample
         of some stringed instruments playing a single note, you could
         loop the last part of the sound, so that they seemed to play
         the note forever.  Looping is most useful in this fashion.

         To loop a portion of your sound, mark the part you want to
         loop with the block markers.  Then click on "Loop" (fifth
         column).  An alert will appear, with four options: "Set
         Loop", "Reset Block", "Loop On/Off", and "Cancel".  "Set
         Loop" is the one you want, as this will set the loop to your
         current block markers.  You'll see your loop segment framed
         in a dark blue box.  Click on "Play" to hear the looped
         sample.  (While looping is on, the entire sample will be
         played, with looping; your block markers are ignored during
         "Play".)

         More than likely you will need to adjust your loop to remove
         the "pops" when the sample loops.  Just move your pointers
         and click on "Loop" again.  Select "Set Loop" again.









         Sound Lab 1.0                                         Page 16



         The other options have other uses.  "Reset Block" will move
         your block markers to the current loop settings; that way,
         you can mark other blocks, edit more sound, and still be able
         to go back to adjust your loop easily.  "Loop On/Off" will
         turn looping on or off, without changing where the loop or
         block markers are.  ("Set Loop" and "Reset Block" both turn
         looping on automatically.)  "Cancel" will do nothing.

         If you want to save the looping information with your sample,
         you will need to save in .AVR format, as only this format
         saves the looping information.

         --- "Overlay"

         Overlaying is a technique used to superimpose one sample over
         another.  You can use "Overlay" to take the sample stored in
         the buffer and overlay it onto the block.  To do this, just
         click on "Overlay" (fourth column).  And don't panic when you
         see the dialog.

         Despite its imposing look, the _Overlay_ dialog isn't that
         bad.  At the top you will see the dialog's title; directly
         underneath is a large white box, showing you some waves.  On
         the left and right sides of this box are two sliders.
         Underneath the box are two text fields, labeled "Block
         Volume" and "Buffer Volume", and four buttons labeled
         "Length".  These are "Block", "Buffer", "Longer", and
         "Shorter".  At the bottom are two buttons labeled "Repeat
         Buffer", called "Yes" and "No", and two other buttons, "Okay"
         and "Cancel".

         The large white box is the "Preview" box.  This shows you
         some waves to give you a general idea of what will happen in
         the overlay.  The light blue wave is your block, and the dark
         blue wave is your buffer.  The black wave is the final result
         of the Overlay.  These waves are not your actual sample, just
         representations for your convenience.

         When you overlay two samples, you can adjust the volume of
         each.  Normally you'll want both at full volume, but this can
         sometimes cause distortions in the final sound, especially if
         you start with loud samples.  In this case, you should lower
         the volume for each sample.  Use the left slider to change
         the volume of the block; use the right slider to change the
         volume of the buffer.  Note that you can also enter the
         numbers in the text fields directly.  Also note that whenever
         you change the volumes, the Preview box is redrawn, allowing
         you to see the change.

         Underneath the box you'll see the four "Length" buttons.
         These let you choose how much to overlay.  "Block" uses the
         block's length, "Buffer" uses the buffer's length, and
         "Longer" and "Shorter" use the longer or shorter sample.
         This way you don't have to worry about making your block the








         Sound Lab 1.0                                         Page 17



         same size as the buffer.

         Below the "Length" buttons is "Repeat".  If you use the
         "Block" as the length (or if you choose "Longer", and that
         ends up being the block), Sound Lab may run out of buffer
         sample before finishing the Overlay.  Sound Lab gives you the
         option of starting over on the buffer (setting "Repeat" to
         "Yes") or using silence (setting "Repeat" to "No").

         Once you've set your options, click on "Okay", and the
         overlay will be done.  Clicking on "Cancel" will abort the
         Overlay.  Overlays may take as much as ten seconds with long
         samples.

         --- Inserting or Overlaying a File

         Many times you will wish to insert or overlay a sound, and
         that sound isn't in memory.  You can load it into the buffer
         and do it (see the next section), but you can also insert or
         overlay right from the file.  To do this, click on "Insert"
         or "Overlay" with the right mouse button.  The buttons will
         change to "Ins File" and "Ovly File".  A fileselector will
         appear, allowing you to choose the file you want to use.
         What happens next depends on which button you used.

         If you clicked on "Ins File", the insert will proceed as
         though you had the file in the buffer.  You might not have
         enough memory, so the same options as "Insert" will apply.
         If the file you insert is an .AVR type, and it's not at the
         same sampling rate as the rest of your sample, Sound Lab will
         ask you if you want to convert it.

         If you clicked on "Ovly File", the _Overlay_ dialog will
         appear.  The entire file will be read when you click on
         "Okay", to overlay it.  Everything else will proceed like a
         normal overlay.

         --- Loading or Saving the Buffer

         You can load or save directly to the buffer.  To do this,
         just click on "Load" or "Save" with the right mouse button;
         the buttons will change to "Load Buf" and "Save Buf".  Then
         select the file you want to load or save to.  Remember that
         you can play the buffer by clicking on "Play Buf" (under
         "Play").

















         Sound Lab 1.0                                         Page 18



         -------- Effects

         In addition to editing sounds, Sound Lab lets you modify the
         sound itself.  These are called Effects.  They let you add
         spice to your sounds.  Remember, though, that these functions
         modify the sound information itself.  Except where noted, you
         _cannot_ undo these functions.  Always save your sample
         before adding an effect, so that you can reload it if the
         effect doesn't sound right.  Also, effects only change the
         part of your sample that is marked as your block.

         --- "Clear" and "Gap"

         "Clear" (fourth column) lets you clear samples from memory.
         When you click on "Clear", an alert will appear with four
         options in it.  They are "Block", "Buffer", "Everything", and
         "Cancel".  "Block" will clear the sample between the block
         markers, replacing it with silence.  "Buffer" will erase any
         sample you have stored in the buffer.  "Everything" means
         just that--selecting this will erase everything in memory.
         "Cancel", of course, aborts the operation.

         "Gap", which is under "Clear", can be used to insert a gap
         into your sound.  To use this, set the left block marker at
         the point where you want to insert the gap.  Then use the
         right marker to show how big a gap you want; the size of the
         gap will be the same as the size of your block.  Then click
         on "Gap".  If there isn't enough memory to insert the gap,
         you'll get the same options as for "Insert".

         Something special happens when you select "Gap" and the left
         block marker is at the end of your sample.  As much memory as
         is available will be added to the end of your sound; you
         should then mark how much you want to keep (including the
         original portion of the sample) and select "Trim".  This way
         you can make a sample longer, leaving blank space at the end
         for echoes.  To use this, switch to Max zoom, move the mouse
         pointer all the way to the right side of the screen, inside
         the sample window; then click the left mouse button.  Then
         click on "Gap".  All of the remaining memory will then be
         added to your sound.

         --- "Volume"

         This incredibly useful effect allows you to change the
         overall volume of a sound.  First mark off which section of
         the sound you want to change; then click on "Volume" (fifth
         column).  A dialog will appear, similar to the _Overlay_
         dialog, but not as complicated.  At the top is the same
         Preview box, but only one slider, on the right side of the
         Preview box.  Also, the Preview box contains a sample, not a
         wave.  Below is a single text field labeled "Amplify", and
         three buttons: "Play", "Okay", and "Cancel".









         Sound Lab 1.0                                         Page 19



         Use the slider on the right to adjust the amplification.
         "Amplify" of 1 means keep the same volume; 0.5 is half
         volume, and 2 is double volume.  As you change the volume
         with the slider, you'll see the Preview box change as well.
         The light blue sample is your original sound; the black
         sample is the sound with the volume change.  Don't forget
         that you can also enter the volume change directly into the
         text field.  If you want to hear the volume change, click on
         the "Play" button; "Okay" confirms the change, and "Cancel"
         aborts it.

         After clicking on "Okay", the change will be made to the
         sample.  With large samples (over 500K) this may take more
         than five seconds, so don't panic.

         One thing to be careful about is boosting the volume too
         high.  It's always a good idea to pretest the volume change
         with the "Play" button; when you boost the volume (especially
         more than double) you introduce some distortion to the sound,
         and using the "Play" button lets you hear that distortion
         before you put it into your sample.

         --- "Fade"

         This effect allows you to fade the sample in or out.  To use
         it, mark off the part of the block you want to fade.  Then
         click on "Fade" (sixth column).  Another large dialog
         appears, similar to _Volume_ and _Overlay_.  It has the
         preview box, sliders to the left and right, two text fields
         labeled "Start" and "End", and six buttons: "Shape", "Play",
         "Fade In", "Fade Out", "Okay", and "Cancel".

         Basically, this dialog lets you set the beginning and ending
         volume of the fade.  The slider on the left sets the start
         volume, and the slider on the right sets the end volume.  You
         can also enter the volume directly.  Clicking on the "Fade
         In" or "Fade Out" buttons will reset the values to those
         defaults.  "Okay" confirms the fade, and "Cancel" aborts it.
         The "Play" button lets you hear the fade before making it
         final, and the "Shape" button brings up a small dialog,
         allowing you to choose the shape of the fade (flat line,
         curve opening up, curve opening down, or S-curve).

         With the _Fade_ dialog, you'll see an extra item in the
         preview box--a light blue line showing you the fade
         boundaries.  It's hard to express in words, but when you see
         it, it will be quite obvious what it's for.  This also shows
         you the difference between the different fade shapes.

         As with volume, large samples take time to fade--about the
         same amount of time as volume.











         Sound Lab 1.0                                         Page 20



         --- "Echo"

         Echo effects add depth to sound.  They make samples sound
         like they're in a place, rather than in a sound room.  Sound
         Lab allows you a great deal of control over echo effects.

         As with the other effects, you need to mark off your block
         first.  Then click on "Echo" (sixth column).  A dialog will
         appear, containing three slider/text field pairs, labeled
         "Echo Fade Rate", "Echo Spacing", and "Maximum Echoes".  At
         the bottom are four buttons labeled "Load", "Save", "Okay",
         and "Cancel".  (Echo is too complicated to "Play" before
         making the change final.)

         The three sliders and text fields allow you to set the echo.
         The first, "Echo Fade Rate", refers to the volume of each
         echo.  A value of 0.5 (the default) causes each echo to be
         half the volume of the previous one.  The second item, "Echo
         Spacing", refers to how far apart (in seconds) the echoes
         are.  The last item, "Maximum Echoes", simply specifies the
         number of echoes to add.

         The bottom four buttons are in two groups.  In the first
         group are "Load" and "Save"; these two buttons allow you to
         load and save the settings in the _Echo_ dialog from or to an
         .EKO file.  Use the _Fileselector_ to specify the file.  The
         other two, "Okay" and "Cancel", confirm or abort the adding
         of echoes.

         Echo is a complicated function.  Don't be surprised if large
         samples take about twenty seconds to do.

         --- "Reverse"

         "Reverse" (sixth column) simply takes your marked sample and
         reverses it, so that when you use "Play", it will sound
         backwards.  This is a very fast option--even large samples
         can take less than three seconds.  If you don't like the
         reversed sound, you can reverse it again, thereby restoring
         your original sample.

         --- "Convert"

         This is not an effect, really.  It's the "Convert" button in
         the _Speed_ dialog.  To use this, just use the _Speed_ dialog
         to set the new speed for the sample; then click on "Convert".
         An alert will appear, telling you the old speed and the new
         speed, and asking you to confirm the conversion.  Click on
         "Okay" to begin the conversion, "Cancel" to abort.

         If you clicked on "Okay", the conversion will begin.  Sound
         Lab uses two techniques to convert samples to different
         sampling rates: "infinite oversampling", and linear
         interpolation.  When you convert to a slower speed, Sound Lab








         Sound Lab 1.0                                         Page 21



         uses the "infinite oversampling" technique to preserve as
         much of the original sound data as possible, as slower speeds
         have less information.  Higher speeds, though, require more
         information; the linear interpolation technique is then used
         to try to "fill in" the missing data.  These two techniques
         have two things in common: they can be slow, and they are
         only approximations.  Samples that are noisy (like voices
         with "f" or "s" sounds, or music with lots of drums) will
         sound muffled when converted using either technique.  And
         large samples can take almost twenty seconds to convert.

         To help alleviate the speed problem, Sound Lab also has
         special optimized routines to convert to half or double
         speed.  These routines are very, very fast, so if you can,
         convert to double or half speed.

         If you chose to convert to a higher speed, then the sample
         will grow in size; you may not have enough memory for this.
         If you don't, Sound Lab will show you the familiar _Insert_
         dialog, allowing you to choose what to do.










































         Sound Lab 1.0                                         Page 22



         -------- Menus

         Sound Lab does have menus.  Usually they're tucked away, out
         of sight, but they can be called up very easily by moving the
         mouse to the top left of the screen.  The menus will appear
         under the mouse, allowing you to select an item.  If you
         don't want to select an item, move the mouse out of the menus
         and click the left mouse button.  The menus will be
         re-hidden, and you can go back to editing your sound.

         These menus are not used for any of Sound Lab's sample
         editing functions.  Rather, they contain information, and
         several disk utilities for your convenience.

         --- /Info/

         The /Info/ item, in the /Desk/ menu, has a submenu attached.
         Just move the mouse into the submenu and select the item you
         want.  /Sound Lab/ brings up the title screen; /Shareware/
         brings up information about how to register the program; and
         /Thanks/ lists some people who helped in the completion of
         this program.

         What you won't find under the /Info/ item are the desk
         accessories.  Despite appearances, Sound Lab is a TOS
         program, and does not cooperate with accessories in the least
         little bit.

         --- /Rename File/

         This item, in the /File/Disk/ menu, allows you to rename a
         file.  After selecting /Rename File/, the _Fileselector_ will
         appear, allowing you to choose which file to rename.  Click
         on "Okay".  Then a small dialog will appear, showing the old
         name, and allowing you to enter the new name.  Click on
         "Okay" to confirm the change, "Cancel" to abort it.  (You
         will not be allowed to enter an illegal filename; use other
         utilities to do that.)

         --- /Delete File(s)/

         This item allows you to delete files from the disk.  The
         _Fileselector_ will appear, allowing you to choose which file
         to delete.  You can also enter a wildcard (like *.*).  Click
         on "Okay".  An alert will appear, showing you which file or
         wildcard you entered, and asking you to confirm your delete.
         Click on "Okay" to delete the files, or "Cancel" to abort.
         In either case, you will be returned to the _Fileselector_,
         so you can delete more files.  Click on "Cancel" when you're
         done deleting files.

         --- /Create Folder/

         This item allows you to create a new folder on the disk.  The








         Sound Lab 1.0                                         Page 23



         _Fileselector_ will appear; choose where you want to create
         the folder, and enter the folder's name in the "Filename"
         part of the _Fileselector_.  Click on "Okay" to create the
         folder, or "Cancel" to abort.

         --- /Remove Folder/

         This item allows you to remove an empty folder from the disk.
         The _Fileselector_ should be used to choose the folder; the
         "Filename" area of the _Fileselector_ should be left blank.
         If the folder is not empty, it cannot be removed; use /Delete
         File(s)/ to empty it.  Otherwise, the folder will be removed
         when you click on "Okay".  "Cancel", of course, aborts the
         operation.

         --- /Free Space/

         This item allows you to check the free space available on any
         connected drive.  Just move the mouse pointer to the desired
         drive shown in the submenu and click the button.  The free
         space will (quickly) be checked, and then displayed, in both
         bytes and kilobytes.  Click on "It does, does it?" when
         finished.

         --- /Format Disk/

         This option allows you to format a disk.  After selecting
         /Format Disk/, a dialog will appear, allowing you to choose
         drive A or B, and one or two sides.  Click on "Okay" to begin
         formatting or "Cancel" to abort.  You will be asked to
         confirm the format, since formatting erases everything on the
         disk.  While the disk is being formatted, you can press any
         key to interrupt.  All disks are formatted 80 tracks, 10
         sectors per track.

         --- /Quit/

         For completeness, I'll also mention /Quit/.  It's found at
         the bottom of the /File/Disk/ menu, and serves the same
         purpose as the "Quit" button--it exits the program.






















         Sound Lab 1.0                                         Page 24



         -------- Tips for Using Sound Lab

         You now know how to use Sound Lab, mostly.  What follows
         could be called "Miscellaneous"; it covers special features
         of the program, techniques you can use, and some overall
         advice.

         --- Moving Dialogs

         Most dialogs (_not_ alerts) can be moved in Sound Lab.  To do
         this, click AND HOLD the left mouse button on the title bar
         of the dialog.  Then drag the hollow rectangle to the
         dialog's desired position, and release the mouse button.  The
         dialog will be moved to the new position; every time you
         bring up that dialog (until you exit the program) it will
         appear where you last positioned it.  You can save the
         dialogs' positions when you save your preferences in the
         _Preferences_ dialog.

         --- Bypassing the Title Screen

         If you don't like the title screen appearing, just hold down
         the Alternate key while the program is loading until the main
         screen is displayed.  If you bypass the title screen, you
         free up 20K of memory for samples; you can also press
         Alternate-Tab to free up that memory after the program is
         loaded.

         --- Choosing a Sampling Rate

         Whenever you record sounds, it's important to choose a
         sampling rate that fits your purpose.  The higher the
         sampling rate, the higher the quality--and the more memory
         used.  If you're using the digitized sound in other programs,
         good speeds are 7.68KHz (for voice) and 9.6KHz (for music).
         If you have the memory, though, you should record your
         samples at a higher speed--15.36KHz or 19.2KHz.  These give
         you much better quality.  You can then convert these samples
         to half their speeds.

         Although Sound Lab allows you to convert from any speed to
         any speed, you're best off sticking with doubling or halving
         the speeds.  There are two reasons for this: first, Sound Lab
         has special routines for doubling/halving that are much
         faster than any other conversion, and second, repeated
         conversions can "muffle" the sound, especially if you don't
         always use doubling/halving.

         --- "High Bit"

         This special button allows you to convert samples from signed
         format to unsigned format.  Sometimes you'll get a sample in
         a format that Sound Lab does not recognize.  Usually these
         formats consist of a small header (a few bytes) followed by








         Sound Lab 1.0                                         Page 25



         the sample in raw form.  Just load up these sounds and play
         them.  If all of the sample sounds very loud and noisy, just
         click on "High Bit" (seventh column) to convert it to an
         unsigned sample.  Then play it again.  If it doesn't sound
         any better, I can't help you; something has altered the
         sound.  If it does sound better, except for some noise at the
         beginning, that's probably the header--just cut the noise
         out.

         Since Sound Lab recognizes .AVR, .SPL, and .SAM files, you
         probably won't need this button very often.  But in case you
         do, it's here.

         --- Loading and Saving Blocks - Partial Files

         Sound Lab does not require you to load and save entire
         samples at once.  You can load or save just blocks of
         samples.

         To load a block, just mark off the section of your sample
         that you want to load over.  Then click on "Load".  An alert
         will appear, asking if you want to load over your entire file
         (as with normal "Load") or just the marked block.  Select
         "Block".  Note the title of the _Fileselector_ changes to
         show you are loading a block, not an entire file.  (If you
         select "File", note that Sound Lab selects the "Hide Blk"
         button for you.)  Select the file you want to load, and click
         on "Okay".  What happens next depends on whether your block
         is longer than the file.  If the block is longer than the
         file, then the file is loaded over the first part of the
         block; the remainder of the block is unchanged.

         If the file is longer than the block, though, the
         _Load_Partial_ dialog will appear.  This dialog allows you to
         choose which part of the file to load.  Use the slider, or
         enter the Offset (the amount of bytes to skip) in the text
         field.  Click on "Okay" to load that portion, or "Cancel" to
         abort the load.

         Whether or not you see the _Load_Partial_ dialog, the file
         you load may not be at the same sampling rate as the rest of
         your file.  If it isn't, Sound Lab will ask you if you want
         to convert it.

         Sound Lab keeps track of which files have been loaded to make
         maximum use of the _Load_Partial_ dialog.  If you load an
         entire file, then mark off a block, and try to load that file
         back, it's obviously not going to fit.  But Sound Lab sees
         that the block filename (the one you've just chosen) is the
         same as the sample filename, and will automatically set the
         _Load_Partial_ dialog to exactly the portion of the file you
         have marked.  So if you accidentally damage a segment of the
         sound, you can reload it easily.









         Sound Lab 1.0                                         Page 26



         Also, if you try to load an entire sample that is too large
         for memory, Sound Lab will then show you the _Load_Partial_
         dialog.  And next time you try to load from that same file,
         it will automatically remember where you last loaded from.
         (This is separate from the block remember feature.)  So you
         can load in consecutively different parts of a very large
         sample for editing work.

         All of this load partial business wouldn't be much good if it
         couldn't be saved the same way.  So naturally, you can save
         partials as well.  Just click on "Save" as you normally
         would; if you try to save back to the same file you loaded a
         partial from, Sound Lab will ask you if you want to save it
         back to the same place it came from.  (This only works when
         entire files have been loaded as partials, not just blocks.)
         Click on "Partial" to save the file back to the proper part,
         "Whole" to erase the old file and save this segment as the
         new file, or "Cancel" to abort the save.

         If you click on "Save" with a block marked, Sound Lab will
         ask you if you want to save the entire file (as with normal
         "Save") or just the marked block.  Select your choice;
         "Cancel" will, of course, abort.

         --- Loading .BAK Files

         Sound Lab has the option to rename old samples to ones with
         extensions of .BAK if you try to save over them.  This can
         prevent you from accidentally erasing a sound.  To re-load
         these samples, you should use the /Rename/ option in the
         /File/Disk/ menu to rename the file to its proper extension
         (.AVR, .SPL, or .SAM), or else Sound Lab won't recognize the
         file type.

         --- Echo Effects

         The "Echo" option in Sound Lab is quite potent.  Use the
         enclosed .EKO files as a guide for setting options.

         A very interesting effect can be obtained by reversing the
         sample, adding an echo effect, and reversing the sample
         again.  Thus the sample plays in the proper direction, but
         the echoes precede the sound.

         You can make other interesting effects by using Echo Fade
         Rates of 1 or nearly 1.  You should only try this with
         relatively quiet samples, though; loud samples will be
         distorted if you also add loud echoes to them.

         If you want to hear the echoes at the end of a sample, you
         should use "Gap" with your left block marker at the end of
         your sample (see "Gap").  This will add blank space at the
         end of your file.









         Sound Lab 1.0                                         Page 27



         --- Background Effects

         The "Overlay" option in Sound Lab is more powerful than it
         may first look.  You can use it some recorded background
         sounds; then overlay them at low volume (.2 or .3) onto a
         louder sample.  Use the repeat option to add the same sound
         over and over.  This gives "atmosphere" to a sample,
         especially if you use echo effects as well.  You can overlay
         sounds even if they're too large to fit into RAM; just use
         "Ovly File".

         You can also get an interesting effect by overlaying the same
         sound onto silence several times in slightly different
         locations.

         --- Preferences

         Sound Lab has no intentions of restricting you to its way of
         doing things.  You can configure many of the options to your
         own preferences.  Clicking on "Prefs" (eighth column) will
         bring up the _Preferences_ dialog.  In this are nine options
         for you to set.

         First is "Output", which lets you choose how you want the
         digitized sound played.  "Sound Chip", the default, refers to
         the ST's sound chip; it's present in all ST's, and produces
         moderate quality sound.  "STe DMA" is only useful on STe's
         and TT's; it selects the STe's digitized sound chip, which
         creates exceptional quality sound.  "Cartridge" plays the
         sound through the ST Replay cartridge's output.

         When you click on the "STe DMA" button, a small dialog will
         appear with three sliders.  These sliders control the overall
         volume (from -80 to 0), the left and right volumes (from -40
         to 0), and the bass and treble (-12 to +12).  You can click
         on "Play" inside the dialog to test the adjustments.  Click
         on "Okay" to confirm the settings, or "Cancel" to restore
         them to their previous values.  Clicking on "Cancel" here
         does _not_ abort the STe DMA output option--just the
         volume/bass/treble settings.  (If you don't have an STe,
         selecting the "STe DMA" button will just use the ST output.)

         The second option is "Window Title".  This lets you choose
         what you want in the title bar of the sample window.  The
         default is "Pathname", which shows you the full path of the
         current file, the speed, magnification, and block size.
         "Info" shows only the filename of the current sample, leaving
         enough room to show the file size in kilobytes and the offset
         in bytes.  This second option can be extremely useful to
         programmers.

         The third option in the _Preferences_ dialog is "Window
         Display".  This chooses how you want to have the sample
         displayed in the window.  You can choose from "Points" (the








         Sound Lab 1.0                                         Page 28



         fastest-drawing option), "Outline" (the default, also the
         slowest), and "Solid" (a good compromise).  The Preview boxes
         in the _Overlay_, _Volume_, and _Fade_ dialogs all follow
         this option, as well as the main window.

         The fourth option is "Dialog Preview".  It specifies whether
         to use the actual sample ("Sample", the default) or generic
         waves ("Wave") in the _Volume_ and _Fade_ dialogs.  The
         _Overlay_ dialog always uses waves, since using the actual
         samples makes for a complete mess in the dialog.

         The fifth option, "Sizes In", refers to which units are used
         in the window title bar.  The default is "Bytes", but you can
         also select "Seconds".  Note that this means only the window
         title bar; it has no effect on items inside dialogs.

         The sixth option is "Menus".  It allows you to choose between
         "Drop-down" (ST-type, the default) or "Pull-down"
         (Macintosh-type).

         The seventh option is "Zoombox".  With this, you can turn the
         "zoom" on ("Yes", the default) or off ("No").  This "zoom"
         appears both before and after all dialogs, if turned on.

         Eighth is "Existing Files".  It allows you to choose what
         Sound Lab will do when you try to save over an existing file.
         You can choose "Erase", which erases the old file to make way
         for the new; "Rename", which renames the old file so its
         extension is .BAK, then saves the new file; or "Ask" (the
         default), which asks this question every time the situation
         occurs.

         The last option is "Default Speed".  Normally this is 9.6KHz,
         but clicking here will bring up the _Speed_ dialog, allowing
         you to choose any speed as the default.

         At the bottom of the _Preferences_ dialog are three buttons:
         "Save", "Use", and "Cancel".  "Save" will save your
         preferences (and the positions of all dialogs) to the file
         SOUNDLAB.PRF, in the same directory as you ran Sound Lab
         from.  If you ran Sound Lab from an AUTO folder, the
         preferences file will be saved to the root directory, not the
         AUTO folder (don't panic, that's where Sound Lab will look
         for it when it loads).  If you ran Sound Lab from a floppy,
         make sure your Sound Lab disk is in the drive when you hit
         "Save".  "Use" will keep the changes you've made, but won't
         save them; this is most useful if you've called up the
         _Preferences_ dialog only to adjust the "STe DMA" buttons.
         "Cancel", of course, aborts the changes and restores the
         previous settings.












         Sound Lab 1.0                                         Page 29



         -------- Using the _Fileselector_

         Sound Lab uses the custom dmj software file selector.  It's
         really quite simple to use.  If you have an alternate file
         selector loaded (like the Universal Item Selector, or the
         Little Green Selector) you won't be able to use it, since
         Sound Lab is a TOS program, and alternate file selectors work
         in GEM programs.

         At the top of the file selector is a line of text telling you
         what file you're supposed to be selecting with the file
         selector.  By "grabbing" this bar with the mouse (i.e. move
         the pointer to it, press, and hold the left button down) you
         can drag the entire file selector to a new spot on the
         screen.  The file selector will appear at this same spot
         every time you use it, until you leave the program.

         Below this line, you will see a line of text containing the
         pathname.  You cannot change this line directly.  More on
         this later.

         Below the pathname is the major component of the file
         selector: the filenames.  This large white box contains up to
         24 filenames at a time.  To select a filename, just click on
         it.  Then click on the "Okay" button, which you will find in
         the lower right hand corner of the file selector.  You can
         also just double-click on the filename and skip clicking on
         the "Okay" button; it will do the same thing.

         Below the white filename box you will see the name of the
         currently selected file.  This filename can be edited with
         the keyboard.  You can use the left and right arrow keys,
         BACKSPACE, and DELETE to edit this filename.  You will not be
         able to enter an illegal filename.  You can press ESC to
         erase the filename completely; CTRL and the left or right
         arrow key will move the cursor to the beginning and end of
         the filename, respectively.

         In the lower right hand corner of the file selector you will
         find two buttons, "Okay" and "Cancel".  Selecting "Okay"
         confirms the choice listed in the "Filename" area in the
         lower left hand corner of the file selector.  Selecting
         "Cancel" aborts this selection process.  Pressing RETURN on
         the keyboard is the same as selecting "Okay"; pressing UNDO
         is the same as selecting "Cancel".

         Directly to the right of the white filename box is a vertical
         slider.  This is only useful when there are more than 24
         files in the current folder.  You can use the up and down
         arrow buttons to scroll the names; you can click above or
         below the slider itself to move the slider in that direction
         quickly; or you can drag the slider to a new position
         directly.









         Sound Lab 1.0                                         Page 30



         You may have noticed some of the names in the white filename
         box have a small > symbol to their left.  These aren't files;
         they are folders.  You can click on a folder's name (just
         once) to change the current folder and see what's inside it.
         The pathname line directly above the white filename box will
         reflect the change--the new folder name will be added on the
         end.  To exit back out of the folder, you can either select
         the "<-" button in the upper right hand corner of the file
         selector, or click on the part of the pathname that you want
         to go to.  For example, if your current folder is
         "D:\SAMPLES\AVR\" and you wanted to go back to the SAMPLES
         folder, you could either select the "<-" button, or click on
         the word "SAMPLES" in the pathname line.  You can jump back
         several folders at a time with just one click.  In the
         example above, you could click on "D:\" and go to the main
         directory of the disk, whereas it would take two clicks of
         the "<-" button to do the same.

         There are three other buttons in the upper right hand corner
         of the file selector.  One has a drive letter on it; another
         has a disk icon on it; the third has "*.*" on it.  The drive
         letter button allows you to quickly change the current drive.
         Just click and hold the mouse button down on the drive
         letter.  Move the mouse pointer to the drive you want to use,
         and release the mouse button.  You will not be able to select
         a drive that does not exist--this also means drive B, so if
         you have a single floppy drive, forget about drive B.

         The disk icon button serves no other purpose but to tell the
         file selector that you have inserted another disk, and you
         would like to reread the disk's directory.

         The "*.*" icon, however, will require some explanation.  This
         button calls up another dialog that allows you to select the
         "search mask".  The search mask is how you tell the file
         selector which files you want to see in the white filename
         box.  You shouldn't normally need to use this.  Before
         explaining about the search mask dialog, a little explanation
         about search masks themselves is necessary.  Search masks are
         just filenames with wildcards in them.  There are two
         wildcard characters that are used: the asterisk (*) and the
         question mark (?).  The question mark represents any
         letter--but only one letter.  The asterisk represents any
         number of letters.  Here's some examples to make things
         clearer: the wildcard SND?.AVR would match SND1.AVR,
         SND2.AVR, and SNDZ.AVR, but not SOUN.AVR, SND.AVR, or
         SND23.AVR.  The wildcard SND*.AVR would match SND1.AVR,
         SND2.AVR, SNDZ.AVR, SND.AVR, SND23.AVR, and SNDTHING.AVR, but
         not SOUND.AVR or SOUND19.AVR.  See?  That's why the wildcard
         "*.*" is used to mean all files--because it matches all
         filenames.  Any number of characters, of any type, match the
         first *.  Then there's the period, which separates the name
         from the extension.  The last * matches any extension, no
         matter how long it is.  The catch here is that GEMDOS takes a








         Sound Lab 1.0                                         Page 31



         shortcut when it comes to "*.*".  That wildcard shouldn't
         match the filename "TEST", because it doesn't have a period
         in it.  But because GEM doesn't actually record the period on
         the disk, it assumes it is there.  So when GEMDOS checks for
         files, "TEST" comes out to be "TEST.", and so fits the
         wildcard.

         You've undoubtedly used wildcards before.  In the GEM File
         Selector, the wildcard appears at the end of the pathname.
         Many programs make use of wildcards to mask out files you
         don't need to worry about.  For example, when selecting a
         picture from SPC-3375 (a Spectrum picture viewer), it uses a
         search mask of *.SP?.  This allows all files to appear in the
         GEM File Selector, as long as the first two letters of the
         extension are "SP".  So anything with an extension of "SPC"
         and "SPU" will show up.  Unfortunately, anything with an
         extension of "SPX" or "SPQ" will also show up.  It would be
         nice if there was an easy way to allow only the extensions
         "SPC" and "SPU".

         The dmj software file selector allows you to do just that.
         It allows you to take several wildcards and chain them
         together to make one mask; a file only needs to fill one of
         the wildcards to appear in the white filename box.  You
         separate wildcards with the vertical bar character, |.  So to
         display just Spectrum pictures, you'd use the mask
         "*.SPC|*.SPU", instead of the less precise "*.SP?".  Of
         course, you don't use pictures in Sound Lab; that's why the
         default mask is "*.AVR|*.SPL|*.SAM"--it shows only .AVR,
         .SPL, and .SAM type files.

         Now that the enhanced wildcards have been explained, I can
         explain how to use the "*.*" dialog.  You will see ten lines
         in the dialog, each with a different search mask.  To select
         one of these search masks, just select its button, which can
         be found at the left side of the dialog.  You can select "Ok"
         to confirm your choice, or double-click on your choice to
         avoid the "Ok" button.  You can press F1-F10 in place of
         click on the selection buttons, and you can press RETURN in
         place of clicking on the "Ok" button.  If you want to change
         one of the search masks, click on the mask you want to
         change.  Then use the arrow keys, BACKSPACE, and DELETE to
         edit the search mask on that line.  Remember that simply
         editing a mask does not select it; you must choose its button
         on the left hand side.  Also note that you cannot edit the
         top two lines.  These are reserved.  The top line has the
         mask provided when the fileselector was called up; the second
         line has the catch-all "*.*".

         This fileselector is very similar to the one used in DMJ GIF.
         The difference is that you can now press F1-F10 in the
         fileselector itself, without having to call up the search
         mask dialog; you can also use ALT-A through ALT-P to switch
         or reread drives.








         Sound Lab 1.0                                         Page 32



         -------- If Something Goes Wrong

         Inevitably you will, at one point, find that things are not
         going well for you.  Here's a list of common things that
         might go wrong, and brief explanations of how to fix them.

         --- Sound Lab won't load.

         Hopefully it told you what was wrong; if so, fix it.
         Otherwise, it's possible that you have a damaged file (not
         likely) or that Sound Lab doesn't like one of your
         accessories or AUTO programs.  If this is the case, fiddle
         around with them and see if you can get Sound Lab to load; if
         you figure out which one(s) Sound Lab doesn't like, please
         tell me, so I can pass it on to other users.

         --- Mouse won't move during play/record functions.

         That's normal.  When you move the mouse, it grabs time from
         the processor, and that screws up the timing for those sound
         routines.  So the mouse is disabled whenever timing is
         critical.

         --- No sound during playback.

         Turn up your monitor's volume.  Or (if you're using the STe
         sound) turn up whatever the STe's speaker ports are connected
         to.  The same goes for the Cartridge output.  It's also
         possible that you don't have a sound loaded.  If you see a
         flat line in the sample window, then no sound is loaded!

         --- No sound during record/listen.

         Turn up the volume on your sound source.  Use the Monitor
         function to check the volume, and adjust it correctly.  Also
         make sure that your cartridge is connected, and you have a
         sound source connected.  Neither the ST Replay nor Daatasound
         cartridge amplify the sound source, so most microphones
         cannot be connected directly to the cartridge.  Use a
         cassette recorder or portable CD player for best results.

         --- Sample is very noisy, hard to hear.

         You may have a signed sample.  Try using "High Bit" to fix
         it.  (See Tips.)

         --- Record/Listen are noisy.

         Make sure you're using either ST Replay or Daatasound
         cartridges.  Other cartridges are not proven to work; I make
         no claims for them.  Also, use only high quality connections
         between your sound source and cartridge; one bad connector
         can ruin an otherwise good setup.









         Sound Lab 1.0                                         Page 33



         --- Samples don't load at the correct speed.

         Use .AVR format when saving files.  This records not only the
         sample, but also the speed of the sample and any looping that
         may go with it.

         --- Loading or Saving produces errors.

         It's possible that a disk could be damaged.  If Sound Lab has
         a problem with a disk, it will tell you what it is.  If the
         disk is damaged, you will need to save to another disk.  If
         you don't have another disk formatted, you can use Sound
         Lab's /Format/ option to format a disk for you.  You may also
         need to do this if your disk gets full.

         --- GFA BASIC Errors

         You're up late one night, fiddling with your finest sounds,
         and you get an alert saying, "GFA BASIC Error".  Ugh.
         Hopefully this won't happen to you.  Sound Lab has been
         extensively tested with a wide variety of AUTO programs on a
         large selection of STs.  On the off chance that something
         does go wrong, I'd like to know about it.  Please tell me
         what happened, what you were doing just before it happened,
         and which accessories and AUTO programs you're using.
         Seriously--the more information I have, the better the chance
         that I can figure out what went wrong.  It wouldn't hurt to
         tell me what kind of computer you're using, either.


































         Sound Lab 1.0                                         Page 34



         -------- Quick Reference & Keyboard Shortcuts

         This section lists all of the capabilities of Sound Lab, with
         a brief description of them and their keyboard equivalents.

         Throughout these descriptions, "Block" refers to your marked
         block; "File" or "Sample" refers to the entire sample loaded
         into memory; and "Buffer" refers to the area of memory set
         aside by Sound Lab to store chunks Cut or Copied from the
         sample.  All keyboard equivalents are in lower case, except
         where "Shift" is noted.

         "Play"         Plays the current block at the current speed.
                        Space bar also activates this option.  If the
                        "Play" button appears inside a dialog, the
                        space bar activates it there too.
         "Monitor"      Displays the input from the sound cartridge
                        over the sample window, allowing the volume of
                        the sound source to be adjusted.  The display
                        should show a wide range of motion, but should
                        not appear clipped at the top or bottom.
                        ("M")
         "Record"       Allows the recording of sound, but only over
                        the current block.  If the entire file is
                        marked as the block, then you can record into
                        the entire file area (as shown by "Memory
                        size").  You can choose to "Wait" for the
                        sound or "Start" immediately.  (Return)
                        Sound Lab works with the Pandaal DaataSound
                        cartridge, and the ST Replay (non-stereo)
                        cartridge.
         "Speed"        Allows the adjustment of the current speed.
                        Brings up a dialog, with 11 preset speeds, the
                        ability to double or halve the speed, go up or
                        down a tone (as in music), adjust the speed
                        with a slider, or enter it directly.  Valid
                        speeds range from 4.915KHz to 30.72KHz.  (The
                        ST's sound chip can't go faster than that.)
                        You can "Play" the speed right in the dialog;
                        "Okay" confirms the change, "Cancel" aborts
                        it.  Keyboard equivalents are F1-F10, F20,
                        "D", "H", up arrow, down arrow, space, Return,
                        and Undo.  The function keys can also be used
                        at the main screen.  ("P")  The "Convert"
                        button is used to convert the sample from the
                        current speed to the newly selected speed.
         "Zoom In"      These keys adjust the zoom level.  Max zoom
         "Zoom Out"     shows the entire file; 1x means each pixel on
                        the screen is one byte in the file.  Max, 16x,
                        8x, 4x, 2x, and 1x are the available zoom
                        levels.  "Z" and "A" are the equivalents.
         "Hide Blk"     This will temporarily hide the selected block,
                        selecting the entire file.  The button (which
                        can be activated by "H") will "stick"; click








         Sound Lab 1.0                                         Page 35



                        on it again to reveal your block.
         "Cut"          Cuts the block from the file, pulling the
                        remaining sample down.  This block is then
                        stored in a buffer (the "Memory size" will
                        change to reflect the change in available
                        space).  ("X")
         "Copy"         Like Cut, except it won't remove the block
                        from the file.  ("C")
         "Clear"        When you hit this button, an alert will
                        appear, asking what you want to clear.  You
                        can clear your "Block", which will replace
                        your marked block with silence; you can clear
                        your "Buffer", giving you more memory for
                        recording and such; or you can clear
                        "Everything", which erases _all_ of your
                        sample and buffer.  If you elect to clear your
                        block, and your block is the whole file, then
                        Sound Lab will reset to the way it was when it
                        was loaded (all memory, except the buffer,
                        available for recording).  Note that if you
                        "Record" while your whole file is marked as a
                        block, you can record as much as you have RAM
                        for, so this is not really necessary.  (Home)
         "Insert"       Inserts the block stored in the buffer (with
                        Cut & Copy) into the sample before the left
                        block marker.  If there isn't enough room for
                        the Insert, you'll be presented with four
                        options: Lose Sample, Lose Buffer, Insert to
                        Fit, and Cancel.  Lose Sample will cause the
                        end of the sample to be lost; Lose Buffer will
                        preserve all of the sample, but trashes the
                        block in the process; and Insert to Fit will
                        insert as much of the buffer as will fit.
                        ("I")
         "Overlay"      Brings up the Overlay dialog.  In this three
                        waves are displayed; light blue is the block,
                        dark blue is the buffer, and black is the
                        result of merging the two together.  The
                        slider on the left adjusts the block volume,
                        and the slider on the right adjusts the buffer
                        volume.  The "Length" buttons allow you to
                        choose which sample (block or buffer) you want
                        as the length to Overlay with; the "Repeat"
                        buttons allow you to choose whether or not to
                        repeat the buffer if the Overlay is longer
                        than the buffer.  Click on "Okay" to overlay
                        the samples, or "Cancel" to abort.  ("O")
         "Volume"       Allows the volume of the block to be changed.
                        In the dialog, you can use the slider to set
                        the volume change, or enter it directly.
                        Valid values are from 0.25 (volume x 1/4) to 4
                        (volume x 4).  The diagram shows the original
                        sample (blue) and the proposed change (black).
                        You can use the "Play" button to test the








         Sound Lab 1.0                                         Page 36



                        change, hearing any distortion that will be
                        introduced because of the change.  Clicking on
                        "Cancel" after the "Play" _will_ abort the
                        change; you _must_ click on "Okay" for the
                        change to take effect.  ("V")
         "Remove"       This is like Cut, except it doesn't copy the
                        block to the buffer first.  Since there is no
                        undo of this, you will be asked if you are
                        sure.  (Delete)
         "Loop"         Allows the setting or clearing of a loop.
                        Brings up an alert with four buttons, "Set
                        Loop", "Reset Block", "Loop On/Off", and
                        "Cancel".  "Set Loop" sets looping to the
                        current marked block.  "Reset Block" moves the
                        block markes to the current loop settings.
                        "Loop On/Off" turns looping on or off (without
                        changing the loop or block markers), and
                        "Cancel" does nothing.  While looping is on,
                        "Play" will play the entire sound with
                        looping, regardless of any marked block; "Set
                        Loop" and "Reset Block" both turn looping on.
                        ("U")
         "Fade"         Allows the fading of the block.  Don't let the
                        dialog scare you, it's only slightly more
                        complicated than the Volume dialog. This time
                        you have two sliders, one for the start
                        volume, and one for the end volume.  You can
                        click on the "Fade In" or "Fade Out" buttons
                        to set the sliders to the appropriate default
                        positions; "Play" will pre-test the fade
                        before making it final, and "Shape" will bring
                        up a small dialog, allowing you to choose the
                        shape of the fade.  In this dialog (or the
                        main _Fade_ dialog) you can use F1-F4 to
                        change shapes.  ("F")
         "Echo"         This also looks worse than it is; it allows
                        you to add echo effects to your block.  The
                        top slider is the volume of each echo compared
                        to its predecessor (0.5 is a good number).
                        The second slider is how far apart--in
                        seconds--the echoes should be.  (The current
                        speed is crucial to the accurate figuring of
                        this.)  And the number of echoes is just that:
                        how many echoes should be added to the block.
                        Click on "Okay" to confirm, "Cancel" to abort.
                        Usually echo spacings of .125 and .062 are
                        good, and three or four echoes are plenty.
                        Use "Load" and "Save" to load and save echo
                        settings.  ("E")
         "Reverse"      Flips the block so it plays backwards.  ("R")
         "High Bit"     Used to toggle between signed samples (.SAM)
                        and unsigned samples (.SPL).  .AVR files may
                        be of either type; Sound Lab uses unsigned
                        samples.  If the sample looks and sounds very








         Sound Lab 1.0                                         Page 37



                        noisy, try toggling the high bit.  When signed
                        samples (.SAM or .AVR) are loaded, Sound Lab
                        automatically toggles the high bit for you, so
                        you shouldn't need this button very often.
                        ("B")
         "Load"         If you have your entire file marked as your
                        current block (as with the "Hide Blk"
                        function), the entire file area is cleared and
                        a new file is loaded in (as specified by the
                        fileselector that pops up).  If you don't have
                        your entire file marked, the file you specify
                        will be loaded over the sample you currently
                        have in memory, up to the length of the block
                        you mark.  If you aren't sure which way the
                        Load is going to work, look at the
                        fileselector's title bar.
                        If there isn't enough room for the load
                        (because either your block or file area is too
                        small) Sound Lab will bring up the "Load
                        Partial" dialog; this allows you to choose
                        exactly which part of the sample to load.  Use
                        the slider in the dialog or enter the amount
                        of bytes to skip, then select "Okay".
                        "Cancel" will, of course, abort the load.
                        "Load" uses the standard dmj software
                        fileselector, but now you can press ALT-A
                        through ALT-P to switch drives (and re-read
                        that drive), and F1-F10 can now be pressed for
                        the search masks without calling up the search
                        mask dialog.  ("L")
         "Save"         This saves the currently marked block.
                        (You'll note the fileselector title reflects
                        whether or not the block is the entire file.)
                        The extensions .SPL (raw data, unsigned), .SAM
                        (raw data, signed), and .AVR (raw data and
                        header info) are all supported.  ("S")
         "Help"         This button brings up the help system.  Since
                        the Help is self-explanatory, I won't go into
                        details here.  Help can also be activated by
                        pressing the Help key; this key can be pressed
                        _anywhere_ to get help with whatever you're
                        doing.
         "Prefs"        This brings up the Preferences dialog.  ("?")
                        In this, you will find you can set several
                        items.  The first, "Output", refers to how you
                        want the digitized sound to be played; choose
                        "Sound Chip" (for regular ST's), "STe DMA"
                        (for STe's), or "Cartridge" (if you have an ST
                        Replay cartridge with output).  Clicking on
                        "STe DMA" will also bring up the _STe_ dialog,
                        allowing you to adjust the volume, bass, and
                        treble.  Next is the "Window Title", which
                        sets what is to be displayed in the sample
                        window title bar; choose "Pathname" (which








         Sound Lab 1.0                                         Page 38



                        displays the full pathname of the file, at the
                        expense of some other information) or "Info"
                        (which displays the filename only, leaving
                        room for the other info).  The third item
                        refers to how to draw the display; choose
                        "Points", "Outline", or "Solid".  Next is
                        "Dialog Preview", which sets the display
                        inside the _Fade_ and _Volume_ dialogs;
                        "Sample" uses the actual sample(s) involved,
                        whereas "Wave" uses generic waves.  The next
                        option refers to what units to display sample
                        sizes in; choose seconds or bytes.  The next
                        item, Menus, refers to how you access the
                        menus; "Drop-down" is like the typical GEM
                        menus, but "Pull-down" requires you to press
                        and hold the mouse button to access the menus
                        (like Macintosh menus).  Next is "Zoombox",
                        which allows you to turn on ("Yes") or off
                        ("No") the zooming boxes on dialogs.  Last is
                        the "Existing Files" preference, which sets
                        what Sound Lab will do if you try to save over
                        an existing file; choose "Erase" (which
                        clobbers the old file), "Rename" (which
                        renames the old file to .BAK, killing any
                        previous .BAK of that name), or "Ask" (which
                        asks which of the two you want to do every
                        time the situation comes up).  The only other
                        item here is "Default Speed", which sets the
                        default speed when Sound Lab first loads.
                        When you're done setting your preferences,
                        click on "Save" (which saves the settings to
                        SOUNDLAB.PRF), "Use" (which keeps the settings
                        but doesn't save them), or "Cancel" (which
                        restores the settings to their previous
                        values).
         "Quit"         Exits the program.  You will be asked if you
                        are sure.

         In addition to these twenty-four buttons, there are ten more
         functions that can be accessed by clicking on one of the
         twenty-four buttons with the _right_ mouse button.  While the
         right mouse button is down, you will see the buttons change
         their labels to reflect the change in functions.  Each is
         placed "under" the most logical button for it.

         "Play Buf"     Plays the sample currently stored in the
                        buffer (from Cut or Copy) at the current
                        speed.  (Shift space)
         "Listen"       Plays the input on the digitizer cartridge
                        through the monitor speaker, at the current
                        sampling rate.  This allows you to hear the
                        quality of the digitized sound before actually
                        recording anything.  (Shift "M")
         "Min Zoom"     Zooms in to 1x magnification.  (Shift "Z")








         Sound Lab 1.0                                         Page 39



         "Max Zoom"     Zooms out to Max magnification.  (Shift "A")
         "Gap"          Inserts a chunk of silence before the left
                        block marker; this chunk is just as long as
                        the marked block is.  If there isn't enough
                        memory for this, the Insert dialog will
                        appear, asking what you want to do about it.
                        ("G", Shift "G")
         "Ins File"     Like Insert, but inserts a file instead of the
                        buffer.  The fileselector will appear,
                        allowing you to select the file to be used.
                        (Shift "I")
         "Ovly File"    Like Overlay, but overlays a file instead of
                        the buffer.  (Shift "O")
         "Trim"         Like "Remove", except that it removes
                        everything from the file that _isn't_ between
                        the block markers.  This is useful if you have
                        just recorded a sample, and there are "pops"
                        at the start and end.  Just mark the block so
                        that you can't hear any "pops", and select
                        Trim.  This also requires confirmation.
                        ("T")
         "Load Buf"     Allows you to load a file directly into the
                        buffer.  If there isn't enough room for the
                        file, Sound Lab will ask you if you want to
                        overwrite the end of your sample to try to fit
                        in the buffer.  Answer "Yes" or "No".  If you
                        answer "No", Sound Lab will present you with
                        the "Load Partial" dialog, allowing you to
                        choose which portion of the file to load.
                        (Shift "L")
         "Save Buf"     Allows you to save the contents of the buffer
                        to disk directly.  Other than that, it works
                        just like Save.  (Shift "S")

         There are also some other keyboard shortcuts that you should
         be aware of.  From the main screen, you can press F1 through
         F10 and F20 to set the speed.  Use ^N, ^D, ^C, ^R, and ^F to
         select the /Rename File/, /Delete File/, /Create Folder/,
         /Remove Folder/, and /Format Disk/ options; Alt-A through
         Alt-P check the free space on that drive.  ^I, ^S, and ^T can
         be used to select the /Sound Lab/, /Shareware/, and /Thanks/
         options from the /Desk/Info/ submenu.  In all alerts and
         dialogs, Return is "Okay", "Yes", or "Retry", and Undo is
         "Cancel" or "No".


















         Sound Lab 1.0                                         Page 40



         -------- Index

         AUTO Folder  7, 28               Folder
         Background  26                       AUTO  7, 28
         Backup Files  11, 26, 28             Create  22, 39
         Block  12                            Remove  23, 39
             Clear  18, 35                Format Disk  23, 39
             Convert  20, 34              Free Space  23, 39
             Copy  14, 35                 Gap  18, 39
             Cut  13, 35                  Help  7, 37
             Echo  20, 36                 Hide Block  12, 34
             Fade  19, 36                 High Bit  24, 32, 36
             Gap  18, 39                  Info  22
             Hide  12, 34                 Insert  14, 35
             Load  25, 37                     File  17, 39
             Loop  15, 36                 Listen  10, 38
             Mark  12                     Load  8, 33, 37
             Play  12, 34                     Block  25
             Record  12, 34                   Buffer  17, 39
             Remove  15, 36                   Echo  20, 36
             Reverse  20, 36                  Partial  25
             Save  26, 37                     Sound Lab  6, 32
             Trim  15, 39                 Looping  9, 15, 36
             Volume  18, 35               Menus  22, 28, 39
         Buffer  13, 34                   Monitor  10, 34
             Insert  14, 35               Moving Dialogs  24
             Load  17, 39                 Overlay  16, 35
             Overlay  16, 35                  Background  26
             Play  14, 38                     File  17, 39
             Save  17, 39                 Play  9, 34
         Cartridge  6, 32                     Block  12
             Installing  6                    Buffer  14,17,38
             Playing Through 27, 37           in Fade  19, 36
         Clear  18, 35                        in Speed  9, 34
         Copy  14, 35                         in STe  27
         Create Folder  22, 39                in Volume  19, 35
         Cut  13, 35                      Preferences  27, 37
         Delete File(s)  22, 39           Preview
         Echo  20, 36                         Fade  19, 36
             Techniques  26                   Overlay  16, 35
         Effects  18                          Sample  27, 38
         Fade  19, 36                         Volume  18, 35
         File(s)                              Wave  27, 38
             Backups  11, 26, 28          Quit  7, 23, 38
             Delete  22, 39               Record  10, 34
             Formats  8, 9, 25, 33            Block  12
             Insert  17, 39                   Speed  24
             List of  6                   Remove  15, 36
             Load  8, 33                      Folder  23
             Overlay  17, 39              Rename File  22, 39
             Rename  22, 39               Reverse  20, 36
             Save  10, 33                 Sampling Rates  4
         Fileselector  29                     Choosing  24









         Sound Lab 1.0                                         Page 41



         Save  10, 33, 37
             Block  26
             Buffer  17, 39
             Echo  20, 36
             Partial  26
         Speed  8, 34
             Convert  20
         Tips  24
         Title Screen  7
             Bypassing  24
         Trim  15, 39
         Volume  18, 35
             Adjusting  10, 32
         Window  7
             Display  8, 27, 38
             Title  7, 8, 27, 38
         Zoom  12, 34, 38, 39











































