#ifndef _MP2INFO_H_
#define _MP2INFO_H_

typedef struct
{
	unsigned int sync			: 12;
	unsigned int id			: 1;
	unsigned int layer		: 2;
	unsigned int protection	: 1;
	unsigned int bitrate		: 4;
	unsigned int frequency	: 2;
	unsigned int padding		: 1;
	unsigned int private		: 1;
	unsigned int mode			: 2;
	unsigned int mode_ext	: 2;
	unsigned int copyright	: 1;
	unsigned int original	: 1;
	unsigned int emphasis	: 2;
} FRAME_HEADER;

#define ID_LOWER 0
#define ID_NORMAL 1

#define LAYER_RESERVED 0
#define LAYER_I 1
#define LAYER_II 2
#define LAYER_III 3

#define PROT_CRC 0
#define PROT_NOCRC 1

#define PADDING_NO 0
#define PADDING_ADD 1

#define MODE_STEREO 0
#define MODE_JOINT 1
#define MODE_DUAL 2
#define MODE_MONO 3

#define MODE_EXT_SUB4 0
#define MODE_EXT_SUB8 1
#define MODE_EXT_SUB12 2
#define MODE_EXT_SUB16 3

#define NO_COPYRIGHT 0
#define COPYRIGHTED 1

#define COPY 0
#define ORIGINAL 1

#define NO_EMPHASIS 0
#define EMPHASIS_50_15 1
#define EMPHASIS_RESERVED 2
#define EMPHASIS_CCITT_J17 3

typedef struct
{
	long bitrate,sample_frequency,filelength,timelength;
} MP2INFO;

#define MP2_NOERR    0
#define MP2ERR_SYNC  1
#define MP2ERR_MONO  2
#define MP2ERR_CRC   3
#define MP2ERR_OTHER 42

extern MP2INFO mp2info;

#endif /* _MP2INFO_H_ */
