/*
 *   PhaPacker.c   1996-1999 (c) Asle / ReDoX
 *
 * Converts PHA packed MODs back to PTK MODs
 * nth revision :(.
 *
*/

#ifdef DOS
#include "..\include\globals.h"
#include "..\include\extern.h"
#endif

#ifdef UNIX
#include "../include/globals.h"
#include "../include/extern.h"
#endif


void Depack_PHA ( void )
{
  Uchar c1=0x00,c2=0x00,c3=0x00,c4=0x00;
  Uchar poss[37][2];
  Uchar Pats_Numbers[128];
  Uchar Pats_Numbers_tmp[128];
  Uchar NOP;
  Uchar *Whole_Pattern_Data;
  Uchar *Pattern;
  Uchar *Sample_Data;
  Uchar Old_Note_Value[4][4];
  Uchar Note,Smp,Fx,FxVal;
  Uchar PatMax=0x00;
  long Pats_Address[128];
  long i=0,j=0,k=0;
  long Pats_Address_tmp[128];
  long Pats_Address_tmp2[128];
  long tmp_ptr,tmp1,tmp2;
  long Start_Pat_Address;
  long Whole_Pattern_Data_Size;
  long Whole_Sample_Size=0;
  long Sample_Data_Address;
  short Old_cpt[4];
  FILE *in,*out;

  if ( Save_Status == BAD )
    return;

#ifdef DOS
  #include "..\include\ptktable.h"
#endif
#ifdef UNIX
  #include "../include/ptktable.h"
#endif

  BZERO ( Pats_Address , 128*4 );
  BZERO ( Pats_Address_tmp , 128*4 );
  BZERO ( Pats_Address_tmp2 , 128*4 );
  BZERO ( Pats_Numbers , 128 );
  BZERO ( Pats_Numbers_tmp , 128 );
  BZERO ( Old_Note_Value , 4*4 );
  BZERO ( Old_cpt , 4*2 );

  in = fopen ( OutName_final , "r+b" ); /* +b is safe bcoz OutName's just been saved */
  sprintf ( Depacked_OutName , "%ld.mod" , Cpt_Filename-1 );
  out = fopen ( Depacked_OutName , "w+b" );

  for ( i=0 ; i<20 ; i++ )   /* title */
    fwrite ( &c1 , 1 , 1 , out );

  fseek ( in , 0 , SEEK_SET );  /* useless */
  for ( i=0 ; i<31 ; i++ )
  {
    c1 = 0x00;
    for ( j=0 ; j<22 ; j++ ) /*sample name*/
      fwrite ( &c1 , 1 , 1 , out );

    fread ( &c1 , 1 , 1 , in );  /* size */
    fread ( &c2 , 1 , 1 , in );
    Whole_Sample_Size += (((c1*256)+c2)*2);
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );
    c1 = 0x00; /* finetune byte in ptk's case .. */
    fwrite ( &c1 , 1 , 1 , out );
    fseek ( in , 1 , 1 ); /* SEEK_SET */

    fread ( &c1 , 1 , 1 , in );  /* volume */
    fwrite ( &c1 , 1 , 1 , out );

    fread ( &c1 , 1 , 1 , in );  /* loop start */
    fread ( &c2 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );

    fread ( &c1 , 1 , 1 , in );  /* loop size */
    fread ( &c2 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );

    fseek ( in , 4 , SEEK_CUR );
    fread ( &c1 , 1 , 1 , in );
    c1 = (c1!=0x00) ? (c1+=0x0b) : 0x00;
    fseek ( out , -6 , 1 ); /* SEEK_END */
    fwrite ( &c1 , 1 , 1 , out );
    fseek ( out , 0 , 2 ); /* SEEK_END */
    fseek ( in , 1 , 1 ); /* SEEK_CUR */
  }
  /*printf ( "Whole sample size : %ld\n" , Whole_Sample_Size );*/

  /* bypass those unknown 14 bytes */
  fseek ( in , 14 , 1 ); /* SEEK_CUR */

  for ( i=0 ; i<128 ; i++ )
  {
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    fread ( &c3 , 1 , 1 , in );
    fread ( &c4 , 1 , 1 , in );
    Pats_Address[i] = (c1*256*256*256)+(c2*256*256)+(c3*256)+c4;
/*fprintf ( info , "%3ld: %ld\n" , i,Pats_Address[i] );*/
  }

  /* ordering of patterns addresses */

  tmp_ptr = 0;
  for ( i=0 ; i<128 ; i++ )
  {
    if ( i==0 )
    {
      Pats_Numbers[0] = 0x00;
      tmp_ptr++;
      continue;
    }

    for ( j=0 ; j<i ; j++ )
    {
      if ( Pats_Address[i] == Pats_Address[j] )
      {
        Pats_Numbers[i] = Pats_Numbers[j];
        break;
      }
    }
    if ( j == i )
      Pats_Numbers[i] = tmp_ptr++;
  }


  /* correct re-order */
  /********************/
  for ( i=0 ; i<128 ; i++ )
    Pats_Address_tmp[i] = Pats_Address[i];

restart:
  for ( i=0 ; i<128 ; i++ )
  {
    for ( j=0 ; j<i ; j++ )
    {
      if ( Pats_Address_tmp[i] < Pats_Address_tmp[j] )
      {
        tmp2 = Pats_Numbers[j];
        Pats_Numbers[j] = Pats_Numbers[i];
        Pats_Numbers[i] = tmp2;
        tmp1 = Pats_Address_tmp[j];
        Pats_Address_tmp[j] = Pats_Address_tmp[i];
        Pats_Address_tmp[i] = tmp1;
        goto restart;
      }
    }
  }

  j=0;
  for ( i=0 ; i<128 ; i++ )
  {
    if ( i==0 )
    {
      Pats_Address_tmp2[j] = Pats_Address_tmp[i];
      continue;
    }

    if ( Pats_Address_tmp[i] == Pats_Address_tmp2[j] )
      continue;
    Pats_Address_tmp2[++j] = Pats_Address_tmp[i];
  }

  /* try to take care of unused patterns ... HARRRRRRD */
  BZERO ( Pats_Address_tmp , 128*4 );
  j=0;
  k = Pats_Address[0];
  for ( i=0 ; i<120 ; i++ ) /* 120 ... leaves 8 unused possible patterns .. */
  {
    Pats_Address_tmp[j] = Pats_Address_tmp2[i];
    j+=1;
    if ( (Pats_Address_tmp2[i+1]-Pats_Address_tmp2[i]) > 1024 )
    {
      Pats_Address_tmp[j] = Pats_Address_tmp2[i]+1024;
      /*printf ( "-> Pattern [%2ld] is unused ! (saved anyway)\n" , j );*/
      j+=1;
    }
/*fprintf ( info , "%3ld: Pats_Address[0] : %6ld  (j:%ld)\n" , i , Pats_Address[0],j );*/
  }
/*
fprintf ( info , "pats address      pats address tmp\n" );
for ( i=0 ; i<128 ; i++ )
{
  fprintf ( info , "%3ld: %6ld   %ld\n" , i , Pats_Address[i] , Pats_Address_tmp[i] );
}
fflush ( info );
*/
  for ( c1=0x00 ; c1<128 ; c1++ )
  {
    for ( c2=0x00 ; c2<128 ; c2++ )
      if ( Pats_Address[c1] == Pats_Address_tmp[c2] )
      {
        Pats_Numbers_tmp[c1] = c2;
      }
  }


  BZERO ( Pats_Numbers , 128 );
  Start_Pat_Address = 999999l;
  for ( i=0 ; i<128 ; i++ )
  {
    Pats_Numbers[i] = Pats_Numbers_tmp[i];
    if ( Pats_Address[i] < Start_Pat_Address )
      Start_Pat_Address = Pats_Address[i];
  }

  /* try to get the number of pattern in pattern list */
  for ( NOP=128 ; NOP>0x00 ; NOP-- )
    if ( Pats_Numbers[NOP-1] != 0x00 )
      break;

  /* write this value */
  fwrite ( &NOP , 1 , 1 , out );

  /* get highest pattern number */
  for ( i=0 ; i< NOP ; i++ )
    if ( Pats_Numbers[i] > PatMax )
      PatMax = Pats_Numbers[i];

  /*printf ( "Highest pattern number : %d\n" , PatMax );*/

  /* ntk restart byte */
  c2 = 0x7f;
  fwrite ( &c2 , 1 , 1 , out );


  /* write pattern list */
  for ( i=0 ; i<128 ; i++ )
    fwrite ( &Pats_Numbers[i] , 1 , 1 , out );


  /* ID string */
  c1 = 'M';
  c2 = '.';
  c3 = 'K';
  fwrite ( &c1 , 1 , 1 , out );
  fwrite ( &c2 , 1 , 1 , out );
  fwrite ( &c3 , 1 , 1 , out );
  fwrite ( &c2 , 1 , 1 , out );

  Sample_Data_Address = ftell ( in );
  /*printf ( "address of the first pattern : %ld\n" , Start_Pat_Address );*/
  fseek ( in , Start_Pat_Address , 0 );

  /* pattern datas */
  /* read ALL pattern data */
  j = ftell (in);
  fseek ( in , 0 , 2 ); /* SEEK_END */
  Whole_Pattern_Data_Size = ftell (in) - j;
  Whole_Pattern_Data = (Uchar *) malloc ( Whole_Pattern_Data_Size );
  fseek ( in , j , 0 ); /* SEEK_SET */
  fread ( Whole_Pattern_Data , Whole_Pattern_Data_Size , 1 , in );
  /*printf ( "Whole pattern data size : %ld\n" , Whole_Pattern_Data_Size );*/
  PatMax +=1;  /* coz first value is $00 */
  Pattern = (Uchar *) malloc ( PatMax*1024 );
  BZERO ( Pattern , PatMax*1024 );

  j=0;
  for ( i=0 ; i<Whole_Pattern_Data_Size ; i++ )
  {
    if ( Whole_Pattern_Data[i] == 0xff )
    {
      i += 1;
      Old_cpt[(k+3)%4] = 0xff - Whole_Pattern_Data[i];
      continue;
    }
    if ( Old_cpt[k%4] != 0 )
    {
      Smp    = Old_Note_Value[k%4][0];
      Note   = Old_Note_Value[k%4][1];
      Fx     = Old_Note_Value[k%4][2];
      FxVal  = Old_Note_Value[k%4][3];
      Old_cpt[k%4] -= 1;

      Pattern[j]    = Smp&0xf0;
      Pattern[j]   |= poss[(Note/2)][0];
      Pattern[j+1]  = poss[(Note/2)][1];
      Pattern[j+2]  = (Smp<<4)&0xf0;
      Pattern[j+2] |= Fx;
      Pattern[j+3]  = FxVal;
      k+=1;
      j+=4;
      i-=1;
      continue;
    }
    Smp   = Whole_Pattern_Data[i];
    Note  = Whole_Pattern_Data[i+1];
    Fx    = Whole_Pattern_Data[i+2];
    FxVal = Whole_Pattern_Data[i+3];
    Old_Note_Value[k%4][0] = Smp;
    Old_Note_Value[k%4][1] = Note;
    Old_Note_Value[k%4][2] = Fx;
    Old_Note_Value[k%4][3] = FxVal;
    i += 3;
    Pattern[j]    = Smp&0xf0;
    Pattern[j]   |= poss[(Note/2)][0];
    Pattern[j+1]  = poss[(Note/2)][1];
    Pattern[j+2]  = (Smp<<4)&0xf0;
    Pattern[j+2] |= Fx;
    Pattern[j+3]  = FxVal;
    k+=1;
    j+=4;
  }
  fwrite ( Pattern , PatMax*1024 , 1 , out );
  free ( Whole_Pattern_Data );
  free ( Pattern );

  /* Sample data */
  fseek ( in , Sample_Data_Address , 0 ); /* SEEK_SET */
  Sample_Data = (Uchar *) malloc ( Whole_Sample_Size );
  fread ( Sample_Data , Whole_Sample_Size , 1 , in );
  fwrite ( Sample_Data , Whole_Sample_Size , 1 , out );
  free ( Sample_Data );

  Crap ( "    PhaPacker     " , BAD , BAD , out );
  /*
  fseek ( out , 830 , SEEK_SET );
  fprintf ( out , " -[Converted with]- " );
  fseek ( out , 860 , SEEK_SET );
  fprintf ( out , "  -[PhaPacker to]-  " );
  fseek ( out , 890 , SEEK_SET );
  fprintf ( out , "   -[Protracker]-   " );
  fseek ( out , 920 , SEEK_SET );
  fprintf ( out , " -[by Asle /ReDoX]- " );
  */
  fflush ( in );
  fflush ( out );
  fclose ( in );
  fclose ( out );

  printf ( "done\n" );
  return; /* useless ... but */
}
