/*
 *   Promizer_18a.c   1997 (c) Asle / ReDoX
 *
 * Converts PM18a packed MODs back to PTK MODs
 * thanks to Gryzor and his ProWizard tool ! ... without it, this prog
 * would not exist !!!
 *
*/

#ifdef DOS
#include "..\include\globals.h"
#include "..\include\extern.h"
#endif

#ifdef UNIX
#include "../include/globals.h"
#include "../include/extern.h"
#endif

#define ON  0
#define OFF 1

void Depack_PM18a ( void )
{
  Uchar c1=0x00,c2=0x00,c3=0x00,c4=0x00;
  short Pat_Max=0;
  long tmp_ptr;
  short Ref_Max=0;
  Uchar Pats_Numbers[128];
  long Pats_Address[128];
  short Pats_PrePointers[64][256];
  Uchar NOP=0x00; /* number of pattern */
  Uchar *ReferenceTable;
  Uchar *SampleData;
  Uchar Pattern[128][1024];
  long i=0,j=0,k=0,l=0;
  long Total_Sample_Size=0;
  long PatDataSize=0l;
  long SDAV=0l;
  Uchar FLAG=OFF;
  Uchar Smp_Fine_Table[31];
  Uchar poss[37][2];
  Uchar OldSmpValue[4];
  short Period;
  FILE *in,*out;

#ifdef DOS
  #include "..\include\tuning.h"
  #include "..\include\ptktable.h"
#endif

#ifdef UNIX
  #include "../include/tuning.h"
  #include "../include/ptktable.h"
#endif

  if ( Save_Status == BAD )
    return;

  in = fopen ( OutName_final , "r+b" ); /* +b is safe bcoz OutName's just been saved */
  sprintf ( Depacked_OutName , "%ld.mod" , Cpt_Filename-1 );
  out = fopen ( Depacked_OutName , "w+b" );

  BZERO ( Pats_Numbers , 128 );
  BZERO ( Pats_PrePointers , 64*256 );
  BZERO ( Pattern , 128*1024 );
  BZERO ( Smp_Fine_Table , 31 );
  BZERO ( OldSmpValue , 4 );
  BZERO ( Pats_Address , 128*4 );

  for ( i=0 ; i<20 ; i++ )   /* title */
    fwrite ( &c1 , 1 , 1 , out );

  /* bypass replaycode routine */
  fseek ( in , 4464 , 0 );  /* SEEK_SET */

  for ( i=0 ; i<31 ; i++ )
  {
    c1 = 0x00;
    for ( j=0 ; j<22 ; j++ ) /*sample name*/
      fwrite ( &c1 , 1 , 1 , out );

    fread ( &c1 , 1 , 1 , in );  /* size */
    fread ( &c2 , 1 , 1 , in );
    Total_Sample_Size += (((c1*256)+c2)*2);
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );
    fread ( &c1 , 1 , 1 , in );  /* finetune */
    Smp_Fine_Table[i] = c1;
    fwrite ( &c1 , 1 , 1 , out );
    fread ( &c1 , 1 , 1 , in );  /* volume */
    fwrite ( &c1 , 1 , 1 , out );
    fread ( &c1 , 1 , 1 , in );  /* loop start */
    fread ( &c2 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );
    fread ( &c1 , 1 , 1 , in );  /* loop size */
    fread ( &c2 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );
  }

  /* pattern table lenght */
  fread ( &c1 , 1 , 1 , in );
  fread ( &c2 , 1 , 1 , in );
  NOP = ((c1*256)+c2)/4;
  fwrite ( &NOP , 1 , 1 , out );

  /*printf ( "Number of patterns : %d\n" , NOP );*/

  /* NoiseTracker restart byte */
  c1 = 0x7f;
  fwrite ( &c1 , 1 , 1 , out );

  for ( i=0 ; i<128 ; i++ )
  {
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    fread ( &c3 , 1 , 1 , in );
    fread ( &c4 , 1 , 1 , in );
    Pats_Address[i] = (c1*256*256*256)+(c2*256*256)+(c3*256)+c4;
  }

  /* ordering of patterns addresses */

  tmp_ptr = 0;
  for ( i=0 ; i<NOP ; i++ )
  {
    if ( i==0 )
    {
      Pats_Numbers[0] = 0x00;
      tmp_ptr++;
      continue;
    }

    for ( j=0 ; j<i ; j++ )
    {
      if ( Pats_Address[i] == Pats_Address[j] )
      {
        Pats_Numbers[i] = Pats_Numbers[j];
        break;
      }
    }
    if ( j == i )
      Pats_Numbers[i] = tmp_ptr++;
  }

  Pat_Max = tmp_ptr-1;

  /* write pattern table */
  for ( c1=0x00 ; c1<128 ; c1++ )
  {
    fwrite ( &Pats_Numbers[c1] , 1 , 1 , out );
  }

  c1 = 'M';
  c2 = '.';
  c3 = 'K';

  fwrite ( &c1 , 1 , 1 , out );
  fwrite ( &c2 , 1 , 1 , out );
  fwrite ( &c3 , 1 , 1 , out );
  fwrite ( &c2 , 1 , 1 , out );


  /* a little pre-calc code ... no other way to deal with these unknown
     pattern data sizes ! :( */
  fseek ( in , 4460 , 0 ); /* SEEK_SET */
  fread ( &c1 , 1 , 1 , in );
  fread ( &c2 , 1 , 1 , in );
  fread ( &c3 , 1 , 1 , in );
  fread ( &c4 , 1 , 1 , in );
  PatDataSize = (c1*256*256*256)+(c2*256*256)+(c3*256)+c4;
  /* go back to pattern data starting address */
  fseek ( in , 5226 , 0 ); /* SEEK_SET */
  /* now, reading all pattern data to get the max value of note */
  for ( j=0 ; j<PatDataSize ; j+=2 )
  {
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    if ( ((c1*256)+c2) > Ref_Max )
      Ref_Max = (c1*256)+c2;
  }
/*
  printf ( "* Ref_Max = %d\n" , Ref_Max );
  printf ( "* where : %ld\n" , ftell ( in ) );
*/
  /* read "reference Table" */
  Ref_Max += 1;  /* coz 1st value is 0 ! */
  i = Ref_Max * 4; /* coz each block is 4 bytes long */
  ReferenceTable = (Uchar *) malloc ( i );
  fread ( ReferenceTable , i , 1 , in );

  /* go back to pattern data starting address */
  fseek ( in , 5226 , 0 ); /* SEEK_SET */
  /*printf ( "Highest pattern number : %d\n" , Pat_Max );*/


  k=0;
  for ( j=0 ; j<=Pat_Max ; j++ )
  {
    fseek ( in , Pats_Address[j]+5226 , 0 );
    for ( i=0 ; i<64 ; i++ )
    {
      /* VOICE #1 */

      fread ( &c1 , 1 , 1 , in );
      k += 1;
      fread ( &c2 , 1 , 1 , in );
      k += 1;
      Pattern[j][i*16]   = ReferenceTable[((c1*256)+c2)*4];
      Pattern[j][i*16+1] = ReferenceTable[((c1*256)+c2)*4+1];
      Pattern[j][i*16+2] = ReferenceTable[((c1*256)+c2)*4+2];
      Pattern[j][i*16+3] = ReferenceTable[((c1*256)+c2)*4+3];
      c3 = ((Pattern[j][i*16+2]>>4)&0x0f) | (Pattern[j][i*16]&0xf0);
      if ( c3 != 0x00 )
      {
        OldSmpValue[0] = c3;
      }
      Period =  ((Pattern[j][i*16]&0x0f)*256)+Pattern[j][i*16+1];
      if ( (Period != 0) && (Smp_Fine_Table[OldSmpValue[0]-1] != 0x00) )
      {
        for ( l=0 ; l<36 ; l++ )
          if ( Tuning[Smp_Fine_Table[OldSmpValue[0]-1]][l] == Period )
          {
            Pattern[j][i*16]   &= 0xf0;
            Pattern[j][i*16]   |= poss[l+1][0];
            Pattern[j][i*16+1]  = poss[l+1][1];
            break;
          }
      }

      if ( ( (Pattern[j][i*16+2] & 0x0f) == 0x0d ) ||
           ( (Pattern[j][i*16+2] & 0x0f) == 0x0b ) )
      {
        FLAG = ON;
      }

      /* VOICE #2 */

      fread ( &c1 , 1 , 1 , in );
      k += 1;
      fread ( &c2 , 1 , 1 , in );
      k += 1;
      Pattern[j][i*16+4] = ReferenceTable[((c1*256)+c2)*4];
      Pattern[j][i*16+5] = ReferenceTable[((c1*256)+c2)*4+1];
      Pattern[j][i*16+6] = ReferenceTable[((c1*256)+c2)*4+2];
      Pattern[j][i*16+7] = ReferenceTable[((c1*256)+c2)*4+3];
      c3 = ((Pattern[j][i*16+6]>>4)&0x0f) | (Pattern[j][i*16+4]&0xf0);
      if ( c3 != 0x00 )
      {
        OldSmpValue[1] = c3;
      }
      Period =  ((Pattern[j][i*16+4]&0x0f)*256)+Pattern[j][i*16+5];
      if ( (Period != 0) && (Smp_Fine_Table[OldSmpValue[1]-1] != 0x00) )
      {
        for ( l=0 ; l<36 ; l++ )
          if ( Tuning[Smp_Fine_Table[OldSmpValue[1]-1]][l] == Period )
          {
            Pattern[j][i*16+4]   &= 0xf0;
            Pattern[j][i*16+4]   |= poss[l+1][0];
            Pattern[j][i*16+5]  = poss[l+1][1];
            break;
          }
      }

      if ( ( ( Pattern[j][i*16+6] & 0x0f) == 0x0d ) ||
           ( (Pattern[j][i*16+6] & 0x0f) == 0x0b ) )
      {
        FLAG = ON;
      }

      /* VOICE #3 */

      fread ( &c1 , 1 , 1 , in );
      k += 1;
      fread ( &c2 , 1 , 1 , in );
      k += 1;
      Pattern[j][i*16+8] = ReferenceTable[((c1*256)+c2)*4];
      Pattern[j][i*16+9] = ReferenceTable[((c1*256)+c2)*4+1];
      Pattern[j][i*16+10]= ReferenceTable[((c1*256)+c2)*4+2];
      Pattern[j][i*16+11]= ReferenceTable[((c1*256)+c2)*4+3];
      c3 = ((Pattern[j][i*16+10]>>4)&0x0f) | (Pattern[j][i*16+8]&0xf0);
      if ( c3 != 0x00 )
      {
        OldSmpValue[2] = c3;
      }
      Period =  ((Pattern[j][i*16+8]&0x0f)*256)+Pattern[j][i*16+9];
      if ( (Period != 0) && (Smp_Fine_Table[OldSmpValue[2]-1] != 0x00) )
      {
        for ( l=0 ; l<36 ; l++ )
          if ( Tuning[Smp_Fine_Table[OldSmpValue[2]-1]][l] == Period )
          {
            Pattern[j][i*16+8]   &= 0xf0;
            Pattern[j][i*16+8]   |= poss[l+1][0];
            Pattern[j][i*16+9]  = poss[l+1][1];
            break;
          }
      }

      if ( ( (Pattern[j][i*16+10] & 0x0f) == 0x0d ) ||
           ( (Pattern[j][i*16+10] & 0x0f) == 0x0b ) )
      {
        FLAG = ON;
      }

      /* VOICE #4 */

      fread ( &c1 , 1 , 1 , in );
      k += 1;
      fread ( &c2 , 1 , 1 , in );
      k += 1;
      Pattern[j][i*16+12]= ReferenceTable[((c1*256)+c2)*4];
      Pattern[j][i*16+13]= ReferenceTable[((c1*256)+c2)*4+1];
      Pattern[j][i*16+14]= ReferenceTable[((c1*256)+c2)*4+2];
      Pattern[j][i*16+15]= ReferenceTable[((c1*256)+c2)*4+3];
      c3 = ((Pattern[j][i*16+14]>>4)&0x0f) | (Pattern[j][i*16+12]&0xf0);
      if ( c3 != 0x00 )
      {
        OldSmpValue[3] = c3;
      }
      Period =  ((Pattern[j][i*16+12]&0x0f)*256)+Pattern[j][i*16+13];
      if ( (Period != 0) && (Smp_Fine_Table[OldSmpValue[3]-1] != 0x00) )
      {
        for ( l=0 ; l<36 ; l++ )
          if ( Tuning[Smp_Fine_Table[OldSmpValue[3]-1]][l] == Period )
          {
            Pattern[j][i*16+12]   &= 0xf0;
            Pattern[j][i*16+12]   |= poss[l+1][0];
            Pattern[j][i*16+13]  = poss[l+1][1];
            break;
          }
      }

      if ( ( (Pattern[j][i*16+14] & 0x0f) == 0x0d ) ||
           ( (Pattern[j][i*16+14] & 0x0f) == 0x0b ) )
      {
        FLAG = ON;
      }

      if ( FLAG == ON )
      {
        FLAG=OFF;
        break;
      }
    }
    fwrite ( Pattern[j] , 1024 , 1 , out );
  }

  /*printf ( "Highest value in pattern data : %d\n" , Ref_Max );*/

  free ( ReferenceTable );

  fseek ( in , 4456 , 0 ); /* SEEK_SET */
  fread ( &c1 , 1 , 1 , in );
  fread ( &c2 , 1 , 1 , in );
  fread ( &c3 , 1 , 1 , in );
  fread ( &c4 , 1 , 1 , in );
  SDAV = (c1*256*256*256)+(c2*256*256)+(c3*256)+c4;
  fseek ( in , 4460 + SDAV , 0 ); /* SEEK_SET */


  /* Now, it's sample data ... though, VERY quickly handled :) */
  /* thx GCC ! (GNU C COMPILER). */

  /*printf ( "out: where before saving sample data : %ld\n" , ftell ( out ) );*/
  /*printf ( "Total sample size : %ld\n" , Total_Sample_Size );*/
  SampleData = (Uchar *) malloc ( Total_Sample_Size );
  fread ( SampleData , Total_Sample_Size , 1 , in );
  fwrite ( SampleData , Total_Sample_Size , 1 , out );
  free ( SampleData );


  Crap ( "  Promizer v1.8a  " , BAD , BAD , out );
  /*
  fseek ( out , 860 , SEEK_SET );
  fprintf ( out , " -[Converted with]- " );
  fseek ( out , 890 , SEEK_SET );
  fprintf ( out , "  -[PM18a to Ptk]-  " );
  fseek ( out , 920 , SEEK_SET );
  fprintf ( out , " -[by Asle /ReDoX]- " );
  */
  fflush ( in );
  fflush ( out );
  fclose ( in );
  fclose ( out );

  printf ( "done\n" );
  return; /* useless ... but */
}
