/*
 *   QuadraComposer.c   1999 (c) Asle / ReDoX
 *
 * Converts QC MODs back to PTK MODs
 *
*/

#ifdef DOS
#include "..\include\globals.h"
#include "..\include\extern.h"
#endif

#ifdef UNIX
#include "../include/globals.h"
#include "../include/extern.h"
#endif

void Depack_QuadraComposer ( void )
{
  Uchar c1=0x00,c2=0x00,c3=0x00,c4=0x00,c5=0x00;
  Uchar Pat_Pos;
  Uchar Pat_Max=0x00;
  Uchar Real_Pat_Max=0x00;
  Uchar *Whatever;
  Uchar Row[16];
  Uchar Pattern[1024];
  Uchar NbrSample=0x00;
  Uchar RealNbrSample=0x00;
  Uchar NbrRow[128];
  Uchar poss[37][2];    /* <------ Ptk's pitch table */
  long  SmpAddresses[32];
  long  SmpSizes[32];
  long  PatAddresses[128];
  long  i=0,j=0,k=0;
  FILE *in,*out;

  if ( Save_Status == BAD )
    return;

#ifdef DOS
  #include "..\include\ptktable.h"
#endif

#ifdef UNIX
  #include "../include/ptktable.h"
#endif

  in = fopen ( OutName_final , "r+b" ); /* +b is safe bcoz OutName's just been saved */
  sprintf ( Depacked_OutName , "%ld.mod" , Cpt_Filename-1 );
  out = fopen ( Depacked_OutName , "w+b" );


  BZERO ( SmpAddresses , 32*4 );
  BZERO ( SmpSizes , 32*4 );
  BZERO ( PatAddresses , 128*4 );
  BZERO ( NbrRow , 128 );

  /* bypass ID's and chunk sizes */
  fseek ( in , 22 , 0 );

  /* read and write title */
  for ( i=0 ; i<20 ; i++ )
  {
    fread ( &c1 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
  }

  /* bypass composer and tempo */
  fseek ( in , 21 , 1 );

  /* read number of samples */
  fread ( &NbrSample , 1 , 1 , in );

  /* write empty 930 sample header */
  Whatever = (Uchar *) malloc ( 930 );
  BZERO ( Whatever , 930 );
  /* puts some $01 for replen */
  for ( i=0 ; i<31 ; i++ )
    Whatever[i*30+29] = 0x01;
  fwrite ( Whatever , 930 , 1 , out );
  free ( Whatever );

  /* read and write sample descriptions */
/*printf ( "sample number:" );*/
  for ( i=0 ; i<NbrSample ; i++ )
  {
    /* read sample number byte */
    fread ( &c5 , 1 , 1 , in );
    if (c5 > RealNbrSample)
      RealNbrSample = c5;
/*printf ( "%d," , c5 );*/
    fseek ( out ,20+(c5-1)*30 , 0 );

    /* read volume */
    fread ( &c4 , 1 , 1 , in );

    /* read size (/2 like ptk) */
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    SmpSizes[c5] = (((c1*256)+c2)*2);

    /* read/write sample name */
    for ( j=0 ; j<20 ; j++ )
    {
      fread ( &c3 , 1 , 1 , in );
      fwrite ( &c3 , 1 , 1 , out );
    }
    /* fill to 22 with $00 */
    c3=0x00;
    fwrite ( &c3 , 1 , 1 , out );
    fwrite ( &c3 , 1 , 1 , out );

    /* write size */
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );

    /* bypass control byte */
    fseek ( in , 1 , 1 );

    /* read/write finetune */
    fread ( &c1 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );

    /* write volume */
    fwrite ( &c4 , 1 , 1 , out );

    /* read/write loops (start & len) */
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    if ( (c1 == 0x00) && (c2 == 0x00) )
      c2 = 0x01;
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );

    /* read address of this sample in the file */
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    fread ( &c3 , 1 , 1 , in );
    fread ( &c4 , 1 , 1 , in );
    SmpAddresses[c5] =( (c1*256*256*256) +
                        (c2*256*256) +
                        (c3*256) +
                        (c4) );
  }
/*printf ( "\n" );*/
  fseek ( out , 0 , 2 );


  /* patterns now */
  /* bypass "pad" ?!? */
  fread ( &c1 , 1 , 1 , in );
  if ( c1 != 0x00 )
    fseek ( in , -1 , 1 );

  /* read number of pattern */
  fread ( &Pat_Max , 1 , 1 , in );
/*  printf ( "\nPat_Max : %d (at %x)\n" , Pat_Max , ftell ( in ) );*/

  /* read patterns info */
/*printf ( "pattern numbers:" );*/
  for ( i=0 ; i<Pat_Max ; i++ )
  {
    /* read pattern number */
    fread ( &c5 , 1 , 1 , in );
/*printf ("%d," , c5);*/
    /* read number of rows for each pattern */
    fread ( &NbrRow[c5] , 1 , 1 , in );

    /* bypass pattern name */
    fseek ( in , 20 , 1 );

    /* read pattern address */
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    fread ( &c3 , 1 , 1 , in );
    fread ( &c4 , 1 , 1 , in );
    PatAddresses[c5] = ( (c1*256*256*256) +
                        (c2*256*256) +
                        (c3*256) +
                        (c4) );
  }
/*printf ("\n");*/


  /* pattern list */
  /* bypass "pad" ?!? */
  fread ( &c1 , 1 , 1 , in );
  if ( c1 != 0x00 )
    fseek ( in , -1 , 1 );

  /* read/write number of position */
  fread ( &Pat_Pos , 1 , 1 , in );
  fwrite ( &Pat_Pos , 1 , 1 , out );

  /* write noisetracker byte */
  c1 = 0x7f;
  fwrite ( &c1 , 1 , 1 , out );

  /* read/write pattern list */
  for ( i=0 ; i<Pat_Pos ; i++ )
  {
    fread ( &c1 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
    if ( c1 > Real_Pat_Max )
      Real_Pat_Max = c1;
  }
/*printf ( "Real_Pat_Max : %d\n" , Real_Pat_Max );*/
  /* fill up to 128 */
  c2=0x00;
  while ( i<128 )
  {
    fwrite ( &c2 , 1 , 1 , out );
    i++;
  }


  /* write ptk's ID */
  c1 = 'M';
  c2 = '.';
  c3 = 'K';
  fwrite ( &c1 , 1 , 1 , out );
  fwrite ( &c2 , 1 , 1 , out );
  fwrite ( &c3 , 1 , 1 , out );
  fwrite ( &c2 , 1 , 1 , out );


  /* pattern data */
/*printf ( "patterns('-'=empty):" );*/
  for ( i=0 ; i<=Real_Pat_Max ; i++ )
  {
    BZERO ( Pattern , 1024 );
    if ( PatAddresses[i] == 0l )
    {
/*printf ( "-(%d)" , NbrRow[i] );*/
      fwrite ( Pattern , 1024 , 1 , out );
      printf ( "-" );
      continue;
    }
/*printf ( "#" );*/
    fseek ( in , PatAddresses[i] , 0 );
    for ( j=0 ; j<=NbrRow[i] ; j++ )
    {
      BZERO ( Row , 16 );
      fread ( Row , 16 , 1 , in );
      for ( k=0 ; k<4 ; k++ )
      {
        /* Fx */
        Pattern[j*16+k*4+2]  =  Row[k*4+2];

        /* Fx args */
        switch ( Pattern[j*16+k*4+2] )
        {
          case 0x09:
            /*printf ( "#" );*/
            Pattern[j*16+k*4+3]  =  (Row[k*4+3]*2);
            break;
          case 0x0b:
            /*printf ( "!" );*/
            c4 = Row[k*4+3]%10;
            c3 = Row[k*4+3]/10;
            Pattern[j*16+k*4+3] = 16;
            Pattern[j*16+k*4+3] *= c3;
            Pattern[j*16+k*4+3] += c4;
            break;
          case 0x0E:
            if ( (Row[k*4+3]&0xf0) == 0xf0 )
              Pattern[j*16+k*4+3] = (Row[k*4+3]-0x10);
            break;
          default:
            Pattern[j*16+k*4+3]  =  Row[k*4+3];
        }

        /* smp nbr (4 lower bits) */
        Pattern[j*16+k*4+2]  |= ((Row[k*4]<<4)&0xf0);
        /* notes */
        c1 = Row[k*4+1];
        if ( c1 != 0xff )
        {
          Pattern[j*16+k*4]    =  poss[c1][0];
          Pattern[j*16+k*4+1]  =  poss[c1][1];
        }
        /* smp nbr (4 higher bits) */
        Pattern[j*16+k*4]    |= (Row[k*4]&0xf0);
      }
    }
    fwrite ( Pattern , 1024 , 1 , out );
  }

  /* sample data */
/*printf ( "\nsamples('-'=empty):" );*/
  for ( i=1 ; i<=RealNbrSample ; i++ )
  {
    if ( SmpSizes[i] == 0 )
    {
/*printf ( "-(%ld)" , SmpSizes[i] );*/
      continue;
    }
/*printf ( "#" );*/
    fseek ( in , SmpAddresses[i] , 0 );
    Whatever = (Uchar *) malloc ( SmpSizes[i] );
    fread ( Whatever , SmpSizes[i] , 1 , in );
    fwrite ( Whatever , SmpSizes[i] , 1 , out );
    free ( Whatever );
  }
/*printf ( "\n" );*/


/*  printf ( "\nwhere: %ld\n" , ftell ( in ) );*/

  fseek ( in , 0 , 2 );
/*  printf ( "end of file : %ld\n" , ftell ( in ) );*/



  /* crap */
  Crap ( " Quadra Composer  " , BAD , BAD , out );
/*
  fseek ( out , 830 , SEEK_SET );
  fprintf ( out , " -[Converted with]- " );
  fseek ( out , 860 , SEEK_SET );
  fprintf ( out , " -[Quadra Composer]-" );
  fseek ( out , 890 , SEEK_SET );
  fprintf ( out , " -[to Protracker]-  " );
  fseek ( out , 920 , SEEK_SET );
  fprintf ( out , " -[by Asle /ReDoX]- " );
*/


  fflush ( in );
  fflush ( out );
  fclose ( in );
  fclose ( out );

  printf ( "done\n" );
  return; /* useless ... but */
}
