/*
 *   TDD.c   1999 (c) Asle / ReDoX
 *
 * Converts TDD packed MODs back to PTK MODs
 *
*/

#ifdef DOS
#include "..\include\globals.h"
#include "..\include\extern.h"
#endif

#ifdef UNIX
#include "../include/globals.h"
#include "../include/extern.h"
#endif

void Depack_TheDarkDemon ( void )
{
  Uchar c1=0x00,c2=0x00,c3=0x00,c4=0x00;
  Uchar poss[37][2];
  Uchar *Whatever;
  Uchar Pattern[1024];
  Uchar PatMax=0x00;
  long i=0,j=0,k=0;
  long Whole_Sample_Size=0;
  long SampleAddresses[31];
  long SampleSizes[31];
  FILE *in,*out;

  if ( Save_Status == BAD )
    return;

#ifdef DOS
  #include "..\include\ptktable.h"
#endif

#ifdef UNIX
  #include "../include/ptktable.h"
#endif

  BZERO ( SampleAddresses , 31*4 );
  BZERO ( SampleSizes , 31*4 );

  in = fopen ( OutName_final , "r+b" ); /* +b is safe bcoz OutName's just been saved */
  sprintf ( Depacked_OutName , "%ld.mod" , Cpt_Filename-1 );
  out = fopen ( Depacked_OutName , "w+b" );

  /* write ptk header */
  Whatever = (Uchar *) malloc ( 1080 );
  BZERO (Whatever , 1080);
  fwrite ( Whatever , 1080 , 1 , out );
  free ( Whatever );

  /* read/write pattern list + size and ntk byte */
  Whatever = (Uchar *) malloc ( 130 );
  BZERO (Whatever , 130);
  fseek ( out , 950 , 0 );
  fread ( Whatever , 130 , 1 , in );
  fwrite ( Whatever , 130 , 1 , out );
  PatMax = 0x00;
  for ( i=0 ; i<128 ; i++ )
    if ( Whatever[i+2] > PatMax )
      PatMax = Whatever[i+2];
  free ( Whatever );
/*  printf ( "highest pattern number : %x\n" , PatMax );*/


  /* sample descriptions */
/*  printf ( "sample sizes/addresses:" );*/
  for ( i=0 ; i<31 ; i++ )
  {
    fseek ( out , 42+(i*30) , 0 );
    /* sample address */
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    fread ( &c3 , 1 , 1 , in );
    fread ( &c4 , 1 , 1 , in );
    SampleAddresses[i] = ((c1*256*256*256)+
                          (c2*256*256)+
                          (c3*256)+
                           c4);

    /* read/write size */
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    Whole_Sample_Size += (((c1*256)+c2)*2);
    SampleSizes[i] = (((c1*256)+c2)*2);
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );
/*    printf ( "%5ld ,%ld" , SampleSizes[i] , SampleAddresses[i]);*/

    /* read/write finetune */
    fread ( &c1 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );

    /* read/write volume */
    fread ( &c1 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );

    /* read loop start address */
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    fread ( &c3 , 1 , 1 , in );
    fread ( &c4 , 1 , 1 , in );
    j = ((c1*256*256*256)+
         (c2*256*256)+
         (c3*256)+
          c4);
    j -= SampleAddresses[i];
    j /= 2;
    /*****************************************************/
    /* BEWARE: it's PC only code here !!!                */
    /* 68k machines code : c1 = *(Whatever+2);           */
    /* 68k machines code : c2 = *(Whatever+3);           */
    /*****************************************************/
    Whatever = (Uchar *) &j;
    c1 = *(Whatever+1);
    c2 = *Whatever;

    /* write loop start */
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );

    /* read/write replen */
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );
  }
/*  printf ( "\nWhole sample size : %ld\n" , Whole_Sample_Size );*/


  /* bypass Samples datas */
  fseek ( in , Whole_Sample_Size , 1 ); /* SEEK_CUR */
/*  printf ( "address of the pattern data : %ld (%x)\n" , ftell ( in ) , ftell ( in ) );*/

  /* write ptk's ID string */
  fseek ( out , 0 , 2 );
  c1 = 'M';
  c2 = '.';
  c3 = 'K';
  fwrite ( &c1 , 1 , 1 , out );
  fwrite ( &c2 , 1 , 1 , out );
  fwrite ( &c3 , 1 , 1 , out );
  fwrite ( &c2 , 1 , 1 , out );


  /* read/write pattern data */
  Whatever = (Uchar *) malloc (1024);
  for ( i=0 ; i<=PatMax ; i++ )
  {
    BZERO ( Whatever , 1024 );
    BZERO ( Pattern , 1024 );
    fread ( Whatever , 1024 , 1 , in );
    for ( j=0 ; j<64 ; j++ )
    {
/*fprintf ( info , "at : %ld\n" , (ftell ( in )-1024+j*16) );*/
      for ( k=0 ; k<4 ; k++ )
      {
        /* fx arg */
        Pattern[j*16+k*4+3]  = Whatever[j*16+k*4+3];

        /* fx */
        Pattern[j*16+k*4+2]  = Whatever[j*16+k*4+2]&0x0f;

        /* smp */
        Pattern[j*16+k*4]    = Whatever[j*16+k*4]&0xf0;
        Pattern[j*16+k*4+2] |= (Whatever[j*16+k*4]<<4)&0xf0;

        /* note */
        Pattern[j*16+k*4]   |= poss[Whatever[j*16+k*4+1]/2][0];
/*fprintf ( info , "(P[0]:%x)" , Pattern[j*16+k*4] );*/
        Pattern[j*16+k*4+1]  = poss[Whatever[j*16+k*4+1]/2][1];
/*fprintf ( info , "%2x ,%2x ,%2x ,%2x |\n"
               , Whatever[j*16+k*4]
               , Whatever[j*16+k*4+1]
               , Whatever[j*16+k*4+2]
               , Whatever[j*16+k*4+3] );
*/
      }
    }
    fwrite ( Pattern , 1024 , 1 , out );
  }
  free ( Whatever );


  /* Sample data */
/*  printf ( "samples:" );*/
  for ( i=0 ; i<31 ; i++ )
  {
    if ( SampleSizes[i] == 0l )
    {
/*      printf ( "-" );*/
      continue;
    }
    fseek ( in , SampleAddresses[i] , 0 );
    Whatever = (Uchar *) malloc ( SampleSizes[i] );
    fread ( Whatever , SampleSizes[i] , 1 , in );
    fwrite ( Whatever , SampleSizes[i] , 1 , out );
    free ( Whatever );
/*    printf ( "+" );*/
  }


  Crap ( "  The Dark Demon  " , BAD , BAD , out );
/*
  fseek ( out , 830 , SEEK_SET );
  fprintf ( out , " -[Converted with]- " );
  fseek ( out , 860 , SEEK_SET );
  fprintf ( out , "  -[--------- to]-  " );
  fseek ( out , 890 , SEEK_SET );
  fprintf ( out , "   -[Protracker]-   " );
  fseek ( out , 920 , SEEK_SET );
  fprintf ( out , " -[by Asle /ReDoX]- " );
*/
  fflush ( in );
  fflush ( out );
  fclose ( in );
  fclose ( out );

  printf ( "done\n" );
  return; /* useless ... but */
}
