#ifdef DOS
#include "..\include\globals.h"
#include "..\include\extern.h"
#endif

#ifdef UNIX
#include "../include/globals.h"
#include "../include/extern.h"
#endif

/*
 *  at now, when this fonction is called, no global var has been used ...
 * and can be here :). (save for the input file pointer ...)
*/
void Support_Types ( void )
{
  long types_file_size,cpt;
  Uchar read_line[_TYPES_LINE_LENGHT];
  FILE *types_file;

  /* fill with $00 ... "Extension" is global */
  memset ( Extensions, 0, sizeof Extensions );

  types_file = fopen ( _TYPES_FILENAME , "rb" );
  if ( types_file == NULL )
  {
    printf ( "!!! couldn't find \"%s\" file !. Default extension used.\n"
             , _TYPES_FILENAME );
    Support_Types_FileDefault ();
    return;
  }

  /* get "_TYPES_" size */
  fseek ( types_file , 0 , 2 ); /* SEEK_END */
  types_file_size = ftell ( types_file );
  fseek ( types_file , 0 , 0 ); /* SEEK_SET */

  PW_i = 0;  /* will inc up to _KNOWN_FORMATS */
  while ( ftell ( types_file ) < types_file_size )
  {
    memset ( read_line, 0, _TYPES_LINE_LENGHT );
    fgets ( read_line , _TYPES_LINE_LENGHT , types_file );
    if ( read_line[0] == '#' )
      continue;
    if ( sizeof ( read_line ) < 2 )
    {
      printf ( "!!! Damaged \"%s\" file at non-commented line %ld\n"
             , _TYPES_FILENAME , PW_i+1 );
      PW_i = 99999l;
      break;
    }
    cpt = 0;
    while ( read_line[cpt] != 0x00 && read_line[cpt] != 0x0a && read_line[cpt] != 0x0d )
    {
      Extensions[PW_i][cpt] = read_line[cpt];
      cpt += 1;
    }
    /*printf ( "%ld:%s," , ftell (types_file),read_line );*/
    PW_i += 1;
    if ( PW_i == _KNOWN_FORMATS )
      break;
  }

  if ( PW_i != _KNOWN_FORMATS )
  {
    printf ( "!!! Damaged \"%s\" file. Missing up %ld extensions definitions\n"
             , _TYPES_FILENAME , _KNOWN_FORMATS-(PW_i+1));
    Support_Types_FileDefault ();
    return;
  }

  fclose ( types_file );
}

/*Uchar *XighExtensions[_KNOWN_FORMATS+1];*/

/*
 * fill the global "Extension" with default extensions if a pb happened
 * while reading "_TYPES_" editable extensions file
*/
void Support_Types_FileDefault ( void )
{
  /* xigh examples */
  /*  strdup( Extensions[0], "AC1" );
      strdup( Extensions[12], "MegaBixExtension" );*/

  /* note: "_TYPES_" file first entry is 1 ! */
  strcpy ( Extensions[0]  , "ac1d" );
  strcpy ( Extensions[1]  , "bp" );
  strcpy ( Extensions[2]  , "fc-m" );
  strcpy ( Extensions[3]  , "hrt" );
  strcpy ( Extensions[4]  , "kris" );
  strcpy ( Extensions[5]  , "PowerMusic" );
  strcpy ( Extensions[6]  , "Promizer10c" );
  strcpy ( Extensions[7]  , "Promizer18a" );
  strcpy ( Extensions[8]  , "Promizer20" );
  strcpy ( Extensions[9]  , "ProRunner1" );
  strcpy ( Extensions[10] , "ProRunner2" );
  strcpy ( Extensions[11] , "skyt" );
  strcpy ( Extensions[12] , "WantonPacker" );
  strcpy ( Extensions[13] , "xann" );
  strcpy ( Extensions[14] , "ModuleProtector" );
  strcpy ( Extensions[15] , "DigitalIllusion" );
  strcpy ( Extensions[16] , "PhaPacker" );
  strcpy ( Extensions[17] , "Promizer01" );
  strcpy ( Extensions[18] , "ProPacker21" );
  strcpy ( Extensions[19] , "ProPacker30" );
  strcpy ( Extensions[20] , "Eureka" );
  strcpy ( Extensions[21] , "StarTrekkerPack" );
  strcpy ( Extensions[22] , "mod" );
  strcpy ( Extensions[23] , "unic1" );
  strcpy ( Extensions[24] , "unic2" );
  strcpy ( Extensions[25] , "Fuzzac" );
  strcpy ( Extensions[26] , "gmc" );
  strcpy ( Extensions[27] , "crb" );
  strcpy ( Extensions[28] , "ksm" );
  strcpy ( Extensions[29] , "Noiserunner" );
  strcpy ( Extensions[30] , "NoisePacker1" );
  strcpy ( Extensions[31] , "NoisePacker2" );
  strcpy ( Extensions[32] , "NoisePacker3" );
  strcpy ( Extensions[33] , "P40A" );
  strcpy ( Extensions[34] , "P40B" );
  strcpy ( Extensions[35] , "P41A" );
  strcpy ( Extensions[36] , "Promizer4" );
  strcpy ( Extensions[37] , "ProPacker1" );
  strcpy ( Extensions[38] , "TrackerPacker1" );
  strcpy ( Extensions[39] , "TrackerPacker2" );
  strcpy ( Extensions[40] , "TrackerPacker3" );
  strcpy ( Extensions[41] , "ZenPacker" );
  strcpy ( Extensions[42] , "P50A" );
  strcpy ( Extensions[43] , "P60A" );
  strcpy ( Extensions[44] , "mod" );
  strcpy ( Extensions[45] , "StoneCrackerData" );
  strcpy ( Extensions[46] , "P61A" );
  strcpy ( Extensions[47] , "stim" );
  strcpy ( Extensions[48] , "mod" );
  strcpy ( Extensions[49] , "TetraPack22" );
  strcpy ( Extensions[50] , "CrunchmaniaData" );
  strcpy ( Extensions[51] , "DefjamCruncher" );
  strcpy ( Extensions[52] , "Tetrapack21" );
  strcpy ( Extensions[53] , "ice" );
  strcpy ( Extensions[54] , "ByteKiller" );
  strcpy ( Extensions[55] , "xpk" );
  strcpy ( Extensions[56] , "Imploder" );
  strcpy ( Extensions[57] , "rnc" );
  strcpy ( Extensions[58] , "DoubleAction" );
  strcpy ( Extensions[59] , "PowerPacker3" );
  strcpy ( Extensions[60] , "PowerPacker4" );
  strcpy ( Extensions[61] , "PowerPacker23" );
  strcpy ( Extensions[62] , "SpikeCruncher" );
  strcpy ( Extensions[63] , "Tetrapack102" );
  strcpy ( Extensions[64] , "TimeCruncher17" );
  strcpy ( Extensions[65] , "MegaCruncher" );
  strcpy ( Extensions[66] , "jam" );
  strcpy ( Extensions[67] , "BSI-FC" );
  strcpy ( Extensions[68] , "digi" );
  strcpy ( Extensions[69] , "qc" );
  strcpy ( Extensions[70] , "TheDarkDemon" );
  strcpy ( Extensions[71] , "FuchsTracker" );
  strcpy ( Extensions[72] , "SynchroPacker46" );
  strcpy ( Extensions[73] , "TNMCruncher11" );
  strcpy ( Extensions[74] , "SuperCruncher27" );
  strcpy ( Extensions[75] , "PPbk" );
  strcpy ( Extensions[76] , "RelokIt1" );
  strcpy ( Extensions[77] , "$08090A08" );
  strcpy ( Extensions[78] , "fire" );
  strcpy ( Extensions[79] , "MacPacker12" );
  strcpy ( Extensions[80] , "SoundFX13" );
  strcpy ( Extensions[81] , "arcD" );
  strcpy ( Extensions[82] , "para" );
  strcpy ( Extensions[83] , "crnd" );
  strcpy ( Extensions[84] , "-sb-" );
  strcpy ( Extensions[85] , "sf" );
  strcpy ( Extensions[86] , "RLE" );
  strcpy ( Extensions[87] , "VDC0" );
  strcpy ( Extensions[88] , "sq" );
  strcpy ( Extensions[89] , "sp" );
  strcpy ( Extensions[90] , "ST26" );
  strcpy ( Extensions[91] , "IT10" );
  strcpy ( Extensions[92] , "HQCCruncher2" );
  strcpy ( Extensions[93] , "TtyItCruncher101" );
  strcpy ( Extensions[94] , "FC13" );
  strcpy ( Extensions[95] , "FC14" );
  strcpy ( Extensions[96] , "1AM" );
  strcpy ( Extensions[97] , "2AM" );
  strcpy ( Extensions[98] , "med" );
  strcpy ( Extensions[99] , "AceCruncherData" );
  strcpy ( Extensions[100], "Newtron" );
  strcpy ( Extensions[101], "GPMO" );
  strcpy ( Extensions[102], "---" );
}




/*
 * saving what's found. Mainly music file here.
 * PW_Start_Address & OutputSize are global .. not everybody likes
 * that :(. I just cant seem to manage it otherwise.
*/
void Save_Rip ( char * format_to_save, int FMT_EXT )
{
  Save_Status = BAD;
  printf ( "%s found at %ld !. its size is : %ld\n", format_to_save , PW_Start_Address , OutputSize );
  if ( (PW_Start_Address + OutputSize) > PW_in_size )
  {
    printf ( "!!! Truncated, missing (%ld byte(s) !)\n"
             , (PW_Start_Address+OutputSize)-PW_in_size );
    PW_i += 2 ;
    return;
  }
  BZERO ( OutName_final, sizeof OutName_final);
  sprintf ( OutName_final , "%ld.%s" , Cpt_Filename , Extensions[FMT_EXT] );
  printf ( "  saving in file \"%s\" ... " , OutName_final );
  Cpt_Filename += 1;
  PW_out = fopen ( OutName_final , "w+b" );
  fwrite ( &in_data[PW_Start_Address] , OutputSize , 1 , PW_out );
  fclose ( PW_out );
  printf ( "done\n" );
  if ( CONVERT == GOOD )
  {
    printf ( "  converting to Protracker ... " );
  }
  fflush ( stdout );
  Save_Status = GOOD;
}

/*
 * Special cases for files with header to rebuild ...
 *
*/
void Save_Rip_Special ( char * format_to_save, int FMT_EXT, Uchar * Header_Block , Ulong Block_Size )
{
  Save_Status = BAD;
  printf ( "%s found at %ld !. its size is : %ld\n", format_to_save , PW_Start_Address , OutputSize );
  if ( (PW_Start_Address + OutputSize) > PW_in_size )
  {
    printf ( "!!! Truncated, missing (%ld byte(s) !)\n"
             , (PW_Start_Address+OutputSize)-PW_in_size );
    PW_i += 2 ;
    return;
  }
  BZERO (OutName_final, sizeof OutName_final);
  sprintf ( OutName_final , "%ld.%s" , Cpt_Filename , Extensions[FMT_EXT] );
  printf ( "  saving in file \"%s\" ... " , OutName_final );
  Cpt_Filename += 1;
  PW_out = fopen ( OutName_final , "w+b" );
  fwrite ( Header_Block , Block_Size  , 1 , PW_out );
  fwrite ( &in_data[PW_Start_Address] , OutputSize , 1 , PW_out );
  fclose ( PW_out );
  printf ( "done\n" );
  if ( CONVERT == GOOD )
  {
    printf ( "  converting to Protracker ... " );
  }
  printf ( "  Header of this file was missing and has been rebuilt !\n" );
  fflush ( stdout );
  Amiga_EXE_Header = GOOD;
  Save_Status = GOOD;
}



/* writing craps in converted MODs */
void Crap ( Uchar *Format , Uchar Delta , Uchar Pack , FILE *out )
{
  fseek ( out , 560 , SEEK_SET );
  fprintf ( out , "[  Converted with  ]" );
  fseek ( out , 590 , SEEK_SET );
  fprintf ( out , "[ ProWizard for PC ]" );
  fseek ( out , 620 , SEEK_SET );
  fprintf ( out , "[ written by Asle! ]" );

  fseek ( out , 680 , SEEK_SET );
  fprintf ( out , "[ Original Format: ]" );
  fseek ( out , 710 , SEEK_SET );
  fprintf ( out , "[%s]" , Format );

  if ( Delta == GOOD )
  {
    fseek ( out , 770 , SEEK_SET );
    fprintf ( out , "[! smp were DELTA  ]" );
  }
  if ( Pack == GOOD )
  {
    fseek ( out , 800 , SEEK_SET );
    fprintf ( out , "[! smp were PACKED ]" );
  }
}


/*
 * Special version of Test() for cruncher data (Ice! etc...)
 * only one file and not hundreds ...
*/
short testSpecialCruncherData ( long Pack_addy , long Unpack_addy )
{
  PW_Start_Address = PW_i;

  /* a small test preventing hangover :) ... */
  /* e.g. addressing of unassigned data */
  if ( ( PW_i + Pack_addy ) > PW_in_size )
  {
/*printf ( "#0\n" );*/
    return BAD;
  }

  /* packed size */
  /* first byte is sometime used ... "SQ is an ex" */
  PW_l = ( (in_data[PW_Start_Address+Pack_addy+1]*256*256) +
           (in_data[PW_Start_Address+Pack_addy+2]*256) +
            in_data[PW_Start_Address+Pack_addy+3] );
  /* unpacked size */
  PW_k = ( (in_data[PW_Start_Address+Unpack_addy]*256*256*256) +
           (in_data[PW_Start_Address+Unpack_addy+1]*256*256) +
           (in_data[PW_Start_Address+Unpack_addy+2]*256) +
            in_data[PW_Start_Address+Unpack_addy+3] );

  if ( (PW_k <= 2) || (PW_l <= 2) )
  {
/*printf ( "#1\n" );*/
    return BAD;
  }

  if ( PW_l > 0xFFFFFF )
  {
/*printf ( "#2\n" );*/
    return BAD;
  }

  if ( PW_k <= PW_l )
  {
/*printf ( "#3\n" );*/
    return BAD;
  }

  if ( PW_k > 0x1ffffff )  /* 33 Megs ! */
  {
/*printf ( "#4\n" );*/
    return BAD;
  }

  return GOOD;
}

/*
 * Special version of Rip() for cruncher data (Ice! etc...)
 * only one file and not hundreds ...
*/
void Rip_SpecialCruncherData ( char *Packer_Name , long Header_Size , int Packer_Extension_Define )
{
  /* PW_l IS the whole size -Header_Size */
  /* various Data crunchers need a little calculation beside the "+" or "-" */
  switch (Header_Size)
  {
    case 999991: /* SQ data cruncher */
      PW_l *= 4;
      PW_l += 10;
      OutputSize = PW_l;
      break;
    default:
      OutputSize = PW_l + Header_Size;
  }

  /* printf ( "\b\b\b\b\b\b\b\b%s file found at %ld !. its size is : %ld\n" , Packer_Name , PW_Start_Address , OutputSize );*/
  /*  OutName[1] = Extensions[Packer_Extension_Define][0];
  OutName[2] = Extensions[Packer_Extension_Define][1];
  OutName[3] = Extensions[Packer_Extension_Define][2];*/

  CONVERT = BAD;
  Save_Rip ( Packer_Name, Packer_Extension_Define );
  
  if ( Save_Status == GOOD )
//    PW_i += (OutputSize - 2);  /* 0 should do but call it "just to be sure" :) */
    PW_i += Header_Size;  /* test to overcome fake datas */
  PW_WholeSampleSize = 0;

}
