//
// /home/ms/source/sidplay/libsidplay/fformat/RCS/mus_.cpp,v
//

#include "mus_.h"


const char text_format[] = "C64 Stereo-/Sidplayer format (MUS)";
const uword HLTcmd = 0x14F;


bool sidTune::MUS_fileSupport( void* musBuffer, udword musLength )
{
	// Remove any format description or format error string.
	info.formatString = 0;
	
	smartPtr<ubyte> spMus((ubyte*)musBuffer,musLength);
	// Skip load address and 3x length entry.
	udword voice1Index = (2+3*2);
	// Add length of voice 1 data.
	voice1Index += readEndian(spMus[3],spMus[2]);
	// Add length of voice 2 data.
	udword voice2Index = voice1Index + readEndian(spMus[5],spMus[4]);
	// Add length of voice 3 data.
	udword voice3Index = voice2Index + readEndian(spMus[7],spMus[6]);
	if ( (readEndian(spMus[voice1Index-2],spMus[voice1Index+1-2]) != HLTcmd)
		|| (readEndian(spMus[voice2Index-2],spMus[voice2Index+1-2]) != HLTcmd)
		|| (readEndian(spMus[voice3Index-2],spMus[voice3Index+1-2]) != HLTcmd)
		|| !spMus )
	{ 
		return false;
	}

	infoString[0][0] = 0;  // clear info strings
	infoString[1][0] = 0;
	infoString[2][0] = 0;
	infoString[3][0] = 0;
	infoString[4][0] = 0;

  	// Voice3Index now is offset to text lines (uppercase Pet-strings).
	smartPtr<char> spPet((char*)musBuffer,musLength);
	spPet += voice3Index;
	for ( int line = 0; line < 5; line++ )
	{
		char c;
		char si = 0;  // count copied characters 
		do 
		{
			c = *spPet;
			spPet++;
			// Do not forget to fix this Pet-filtering !
			if (( c >= 0x20 ) && ( c < 96 ) && ( si < 31 ))
			{
				infoString[line][si] = c;  // copy to info string
				si++;
			}
		} 
		while ( !((c == 0x0D) || (c == 0x00) || spPet.fail()) ); 
		info.infoString[line] = &infoString[line][0];
	}
	info.numberOfInfoStrings = 5;
	
	info.loadAddr = 0x1000;
	info.initAddr = 0xc7b0;
	info.playAddr = 0;
	info.songs = (info.startSong = 1);
	info.musPlayer = true;
	fileOffset = 2;  // offset to the C64 lo/hi load address
	songSpeed[0] = SIDTUNE_SPEED_CIA_1A;
	info.formatString = text_format;
	return true;
}


ubyte sidplayer[] =
{
  0xc5,0xc0,0x4c,0x56,0xc2,0x4c, 0xf,0xc5,0xec,0xc1,0x31,0xea,0xd5,0xc0,0xd5,0xc0,
  0xd5,0xc0,0x60, 0x1, 0x2, 0x4, 0x0, 0x7, 0xe, 0x1, 0x0,0xff, 0x0, 0x2, 0x4, 0x5,
   0x7, 0x9, 0xb,0x1e,0x18,0x8b,0x7e,0xfa, 0x6,0xac,0xf3,0xe6,0x8f,0xf8,0x2e,0x86,
  0x8e,0x96,0x9f,0xa8,0xb3,0xbd,0xc8,0xd4,0xe1,0xee,0xfd,0x8c,0x78,0x64,0x50,0x3c,
  0x28,0x14, 0x0, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xf,0x11,0x12, 0x0,
  0xe0, 0x0, 0x4, 0x8, 0xc,0xf9, 0x0,0xf5,0x78,0xa2, 0x2,0xbd,0x13, 0x3,0x9d,0xcc,
  0xc0,0xbd,0xca,0xc0,0x9d,0x13, 0x3,0xca,0xd0,0xf1,0x8e, 0x0,0xc0,0x58,0x60,0xa9,
   0x0,0x8d, 0x0,0xc0,0x86,0xfb,0x84,0xfc,0xa0,0xc4,0x99, 0x0,0xc0,0x88,0xd0,0xfa,
  0x8d,0x17,0xd4,0x8d,0x15,0xd4,0x8d,0x16,0xd4,0xa9, 0x8,0x8d,0x1d,0xc0,0x8d,0x18,
  0xd4,0xa9,0x90,0x8d,0x1e,0xc0,0xa9, 0xc,0x8d,0x1f,0xc0,0xa9,0xd4,0x85,0xfe,0xa2,
   0x2,0xa9, 0x1,0x9d,0x21,0xc0,0xa9, 0x4,0x9d,0x27,0xc0,0xa9, 0x4,0x9d,0x6f,0xc0,
  0xbd,0x14,0xc1,0x9d,0x8a,0xc0,0xbd,0xd9,0xc0,0x85,0xfd,0xa9, 0x0,0xa0, 0x2,0x91,
  0xfd,0xa9, 0x8,0x9d, 0xe,0xc0,0x9d,0x63,0xc0,0xc8,0x91,0xfd,0xc8,0x91,0xfd,0xa9,
  0x40,0x9d,0x11,0xc0,0x91,0xfd,0xa9,0x20,0x9d,0x14,0xc0,0xc8,0x91,0xfd,0xa9,0xf5,
  0x9d,0x17,0xc0,0xc8,0x91,0xfd,0xca,0x10,0xb8,0xa5,0xfb,0x18,0x69, 0x6,0x85,0xfd,
  0xa9, 0x0,0xaa,0xa8,0x65,0xfc,0x85,0xfe,0x9d,0x7e,0xc0,0x9d,0x84,0xc0,0xa5,0xfd,
  0x9d,0x7b,0xc0,0x9d,0x81,0xc0,0x18,0x71,0xfb,0x85,0xfd,0xa5,0xfe,0xc8,0x71,0xfb,
  0xc8,0xe8,0xe0, 0x3,0xd0,0xe0,0xa6,0xfd,0xa8,0x60,0x78,0xad,0xcd,0xc0,0x8d,0x14,
   0x3,0xad,0xce,0xc0,0x8d,0x15, 0x3,0x58,0x60,0xad, 0xd,0xdc,0xad, 0x0,0xc0,0x30,
  0x57, 0x9,0x80,0xa8,0x29, 0x7,0xf0,0x55,0xd8,0x8c, 0x0,0xc0,0xa9,0xd4,0x85,0xfc,
  0x58,0xa2, 0x0,0xad, 0x0,0xc0,0x3d,0xd6,0xc0,0xf0, 0xd,0x8e,0x20,0xc0,0x20,0xc5,
  0xc0,0xad, 0x0,0xc0,0x29,0x78,0xd0,0x32,0xe8,0xe0, 0x3,0xd0,0xe6,0xca,0xad, 0x0,
  0xc0,0x3d,0xd6,0xc0,0xf0,0x19,0xbd,0xd9,0xc0,0x85,0xfb,0xbd, 0x5,0xc0,0xa0, 0x0,
  0x91,0xfb,0xbd, 0x8,0xc0,0xc8,0x91,0xfb,0xbd,0x78,0xc0,0xa0, 0x4,0x91,0xfb,0xca,
  0x10,0xdc,0xad, 0x0,0xc0,0x29,0x7f,0x2c,0xa9, 0x8,0x8d, 0x0,0xc0,0x6c,0xcd,0xc0,
  0x6c,0xcf,0xc0,0xbd,0xd9,0xc0,0x85,0xfb,0xde,0x21,0xc0,0xf0,0x4f,0xbd,0x24,0xc0,
  0x30,0xee,0xd0, 0xe,0xbd,0x27,0xc0,0xdd,0x21,0xc0,0x90, 0x6,0xbd,0x11,0xc0,0x9d,
  0x78,0xc0,0xbd,0x2a,0xc0,0xf0,0x56, 0xa,0xbd, 0x5,0xc0,0xb0,0x31,0x7d,0x2d,0xc0,
  0x9d, 0x5,0xc0,0xa8,0xbd, 0x8,0xc0,0x7d,0x30,0xc0,0x9d, 0x8,0xc0,0x48,0x98,0xdd,
  0x54,0xc0,0x68,0xfd,0x57,0xc0,0x90,0x33,0xbd,0x54,0xc0,0x9d, 0x5,0xc0,0xbd,0x57,
  0xc0,0x9d, 0x8,0xc0,0xa9, 0x0,0x9d,0x2a,0xc0,0x18,0x90,0x1f,0xf0,0x75,0xfd,0x2d,
  0xc0,0x9d, 0x5,0xc0,0xbd, 0x8,0xc0,0xfd,0x30,0xc0,0x9d, 0x8,0xc0,0xbd,0x54,0xc0,
  0xdd, 0x5,0xc0,0xbd,0x57,0xc0,0xfd, 0x8,0xc0,0xb0,0xcd,0x90,0x65,0xbd,0x33,0xc0,
  0xf0,0x60,0xa0, 0x0,0xde,0x36,0xc0,0xd0,0x31,0xbd,0x39,0xc0,0x1d,0x3c,0xc0,0xd0,
  0x1b,0xbd,0x45,0xc0,0x9d,0x3f,0xc0,0x9d,0x36,0xc0,0xbd,0x33,0xc0, 0xa,0xbd,0x42,
  0xc0,0x90, 0x4,0x49,0xff,0x69, 0x0,0x9d,0x33,0xc0,0xd0,0x10,0xbd,0x3f,0xc0,0x9d,
  0x36,0xc0,0x98,0x38,0xfd,0x33,0xc0,0x9d,0x33,0xc0,0xc9, 0x0,0x10, 0x1,0x88,0x18,
  0x7d,0x39,0xc0,0x9d,0x39,0xc0,0x48,0x98,0x7d,0x3c,0xc0,0x9d,0x3c,0xc0,0xa8,0x68,
  0x18,0x90, 0x2,0xf0,0x55,0x7d,0x54,0xc0,0x9d, 0x5,0xc0,0x98,0x7d,0x57,0xc0,0x9d,
   0x8,0xc0,0xbd,0x5a,0xc0,0xf0,0x17,0x18,0x7d, 0xb,0xc0,0x9d, 0xb,0xc0,0xa0, 0x2,
  0x91,0xfb,0xbd,0x5d,0xc0,0x7d, 0xe,0xc0,0x9d, 0xe,0xc0,0xc8,0x91,0xfb,0xa0, 0x0,
  0xbd,0x69,0xc0,0xf0,0x22,0x10, 0x1,0xc8,0x18,0x6d,0x1a,0xc0,0x48,0x29, 0x7,0x8d,
  0x1a,0xc0,0x8d,0x15,0xd4,0x68,0x6a,0x4a,0x4a,0x18,0x79,0x12,0xc1,0x18,0x6d,0x1b,
  0xc0,0x8d,0x1b,0xc0,0x8d,0x16,0xd4,0x6c,0xcf,0xc0,0xbd,0x7b,0xc0,0x85,0xfd,0xbd,
  0x7e,0xc0,0x85,0xfe,0xd0, 0x6,0x6c,0xd1,0xc0,0x20,0xc8,0xc0,0xad, 0x0,0xc0,0x3d,
  0xd6,0xc0,0xf0,0xf2,0xa0, 0x0,0xb1,0xfd,0x85,0xff,0xc8,0xb1,0xfd,0xa8,0xa5,0xfd,
  0x18,0x69, 0x2,0x85,0xfd,0x9d,0x7b,0xc0,0xa5,0xfe,0x69, 0x0,0x85,0xfe,0x9d,0x7e,
  0xc0,0xa5,0xff,0x29, 0x3,0xd0,0xd2,0xbd,0x54,0xc0,0x9d, 0x5,0xc0,0xbd,0x57,0xc0,
  0x9d, 0x8,0xc0,0x98,0x9d, 0x2,0xc0,0x29,0x38,0x4a,0x4a,0x4a,0x7d,0x48,0xc0,0x85,
  0xfd,0x98,0x29,0xc0, 0xa,0x2a,0x2a,0xa8,0xb9,0xdb,0xc0,0x85,0xfe,0xbd, 0x2,0xc0,
  0x29, 0x7,0xf0,0x68,0xd0, 0x2,0xf0,0x92,0xa8,0xb9,0xde,0xc0,0x65,0xfe,0x18,0x7d,
  0x4b,0xc0,0x10, 0x5,0x18,0x69, 0xc,0xe6,0xfd,0xc9, 0xc,0x90, 0x4,0xe9, 0xc,0xc6,
  0xfd,0x85,0xfe,0xa8,0xa5,0xff,0x48,0xb9,0xf2,0xc0,0x85,0xff,0xb9,0xe6,0xc0,0xa4,
  0xfd,0x88,0x30, 0x6,0x46,0xff,0x6a,0x88,0x10,0xfa,0x18,0x7d,0x4e,0xc0,0x9d,0x54,
  0xc0,0xa5,0xff,0x7d,0x51,0xc0,0x9d,0x57,0xc0,0x68,0x85,0xff,0x29,0x1c,0xf0,0xb6,
  0xbd,0x2d,0xc0,0x1d,0x30,0xc0,0xf0,0x16,0xbd, 0x5,0xc0,0xdd,0x54,0xc0,0xbd, 0x8,
  0xc0,0xfd,0x57,0xc0,0xa9,0xfe,0x6a,0x9d,0x2a,0xc0,0x90,0x11,0xf0,0x57,0x9d,0x2a,
  0xc0,0xbd,0x54,0xc0,0x9d, 0x5,0xc0,0xbd,0x57,0xc0,0x9d, 0x8,0xc0,0xbd,0x24,0xc0,
   0xa,0xd0,0x42,0xbd,0x5a,0xc0,0xf0,0x13,0xbd,0x60,0xc0,0x9d, 0xb,0xc0,0xa0, 0x2,
  0x91,0xfb,0xbd,0x63,0xc0,0x9d, 0xe,0xc0,0xc8,0x91,0xfb,0xbd,0x66,0xc0,0xf0, 0xf,
  0xa4,0xfd,0x18,0x79,0xfe,0xc0,0xa4,0xfe,0x18,0x79, 0x6,0xc1,0x18,0x90, 0x8,0xbd,
  0x69,0xc0,0xf0,0x11,0xbd,0x6c,0xc0,0x8d,0x1b,0xc0,0x8d,0x16,0xd4,0xa9, 0x0,0x8d,
  0x1a,0xc0,0x8d,0x15,0xd4,0xa5,0xff,0xa8,0x29,0x20,0x85,0xff,0x98,0x29,0x40,0x9d,
  0x24,0xc0,0x98,0x29,0x1c,0x4a,0x4a,0xa8,0xad,0x1f,0xc0,0x88,0xf0,0x1c,0xad,0x1e,
  0xc0,0xd0, 0x1,0x38,0x88,0xf0, 0x6,0x6a,0xb0,0x39,0x88,0xd0,0xfa,0xa4,0xff,0x85,
  0xff,0xf0, 0x7,0x4a,0xb0,0x2d,0x65,0xff,0xb0,0x2c,0x9d,0x21,0xc0,0xbd,0x6f,0xc0,
   0xa, 0xa,0x1d,0x72,0xc0, 0xa,0x1d,0x75,0xc0, 0xa,0x9d,0x11,0xc0,0x38,0xbd, 0x2,
  0xc0,0x29, 0x7,0xd0, 0x3,0x7e,0x24,0xc0,0xbd,0x11,0xc0,0x69, 0x0,0x9d,0x78,0xc0,
  0x6c,0xd1,0xc0,0xa9,0x10,0x2c,0xa9,0x18,0x8d, 0x0,0xc0,0x60,0x98,0x48,0xa5,0xff,
  0x4a,0xb0,0x71,0x4a,0x4a,0xb0,0x1f,0x4a,0xb0, 0xf,0x9d,0x63,0xc0,0xa0, 0x3,0x91,
  0xfb,0x68,0x9d,0x60,0xc0,0x88,0x91,0xfb,0x60,0x4a,0x90, 0x2, 0x9,0xf8,0x9d,0x51,
  0xc0,0x68,0x9d,0x4e,0xc0,0x60,0x4a,0x90, 0xb,0x4a,0x68,0xb0, 0x6,0x9d,0x6c,0xc0,
  0x8d,0x16,0xd4,0x60,0xa8,0xf0,0x22,0x68,0x88,0xf0,0x23,0x88,0xf0,0x24,0x88,0xf0,
  0x25,0x88,0xf0,0x32,0x88,0xf0,0x33,0x88,0xf0,0x3c,0x88,0xf0,0x3d,0x88,0xf0,0x59,
  0x88,0xf0,0x5a,0x88,0xf0,0x5b,0x6c,0xd3,0xc0,0x68,0x8d,0x1e,0xc0,0x60,0x8d,0x1f,
  0xc0,0x60,0x9d,0x27,0xc0,0x60,0x9d,0x87,0xc0,0xa5,0xfd,0x9d,0x81,0xc0,0xa5,0xfe,
  0x9d,0x84,0xc0,0x60,0xb0,0x55,0x8d, 0x1,0xc0,0x60,0x9d,0x5a,0xc0, 0xa,0x90, 0x1,
  0x88,0x98,0x9d,0x5d,0xc0,0x60,0x9d,0x69,0xc0,0x60,0xa8,0xd0, 0x4,0x9d,0x33,0xc0,
  0x60,0x9d,0x42,0xc0,0xbc,0x33,0xc0,0xd0, 0xf,0x9d,0x33,0xc0,0x98,0x9d,0x39,0xc0,
  0x9d,0x3c,0xc0,0xa9, 0x1,0x9d,0x36,0xc0,0x60,0x9d,0x45,0xc0,0x60,0x9d,0x66,0xc0,
  0x60,0x4a,0x90, 0x2,0xc8,0x18,0x48,0x29, 0x7,0x79,0x18,0xc1,0x9d,0x48,0xc0,0x68,
  0x4a,0x4a,0x4a,0x18,0x79,0x19,0xc1,0x9d,0x4b,0xc0,0x60,0x4a,0x90, 0x8,0x9d,0x30,
  0xc0,0x68,0x9d,0x2d,0xc0,0x60,0x68,0x4a,0xb0,0x5c,0x4a,0xb0,0x2c,0x4a,0xb0, 0x5,
  0x4a,0xa0,0xf0,0xd0, 0x6, 0xa, 0xa, 0xa, 0xa,0xa0, 0xf,0x85,0xff,0x98,0xa0, 0x5,
  0xb0, 0xb,0x3d,0x14,0xc0, 0x5,0xff,0x9d,0x14,0xc0,0x91,0xfb,0x60,0x3d,0x17,0xc0,
   0x5,0xff,0x9d,0x17,0xc0,0xc8,0x91,0xfb,0x60,0x4a,0xb0,0x2c,0x4a,0xb0,0x52,0x85,
  0xff,0xbd,0x8a,0xc0,0xdd,0x15,0xc1,0xf0,0x42,0xfe,0x8a,0xc0,0xa8,0xa5,0xfd,0x99,
  0x8d,0xc0,0xa5,0xfe,0x99,0x99,0xc0,0xa4,0xff,0xb9,0xb5,0xc0,0xf0,0x2a,0x85,0xfe,
  0xb9,0xa5,0xc0,0x85,0xfd,0x60,0xb0,0x46,0x4a,0xb0,0x34,0xa8,0xa5,0xfd,0x99,0xa5,
  0xc0,0xa5,0xfe,0x99,0xb5,0xc0,0xbd,0x8a,0xc0,0xdd,0x15,0xc1,0xf0, 0xd,0xfe,0x8a,
  0xc0,0xa8,0xa9, 0x0,0x99,0x99,0xc0,0x60,0xa9,0x30,0x2c,0xa9,0x28,0x8d, 0x0,0xc0,
  0x60, 0xa, 0xa, 0xa, 0xa,0x4d,0x1c,0xc0,0x29,0xf0,0x4d,0x1c,0xc0,0x90,0x6b,0x4d,
  0x1d,0xc0,0x29, 0xf,0x4d,0x1d,0xc0,0x8d,0x1d,0xc0,0x8d,0x18,0xd4,0x60,0x4a,0x4a,
  0xb0,0x5f,0x4a,0xa8,0xf0,0x17,0x88,0xf0,0x2d,0x88,0xf0,0x39,0x88,0xf0,0x3c,0x88,
  0xf0,0x3f,0xad,0x1d,0xc0,0x29,0x7f,0x90,0x62, 0x9,0x80,0xb0,0x5e,0xac,0x1d,0xc0,
  0xb0, 0x7,0xc8,0x98,0x29, 0xf,0xd0, 0x7,0x60,0x98,0x29, 0xf,0xf0, 0x7,0x88,0x8c,
  0x1d,0xc0,0x8c,0x18,0xd4,0x60,0xbd,0xd6,0xc0,0x49,0xff,0x2d,0x1c,0xc0,0x90,0x1a,
  0x1d,0xd6,0xc0,0xb0,0x15,0x98,0x2a,0x9d,0x72,0xc0,0x60,0x98,0x2a,0x9d,0x75,0xc0,
  0x60,0xad,0x1c,0xc0,0x29,0xf7,0x90, 0x2, 0x9, 0x8,0x8d,0x1c,0xc0,0x8d,0x17,0xd4,
  0x60,0x4a,0xb0,0x1e,0x4a,0xb0, 0x8,0xd0, 0x2,0xa9, 0x8,0x9d,0x6f,0xc0,0x60, 0xa,
   0xa, 0xa, 0xa,0x4d,0x1d,0xc0,0x29,0x70,0x4d,0x1d,0xc0,0x8d,0x1d,0xc0,0x8d,0x18,
  0xd4,0x60,0x4a,0xa8,0xd0,0x15,0xbd,0x87,0xc0,0xf0, 0x5,0xde,0x87,0xc0,0xf0, 0xa,
  0xbd,0x81,0xc0,0x85,0xfd,0xbd,0x84,0xc0,0x85,0xfe,0x60,0x88,0xd0,0x20,0xbd,0x8a,
  0xc0,0xdd,0x14,0xc1,0xf0,0x12,0xde,0x8a,0xc0,0xa8,0x88,0xb9,0x99,0xc0,0xf0, 0x7,
  0x85,0xfe,0xb9,0x8d,0xc0,0x85,0xfd,0x60,0xa9,0x20,0x8d, 0x0,0xc0,0x60,0xad, 0x0,
  0xc0,0x5d,0xd6,0xc0,0x8d, 0x0,0xc0,0x88,0x98,0x91,0xfb,0xc8,0x91,0xfb,0x60,0x8e,
  0xcb,0xc0,0x8c,0xcc,0xc0,0x8a,0x18,0x69,0x6a,0x8d,0xc6,0xc0,0x98,0x69, 0x0,0x8d,
  0xc7,0xc0,0x8a,0x18,0x69,0x23,0x8d,0xc9,0xc0,0x98,0x69, 0x3,0x8d,0xca,0xc0,0x86,
  0xfb,0x84,0xfc,0xa9,0xec,0x85,0xfd,0xa9,0xc1,0x85,0xfe,0xa2, 0x5,0xa0, 0x0,0xb1,
  0xfd,0x91,0xfb,0xc8,0xd0,0xf9,0xe6,0xfc,0xe6,0xfe,0xca,0xd0,0xf2,0xb1,0xfd,0x91,
  0xfb,0xc8,0xc0,0x76,0xd0,0xf7,0x60,0x82,0x80,0x80,0x80,0x82, 0x0,0x20,0xdd,0xc1,
  0x20,0x1b,0xc1,0xa2, 0x0,0xa0,0x10,0x20,0x32,0xc1,0xa9, 0x7,0x8d, 0x0,0xc0,0x60
};


void sidTune::MUS_installPlayer(ubyte *c64buf)
{
	if (status && (c64buf != 0))
	{
		uword dest = readEndian(sidplayer[1],sidplayer[0]);
		for ( uword i = 2; i < sizeof(sidplayer); i++ )
		{
			c64buf[dest+i-2] = sidplayer[i];
		}
	} 
}
