//
// Libsidplay compile time definitions.
//
// Programmer's note: If you don't include ``player.h'' only,
// do not forget to include this in every file that uses libsidplay.
// Please read this carefully and edit where necessary.
//

#ifndef CONFIG_H
#define CONFIG_H


// --------------------------------------------------------------------------
// Specifies the endianess of your CPU's hardware.
// --------------------------------------------------------------------------
//
#define IS_LITTLE_ENDIAN
//#define IS_BIG_ENDIAN

// --------------------------------------------------------------------------
// Ought-to-be automatic compiler and system dependencies.
// --------------------------------------------------------------------------
//
// A user defined ``bool'' type for compilers that don't yet support one.
//
#if defined(__BORLANDC__) && (__BORLANDC__ < 0x500) || defined(__WATCOMC__)
  #define DONT_HAVE_BOOL_TYPE
#endif
//
// Short MS-DOS style include file names of length 8.3.
// 
#if defined(__BORLANDC__) || defined(_MSC_VER)
  #define HAVE_SHORT_HEADERNAMES
#endif
//
// Whether standard function ``case-sensitive string comparison''
// is called ``strcasecmp'' instead of ``stricmp''.
//
#if defined(linux) || defined(unix)
  #define HAVE_STRCASECMP
#endif
//
// Whether standard member ``ios::binary'' or ``ios::bin'' is available.
//
#if defined(__BORLANDC__) || defined(_MSC_VER) || defined(_WINDOWS)
  #define HAVE_IOS_BINARY
#endif

// --------------------------------------------------------------------------
// Hardware-specific speed optimization.
// --------------------------------------------------------------------------
//
// Caution: Must not work on every hardware and therefore can result in
// trouble. Hardware-specific speed optimizations use a union to access
// integer fixpoint operands in memory. This makes an assumption about the
// hardware and software architecture and therefore is considered a hack!
// Try it. You will notice if it doesn't work ;)
//
// However, this option is highly used and tested. A failing little endian
// system has not been reported so far.
//
#define DIRECT_FIXPOINT
//
// This will cause little(big) endian machines to directly access little(big)
// endian values in memory structures or arrays, disregarding alignment.
//
#define OPTIMIZE_ENDIAN_ACCESS
	
// --------------------------------------------------------------------------
// Possible speed optimization on high-end machines.
// --------------------------------------------------------------------------
//
// Calculate envelope with floating point precision. High-end FPU is
// strongly recommended, otherwise this may not be faster. Forget about
// the Pentium FPU.
//
//#define SID_FPUENVE
//#define SID_FPUMIXERINIT
#define SID_FPUFILTER

// --------------------------------------------------------------------------
// Don't touch these!
// --------------------------------------------------------------------------
//
//#define NO_STDIN_LOADER
#define SIDEMU_TIME_COUNT
//#define SID_LINENVE
//#define SID_REFTIMES
//#define SID_EXPENVE
//#define LARGE_NOISE_TABLE
//#define PORTABLE_FIXPOINT
//#define NO_RTS_UPON_BRK


#if defined(SID_FPUFILTER)
typedef float filterfloat;
#else
#include "PseudoFloat.h"
typedef fixed filterfloat;
#endif




#endif
