/*
 *  StarTrekker _Packer.c   1997 (c) Asle / ReDoX
 *
 * Converts back to ptk StarTrekker packed MODs
 *
*/

#ifdef DOS
#include "..\include\globals.h"
#include "..\include\extern.h"
#endif

#ifdef UNIX
#include "../include/globals.h"
#include "../include/extern.h"
#endif


void Depack_STARPACK ( void )
{
  Uchar c1=0x00,c2=0x00,c3=0x00,c4=0x00,c5;
  Uchar Pats_Numbers[128];
  Uchar Pats_Numbers_tmp[128];
  Uchar Pat_Pos;
  Uchar *Whatever;
  Uchar Pattern[1024];
  Uchar PatMax=0x00;
  long i=0,j=0,k=0;
  long Total_Sample_Size=0;
  long Pats_Address[128];
  long Pats_Address_tmp[128];
  long Pats_Address_tmp2[128];
  long tmp_ptr,tmp1,tmp2;
  long SampleDataAddress=0;
  FILE *in,*out;

  if ( Save_Status == BAD )
    return;

  BZERO ( Pats_Numbers , 128 );
  BZERO ( Pats_Numbers_tmp , 128 );
  BZERO ( Pats_Address , 128*4 );
  BZERO ( Pats_Address_tmp , 128*4 );
  BZERO ( Pats_Address_tmp2 , 128*4 );

  in = fopen ( OutName_final , "r+b" ); /* +b is safe bcoz OutName's just been saved */
  sprintf ( Depacked_OutName , "%ld.mod" , Cpt_Filename-1 );
  out = fopen ( Depacked_OutName , "w+b" );

  /* read and write title */
  for ( i=0 ; i<20 ; i++ )   /* title */
  {
    fread ( &c1 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
  }

  /* read and write sample descriptions */
  for ( i=0 ; i<31 ; i++ )
  {
    c1 = 0x00;
    for ( j=0 ; j<22 ; j++ ) /*sample name*/
      fwrite ( &c1 , 1 , 1 , out );

    fread ( &c1 , 1 , 1 , in );  /* size */
    fread ( &c2 , 1 , 1 , in );
    Total_Sample_Size += (((c1*256)+c2)*2);
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );
    fread ( &c1 , 1 , 1 , in );  /* finetune */
    fwrite ( &c1 , 1 , 1 , out );
    fread ( &c1 , 1 , 1 , in );  /* volume */
    fwrite ( &c1 , 1 , 1 , out );
    fread ( &c1 , 1 , 1 , in );  /* loop start */
    fread ( &c2 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );
    fread ( &c1 , 1 , 1 , in );  /* loop size */
    fread ( &c2 , 1 , 1 , in );
    fwrite ( &c1 , 1 , 1 , out );
    fwrite ( &c2 , 1 , 1 , out );
  }
  /*printf ( "Whole sample size : %ld\n" , Total_Sample_Size );*/

  /* read size of pattern table */
  fread ( &c1 , 1 , 1 , in );
  fread ( &c2 , 1 , 1 , in );
  Pat_Pos = ((c1*256)+c2)/4;
  /*printf ( "Size of pattern table : %d\n" , Pat_Pos );*/

  /* bypass $0000 unknown bytes */
  fseek ( in , 2 , 1 ); /* SEEK_CUR */

/***********/

  for ( i=0 ; i<128 ; i++ )
  {
    fread ( &c1 , 1 , 1 , in );
    fread ( &c2 , 1 , 1 , in );
    fread ( &c3 , 1 , 1 , in );
    fread ( &c4 , 1 , 1 , in );
    Pats_Address[i] = (c1*256*256*256)+(c2*256*256)+(c3*256)+c4;
  }

  /* ordering of patterns addresses */

  tmp_ptr = 0;
  for ( i=0 ; i<Pat_Pos ; i++ )
  {
    if ( i==0 )
    {
      Pats_Numbers[0] = 0x00;
      tmp_ptr++;
      continue;
    }

    for ( j=0 ; j<i ; j++ )
    {
      if ( Pats_Address[i] == Pats_Address[j] )
      {
        Pats_Numbers[i] = Pats_Numbers[j];
        break;
      }
    }
    if ( j == i )
      Pats_Numbers[i] = tmp_ptr++;
  }
/*
for ( i=0 ; i<128 ; i++ )
fprintf ( info , "%x," , Pats_Numbers[i] );
fprintf ( info , "\n\n" );
*/
  /* correct re-order */
  /********************/
  for ( i=0 ; i<128 ; i++ )
    Pats_Address_tmp[i] = Pats_Address[i];

restart:
  for ( i=0 ; i<Pat_Pos ; i++ )
  {
    for ( j=0 ; j<i ; j++ )
    {
      if ( Pats_Address_tmp[i] < Pats_Address_tmp[j] )
      {
        tmp2 = Pats_Numbers[j];
        Pats_Numbers[j] = Pats_Numbers[i];
        Pats_Numbers[i] = tmp2;
        tmp1 = Pats_Address_tmp[j];
        Pats_Address_tmp[j] = Pats_Address_tmp[i];
        Pats_Address_tmp[i] = tmp1;
        goto restart;
      }
    }
  }
/*
for ( i=0 ; i<128 ; i++ )
fprintf ( info , "%x," , Pats_Numbers[i] );
fprintf ( info , "\n\n" );
*/
  j=0;
  for ( i=0 ; i<128 ; i++ )
  {
    if ( i==0 )
    {
      Pats_Address_tmp2[j] = Pats_Address_tmp[i];
      continue;
    }

    if ( Pats_Address_tmp[i] == Pats_Address_tmp2[j] )
      continue;
    Pats_Address_tmp2[++j] = Pats_Address_tmp[i];
  }

/*
for ( i=0 ; i<128 ; i++ )
fprintf ( info , "%ld," , Pats_Address[i] );
fprintf ( info , "\n\n" );
for ( i=0 ; i<128 ; i++ )
fprintf ( info , "%ld," , Pats_Address_tmp2[i] );
fprintf ( info , "\n\n" );

for ( i=0 ; i<128 ; i++ )
fprintf ( info , "%x," , Pats_Numbers_tmp[i] );
fprintf ( info , "\n\n" );
*/

  /* try to locate unused patterns .. hard ! */
  j=0;
  for ( i=0 ; i<(Pat_Pos-1) ; i++ )
  {
/*
fprintf ( info , "%6ld (%6ld,%6ld)\n"
               , Pats_Address_tmp2[i+1] - Pats_Address_tmp2[i]
               , Pats_Address_tmp2[i+1]
               , Pats_Address_tmp2[i] );
*/
    Pats_Address_tmp[j] = Pats_Address_tmp2[i];
    j+=1;
    if ( (Pats_Address_tmp2[i+1] - Pats_Address_tmp2[i]) > 1024 )
    {
      /*printf ( "! pattern %ld is not used ... saved anyway\n" , j );*/
      Pats_Address_tmp[j] = Pats_Address_tmp2[i] + 1024;
      j+=1;
    }
  }

  /* assign pattern list */
  for ( c1=0x00 ; c1<128 ; c1++ )
  {
    for ( c2=0x00 ; c2<128 ; c2++ )
      if ( Pats_Address[c1] == Pats_Address_tmp[c2] )
      {
        Pats_Numbers_tmp[c1] = c2;
        break;
      }
  }
/*
for ( i=0 ; i<128 ; i++ )
fprintf ( info , "%x," , Pats_Numbers_tmp[i] );
fprintf ( info , "\n\n" );
*/

  BZERO ( Pats_Numbers , 128 );
  for ( i=0 ; i<Pat_Pos ; i++ )
  {
    Pats_Numbers[i] = Pats_Numbers_tmp[i];
  }

  /* write number of position */
  fwrite ( &Pat_Pos , 1 , 1 , out );

  /* get highest pattern number */
  for ( i=0 ; i< Pat_Pos ; i++ )
    if ( Pats_Numbers[i] > PatMax )
      PatMax = Pats_Numbers[i];

  /*printf ( "Highest pattern number : %d\n" , PatMax );*/

  /* write noisetracker byte */
  c1 = 0x7f;
  fwrite ( &c1 , 1 , 1 , out );

  /* write pattern list */
  for ( i=0 ; i<128 ; i++ )
    fwrite ( &Pats_Numbers[i] , 1 , 1 , out );

/***********/


  /* write ptk's ID */
  c1 = 'M';
  c2 = '.';
  c3 = 'K';
  fwrite ( &c1 , 1 , 1 , out );
  fwrite ( &c2 , 1 , 1 , out );
  fwrite ( &c3 , 1 , 1 , out );
  fwrite ( &c2 , 1 , 1 , out );

  /* read sample data address */
  fseek ( in , 0x310 , 0 );
  fread ( &c1 , 1 , 1 , in );
  fread ( &c2 , 1 , 1 , in );
  fread ( &c3 , 1 , 1 , in );
  fread ( &c4 , 1 , 1 , in );
  SampleDataAddress = (c1*256*256*256)+(c2*256*256)+(c3*256)+c4+0x314;

  /* pattern data */
  fseek ( in , 0x314 , 0 ); /* SEEK_CUR */
  PatMax += 1;
  for ( i=0 ; i<PatMax ; i++ )
  {
    BZERO ( Pattern , 1024 );
    for ( j=0 ; j<64 ; j++ )
    {
      for ( k=0 ; k<4 ; k++ )
      {
        fread ( &c1 , 1 , 1 , in );
        if ( c1 == 0x80 )
        {
          Pattern[j*16+k*4]   = 0x00;
          Pattern[j*16+k*4+1] = 0x00;
          Pattern[j*16+k*4+2] = 0x00;
          Pattern[j*16+k*4+3] = 0x00;
          continue;
        }
        fread ( &c2 , 1 , 1 , in );
        fread ( &c3 , 1 , 1 , in );
        fread ( &c4 , 1 , 1 , in );
        Pattern[j*16+k*4]   = c1&0x0f;
        Pattern[j*16+k*4+1] = c2;
        Pattern[j*16+k*4+2] = c3&0x0f;
        Pattern[j*16+k*4+3] = c4;

        c5 = (c1&0xf0) | ((c3>>4)&0x0f);
        c5 /= 4;
        Pattern[j*16+k*4]   |= (c5&0xf0);
        Pattern[j*16+k*4+2] |= ((c5<<4)&0xf0);
      }
    }
    fwrite ( Pattern , 1024 , 1 , out );
    /*printf ( "+" );*/
  }
  /*printf ( "\n" );*/

  /* sample data */
  fseek ( in , SampleDataAddress , 0 );
  Whatever = (Uchar *) malloc ( Total_Sample_Size );
  BZERO ( Whatever , Total_Sample_Size );
  fread ( Whatever , Total_Sample_Size , 1 , in );
  fwrite ( Whatever , Total_Sample_Size , 1 , out );
  free ( Whatever );


  Crap ( " StarTrekker Pack " , BAD , BAD , out );
  /*
  fseek ( out , 830 , SEEK_SET );
  fprintf ( out , " -[Converted with]- " );
  fseek ( out , 860 , SEEK_SET );
  fprintf ( out , "-[StarTrekker pack]-" );
  fseek ( out , 890 , SEEK_SET );
  fprintf ( out , "  -[2 Protracker]-  " );
  fseek ( out , 920 , SEEK_SET );
  fprintf ( out , " -[by Asle /ReDoX]- " );
  */
  fflush ( in );
  fflush ( out );
  fclose ( in );
  fclose ( out );

  printf ( "done\n" );
  return; /* useless ... but */
}
