#include <stdio.h>
#include <stdlib.h>

#include "window.h"
#include "replay.h"

/* Function from mp2event.c */
extern int quit_program(void);
extern void update_time(void);

void window_create(int wind_id)
{
	WINDFORM *wind = &windforms[wind_id];

	wind->wind_id = wind_id;

	if(!wind->has_opened) {
		form_center(wind->formtree,&wind->form.x,&wind->form.y,
			&wind->form.w,&wind->form.h);
		wind_calc(WC_BORDER,wind->windkind,wind->form.x,wind->form.y,
			wind->form.w,wind->form.h,&wind->wind.x,&wind->wind.y,
			&wind->wind.w,&wind->wind.h);

		wind->has_opened = 1;
	}
	
	wind->whandle=wind_create(wind->windkind,wind->wind.x,wind->wind.y,
		wind->wind.w,wind->wind.h);
	wind_set(wind->whandle,WF_NAME,wind->wind_title);

	if(wind_id == WIND_CTRL)
		wind_set(wind->whandle,WF_BEVENT,1,0,0,0); /* untoppable */
	
	wind_calc(WC_WORK,wind->windkind,wind->wind.x,wind->wind.y,
		wind->wind.w,wind->wind.h,&wind->form.x,&wind->form.y,
		&wind->form.w,&wind->form.h);
	wind->formtree[wind->firstobj].ob_x=wind->form.x;
	wind->formtree[wind->firstobj].ob_y=wind->form.y;
	wind->formtree[wind->firstobj].ob_width=wind->form.w;
	wind->formtree[wind->firstobj].ob_height=wind->form.h;

	add_windhandle(wind->whandle,wind->wind_id);
}

void window_open(int wind_id)
{
	wind_open(windforms[wind_id].whandle,
		windforms[wind_id].wind.x,windforms[wind_id].wind.y,
		windforms[wind_id].wind.w,windforms[wind_id].wind.h);
	windforms[wind_id].wind_open=1;
}

int window_close(int wind_id)
{
	int whandle;
	
	/* Close topped window if wind_id < 0 */
	if(wind_id < 0) {
		wind_get(0, WF_TOP, &whandle);
		wind_id = find_windform(whandle);
		if(wind_id < 0)
			return 0;
	} else {
		whandle = windforms[wind_id].whandle;
	}

	if(!windforms[wind_id].wind_open)
		return 0;
	
	wind_close(whandle);
	wind_delete(whandle);
	del_windhandle(whandle);
	windforms[wind_id].wind_open=0;
	if(wind_id == WIND_CTRL) {
		window_close(WIND_INFO);
		window_close(WIND_SHOE);
		return quit_program();
	}

	return 0;
}

void window_switch()
{
	WINDHANDLELIST *wind=windhandles, *top;
	int whandle, wind_id;

	wind_get(0, WF_TOP, &whandle);

	/* find handle of top window */
	while(wind && wind->whandle != whandle)
		wind = wind->next;
	top = wind;
	wind_id = top->wind_id;
	
	/* find handle of next open window */
	if(top->next)
		wind = top->next;
	else
		wind = windhandles;
	while(wind != top && wind_id == top->wind_id) {
		if(windforms[wind->wind_id].wind_open) {
			wind_id = wind->wind_id;
		}
		if(wind->next)
			wind = wind->next;
		else
			wind = windhandles;
	}
		
	if(windforms[wind_id].wind_open)
		wind_set(windforms[wind_id].whandle,WF_TOP);
}

void window_move(int wind_id, int x, int y)
{
	WINDFORM *wind = &windforms[wind_id];

	if(!wind->has_opened) {
		form_center(wind->formtree,&wind->form.x,&wind->form.y,
			&wind->form.w,&wind->form.h);
		wind_calc(WC_BORDER,wind->windkind,wind->form.x,wind->form.y,
			wind->form.w,wind->form.h,&wind->wind.x,&wind->wind.y,
			&wind->wind.w,&wind->wind.h);

		wind->has_opened = 1;
	}

	if(wind->wind_open) {
		wind_set(wind->whandle,WF_CURRXYWH,x,y,
			wind->wind.w,wind->wind.h);
	}
	wind->wind.x=x;
	wind->wind.y=y;
	wind_calc(WC_WORK,wind->windkind,
		wind->wind.x, wind->wind.y, wind->wind.w, wind->wind.h,
		&wind->form.x, &wind->form.y, &wind->form.w, &wind->form.h);
	wind->formtree[wind->firstobj].ob_x=wind->form.x;
	wind->formtree[wind->firstobj].ob_y=wind->form.y;
	wind->formtree[wind->firstobj].ob_width=wind->form.w;
	wind->formtree[wind->firstobj].ob_height=wind->form.h;
	if(replayp())
		update_time();
}

void add_windhandle(int whandle, int wind_id)
{
	WINDHANDLELIST *new;
	
	new = (WINDHANDLELIST *)malloc(sizeof(WINDHANDLELIST));
	new->next = windhandles;
	new->whandle = whandle;
	new->wind_id = wind_id;
	windhandles = new;
}

void del_windhandle(int whandle)
{
	WINDHANDLELIST *wind = windhandles, *last=NULL;
	
	while(wind) {
		if(wind->whandle == whandle) {
			if(last)
				last->next = wind->next;
			else
				windhandles = wind->next;
			free(wind);
			break;
		}
		last = wind;
		wind = wind->next;
	}
}

int find_windform(int whandle)
{
	WINDHANDLELIST *wind = windhandles;

	while(wind) {
		if(wind->whandle == whandle) {
			return wind->wind_id;
		}
		wind = wind->next;
	}

	return -1;
}
