#include <stdio.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <linux/soundcard.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

#include "sapLib.h"

#define sapcmp(a, b, c) if (strncmp(a, b, strlen(a))==0) {printf("%s: %s", c, b+strlen(a)+1); st=1;}

#define sapfind(d, a, c) {unsigned char testBuf[1000]; int st=0; FILE *f=fopen(d, "rb"); do { fgets((char *)testBuf, 1000, f); if(testBuf[0]!=0xff) sapcmp(a, (char *)testBuf, c); } while(testBuf[0]!=0xff); if(st==0) printf("%s: <?>\n", c); fclose(f); }

signed short buffer[88200];
int fd, format;

int main(int argc, char **argv)
{
	printf("Penguin Sap v0.01 by Jaymz Julian (jaymz@dspaudio.com)\n");
	printf("Sap Library v1.52 by Adam Bienias\n");
	
	char *file2play;
	int verbose=0;
	int bits=16;
	int mono=0;
	int songNum=0;
	// parse the options
	if(argc==1) 
	{
		printf("Usage: %s [-v] filename.sap\n", argv[0]);
		printf("       -oX : Song number\n");
		printf("       -v  : Print verbose info\n");
		printf("       -m  : Mono audio output (Default is stereo)\n");
		printf("       -8  : 8 bit output (Default is 16 bit)\n");
		exit(1);
	}
	
	for(int x=1;x<argc;x++)
	{
		if(argv[x][0]=='-')
		{
			// it's an option
			switch(argv[x][1])
			{
				case 'v':
					verbose=1;
					break;
				case 'm':
					mono=1;
					break;
				case '8':
					bits=8;
					break;
				case 'o':
					songNum=atoi(argv[x]+2);
					break;
				default:
					printf("Invalid paramater - run without any parameters for help!\n");
					exit(1);
					break;
			}
		}
		else
		{
			// it's a file
			file2play=argv[x];
		}
	}
	

	printf("Filenames    : %s\n",file2play);
	sapMUSICstrc *fish=sapLoadMusicFile(file2play);

	if(fish->defSong== -1) fish->defSong=1;
	if(fish->numOfSongs== -1) fish->numOfSongs=1;

	if(songNum!=0)
		sapPlaySong(songNum);
	else
		songNum=fish->defSong;


	// FIXME: detect file type here (binary, chaos music,digi, etc)
        printf("File format  : Atari XL/XE SAP (Type)\n");
	
	// print sidplay like info
	// FIXME: support chaos music/softsynth types
	// FIXME: get load address

	sapfind(file2play, "NAME"    , "Name         ");
	sapfind(file2play, "AUTHOR"  , "Author       ");
	sapfind(file2play, "DATE"    , "Copyright    ");
	if(verbose==1)
	{
	        printf("Load Address : <?>\n");
		sapfind(file2play, "INIT"    , "Init address ");
		sapfind(file2play, "PLAYER"  , "Play address ");
	}
	sapfind(file2play, "TIME"    , "Play time    ");

	printf("Setting Song : %d out of %d (default = %d)\n", songNum, fish->numOfSongs, fish->defSong);

	// FIXME: support fastplay
        printf("Song speed   : 50 Hz VBI (PAL)\n");

	printf("Playing, press ^C to stop ...\n");
	fflush(stdout);

	// loading succesful - init the soundcard
	// why does this code work in FLAW, but not in penguin sap?
	fd=open("/dev/mixer", O_WRONLY, 0);
	fd=open("/dev/dsp", O_WRONLY, 0);
	if(bits==16)
		format=AFMT_S16_LE;
	else
		format=AFMT_U8;

	ioctl(fd, SNDCTL_DSP_SETFMT, &format);
	format=44100;
	ioctl(fd, SNDCTL_DSP_SPEED, &format);

	if(mono==1)
		format=1;
	else
		format=2;

	ioctl(fd, SNDCTL_DSP_CHANNELS, &format);

	do
	{
		int dataSize=22050*4;
		sapRenderBuffer(buffer, 22050);
		if(mono==1)
		{
			// transform to mono
			for(int c=0;c<22050;c++)
				buffer[c]=((buffer[c*2]+buffer[c*2+1])/2);
			dataSize/=2;
		}

		if(bits==8)
		{
			short ws;
			dataSize/=2;
			for(int c=0;c<dataSize;c++)
			{
				ws=(buffer[c]>>8)+128;
				((char *)buffer)[c]=(char)ws;
			}
		}
		write(fd, buffer, dataSize);
	} while(0==0);
}
