/*
  see documentation for all the hard stuff like copyright info
  and such...
 */

#ifndef XMMS_SID_FUNCTIONS
#define XMMS_SID_FUNCTIONS

#include <gtk/gtk.h>
#include <xmms/plugin.h>
#include <sidplay/player.h>



extern "C" { // Well, this is gonna be only used within C++ anyway =)
////////////////////////////////////////////////////////////////////

// sid_plugin.cpp
InputPlugin *get_iplugin_info(void);
void sid_init(void);
int is_our_file(char *filename);
void play_file(char *filename);
void stop(void);
void sid_pause(short paused);
void get_song_info(char *filename, char **title, int *length);
void seek(int time);
int gettracknum(void);

void bailout(char *reason);

static void *playloop (void *arg);

char *parse_filename(char *filename);
int parse_songnumber(char *filename);

// sid_interface.cpp

void general_sidplug_ui_init(void);
void init_sidplug_dialogs(void);

void sidplug_show_about(void);
void sidplug_configdialog(void);

// sid_plug_config.cpp

void load_config(void);
void save_config(void);
void set_sidconfig_defaults(void);
  // void internal_to_sidplay(void);
  // void sidplay_to_internal(void);

void internal_to_config(void);
void config_to_internal(void);

void dump_settings_to_stdout(void);

void validate_settings(void);

////////////////////////////////////////////////////////////////////


// There *is* a logic behind these numbers. Think of the speakers. =)
enum sidOutMode { sidMono = 1, sidStereo = 2, sidStereoSurround = 5 };

// 6581 is the number one, 8580 is just a zero! =)
enum sidMdl { sidMOS8580 = 0, sidMOS6581 = 1 };

//               42371 = "ameri", 3070 = "eoro"
enum sidCS { PAL = 3070, NTSC = 42371 };

struct pluginconfig {
  int fragments; /* = 16 */
  int fragSizeBase; /* = 12 */
};

extern struct pluginconfig sidplugin_config;

// DEBUG: Displays all kinds of possible debug information to stdout.
// You probably want to disable this in the production version.
#undef DEBUG
// SPAMMYDEBUG: Displays all kinds of *spammy* debug information (eg,
// the information is printed from inside of a loop or something
// equally stupid. You probably don't want to see this stuff when
// debugging either.
#undef SPAMMYDEBUG

////////////////////////////////////////////////////////////////////
}

#endif /* XMMS_SID_FUNCTIONS */
