/*
CMachineParameter const paraSM = 
{ 
	pt_byte,										// type
	"SyntheSys",
	"SyntheSys",									// description
	0,												// MinValue	
	4,												// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	0
};


CMachineParameter const paraOSC1 = 
{ 
	pt_byte,										// type
	"OSC1 Waveform",
	"OSC1 Waveform",								// description
	0,												// MinValue	
	8,												// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	1
};

CMachineParameter const paraPW1 = 
{ 
	pt_word,										// type
	"PW1",
	"PW1",										// description
	0,												// MinValue	
	512,											// MaxValue
	65535,											// NoValue
	MPF_STATE,										// Flags
	256
};

CMachineParameter const paraOSC2 = 
{ 
	pt_byte,										// type
	"OSC2 Waveform",
	"OSC2 Waveform",								// description
	0,												// MinValue	
	8,												// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	1
};


CMachineParameter const paraPW2 = 
{ 
	pt_word,										// type
	"PW2",
	"PW2",										// description
	0,												// MinValue	
	512,											// MaxValue
	65535,											// NoValue
	MPF_STATE,										// Flags
	256
};

CMachineParameter const paraNoise = 
{ 
	pt_byte,										// type
	"Noise",
	"Noise",								// description
	0,												// MinValue	
	128,												// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	0
};

CMachineParameter const paraFine = 
{ 
	pt_byte,										// type
	"OSC2 Fine",
	"OSC2 Fine",									// description
	0,												// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	64
};

CMachineParameter const paraDetune = 
{ 
	pt_byte,										// type
	"OSC2 Detune",
	"OSC2 Detune",									// description
	0,												// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	64
};


CMachineParameter const paraENV1_A = 
{ 
	pt_word,										// type
	"ENV1 Attack",
	"ENV1 Attack",									// description
	1,												// MinValue	
	2048,											// MaxValue
	0,											// NoValue
	MPF_STATE,										// Flags
	32
};


CMachineParameter const paraENV1_D = 
{ 
	pt_word,										// type
	"ENV1 Decay",
	"ENV1 Decay",									// description
	1,												// MinValue	
	2048,											// MaxValue
	0,											// NoValue
	MPF_STATE,										// Flags
	148
};

CMachineParameter const paraENV1_S = 
{ 
	pt_byte,										// type
	"ENV1 Sustain",
	"ENV1 Sustain",									// description
	0,												// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	32
};

CMachineParameter const paraENV1_R = 
{ 
	pt_word,										// type
	"ENV1 Release",
	"ENV1 Release",									// description
	1,											// MinValue	
	2048,											// MaxValue
	0,											// NoValue
	MPF_STATE,										// Flags
	148
};

CMachineParameter const paraLfo = 
{ 
	pt_word,										// type
	"LFO1 Period",
	"LFO1 Period",				// description
	0,												// MinValue	
	2048,											// MaxValue
	65535,											// NoValue
	MPF_STATE,										// Flags
	16
};

CMachineParameter const paraLfo2 = 
{ 
	pt_word,										// type
	"LFO2 Period",
	"LFO2 Period",				// description
	0,												// MinValue	
	2048,											// MaxValue
	65535,											// NoValue
	MPF_STATE,										// Flags
	16
};

CMachineParameter const paraVCF_Cutoff = 
{ 
	pt_byte,										// type
	"VCF Cutoff",
	"VCF Cutoff",									// description
	0,											// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	128
};


CMachineParameter const paraVCF_Resonance = 
{ 
	pt_byte,										// type
	"VCF Q",
	"VCF Q",									// description
	0,											// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	0
};


CMachineParameter const paraVCF_HPF = 
{ 
	pt_byte,										// type
	"VCF Type",
	"VCF Type",									// description
	0,											// MinValue	
	5,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	0
};

CMachineParameter const paraENV1TOVCF = 
{ 
	pt_byte,										// type
	"VCF>ENV1",
	"VCF>ENV1",									// description
	0,											// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	64
};

CMachineParameter const paraLFOTOVCF = 
{ 
	pt_byte,										// type
	"VCF>LFO1",
	"VCF>LFO1",									// description
	0,											// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	64
};

CMachineParameter const paraLFOTOVCF2 = 
{ 
	pt_byte,										// type
	"VCF>LFO2",
	"VCF>LFO2",									// description
	0,											// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	64
};

CMachineParameter const paraLFO1TOPW1 = 
{ 
	pt_byte,										// type
	"PW1>LFO1",
	"PW1>LFO1",									// description
	0,											// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	64
};

CMachineParameter const paraLFO2TOPW1 = 
{ 
	pt_byte,										// type
	"PW1>LFO2",
	"PW1>LFO2",									// description
	0,											// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	64
};

CMachineParameter const paraLFO1TOPW2 = 
{ 
	pt_byte,										// type
	"PW2>LFO1",
	"PW2>LFO1",									// description
	0,											// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	64
};

CMachineParameter const paraLFO2TOPW2 = 
{ 
	pt_byte,										// type
	"PW2>LFO2",
	"PW2>LFO2",									// description
	0,											// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	64
};

CMachineParameter const paraGlide = 
{ 
	pt_byte,										// type
	"Glide",
	"Glide Amount",									// description
	0,												// MinValue	
	128,											// MaxValue
	255,											// NoValue
	MPF_STATE,										// Flags
	0
};

CMachineParameter const paraNote = 
{ 
	pt_note,										// type
	"Note",
	"Note",											// description
	NOTE_MIN, 											// MinValue	
	NOTE_MAX,			  									// MaxValue
	NOTE_NO,    									// NoValue
	0,												// Flags
	0
};

CMachineParameter const paraVolume = 
{ 
	pt_byte,										// type
	"Volume",
	"Volume [sustain level] (0=0%, 80=100%, FE=~200%)",	// description
	0,												// MinValue	
	0xfe,  											// MaxValue
	0xff,    										// NoValue
	0,										// Flags
	0x80
};

CMachineParameter const *pParameters[] = { 
	// global
	&paraSM,
	&paraOSC1,
	&paraPW1,
	&paraOSC2,
	&paraPW2,
	&paraNoise,
	&paraFine,
	&paraDetune,
	&paraENV1_A,
	&paraENV1_D,
	&paraENV1_S,
	&paraENV1_R,
	&paraLfo,
	&paraLfo2,
	&paraVCF_Cutoff,
	&paraVCF_Resonance,
	&paraVCF_HPF,
	&paraENV1TOVCF,
	&paraLFOTOVCF,
	&paraLFOTOVCF2,
	&paraLFO1TOPW1,
	&paraLFO2TOPW1,
	&paraLFO1TOPW2,
	&paraLFO2TOPW2,
	&paraGlide,
	
	// track
	&paraNote,
	&paraVolume
};

#pragma pack(1)

class gvals
{
public:
byte sm;
byte osc1;
word pw1;
byte osc2;
word pw2;
byte noise;
byte fine;
byte detune;
word env1_a;
word env1_d;
byte env1_s;
word env1_r;
word lfo;
word lfo2;
byte vcf_cutoff;
byte vcf_resonance;
byte vcf_hpf;
byte env1tovcf;
byte lfotovcf;
byte lfotovcf2;
byte lfo1topw1;
byte lfo2topw1;
byte lfo1topw2;
byte lfo2topw2;
byte glide;
};

class tvals
{
public:
	byte note;
	byte volume;
};

#pragma pack()

CMachineInfo const MacInfo = 
{
	MT_GENERATOR,							// type
	MI_VERSION,
	0,										// flags
	1,										// min tracks
	MAX_TRACKS,								// max tracks
	25,										// numGlobalParameters
	2,										// numTrackParameters
	pParameters,
	0, 
	NULL,
#ifdef _DEBUG
	"Arguelles Alpha (Debug build)",			// name
#else
	"Arguelles Alpha",
#endif
	"Alpha",									// short name
	"Juan Antonio Arguelles Rius", 			// author
	NULL
};

class Alphatrack
{
public:
	mi();
	virtual ~mi();
	
	virtual float Filter(char c,float input,float f,float q);
	virtual float Filter2( float x, char i);
	virtual void MakeBW(void);
	float Kutoff( int v);
	float Reonance( float v);
	float Bandwidth( int v);
	void ComputeCoefs(int freq, int r, int t);

	virtual void Init(CMachineDataInput * const pi);
	virtual void Tick();
	virtual bool Work(float *psamples, int numsamples, int const mode);
	virtual void SetNumTracks(int const n) { numTracks = n; }
	virtual void Stop();
	virtual void InitWavetable();
	virtual void SynthNote(char channel,float note);
	virtual float SynthWork(char channel);
	virtual float ADSR_Coef(float sustain,int stage);
	virtual void LfoAdvance(void);
	virtual int f2i(double d);
	virtual char const *DescribeValue(int const param, int const value);
	virtual float GetS(int type,float offset, float pwi);

public:
	int numTracks;
	gvals gval;
	tvals tval;
	float SineTable[600];
	float coef[5];
	float coeftab[5][128][128][5];
	float OSC1_Step;
	float OSC2_Step;
	int ENV1_A;
	int ENV1_D;
	float ENV1_S;
	int ENV1_R;
	float buf0;
	float buf1;
	float fy2;
	float fy1;
	float fx2;
	float fx1;
	float Pw1;
	float Pw2;
	float ENV1TOVCF;
	float LFOTOVCF;
	float LFOTOVCF2;
	float LFO1TOPW1;
	float LFO2TOPW1;
	float LFO1TOPW2;
	float LFO2TOPW2;

	int VReso;	
	float Vcf_Cutoff;
	float Vcf_Resonance;
	char Vcf_Hpf;
	char sm;
	float Fine,Detune;
	union res_acc
	{
	unsigned __int16 short_acc[2];
	unsigned __int32 long_acc;
	};
	float OSC1_Position;
	float OSC2_Position;

	char OSC1,OSC2;
	float Noise;
	float OSC1_Volume;
	char  ENV1_Stage;
	int ENV1_Counter;
	float CVol;
	float TVol;
	float ENV1_Val;
	int Period;	
	int Period2;	
	int Gr,Gr2;
	int SubGrCounter,SubGrCounter2;
	int SubGrMax,SubGrMax2;
	float final;
	int VCutoff;
};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
	TrackVals = tval;
	AttrVals = NULL;
}

mi::~mi()
{

}

void mi::Init(CMachineDataInput * const pi)
{
	Vcf_Cutoff=1.0f;
	Vcf_Resonance=0.0f;
	Vcf_Hpf=0;
	sm=0;
	Fine=0.5;
	VCutoff=0;
	Detune=0.0f;
	final=0;
	OSC1=1;
	OSC2=1;
	Pw1=256;
	Pw2=256;
	ENV1_A=1024;
	ENV1_D=22100;
	ENV1_S=0.3f;
	ENV1_R=22100;
	ENV1TOVCF=0.0f;
	LFOTOVCF=0.0f;
	LFOTOVCF2=0.0f;
	LFO1TOPW1=0.0f;
	LFO2TOPW1=0.0f;
	LFO1TOPW2=0.0f;
	LFO2TOPW2=0.0f;
	
	VReso=0;
	Noise=0;
	Period=16;
	Period2=16;
	Gr=0;
	Gr2=0;

	SubGrCounter=0;
	SubGrCounter2=0;

	SubGrMax=200;
	SubGrMax2=200;
	
	OSC1_Step=0;
	OSC1_Position=0;
	OSC2_Step=0;
	OSC2_Position=0;
	OSC1_Volume=1.0f;
	ENV1_Stage=0;
	ENV1_Counter=0;
	CVol=0.0f;
	TVol=0.0f;
	ENV1_Val=0.0f;
	buf0=0.0f;
	buf1=0.0f;
	fy2=0.0f;
	fy1=0.0f;
	fx2=0.0f;
	fx1=0.0f;
	}
	MakeBW();
	InitWavetable();
}

void mi::Tick()
{
	sm=gval.sm;

	OSC1=gval.osc1;

	Pw1=(float)gval.pw1;

	OSC2=gval.osc2;

	Pw2=(float)gval.pw2;

	Noise=(float)gval.noise/128.0f;

	Fine=(float)gval.fine/128.0f;

	Detune=(float)gval.detune-64.0f;

	ENV1_A=(int)gval.env1_a*(int)gval.env1_a;
		
	ENV1_D=gval.env1_d*(int)gval.env1_d;

	ENV1_S=(float)gval.env1_s/128.0f;
	
	ENV1_R=gval.env1_r*(int)gval.env1_r;

	Vcf_Cutoff=(float)gval.vcf_cutoff/128.0f;

	Vcf_Resonance=(float)gval.vcf_resonance/128.0f;
	VReso=f2i(Vcf_Resonance*127.0f);

	Vcf_Hpf=gval.vcf_hpf;

	ENV1TOVCF=((float)gval.env1tovcf-64.0f)/64.0f;

	Period = gval.lfo;
	SubGrMax=(SamplesPerTick/3600)*Period;

	Period2 = gval.lfo2;
	SubGrMax2=(SamplesPerTick/3600)*Period2;

	LFOTOVCF=((float)gval.lfotovcf-64.0f)/64.0f;
	LFOTOVCF2=((float)gval.lfotovcf2-64.0f)/64.0f;
	LFO1TOPW1=((float)gval.lfo1topw1-64.0f)*4;
	LFO2TOPW1=((float)gval.lfo2topw1-64.0f)*4;
	LFO1TOPW2=((float)gval.lfo1topw2-64.0f)*4;
	LFO2TOPW2=((float)gval.lfo2topw2-64.0f)*4;

	if(tval[c].note!=NOTE_NO)
		{
			if(tval[c].note==NOTE_OFF)
			{
				// Note off on track c
				ENV1_Stage[c]=4;
				TVol[c]=ENV1_S;
				ENV1_Counter[c]=1;
			}
			else
			{
				// Note on on track c

			float tNote =(float) ((tval[c].note>>4)*12+(tval[c].note&0x0f)-1)-41;
			SynthNote(c,tNote);
			}
		}
		
		if(tval[c].volume!=paraVolume.NoValue)
			OSC1_Volume[c]=(float)tval[c].volume/128.0f;
		
	}
}

bool mi::Work(float *psamples, int numsamples, int const)
{
	bool gotsomething = false;
do{
	final=0;
	LfoAdvance();
	for (int c = 0; c < numTracks; c++)
	{
		float freak=0;
		if (ENV1_Stage[c]>0)
		{
			freak=SynthWork(c);
			gotsomething=true;	
		}
		float FinalC=Vcf_Cutoff+SineTable[Gr]*LFOTOVCF+SineTable[Gr2]*LFOTOVCF2+ENV1_Val[c]*ENV1TOVCF;
		
		switch(Vcf_Hpf)
		{
		case 0:
		VCutoff=f2i(FinalC*128.0f);
		if (VCutoff>127)VCutoff=127;
		if (VCutoff<0)VCutoff=0;

		coef[0]=coeftab[0][VCutoff][VReso][0];
		coef[1]=coeftab[1][VCutoff][VReso][0];
		coef[2]=coeftab[2][VCutoff][VReso][0];
		coef[3]=coeftab[3][VCutoff][VReso][0];
		coef[4]=coeftab[4][VCutoff][VReso][0];
		freak=Filter2(freak++,c);
		break;

		case 1:
		VCutoff=f2i(FinalC*128.0f);
		if (VCutoff>127)VCutoff=127;
		if (VCutoff<0)VCutoff=0;

		coef[0]=coeftab[0][VCutoff][VReso][1];
		coef[1]=coeftab[1][VCutoff][VReso][1];
		coef[2]=coeftab[2][VCutoff][VReso][1];
		coef[3]=coeftab[3][VCutoff][VReso][1];
		coef[4]=coeftab[4][VCutoff][VReso][1];
		freak=Filter2(freak++,c);
		break;

		case 2:

		VCutoff=f2i(FinalC*128.0f);
		if (VCutoff>127)VCutoff=127;
		if (VCutoff<0)VCutoff=0;

		coef[0]=coeftab[0][VCutoff][VReso][2];
		coef[1]=coeftab[1][VCutoff][VReso][2];
		coef[2]=coeftab[2][VCutoff][VReso][2];
		coef[3]=coeftab[3][VCutoff][VReso][2];
		coef[4]=coeftab[4][VCutoff][VReso][2];
		freak=Filter2(freak++,c);
		break;

		case 3:

		VCutoff=f2i(FinalC*128.0f);
		if (VCutoff>127)VCutoff=127;
		if (VCutoff<0)VCutoff=0;

		coef[0]=coeftab[0][VCutoff][VReso][3];
		coef[1]=coeftab[1][VCutoff][VReso][3];
		coef[2]=coeftab[2][VCutoff][VReso][3];
		coef[3]=coeftab[3][VCutoff][VReso][3];
		coef[4]=coeftab[4][VCutoff][VReso][3];
		freak=Filter2(freak++,c);
		break;

		case 4:freak=Filter(c,freak,FinalC,Vcf_Resonance);break;

		}


		final+=freak;
	}
	*psamples++=final;
}while(--numsamples);

	return gotsomething;
}

void mi::Stop()
{
	for (int c = 0; c < numTracks; c++)
		ENV1_Stage[c]=0;
}
 
void mi::InitWavetable()
{
	SineTable[c]=(float)sin((float)c*0.0174532f);
}

}

void mi::SynthNote(char channel,float note)
{
	ENV1_Stage[channel]=1;
	ENV1_Counter[channel]=0;
	ENV1_Val[channel]=0.0f;
	OSC1_Step[channel]=(float)pow(2.0,note/12.0f);
	OSC2_Step[channel]=(float)pow(2.0,(note+Fine+Detune)/12.0f);
}

float mi::SynthWork(char channel)
{
	
	float OSC1Result=GetS(OSC1,OSC1_Position[channel],Pw1+SineTable[Gr]*LFO1TOPW1+SineTable[Gr2]*LFO2TOPW1);
	OSC1_Position[channel]+=OSC1_Step[channel];
	if(OSC1_Position[channel]>=512)OSC1_Position[channel]-=512;
	
	float OSC2Result=GetS(OSC2,OSC2_Position[channel],Pw2+SineTable[Gr]*LFO1TOPW2+SineTable[Gr2]*LFO2TOPW2);
	OSC2_Position[channel]+=OSC2_Step[channel];
	if(OSC2_Position[channel]>=512)OSC2_Position[channel]-=512;

	switch(ENV1_Stage[channel])
	{
	case 1:
		ENV1_Counter[channel]++;
		ENV1_Val[channel]+=ADSR_Coef(ENV1_S,1);
		if (ENV1_Counter[channel]>=ENV1_A)
		{
			ENV1_Counter[channel]=1;
			ENV1_Stage[channel]=2;
		}
	break;

	case 2:
		ENV1_Counter[channel]++;
		ENV1_Val[channel]-=ADSR_Coef(ENV1_S,2);
		
		if (ENV1_Counter[channel]>=ENV1_D)
		{
			ENV1_Counter[channel]=1;
			if (ENV1_S<0.01f)
			ENV1_Stage[channel]=5;
			else
			ENV1_Stage[channel]=3;
		}
	break;
	
	case 3:
	ENV1_Val[channel]=ENV1_S;
	break;

	case 4:
		ENV1_Counter[channel]++;
		ENV1_Val[channel]-=ADSR_Coef(ENV1_S,4);
		
		if (ENV1_Counter[channel]>=ENV1_R)
		{
			ENV1_Counter[channel]=0;
			ENV1_Stage[channel]=5;
		}
	break;
	}

	if (ENV1_Stage[channel]<5)
	{
	TVol[channel]=OSC1_Volume[channel]*ENV1_Val[channel];
	}
	else
	{
	TVol[channel]=0.0f;
	if (CVol[channel]<0.0002f)ENV1_Stage[channel]=0;
	}

	float ad=TVol[channel]-CVol[channel];

	if (ad>0.00001f || ad<-0.00001f)
		CVol[channel]+=ad/256.0f;
	float Noiser=Noise*(rand()-16384.0f);
	
	float OSCSResults;
	switch (sm){
	case 0:
	OSCSResults=OSC1Result+OSC2Result;
	break;
	case 1:
	OSCSResults=OSC1Result-OSC2Result;
	break;
	case 2:
	OSCSResults=OSC1Result*(OSC2Result/32768.0f);
	break;
	case 3:
	OSCSResults=float(f2i(OSC1Result) & f2i(OSC2Result));
	break;
	case 4:
	OSCSResults=float(f2i(OSC1Result) | f2i(OSC2Result));
	break;
	
	}
	return (Noiser+OSCSResults)*CVol[channel];
	
}

float mi::ADSR_Coef(float sustain,int stage)
{
	float coef=0.0f;

	switch(stage)
	{
	case 1:
		coef=(float)1.0f/(float)ENV1_A;
	break;
	
	case 2:
		coef=(1.0f-sustain)/(float)ENV1_D;
	break;
	
	case 3:
		coef=0;
	break;

	case 4:
		coef=sustain/(float)ENV1_R;
	break;
	}
	return coef;
}

float mi::Filter(char c,float input,float f,float q)
{
  input++;
  if (f>0.95f)f=0.95f;
  if (f<0.05f)f=0.05f;
  if (q>0.95f)q=0.95f;
  if (q<0.05f)q=0.05f;
  
  float fa = 1.0f - f; 
  float fb = q * (1.0f + 1.0f/fa);
  buf0[c] = fa * buf0[c] + f * (input + fb * (buf0[c] - buf1[c])); 
  buf1[c] = fa * buf1[c] + f * buf0[c];
  return buf1[c];  
}

void mi::LfoAdvance(void)
{
		SubGrCounter++;
		SubGrCounter2++;
		
		if(SubGrCounter>SubGrMax){
			SubGrCounter=0;
			Gr++;
			if(Gr>359)
				Gr=0;
		}
		
		if(SubGrCounter2>SubGrMax2){
			SubGrCounter2=0;
			Gr2++;
			if(Gr2>359)
				Gr2=0;
		}
}


int mi::f2i(double d)
{
  const double magic = 6755399441055744.0; // 2^51 + 2^52
  double tmp = (d-0.5) + magic;
  return *(int*) &tmp;
}

char const *mi::DescribeValue(int const param, int const value)
{
	static char txt[16];

	switch(param)
	{
	case 0:
	switch(value)
		{
		case 0: return "Add";break;
		case 1: return "Sub";break;
		case 2: return "AM";break;
		case 3: return "And";break;
		case 4: return "Or";break;
		}
	break;
	case 1:
		switch(value)
		{
		case 0: return "Sine";break;
		case 1: return "Sawtooth";break;
		case 2: return "Pulse";break;
		case 3: return "PW Value";break;
		case 4: return "-Sawtooth";break;
		case 5: return "RndWave";break;
		case 6: return "None";break;
		case 7: return "None";break;
		case 8: return "Off";break;
		}
	break;

	case 3:
		switch(value)
		{
		case 0: return "Sine";break;
		case 1: return "Sawtooth";break;
		case 2: return "Pulse";break;
		case 3: return "PW Value";break;
		case 4: return "-Sawtooth";break;
		case 5: return "RndWave";break;
		case 6: return "None";break;
		case 7: return "None";break;
		case 8: return "Off";break;
		}
	break;

	case 5:
		sprintf(txt, "%2.1f%%", (float)value*0.78125f);
	break;
	
	case 6:
		sprintf(txt, "%d Units", value);
	break;
	
	case 7:
		sprintf(txt, "%d SemiTns.", (int)value-64);
	break;

	case 10:
		sprintf(txt, "%2.1f%%", (float)value*0.78125f);
	break;

	case 12:
		sprintf(txt, "%2.1f Ticks", (float)value/10.0f);
	break;
	
	case 13:
		sprintf(txt, "%2.1f Ticks", (float)value/10.0f);
	break;

	case 16:
		switch(value)
		{
		case 0: return "LP12";break;
		case 1: return "HP";break;
		case 2: return "BP";break;
		case 3: return "BR";break;
		case 4: return "LP24";break;
		case 5: return "Off";break;
		}
	break;

	case 17:
		sprintf(txt, "%2.1f%%", ((float)value-64.0f)*1.5625f);
	break;

	case 18:
		sprintf(txt, "%2.1f%%", ((float)value-64.0f)*1.5625f);
	break;

	case 19:
		sprintf(txt, "%2.1f%%", ((float)value-64.0f)*1.5625f);
	break;

	case 20:
		sprintf(txt, "%2.1f%%", ((float)value-64.0f)*1.5625f);
	break;

	case 21:
		sprintf(txt, "%2.1f%%", ((float)value-64.0f)*1.5625f);
	break;

	case 22:
		sprintf(txt, "%2.1f%%", ((float)value-64.0f)*1.5625f);
	break;

	case 23:
		sprintf(txt, "%2.1f%%", ((float)value-64.0f)*1.5625f);
	break;


	default:
	return NULL;
	}
	return txt;
}

void mi::MakeBW(void)
{
for (int cutt=0;cutt<128;cutt++)
{
for (int rezz=0;rezz<128;rezz++)
{
for (int typp=0;typp<4;typp++)
{
ComputeCoefs(cutt,rezz,typp);
coeftab[0][cutt][rezz][typp]=coef[0];		
coeftab[1][cutt][rezz][typp]=coef[1];
coeftab[2][cutt][rezz][typp]=coef[2];
coeftab[3][cutt][rezz][typp]=coef[3];
coeftab[4][cutt][rezz][typp]=coef[4];
}}}

}

void mi::ComputeCoefs(int freq, int r, int t)
{
    float omega =float (2*PI*Kutoff(freq)/44100);
    float sn = (float)sin( omega);
    float cs = (float)cos( omega);
    float alpha;
        
	if( t<2)
    alpha =float(sn / Reonance( r *(freq+70)/(127.0f+70)));
    else
    alpha =float (sn * sinh( Bandwidth( r) * omega/sn));

        float a0, a1, a2, b0, b1, b2;

        switch( t)
		{
    
		case 0: // LP
                b0 =  (1 - cs)/2;
                b1 =   1 - cs;
                b2 =  (1 - cs)/2;
                a0 =   1 + alpha;
                a1 =  -2*cs;
                a2 =   1 - alpha;
                break;
        case 1: // HP
                b0 =  (1 + cs)/2;
                b1 = -(1 + cs);
                b2 =  (1 + cs)/2;
                a0 =   1 + alpha;
                a1 =  -2*cs;
                a2 =   1 - alpha;
                break;
        case 2: // BP
                b0 =   alpha;
                b1 =   0;
                b2 =  -alpha;
                a0 =   1 + alpha;
                a1 =  -2*cs;
                a2 =   1 - alpha;
                break;
        case 3: // BR
                b0 =   1;
                b1 =  -2*cs;
                b2 =   1;
                a0 =   1 + alpha;
                a1 =  -2*cs;
                a2 =   1 - alpha;
                break;
		}

        coef[0] = b0/a0;
        coef[1] = b1/a0;
        coef[2] = b2/a0;
        coef[3] = -a1/a0;
        coef[4] = -a2/a0;
}
	

float mi::Kutoff( int v)
{
        return float(pow( (v+5)/(127.0+5), 1.7)*13000+30);
}

float mi::Reonance( float v)
{
        return float(pow( v/127.0, 4)*150+0.1);
}

float mi::Bandwidth( int v)
{
        return float(pow( v/127.0, 4)*4+0.1);
}

float mi::Filter2(float x)
{
        float y;
		y = coef[0]*x + coef[1]*fx1 + coef[2]*fx2 + coef[3]*fy1 + coef[4]*fy2;
		fy2=fy1;
        fy1=y;
        fx2=fx1;
        fx1=x;
        return y;
}

float mi::GetS(int type,float offset, float pwi)
{
switch(type)
	{
		case 0: return (float)sin(offset*0.0122718f)*16384;break;
		case 1: return (offset-256)*64.0f;break;
		case 2: 
			if (pwi<2)pwi=2;
			if (pwi>510)pwi=510;

			if (offset<pwi)
			return 16384;
			else
			return -16384;
		break;
		
		case 3: return (pwi-256)*64;break;
		case 4: return (offset-256)*-64.0f;break;
		
		case 5:
			if (pwi<2)pwi=2;
			if (pwi>510)pwi=510;

			if (offset<pwi)
			return (float)rand()-8192;
			else
			return 0;
		break;
		
		case 6: return 0;break;
		case 7: return 0;break;
		case 8: return 0;break;
		default:
			return 0;
		break;
	}
}
*/
