; may 12, 2000
;
; simple shell for converting sid sound designer songs
; to snd format. needs additional "asm" and "ice" utils
; to function (as found in the ssdsnd package).
;
; anders eriksson
; ae@dhs.nu


		section	text

		include	'init.s'

		move.l	#makesndsrc,d0				;assemble snd file
		move.l	#asm,d1
		bsr.w	pexec

		move.l	#makesnd_err,error_msg			;see if assembly
		move.l	#makesndprg,d0				;of makesnd.s
		bsr.w	fsfirst					;went ok


		bsr.w	header_cut				;remove exec header and save as track.snd

	
		move.l	#makesndprg,d0				;erase makesnd.prg
		bsr.w	fdelete

		move.l	#env,d0					;icepacker
		move.l	#ice,d1					;
		bsr.w	pexec					;
		
		include	'exit.s'				;exit
		include	'head.s'				;head cutter

; --------------------------------------------------------------
;		Misc subroutines
; --------------------------------------------------------------

crawcin:	move.w	#7,-(sp)				;crawcin()
		trap	#1					;
		addq.l	#2,sp					;
		rts						;

cconws:		move.l	d0,-(sp)				;cconws()
		move.w	#9,-(sp)				;
		trap	#1					;
		addq.l	#6,sp					;
		rts

pexec:		pea	env
		move.l	d0,-(sp)				;commandline
		move.l	d1,-(sp)				;filename
		clr.w	-(sp)
		move.w	#75,-(sp)
		trap	#1
		lea.l	16(sp),sp
		rts

fdelete:	move.l	d0,-(sp)				;filename
		move.w	#$41,-(sp)
		trap	#1
		addq.l	#6,sp
		rts

fsfirst:	clr.w	-(sp)					;fsfirst()
		move.l	d0,-(sp)				;
		move.w	#$4e,-(sp)				;
		trap	#1					;
		addq.l	#8,sp					;
		tst.l	d0					;
		beq.s	.ok					;ok
		bra.w	exit_error				;
.ok:		rts		


fclose:		move.w	filenumber,-(sp)			;fclose()
		move.w	#$3e,-(sp)				;
		trap	#1					;
		addq.l	#4,sp					;
		rts
		

		section	data

		even
env:		dc.b	0,0

		even
asm:		dc.b	'asm',0

		even
ice:		dc.b	'ice',0
		
		even
makesndsrc:	dc.b	' makesnd.s',0

		even
makesndprg:	dc.b	'makesnd.prg',0

		even
tracksnd:	dc.b	'track.snd',0



		section	bss

error_msg:	ds.l	1
save_dta:	ds.l	1
dta:		ds.l	11

		end