#ifndef _WINDOW_H_
#define _WINDOW_H_

#include <aes.h>

#include "mp2audio.h"

typedef struct
{
	int wind_id,whandle,wind_open,windkind,firstobj,objdepth;
	int has_opened;
	char wind_title[64];
	CORDS wind,form;
	OBJECT *formtree;
} WINDFORM;

typedef struct _windhandlelist
{
	int whandle, wind_id;
	struct _windhandlelist *next;
} WINDHANDLELIST;

#define WIND_CTRL 0
#define WIND_INFO 1
#define WIND_SHOE 2

#define KEEPSELECT 0x8000  /* flag bit 15 */

/* Global variables */
extern WINDFORM windforms[5];
extern WINDHANDLELIST *windhandles;

/* Functions */
extern void window_create(int wind_id);
extern void window_open(int wind_id);
extern int window_close(int wind_id);
extern void window_switch(void);
extern void window_move(int wind_id, int x, int y);
extern void add_windhandle(int whandle, int wind_id);
extern void del_windhandle(int whandle);
extern int find_windform(int whandle);

#endif /* _WINDOW_H_ */
