/*
  LibSIDPlay plugin for XMMS
  Highly Excellent, isn't it? NOT! =)

  Copyright (c) Urpo Lankinen <wwwwolf@iki.fi>.
  Distributed under the GPL. Really.

  Sorry for writing in C++, but... that's where most of the
  inspirational code came from. =)

  Improvement ideas are welcome!

 */

/*
  TO CHECK:

  - Where do we get rid of all the unnecessary crap (like our
    emuEngine objects and stuff like that?) Otherwise, we might have a
    Nasty Memory Leak(tm) (probably not too huge, but annoying nevertheless).
 */


#include <iostream.h> // debugging use only
#include <fstream.h>  // file magic number hunt

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>

#include <xmms/plugin.h> // XMMS hooking stuff
#include <xmms/util.h>
#include <sidplay/player.h> // SIDPLAY functions

#include "built_iface.h"
#include "sid_plugin.hh"   // our function declarations and config

struct pluginconfig sidplugin_config;

unsigned long blk_size;

// Should be calculated!
#define BUFSIZE (64*1024)

// ==================================================================
// InputPlugin structure (so that xmms can see the Glory of SID)
// ==================================================================

InputPlugin sid_ip =
{
  NULL,                              // handle (internal)
  NULL,                              // filename (internal)
  "SID Plugin",                      // description
  sid_init,                          // init 
  sidplug_show_about,                // about 
  sidplug_configdialog,              // configure 
  is_our_file,                       // is_our_file 
  NULL,                              // scan_dir 
  play_file,                         // play_file 
  stop,                              // stop 
  sid_pause,                         // pause 
  seek,                              // seek
  NULL,                              // seek_eq 
  gettracknum,                       // get_time 
  NULL,                              // get_volume 
  NULL,                              // set_volume 
  NULL,                              // add_vis (obsolete) 
  NULL,                              // get_vis_type (obsolete) 
  NULL,                              // add_vis_pcm -- this can be done 
  NULL,                              // set_info 
  NULL,                              // set_info_text 
  get_song_info,                     // get_song_info 
  NULL,                              // file_info_box -- this can be done 
  NULL                               // output (internal) 
};

// ==================================================================
// Other variables
// ==================================================================

static pthread_t decode_thread;
static gboolean audio_error = FALSE;

// SID variables

emuEngine *myEmuEngine;                 // Emulator engine
sidTune *myTune;
struct emuConfig myEmuConfig;
struct sidTuneInfo mySidInfo;

// state variables

int selectedSong = 0;

ubyte *buffer;

static gboolean running = FALSE;

// ==================================================================
// The things that make the world go 'round (functions)
// ==================================================================

InputPlugin *get_iplugin_info(void)
{
#ifdef DEBUG
  cout << "SID: The Heathen acknowledges our Existence! "
       << "Conversion underway...\n";
#endif
  return &sid_ip;
#ifdef DEBUG
// cout << "SID: NB: Buffer size hardcoded to " << BUFSIZE<< " kbytes," << endl
//      << "     please come back when the stock is replenished. =)" << endl;
#endif
}

void sid_init(void)
{
  set_sidconfig_defaults();
  general_sidplug_ui_init();
  init_sidplug_dialogs(); // Initialize the popup

  myEmuEngine = new emuEngine(); // create new emulator engine
  if(!myEmuEngine)
    bailout("Not enough memory!\n");

#ifdef DEBUG
  cout << "SID: Emulator engine initialized succesfully.\n";
#endif
  
  // Verify that our library works... No! We can't assume the user
  // has a working copy of the library! Of *course* we have one in
  // Debian, but... =)
  if(!myEmuEngine->verifyEndianess())
    bailout("Hardware endianess improperly configured\nduring compilation.");


#ifdef DEBUG
  cout << "SID: OK, the library seems to have correct endianness.\n";
#endif

  // Get the default configuration.
  myEmuEngine->getConfig(myEmuConfig);

  load_config(); // Load stuff from config file.

#ifdef DEBUG
  cout << "SID: The settings have been loaded.\n";
#endif

  validate_settings(); // See that the values are sane.

#ifdef DEBUG
  cout << "SID: *** Initialization done ***\n";
#endif

}

/*
  We recognize only PSID files at the moment. But that's what
  the HVSC is made of, no need to worry.
*/
int is_our_file(char *filename)
{
  fstream f;
  gchar *fname;

  char buffer[10]; // Yes, 10 bytes for our 4-byte signature - just in case *g*

#ifdef DEBUG
  cout << "SID: Checking: " << filename << endl;
#endif

  if(access(filename,R_OK) != 0) {
    // Not found! Let's see...
    if(access(parse_filename(filename),R_OK) != 0) {
      // Not found either...
      return 0;
    }
    else {
      fname = g_strdup(parse_filename(filename));
    }
  }
  else {
    // Found as is...
    fname = g_strdup(filename);
  }

  // OK, we have the Name...
  f.open(fname, ios::in);
  f.read(buffer,4); /* read 4 bytes */
  f.close();

  free(fname);

  buffer[4] = '\000';

  
  /* The big, slow and stupid way - but no need to get #include <regex.h>
     for crap like this, right? =)
  */
  if(buffer[0] == 'P' && buffer[1] == 'S' &&
     buffer[2] == 'I' && buffer[3] == 'D') {
#ifdef SPAMMYDEBUG
    cout << "SID: File " << filename << " is in the One True Format."
	 << endl;
#endif
    return 1;
  }
#ifdef SPAMMYDEBUG
  cout << "SID: File " << filename << " isn't the One. Sorry, Morpheus."
       << endl << "    I suppose you play the music now?" << endl;
#endif
  return 0;

}

void play_file(char *filename)
{
#ifdef DEBUG
  cout << "SID: Loading " << filename << endl;
#endif
  myTune = new sidTune(filename);
  myTune->getInfo(mySidInfo);

  // Should check if we have the Information.

#ifdef DEBUG
  cout << "SID: Information read." << endl;
#endif


  // Setting the selectedSong to the default should happen here...
  selectedSong = mySidInfo.startSong;

  // All sorts of things in this place!

  //internal_to_sidplay();
  myEmuEngine->setConfig(myEmuConfig);

  if(!sidEmuInitializeSong((*myEmuEngine),(*myTune),(uword)selectedSong)) {
    audio_error = TRUE;
    return;
  }

#ifdef DEBUG
  cout << "SID: Initialization done." << endl;
#endif


  blk_size = 512 * (((myEmuConfig.bitsPerSample==SIDEMU_8BIT) ? 8 : 16) / 8)
    * ((myEmuConfig.channels==SIDEMU_MONO) ? 1 : 2);


  if((buffer = new ubyte[blk_size]) == 0) { // Buffer Size
#ifdef DEBUG
  cout << "SID: This cheapskate couldn't get me 'nuff memory!" << endl;
#endif
    audio_error = TRUE;
    return; /* Hot damn! */
  }



  // OPEN AUDIO.
  
                                // Bits
  if (sid_ip.output->open_audio(((myEmuConfig.bitsPerSample==SIDEMU_16BIT)?
				FMT_S16_LE : FMT_U8),
				// Freq
				myEmuConfig.frequency,
				// Channels
				((myEmuConfig.channels==SIDEMU_MONO)?
				 1:2)) == 0)
      {
	// If function returns true, bail out. Kinky, if you ask me.
	audio_error = TRUE;
	return;
      }

#ifdef DEBUG
  cout << "SID: Goodbye, cruel world. Entering the Loop." << endl;
#endif

  running = TRUE;
  pthread_create(&decode_thread, NULL, playloop, NULL);
}



static void *playloop (void *arg)
{
#ifdef DEBUG
  cout << "SID: Playloop thread, Evil Overlord speaking.\n";
#endif

  // cout << "Do we crash here?" << endl;
  for (;;) {
    if(running) {
      //cout << "Before..." << endl;
      sidEmuFillBuffer((*myEmuEngine),(*myTune),buffer,blk_size);
      //cout << "the data..." << endl;
      sid_ip.output->write_audio(buffer, blk_size);
      //cout << "...was sent?" << endl;
    }
    while((sid_ip.output->buffer_free() < blk_size) && running)
      usleep(10000);
    if(!running) 
      break;
  }
  // cout << "Or is it something like this?" << endl;

#ifdef DEBUG
  cout << "SID: Playloop exiting." << endl;
#endif
}

void stop(void)
{
#ifdef DEBUG
  cout << "SID: Signalling our thread." << endl;
#endif
  running = FALSE;

#ifdef DEBUG
  cout << "SID: Joining playloop thread." << endl;
#endif
  pthread_join(decode_thread, NULL);
#ifdef DEBUG
  cout << "SID: Closing audio." << endl;
#endif
  sid_ip.output->close_audio();

#ifdef DEBUG
  cout << "SID: Ny00king the sidtune object.." << endl;
#endif
  delete(myTune);
#ifdef DEBUG
  cout << "SID: Full halt ahead!" << endl;
#endif
}




void seek(int time)
{
  gboolean was_running = FALSE;

  if(running) {
    // Basically copied from above.
    was_running = TRUE;
    running = FALSE;
    pthread_join(decode_thread, NULL);
    // ...but we won't close the audio...
  }
  selectedSong = time;
  if(!sidEmuInitializeSong((*myEmuEngine),(*myTune),(uword)selectedSong)) {
    audio_error = TRUE;
    return;
  }
  if(was_running) {
    // ... because here, we start running again!
    running = TRUE;
    pthread_create(&decode_thread, NULL, playloop, NULL);
  }
}

int gettracknum(void)
{
  if(running) {
    return selectedSong+1;
  } else if(audio_error) {
    return -2;
  } else {
    return -1;
  }
}


/* Auxiliary function for file loading:
   Gets the filename part of 'filename:songnr'
*/

char *parse_filename(char *filename)
{
  char *tmp;
  
  tmp = strchr(filename, ':');

  if(tmp != NULL) {
    tmp[0] = '\000'; // Hmph, mucking with obscurities...
    return filename;
  }
  else
    return filename;
}

/* Auxiliary function for file loading:
   Gets the songnr part of 'filename:songnr'
*/

int parse_songnumber(char *filename)
{
  char *tmp;
  
  tmp = strrchr(filename, ':');

  if(tmp) {
    tmp++; // Skip the ':'
    // And they call Perl write-only language...
    if(((int)strtol(tmp, (char**)NULL, 10)) > 0)
      return ((int)strtol(tmp, (char**)NULL, 10));
    else
      return -1;
  }
  else
    return -1;
}




void sid_pause(short paused)
{
#ifdef DEBUG
  cout << "SID: Pause " << ((paused==1) ? "On" : "Off") << endl;
#endif
  sid_ip.output->pause(paused);
}


void get_song_info(char *filename, char **title, int *length)
{ 
#ifdef DEBUG
  cout << "SID: Getting song info.\n";
#endif

  gchar *temp;
  sidTune *st;
  sidTuneInfo si;

  st = new sidTune(filename);
  st->getInfo(si);
  delete(st);

#ifdef DEBUG
  cout << "SID: INFO" << endl
       << "     Name      : " << si.nameString << endl
       << "     Author    : " << si.authorString << endl
       << "     Copyright : " << si.copyrightString << endl
       << "     Songs     : " << si.songs << endl
       << "       (Default: " << si.startSong << ")" << endl;

  //  cout << "SID: Future length of titletmp: "
  //       << (strlen(si.nameString)+2+strlen(si.authorString)+2) << endl;
    
#endif

  temp = g_strconcat(si.nameString, " (", si.authorString, ")", NULL);

#ifdef DEBUG
  cout << "SID: temp: \"" << temp << "\"" << endl;
#endif

  (*title) = g_strdup(temp);
  (*length) = si.songs;

  g_free(temp);
}






/*
  Shows the reason why life is an absurd concept for a pathetic
  piece of code such as this, and bails out. *sob* *boohoo*
  (Hmm, interesting philosophical question... do the processes have
  a soul?)
 */
void bailout(char *reason)
{
  cerr << "SID: " << reason << endl; // just print it out to stderr.
}
