;***********************
;**** CLOCK MANAGER ****
;***********************
;Copyright STGHOST/SECTOR ONE 1999

;contains:
; - clkprobe (find frequency of all available clocks)
; - setclock (setup system for a given frequency)

	export clkprobe
	export test_ext_clk

	export bufe,bufs
	export type
	export frq

;****************
;*** clkprobe ***
;****************
;Find out the speed of external clock
;even for a dual external clock !!!
;(FDI supported)

_bufsize	equ	8820
noextlow	equ	35	; [1-35] U [42-50] 49 kHz (type 0)
noexthi	equ	42	; [36-38] 48 kHz (type 2)
bilimit	equ	38	; [39-41] 44.1kHz (type 1)

clkprobe:
	clr.l	type
	clr.w	-(sp)
	pea	_bufsize.w
	move.w	#68,-(sp)
	trap	#1	;Mxalloc: STRAM ONLY !
	addq.l	#8,sp
	tst.l	d0
	beq	.error
	move.l	d0,bufs
	add.l	#_bufsize,d0
	move.l	d0,bufe
	pea	test_ext_clk(pc)
	move.w	#38,-(sp)
	trap	#14
	addq.l	#6,sp
	move.l	bufs(pc),-(sp)
	move.w	#73,-(sp)
	trap	#1
	addq.l	#6,sp
.error:
	rts

;*** test_ext_clk ***
;-external clock probing rout
;-does all setup and restore stuff
;-calls twice the test rout (for double external clocks)
test_ext_clk:
;save status and setup audio system for test
	lea	oldcnf(pc),a0
	move.b	$ffff8900.w,(a0)+
	move.b	$ffff8920.w,(a0)+
	move.l	$ffff8930.w,(a0)+
	move.l	$ffff8934.w,(a0)+
	move.l	$ffff8938.w,(a0)+
	move.b	$ffff8921.w,(a0)
	clr.b	$ffff8900.w	;no interrupt
	clr.b	$ffff8920.w	;1 track - track 0 for speaker
	move.l	#$810115,$ffff8930.w	;matrix setup for int. clock
	clr.b	$ffff8901.w	;stop all dma operations
	move.b	#$83,$ffff8921.w	;activate audio setup (mono 50kHz in STE mode)
	move.l	#$01010003,$ffff8934.w	;freqdiv=1, rec 1 trk, mat+adc
	clr.w	$ffff8938.w	;kick YAMAHA - mic input instead, gain=0

;clean up the little buffer
	move.l	bufs(pc),d0
	move.l	bufe(pc),d1
	move.l	d0,a1
	move.w	#(_bufsize/4)-1,d2
.wash:	clr.l	(a1)+
	dbf	d2,.wash
;ext clock stuff
	or.w	#$6222,$ffff8930.w	;select external clock
	bset	#0,$ffff8941.w	;enable clock selection for newclock
	bset	#1,$ffff8941.w	;enable direction control for FDI
	bset	#2,$ffff8941.w	;enable reset control for FDI
	bset	#1,$ffff8943.w	;set mode to play in FDI
	bclr	#2,$ffff8943.w	;no FDI reset !

;setup dma replay
	lea	$ffff8900.w,a2
	swap	d0
	swap	d1
	move.b	d0,$ffff8903.w
	swap	d0
	movep.w	d0,5(a2)
	move.b	d1,$ffff890f.w
	swap	d1
	movep.w	d1,$11(a2)

;now probing for both clocks (newclock)
;test clock 1
	bset	#0,$ffff8943.w
	bsr.s	do_test
	move.w	d0,type+2
;test clock 0
	bclr	#0,$ffff8943.w
	bsr.s	do_test
	move.w	d0,type

;now restore original audio setup
	lea	oldcnf(pc),a0
	move.b	(a0)+,$ffff8900.w
	move.b	(a0)+,$ffff8920.w
	move.l	(a0)+,$ffff8930.w
	move.l	(a0)+,$ffff8934.w
	move.l	(a0)+,$ffff8938.w
	move.b	(a0),$ffff8921.w

;all done
	rts

type:	ds.w	2
bufs:	ds.l	1
bufe:	ds.l	1
oldcnf:	ds.l	4

; * the test itself *
do_test:
	move.w	#$2500,sr
	lea	$ffff8901.w,a2
	lea	$4ba.w,a3
	moveq	#2,d0
	moveq	#50,d1
	add.l	(a3),d0
	add.l	d0,d1
.tstart:	cmp.l	(a3),d0	;time to start ?
	bne.s	.tstart
	move.b	#1,(a2)	;start replay
	nop
.tloop:	tst.b	(a2)	;end of buffer ?
	beq.s	.tstop
	cmp.l	(a3),d1	;time limit reached ?
	bne.s	.tloop
	clr.b	$ffff8901.w	;turn off replay
.tstop:	move.l	(a3),d2	;stop time
	sub.l	d0,d2	;d2 = timelength

;now compute the clock type from the timelength
	moveq	#0,d0	;type=int49 (default)
	cmp.w	#noextlow,d2
	bls.s	.typ0
	cmp.w	#noexthi,d2
	bhs.s	.typ0
	cmp.w	#bilimit,d2
	bls.s	.typ2
	moveq	#1,d0	;type=ext44
	bra.s	.typ0
.typ2:	moveq	#2,d0	;type=ext48
.typ0:
	move.w	#$2300,sr
	rts


;******************
;***  setclock  ***
;******************
;setclock is used to setup clock according to clkprobe results
;  - select best available clock for wanted frequency
;  - stop dma activity
;  - setup system at right frequency
;  - computes relative frequency if exact frequency not available (for DSP)
;Input: d0 = wanted frequency
;Output: none

setclock:
;- Setup freq list from clkprobe output
	lea	freqs(pc),a1
	movem.w	type(pc),d1-d2
	move.l	(a1),a2
	move.l	(a1,d1.w*4),a3
	move.l	(a1,d2.w*4),a4
	lea	freqs2(pc),a1
	movem.l	a2-a4,(a1)

;- now get closer frequency for each clock
	moveq	#2,d5
.check_all:
	move.l	(a1)+,a0
	move.w	(a0)+,d1
.gethfrq:	cmp.l	(a0),d0
	bls.s	.take_it
	addq.l	#8,a0
	dbf	d1,.gethfrq
.take_it:	move.l	d3,d2
	move.l	d4,d3
	move.l	(a0)+,d4
	sub.l	d0,d4
	bpl.s	.posi
	neg.l	d4	;get absolute value
.posi:	dbf	d5,.check_all

;- Stop all dma stuff
	clr.b	$ffff8900.w	;kick audio-dma interrupts
	clr.b	$ffff8901.w	;stop dmasound
	clr.w	$ffff8934.w	;no clock (ste mode)

;- Select best clock
	cmp.l	d2,d3
	blo.s	.doclock1
	cmp.l	d2,d4
	blo.s	.doclock2
.doclock0:
	and.w	#$9DDD,$ffff8930.w	;no ext clock
	clr.b	$ffff8934.w
	move.l	-12(a1),a0
	bra.s	.clock_ok
.doclock1:
	cmp.l	d3,d4
	blo.s	.doclock2
	or.w	#$6222,$ffff8930.w	;use ext clock
	bclr	#0,$ffff8943.w	;select ext clock #0
	move.l	-8(a1),a0
	bra.s	.clock_ok
.doclock2:
	or.w	#$6222,$ffff8930.w	;use ext clock
	bset	#0,$ffff8943.w	;select ext clock #1
	move.l	-(a1),a0

;- Setup system with selected clock
.clock_ok:
	move.w	(a0)+,d1
.getfrq:	cmp.l	(a0),d0
	bls.s	.takeit
	addq.l	#8,a0
	dbf	d1,.getfrq
.takeit:	move.l	(a0)+,d2
	move.w	(a0)+,$ffff8934.w

;- Computes relative frequency (d0/d2=>frq):
	move.l	#$7fffff,d1
	cmp.l	d0,d2	;if selected freq(d2) < needed freq(d0) then frq=1.0
	bls.s	.keepit
	divul.l	d2,d3:d1	;else frq=d0/d2 (0<frq<1.0)
	mulu	d0,d1
	mulu	d0,d3
	divu	d2,d3
	ext.l	d3
	add.l	d3,d1
.keepit:	move.l	d1,frq
	rts

frq:	ds.l	1
freqs:	dc.l	fal_int,fal_cd,fal_dat
freqs2:	ds.l	3	;generated from freqs and type(clkprobe)
fal_int:	dc.w	7	;nbre - 1
	dc.l	8195	;frquence Falcon
	dc.w	11,3
	dc.l	9834
	dc.w	9,3
	dc.l	12292
	dc.w	7,3
	dc.l	16390
	dc.w	5,3
	dc.l	19668
	dc.w	4,3
	dc.l	24585
	dc.w	3,3
	dc.l	32780
	dc.w	2,3
	dc.l	49170
	dc.w	1,3
fal_cd:	dc.w	7
	dc.l	7350	;freq externe 44.1KHz
	dc.w	$b0b,3
	dc.l	8820
	dc.w	$909,3
	dc.l	11025	
	dc.w	$707,3
	dc.l	14700
	dc.w	$505,3
	dc.l	17640
	dc.w	$404,3
	dc.l	22050
	dc.w	$303,3
	dc.l	29400
	dc.w	$202,3
	dc.l	44100
	dc.w	$101,3
fal_dat:	dc.w	7
	dc.l	8000	;freq externe 48KHz
	dc.w	$b0b,3
	dc.l	9600
	dc.w	$909,3
	dc.l	12000
	dc.w	$707,3
	dc.l	16000
	dc.w	$505,3
	dc.l	19200
	dc.w	$404,3
	dc.l	24000
	dc.w	$303,3
	dc.l	32000
	dc.w	$202,3
	dc.l	48000
	dc.w	$101,3
