#include <stdio.h> /* debugging aid */
#include <glib.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "../built_iface.h"

void
on_ok_clicked                          (GtkButton       *button,
                                        gpointer         user_data)
{
  config_to_internal();
  //internal_to_sidplay();
  gtk_widget_hide(settings_dialog);
  settings_shown = FALSE;
}


void
on_cancel_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(settings_dialog);
  settings_shown = FALSE;
}

void
on_bufsize_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  /* Change the shown buffer size */
}


/*
  User clicks the OK to close the about box.
 */
void
on_close_about                         (GtkObject       *object,
                                        gpointer         user_data)
{
  /* printf("SID: Want to close the about box.\n"); */
  gtk_widget_hide(about_popup);
  about_shown = FALSE;
}


void
on_formchange                          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  printf("%s\n", user_data);
}


void
on_freq_changed                        (GtkButton       *button,
                                        gpointer         user_data)
{
  printf("%s\n", user_data);
}


void
on_mode_changed                        (GtkButton       *button,
                                        gpointer         user_data)
{
  printf("%s\n", user_data);
}

void
on_panning_toggled                     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  printf("%s\n", user_data);
}


void
on_playsid_toggled                     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  printf("%s\n", user_data);
}


void
on_filter_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  printf("%s\n", user_data);
}


void
on_forcespeeds_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  printf("%s\n", user_data);
}



#ifdef AREYACRAZY

void formchange()
{
}


void freq_set()
{
}

void mode_set()
{
}

void panning_tog()
{
}


void playsid_tog()
{
}


void filter_tog()
{
}


void forcespeeds_tog()
{
}


#endif


/* Glade-generated stuff will appear under this line ====================== */

