; *************************************************************
; **** Beispiel fr die Einbindung eines mit "SAVE MODUL"  ****
; **** abgespeicherten Songs in Assembler.                 ****
; **** Es knnen die Module aller Versionen abgespielt     ****
; **** werden!                                             ****
; *************************************************************

                pea     mes1(PC)
                move.w  #9,-(SP)
                trap    #1
                addq.l  #6,SP

; *** die Soundroutine einladen:

                clr.w   -(SP)                ; OPEN
                pea     routname(PC)
                move.w  #$3D,-(SP)
                trap    #1
                addq.l  #8,SP

                tst.l   D0                   ; ERROR?
                bmi     error

                move.l  D0,D7

                pea     routine(PC)          ; READ
                move.l  #10000,-(SP)
                move.w  D7,-(SP)
                move.w  #$3F,-(SP)
                trap    #1
                lea     12(SP),SP

                move.w  D7,-(SP)             ; CLOSE
                move.w  #$3E,-(SP)
                trap    #1
                addq.l  #4,SP

; *** das Songmodul einladen: ***

                clr.w   -(SP)                ; OPEN
                pea     songname(PC)
                move.w  #$3D,-(SP)
                trap    #1
                addq.l  #8,SP

                tst.l   D0                   ; ERROR?
                bmi     error

                move.l  D0,D7

                pea     buffer(PC)           ; READ
                move.l  #15000,-(SP)
                move.w  D7,-(SP)
                move.w  #$3F,-(SP)
                trap    #1
                lea     12(SP),SP

                move.w  D7,-(SP)             ; CLOSE
                move.w  #$3E,-(SP)
                trap    #1
                addq.l  #4,SP

                pea     0                    ; --> SUPERVISOR
                move.w  #$20,-(SP)
                trap    #1
                addq.l  #6,SP
                move.l  D0,ssp_save

                lea     buffer(PC),A0
                bsr     routine+28           ; * ASK MOD TYPE *

                btst    #0,D0                ; Digi-Modul?
                beq.s   nodigimodul

                bsr     routine+44           ; ACIA PATCH

; (ein Timer C-Patch ist nicht ntig, da wir uns selbst dort reinhngen, und
;  entsprechende Manahmen selbst vornehmen!)

                lea     buffer(PC),A0
                lea     modul(PC),A1
                bsr     routine+8            ; * INIT 2 (Digi-Pre-Init) *

                lea     modul(PC),A0
                bsr     routine+4            ; * INIT 1 *

; * jetzt ist das Digi-Modul fertig initialisiert *
; * Nun folgt die Einbindung in die Interruptstruktur, hier in den TIMER C: *

                bsr.s   link_in

                move.w  #7,-(SP)             ; Warten auf Taste
                trap    #1
                addq.l  #2,SP

                move.l  old_vector(PC),$0114.w ; Routine wieder aushngen!

                bsr     routine+36           ; Timer D off (Digis!)
                bsr     routine+40           ; Soundkanle aus!

                bsr     routine+48           ; ACIA-Patch rckgngig machen

                bra.s   weider

; --------------------------------------------- Vorgehen bei Digilosen Modulen:

nodigimodul:    lea     buffer(PC),A0
                bsr     routine+4            ; * INIT 1 *

                bsr.s   link_in              ; und Routine einhngen!

                move.w  #7,-(SP)
                trap    #1
                addq.l  #2,SP

                move.l  old_vector(PC),$0114.w ; Routine wieder aushngen!
                bsr     routine+40           ; Soundkanle aus!

weider:         move.l  ssp_save(PC),-(SP)   ; --> USER-Mode
                move.w  #$20,-(SP)
                trap    #1
                addq.l  #6,SP

                bra.s   noerror

error:          pea     mes2(PC)
                move.w  #9,-(SP)
                trap    #1
                addq.l  #6,SP

                move.w  #7,-(SP)
                trap    #1
                addq.l  #2,SP

noerror:        clr.w   -(SP)
                trap    #1

; *****************************************************************************

; ******* Einhngen in den Timer C (Systemroutine dabei rausschmeissen): ****
;                                   (dadurch gibt's keinen rger mit dem
;                                    Acia-Interrupt!)

link_in:        move.l  $0114.w,old_vector
                move.l  #new_tc,$0114.w
                rts

; ------------------------------------- Der Timer C - Handler:

new_tc:         andi    #$F4FF,SR            ; (fr den Fall, da Digis gespielt
;                                              werden!)

                bsr     routine+16           ; 200Hz-Ansprung (Register werden
;                                              alle gerettet)

;                                              ACHTUNG: bei einem Aufruf mit
;                                              50Hz (z.B. VBL) erfolgt der
;                                              Ansprung bei +12 !!!

                bclr    #5,$FFFA11           ; EOI (End of Interrupt)
;                                              (nur bei digilosen Modulen
;                                               notwendig, sonst befindet sich
;                                               der MFP im AEI-Mode!)

                rte                          ; und weg!

old_vector:     dc.l 0


; *******************************************************************************

                data

mes1:           dc.b 27,'E'
                dc.b '*************************************',13,10
                dc.b '* Beispiel fr die Einbindung eines *',13,10
                dc.b '* Songmoduls beliebiger Version in  *',13,10
                dc.b '* Assembler!                        *',13,10
                dc.b '*                                   *',13,10
                dc.b '* Zum Abbrechen eine Taste drcken. *',13,10
                dc.b '*************************************',13,10
                dc.b 13,10,0

mes2:           dc.b 'Ich kann die Dateien nicht finden !!!',13,10,0

routname:       dc.b '\include.mm2\mm2_play.rot',0
songname:       dc.b '\include.mm2\MR_X_DIE.mod',0

                bss

ssp_save:       ds.l 1

routine:        ds.b 10000         ; * Platz fr die Abspielroutine *
                ds.w 0
modul:          ds.b 16000         ; * Platz fr das Modul *
                ds.w 0
buffer:         ds.b 15000         ; * Platz, um das Modul zwischenzuspeichern *
;                                      (nur bei Digi-MOdulen notwendig!)
                end
