# compilers: gnu, pgi
# modes: debug, profile, optimize

COMPILER=gnu
MODE=optimize

#gnu c options
#
ifeq ($(COMPILER),gnu)
  CC=gcc
  CXX=g++ --no-exceptions
  DEPCC=gcc
  LD=gcc
  ifeq ($(MODE),optimize)
    OFLAG=-march=pentiumpro -mcpu=pentiumpro -O6 -ffast-math -malign-double -finline-limit-1000000 -funroll-loops -fstrength-reduce -finline-functions
    DFLAG=
  endif
  
  ifeq ($(MODE),debug)
    OFLAG=
    DFLAG=-g
  endif

  ifeq (($MODE),profile)
    OFLAG=
    DFLAG=-g -pg
  endif

  DEPCFLAGS=
  CFLAGS=$(OFLAG) $(DFLAG) $(DEPCFLAGS)
  LDFLAGS=
  LIBS=$(DFLAG) 
endif



# pgi cc options
#
ifeq (($COMPILER),pgi)
  CC=pgcc -B
  CXX=pgCC --pch --no_exceptions
  DEPCC=gcc
  LD=pgCC

  ifeq ($(MODE),optimize)
    OFLAG=-w -tp p6 -fast -O2 -Munroll -Mnoframe -Minline=levels:10 -Mvect=assoc,cachesize:524288,sse -Msafeptr -Msingle 
    DFLAG=
  endif

  ifeq ($(MODE),debug)
    OFLAG=-w
    DFLAG=
  endif

  ifeq ($(MODE),profile)
    OFLAG=-w
    DFLAG=-g -Mprof=lines
  endif
 
  DEPCFLAGS=
  CFLAGS=$(OFLAG) $(DFLAG) $(DEPCFLAGS)
  LDFLAGS=$(DFLAG)
  LIBS=
endif

CXXFLAGS=$(CFLAGS)


all: 
	make -f .make

clean:
	rm -f *.o
	rm -f *.pch
	rm -f $(EXTRAO)
	rm -f $(EXE) 

realclean: clean
	rm -f .targets .make

depend:
	find . -name '*.c*' | sed 's/\.cpp$$/\.o/g' | sed 's/\.c$$/\.o/g' > .targets
	echo CC=$(CC) > .make
	echo CXX=$(CXX) >> .make
	echo LD=$(LD) >> .make
	echo CFLAGS=$(CFLAGS) >> .make
	echo CXXFLAGS=$(CXXFLAGS) >> .make
	echo LIBS=$(LIBS) >> .make
	echo $(EXE): `cat .targets` $(EXTRAO) >> .make
	echo -e \\t$(LD) $(SHARED) $(LDFLAGS) -o $(EXE) `cat .targets` $(EXTRAO) $(LIBS)  >> .make
	echo -e \\t$(POST) >> .make
	$(DEPCC) $(DEPCFLAGS) -M `find . -name '*.c*'` >> .make
