#include <tos.h>
#include <ext.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "snddefs.h"
#include "decoder.h"
#include "stream.h"
#include "matrix.h"
#include "clock.h"

/* global variables from mp2audio.c */
extern int replay;

#define MUTE         1
#define MUTE_RESTORE 0

/* If tos.h defines the wrong names!! */
#ifndef setsndmode
#define Vsetmode setmode
#define setmode setsndmode
#endif

/* External clock values */
long ext0, ext1;

static void mute(int mode)
{
	static int ltatten, rtatten, ltgain, rtgain;

	if(mode) { /* mode==MUTE */
		/* Save old settings */
		ltatten = (int) soundcmd(LTATTEN, -1);
		rtatten = (int) soundcmd(RTATTEN, -1);
		ltgain = (int) soundcmd(LTGAIN, -1);
		rtgain = (int) soundcmd(RTGAIN, -1);
		soundcmd(LTATTEN, 0x00f0);
		soundcmd(RTATTEN, 0x00f0);
		soundcmd(RTGAIN, 0x0000);
		soundcmd(LTGAIN, 0x0000);
	} else { /* mode==MUTE_RESTORE */
		/* Restore old settings */
		soundcmd(LTATTEN, ltatten);
		soundcmd(RTATTEN, rtatten);
		soundcmd(LTGAIN, ltgain);
		soundcmd(RTGAIN, rtgain);
	}
}

int external_clock(void)
{
	static int external_clock_enabled = -1;
	
	if(external_clock_enabled >= 0)
		return external_clock_enabled;

#if 1
	bufs = (long)Mxalloc(TEST_BUFSIZE, 0);
	if(!bufs) {
		ext0 = ext1 = 0;
		return 0;
	}
	bufe = bufs + TEST_BUFSIZE;
		
	Supexec(test_ext_clk);
		
	Mfree((void *)bufs);
#else
/*	clkprobe(); */
#endif

	switch(((int *)&type)[0]) {
	case 1:
		ext0 = 44100L;
		break;
	case 2:
		ext0 = 48000L;
		break;
	default:
		ext0 = 0;
	}
	switch(((int *)&type)[1]) {
	case 1:
		ext1 = 44100L;
		break;
	case 2:
		ext1 = 48000L;
		break;
	default:
		ext1 = 0;
	}

	external_clock_enabled = ext0 || ext1;

	return external_clock_enabled;
}

static void set_matrix(long frequency)
{
	sndstatus(SND_RESET);
	setmode(STEREO16);
	soundcmd(ADDERIN,MATIN);
	dsptristate(ENABLE,ENABLE);
	setbuffer(SR_PLAY, stream_get_buffer(), stream_get_buffer_end());

	switch((int)(frequency/10)) {
	case 1600:
		if(ext0 == 48000L) {
			gpio(2, 0); /* Use clock 0 */
			Supexec(set_matrix_ext_16000);
		} else if(ext1 == 48000L) {
			gpio(2, 1); /* Use clock 1 */
			Supexec(set_matrix_ext_16000);
		} else
			Supexec(set_matrix_int_16390);
		break;
	case 2205:
		if(ext0 == 44100L) {
			gpio(2, 0); /* Use clock 0 */
			Supexec(set_matrix_ext_half);
		} else if(ext1 == 44100L) {
			gpio(2, 1); /* Use clock 1 */
			Supexec(set_matrix_ext_half);
		} else
			Supexec(set_matrix_int_24585);
		break;
	case 2400:
		if(ext0 == 48000L) {
			gpio(2, 0); /* Use clock 0 */
			Supexec(set_matrix_ext_half);
		} else if(ext1 == 48000L) {
			gpio(2, 1); /* Use clock 1 */
			Supexec(set_matrix_ext_half);
		} else
			Supexec(set_matrix_int_24585);
		break;
	case 3200:
		if(ext0 == 48000L) {
			gpio(2, 0); /* Use clock 0 */
			Supexec(set_matrix_ext_32000);
		} else if(ext1 == 48000L) {
			gpio(2, 1); /* Use clock 1 */
			Supexec(set_matrix_ext_32000);
		} else
			Supexec(set_matrix_int_32780);
		break;
	case 4410:
		if(ext0 == 44100L) {
			gpio(2, 0); /* Use clock 0 */
			Supexec(set_matrix_ext_full);
		} else if(ext1 == 44100L) {
			gpio(2, 1); /* Use clock 1 */
			Supexec(set_matrix_ext_full);
		} else
			Supexec(set_matrix_int_49170);

/* SPDIF test */
#if 0
			{
			int recmo;
			recmo=0; /* Record/44.1KHz */
			gpio(2,recmo+4); /* Reset */
			delay(50);
			gpio(2,recmo); /* Unreset */
			}
#endif
/* end SPDIF test */

		break;
	case 4800:
		if(ext0 == 48000L) {
			gpio(2, 0); /* Use clock 0 */
			Supexec(set_matrix_ext_full);
		} else if(ext1 == 48000L) {
			gpio(2, 1); /* Use clock 1 */
			Supexec(set_matrix_ext_full);
		} else
			Supexec(set_matrix_int_49170);
				
		break;
	}
}

void replay_continue(void)
{
	Dsp_Hf0(0);		/* Tell DSP to play again. */
	replay = 1;
}

void replay_init(long frequency)
{
	/* Save all old audio settings */
	Supexec(saveaudio);

	mute(MUTE);
	set_matrix(frequency);
	mute(MUTE_RESTORE);
	
/*	do decoder_load(); while(!decoder_dma_acknowledge()); */
	
	decoder_load();
	stream_load(1);

	if(frequency == 44100L && !external_clock()) {
		/* Enable frequency conversion. */
		/* Still not reimplemented.. sigh.. */
	}

	buffoper(SB_PLA_ENA | SB_PLA_RPT);
	replay = 1;
}

void replay_pause(void)
{
	Dsp_Hf0(1);		/* Tell DSP to pause. */
	replay = 0;
}

int replay_pausep(void)
{
	return Dsp_Hf0(-1);
}

int replayp(void)
{
	return replay;
}

void replay_stop(void)
{
	/* Restore all old audio settings */
	Supexec(restoreaudio);
	
	stream_reset();
	replay = 0;
}
